/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.IndexMode;
import co.elastic.clients.elasticsearch.indices.ManagedBy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamIndex
implements JsonpSerializable {
    private final String indexName;
    private final String indexUuid;
    @Nullable
    private final String ilmPolicy;
    @Nullable
    private final ManagedBy managedBy;
    @Nullable
    private final Boolean preferIlm;
    @Nullable
    private final IndexMode indexMode;
    public static final JsonpDeserializer<DataStreamIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamIndex::setupDataStreamIndexDeserializer);

    private DataStreamIndex(Builder builder) {
        this.indexName = ApiTypeHelper.requireNonNull(builder.indexName, this, "indexName");
        this.indexUuid = ApiTypeHelper.requireNonNull(builder.indexUuid, this, "indexUuid");
        this.ilmPolicy = builder.ilmPolicy;
        this.managedBy = builder.managedBy;
        this.preferIlm = builder.preferIlm;
        this.indexMode = builder.indexMode;
    }

    public static DataStreamIndex of(Function<Builder, ObjectBuilder<DataStreamIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String indexUuid() {
        return this.indexUuid;
    }

    @Nullable
    public final String ilmPolicy() {
        return this.ilmPolicy;
    }

    @Nullable
    public final ManagedBy managedBy() {
        return this.managedBy;
    }

    @Nullable
    public final Boolean preferIlm() {
        return this.preferIlm;
    }

    @Nullable
    public final IndexMode indexMode() {
        return this.indexMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_name");
        generator.write(this.indexName);
        generator.writeKey("index_uuid");
        generator.write(this.indexUuid);
        if (this.ilmPolicy != null) {
            generator.writeKey("ilm_policy");
            generator.write(this.ilmPolicy);
        }
        if (this.managedBy != null) {
            generator.writeKey("managed_by");
            this.managedBy.serialize(generator, mapper);
        }
        if (this.preferIlm != null) {
            generator.writeKey("prefer_ilm");
            generator.write(this.preferIlm.booleanValue());
        }
        if (this.indexMode != null) {
            generator.writeKey("index_mode");
            this.indexMode.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataStreamIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::indexUuid, JsonpDeserializer.stringDeserializer(), "index_uuid");
        op.add(Builder::ilmPolicy, JsonpDeserializer.stringDeserializer(), "ilm_policy");
        op.add(Builder::managedBy, ManagedBy._DESERIALIZER, "managed_by");
        op.add(Builder::preferIlm, JsonpDeserializer.booleanDeserializer(), "prefer_ilm");
        op.add(Builder::indexMode, IndexMode._DESERIALIZER, "index_mode");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamIndex> {
        private String indexName;
        private String indexUuid;
        @Nullable
        private String ilmPolicy;
        @Nullable
        private ManagedBy managedBy;
        @Nullable
        private Boolean preferIlm;
        @Nullable
        private IndexMode indexMode;

        public final Builder indexName(String value) {
            this.indexName = value;
            return this;
        }

        public final Builder indexUuid(String value) {
            this.indexUuid = value;
            return this;
        }

        public final Builder ilmPolicy(@Nullable String value) {
            this.ilmPolicy = value;
            return this;
        }

        public final Builder managedBy(@Nullable ManagedBy value) {
            this.managedBy = value;
            return this;
        }

        public final Builder preferIlm(@Nullable Boolean value) {
            this.preferIlm = value;
            return this;
        }

        public final Builder indexMode(@Nullable IndexMode value) {
            this.indexMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamIndex build() {
            this._checkSingleUse();
            return new DataStreamIndex(this);
        }
    }
}

