/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.SettingsSimilarityBm25;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityBoolean;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityDfi;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityDfr;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityIb;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityLmd;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityLmj;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityScripted;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SettingsSimilarity
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<SettingsSimilarity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SettingsSimilarity::setupSettingsSimilarityDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public SettingsSimilarity(SettingsSimilarityVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._settingsSimilarityKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private SettingsSimilarity(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static SettingsSimilarity of(Function<Builder, ObjectBuilder<SettingsSimilarity>> fn) {
        return fn.apply(new Builder()).build();
    }

    public SettingsSimilarity(String kind, JsonData value) {
        this._kind = Kind._Custom;
        this._value = value;
        this._customKind = kind;
    }

    public boolean isBm25() {
        return this._kind == Kind.Bm25;
    }

    public SettingsSimilarityBm25 bm25() {
        return (SettingsSimilarityBm25)TaggedUnionUtils.get(this, Kind.Bm25);
    }

    public boolean isBoolean() {
        return this._kind == Kind.Boolean;
    }

    public SettingsSimilarityBoolean boolean_() {
        return (SettingsSimilarityBoolean)TaggedUnionUtils.get(this, Kind.Boolean);
    }

    public boolean isDfi() {
        return this._kind == Kind.Dfi;
    }

    public SettingsSimilarityDfi dfi() {
        return (SettingsSimilarityDfi)TaggedUnionUtils.get(this, Kind.Dfi);
    }

    public boolean isDfr() {
        return this._kind == Kind.Dfr;
    }

    public SettingsSimilarityDfr dfr() {
        return (SettingsSimilarityDfr)TaggedUnionUtils.get(this, Kind.Dfr);
    }

    public boolean isIb() {
        return this._kind == Kind.Ib;
    }

    public SettingsSimilarityIb ib() {
        return (SettingsSimilarityIb)TaggedUnionUtils.get(this, Kind.Ib);
    }

    public boolean isLMDirichlet() {
        return this._kind == Kind.LMDirichlet;
    }

    public SettingsSimilarityLmd lmdirichlet() {
        return (SettingsSimilarityLmd)TaggedUnionUtils.get(this, Kind.LMDirichlet);
    }

    public boolean isLMJelinekMercer() {
        return this._kind == Kind.LMJelinekMercer;
    }

    public SettingsSimilarityLmj lmjelinekmercer() {
        return (SettingsSimilarityLmj)TaggedUnionUtils.get(this, Kind.LMJelinekMercer);
    }

    public boolean isScripted() {
        return this._kind == Kind.Scripted;
    }

    public SettingsSimilarityScripted scripted() {
        return (SettingsSimilarityScripted)TaggedUnionUtils.get(this, Kind.Scripted);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSettingsSimilarityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bm25, SettingsSimilarityBm25._DESERIALIZER, "BM25");
        op.add(Builder::boolean_, SettingsSimilarityBoolean._DESERIALIZER, "boolean");
        op.add(Builder::dfi, SettingsSimilarityDfi._DESERIALIZER, "DFI");
        op.add(Builder::dfr, SettingsSimilarityDfr._DESERIALIZER, "DFR");
        op.add(Builder::ib, SettingsSimilarityIb._DESERIALIZER, "IB");
        op.add(Builder::lmdirichlet, SettingsSimilarityLmd._DESERIALIZER, "LMDirichlet");
        op.add(Builder::lmjelinekmercer, SettingsSimilarityLmj._DESERIALIZER, "LMJelinekMercer");
        op.add(Builder::scripted, SettingsSimilarityScripted._DESERIALIZER, "scripted");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
        op.setTypeProperty("type", null);
    }

    public static enum Kind implements JsonEnum
    {
        Bm25("BM25"),
        Boolean("boolean"),
        Dfi("DFI"),
        Dfr("DFR"),
        Ib("IB"),
        LMDirichlet("LMDirichlet"),
        LMJelinekMercer("LMJelinekMercer"),
        Scripted("scripted"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SettingsSimilarity> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> bm25(SettingsSimilarityBm25 v) {
            this._kind = Kind.Bm25;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> bm25(Function<SettingsSimilarityBm25.Builder, ObjectBuilder<SettingsSimilarityBm25>> fn) {
            return this.bm25(fn.apply(new SettingsSimilarityBm25.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> boolean_(SettingsSimilarityBoolean v) {
            this._kind = Kind.Boolean;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> boolean_(Function<SettingsSimilarityBoolean.Builder, ObjectBuilder<SettingsSimilarityBoolean>> fn) {
            return this.boolean_(fn.apply(new SettingsSimilarityBoolean.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> dfi(SettingsSimilarityDfi v) {
            this._kind = Kind.Dfi;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> dfi(Function<SettingsSimilarityDfi.Builder, ObjectBuilder<SettingsSimilarityDfi>> fn) {
            return this.dfi(fn.apply(new SettingsSimilarityDfi.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> dfr(SettingsSimilarityDfr v) {
            this._kind = Kind.Dfr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> dfr(Function<SettingsSimilarityDfr.Builder, ObjectBuilder<SettingsSimilarityDfr>> fn) {
            return this.dfr(fn.apply(new SettingsSimilarityDfr.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> ib(SettingsSimilarityIb v) {
            this._kind = Kind.Ib;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> ib(Function<SettingsSimilarityIb.Builder, ObjectBuilder<SettingsSimilarityIb>> fn) {
            return this.ib(fn.apply(new SettingsSimilarityIb.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> lmdirichlet(SettingsSimilarityLmd v) {
            this._kind = Kind.LMDirichlet;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> lmdirichlet(Function<SettingsSimilarityLmd.Builder, ObjectBuilder<SettingsSimilarityLmd>> fn) {
            return this.lmdirichlet(fn.apply(new SettingsSimilarityLmd.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> lmjelinekmercer(SettingsSimilarityLmj v) {
            this._kind = Kind.LMJelinekMercer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> lmjelinekmercer(Function<SettingsSimilarityLmj.Builder, ObjectBuilder<SettingsSimilarityLmj>> fn) {
            return this.lmjelinekmercer(fn.apply(new SettingsSimilarityLmj.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> scripted(SettingsSimilarityScripted v) {
            this._kind = Kind.Scripted;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SettingsSimilarity> scripted(Function<SettingsSimilarityScripted.Builder, ObjectBuilder<SettingsSimilarityScripted>> fn) {
            return this.scripted(fn.apply(new SettingsSimilarityScripted.Builder()).build());
        }

        public ObjectBuilder<SettingsSimilarity> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public SettingsSimilarity build() {
            this._checkSingleUse();
            return new SettingsSimilarity(this);
        }
    }
}

