/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.ContentObject;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class MessageContent
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<MessageContent> _DESERIALIZER = JsonpDeserializer.lazy(MessageContent::buildMessageContentDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private MessageContent(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private MessageContent(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static MessageContent of(Function<Builder, ObjectBuilder<MessageContent>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isObject() {
        return this._kind == Kind.Object;
    }

    public List<ContentObject> object() {
        return (List)TaggedUnionUtils.get(this, Kind.Object);
    }

    public boolean isString() {
        return this._kind == Kind.String;
    }

    public String string() {
        return (String)TaggedUnionUtils.get(this, Kind.String);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Object: {
                    generator.writeStartArray();
                    for (ContentObject item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case String: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<MessageContent> buildMessageContentDeserializer() {
        return new UnionDeserializer.Builder<MessageContent, Kind, Object>(MessageContent::new, false).addMember(Kind.Object, JsonpDeserializer.arrayDeserializer(ContentObject._DESERIALIZER)).addMember(Kind.String, JsonpDeserializer.stringDeserializer()).build();
    }

    public static enum Kind {
        Object,
        String;

    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MessageContent> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<MessageContent> object(List<ContentObject> v) {
            this._kind = Kind.Object;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MessageContent> string(String v) {
            this._kind = Kind.String;
            this._value = v;
            return this;
        }

        @Override
        public MessageContent build() {
            this._checkSingleUse();
            return new MessageContent(this);
        }
    }
}

