/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DiscoveryNodeContent;
import co.elastic.clients.elasticsearch.ml.SnapshotUpgradeState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ModelSnapshotUpgrade
implements JsonpSerializable {
    private final String jobId;
    private final String snapshotId;
    private final SnapshotUpgradeState state;
    @Nullable
    private final DiscoveryNodeContent node;
    private final String assignmentExplanation;
    public static final JsonpDeserializer<ModelSnapshotUpgrade> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ModelSnapshotUpgrade::setupModelSnapshotUpgradeDeserializer);

    private ModelSnapshotUpgrade(Builder builder) {
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.snapshotId = ApiTypeHelper.requireNonNull(builder.snapshotId, this, "snapshotId");
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.node = builder.node;
        this.assignmentExplanation = ApiTypeHelper.requireNonNull(builder.assignmentExplanation, this, "assignmentExplanation");
    }

    public static ModelSnapshotUpgrade of(Function<Builder, ObjectBuilder<ModelSnapshotUpgrade>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final SnapshotUpgradeState state() {
        return this.state;
    }

    @Nullable
    public final DiscoveryNodeContent node() {
        return this.node;
    }

    public final String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("snapshot_id");
        generator.write(this.snapshotId);
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        generator.writeKey("assignment_explanation");
        generator.write(this.assignmentExplanation);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupModelSnapshotUpgradeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::snapshotId, JsonpDeserializer.stringDeserializer(), "snapshot_id");
        op.add(Builder::state, SnapshotUpgradeState._DESERIALIZER, "state");
        op.add(Builder::node, DiscoveryNodeContent._DESERIALIZER, "node");
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ModelSnapshotUpgrade> {
        private String jobId;
        private String snapshotId;
        private SnapshotUpgradeState state;
        @Nullable
        private DiscoveryNodeContent node;
        private String assignmentExplanation;

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public final Builder state(SnapshotUpgradeState value) {
            this.state = value;
            return this;
        }

        public final Builder node(@Nullable DiscoveryNodeContent value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<DiscoveryNodeContent.Builder, ObjectBuilder<DiscoveryNodeContent>> fn) {
            return this.node(fn.apply(new DiscoveryNodeContent.Builder()).build());
        }

        public final Builder assignmentExplanation(String value) {
            this.assignmentExplanation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ModelSnapshotUpgrade build() {
            this._checkSingleUse();
            return new ModelSnapshotUpgrade(this);
        }
    }
}

