/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch.search_application.SearchApplicationTemplate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchApplicationParameters
implements JsonpSerializable {
    private final List<String> indices;
    @Nullable
    private final String analyticsCollectionName;
    @Nullable
    private final SearchApplicationTemplate template;
    public static final JsonpDeserializer<SearchApplicationParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchApplicationParameters::setupSearchApplicationParametersDeserializer);

    protected SearchApplicationParameters(AbstractBuilder<?> builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.analyticsCollectionName = builder.analyticsCollectionName;
        this.template = builder.template;
    }

    public static SearchApplicationParameters searchApplicationParametersOf(Function<Builder, ObjectBuilder<SearchApplicationParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final String analyticsCollectionName() {
        return this.analyticsCollectionName;
    }

    @Nullable
    public final SearchApplicationTemplate template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.analyticsCollectionName != null) {
            generator.writeKey("analytics_collection_name");
            generator.write(this.analyticsCollectionName);
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSearchApplicationParametersDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(AbstractBuilder::analyticsCollectionName, JsonpDeserializer.stringDeserializer(), "analytics_collection_name");
        op.add(AbstractBuilder::template, SearchApplicationTemplate._DESERIALIZER, "template");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private List<String> indices;
        @Nullable
        private String analyticsCollectionName;
        @Nullable
        private SearchApplicationTemplate template;

        public final BuilderT indices(List<String> list) {
            this.indices = AbstractBuilder._listAddAll(this.indices, list);
            return (BuilderT)this.self();
        }

        public final BuilderT indices(String value, String ... values) {
            this.indices = AbstractBuilder._listAdd(this.indices, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT analyticsCollectionName(@Nullable String value) {
            this.analyticsCollectionName = value;
            return (BuilderT)this.self();
        }

        public final BuilderT template(@Nullable SearchApplicationTemplate value) {
            this.template = value;
            return (BuilderT)this.self();
        }

        public final BuilderT template(Function<SearchApplicationTemplate.Builder, ObjectBuilder<SearchApplicationTemplate>> fn) {
            return this.template(fn.apply(new SearchApplicationTemplate.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<SearchApplicationParameters> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchApplicationParameters build() {
            this._checkSingleUse();
            return new SearchApplicationParameters(this);
        }
    }
}

