/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.mapping.ChunkRescorerChunkingSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ChunkRescorer
implements JsonpSerializable {
    @Nullable
    private final Integer size;
    @Nullable
    private final ChunkRescorerChunkingSettings chunkingSettings;
    public static final JsonpDeserializer<ChunkRescorer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChunkRescorer::setupChunkRescorerDeserializer);

    private ChunkRescorer(Builder builder) {
        this.size = builder.size;
        this.chunkingSettings = builder.chunkingSettings;
    }

    public static ChunkRescorer of(Function<Builder, ObjectBuilder<ChunkRescorer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final ChunkRescorerChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupChunkRescorerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::chunkingSettings, ChunkRescorerChunkingSettings._DESERIALIZER, "chunking_settings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ChunkRescorer> {
        @Nullable
        private Integer size;
        @Nullable
        private ChunkRescorerChunkingSettings chunkingSettings;

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable ChunkRescorerChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<ChunkRescorerChunkingSettings.Builder, ObjectBuilder<ChunkRescorerChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new ChunkRescorerChunkingSettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChunkRescorer build() {
            this._checkSingleUse();
            return new ChunkRescorer(this);
        }
    }
}

