/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.HighlightBase;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Highlight
extends HighlightBase {
    @Nullable
    private final HighlighterEncoder encoder;
    private final List<NamedValue<HighlightField>> fields;
    public static final JsonpDeserializer<Highlight> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Highlight::setupHighlightDeserializer);

    private Highlight(Builder builder) {
        super(builder);
        this.encoder = builder.encoder;
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
    }

    public static Highlight of(Function<Builder, ObjectBuilder<Highlight>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final HighlighterEncoder encoder() {
        return this.encoder;
    }

    public final List<NamedValue<HighlightField>> fields() {
        return this.fields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.encoder != null) {
            generator.writeKey("encoder");
            this.encoder.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (NamedValue<HighlightField> item0 : this.fields) {
                generator.writeStartObject();
                generator.writeKey(item0.name());
                item0.value().serialize(generator, mapper);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupHighlightDeserializer(ObjectDeserializer<Builder> op) {
        HighlightBase.setupHighlightBaseDeserializer(op);
        op.add(Builder::encoder, HighlighterEncoder._DESERIALIZER, "encoder");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(NamedValue.deserializer(() -> HighlightField._DESERIALIZER)), "fields");
    }

    public static class Builder
    extends HighlightBase.AbstractBuilder<Builder>
    implements ObjectBuilder<Highlight> {
        @Nullable
        private HighlighterEncoder encoder;
        private List<NamedValue<HighlightField>> fields;

        public final Builder encoder(@Nullable HighlighterEncoder value) {
            this.encoder = value;
            return this;
        }

        public final Builder fields(List<NamedValue<HighlightField>> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @SafeVarargs
        public final Builder fields(NamedValue<HighlightField> value, NamedValue<HighlightField> ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Highlight build() {
            this._checkSingleUse();
            return new Highlight(this);
        }
    }
}

