/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.reload_search_analyzers;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.reload_search_analyzers.ReloadDetails;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ReloadResult
implements JsonpSerializable {
    private final List<ReloadDetails> reloadDetails;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<ReloadResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadResult::setupReloadResultDeserializer);

    protected ReloadResult(AbstractBuilder<?> builder) {
        this.reloadDetails = ApiTypeHelper.unmodifiableRequired(builder.reloadDetails, (Object)this, "reloadDetails");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static ReloadResult reloadResultOf(Function<Builder, ObjectBuilder<ReloadResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ReloadDetails> reloadDetails() {
        return this.reloadDetails;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.reloadDetails)) {
            generator.writeKey("reload_details");
            generator.writeStartArray();
            for (ReloadDetails item0 : this.reloadDetails) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupReloadResultDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::reloadDetails, JsonpDeserializer.arrayDeserializer(ReloadDetails._DESERIALIZER), "reload_details");
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private List<ReloadDetails> reloadDetails;
        private ShardStatistics shards;

        public final BuilderT reloadDetails(List<ReloadDetails> list) {
            this.reloadDetails = AbstractBuilder._listAddAll(this.reloadDetails, list);
            return (BuilderT)this.self();
        }

        public final BuilderT reloadDetails(ReloadDetails value, ReloadDetails ... values) {
            this.reloadDetails = AbstractBuilder._listAdd(this.reloadDetails, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT reloadDetails(Function<ReloadDetails.Builder, ObjectBuilder<ReloadDetails>> fn) {
            return this.reloadDetails(fn.apply(new ReloadDetails.Builder()).build(), new ReloadDetails[0]);
        }

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ReloadResult> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReloadResult build() {
            this._checkSingleUse();
            return new ReloadResult(this);
        }
    }
}

