/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.Ai21ServiceSettings;
import co.elastic.clients.elasticsearch.inference.Ai21ServiceType;
import co.elastic.clients.elasticsearch.inference.Ai21TaskType;
import co.elastic.clients.elasticsearch.inference.PutAi21Response;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAi21Request
extends RequestBase
implements JsonpSerializable {
    private final String ai21InferenceId;
    private final Ai21ServiceType service;
    private final Ai21ServiceSettings serviceSettings;
    private final Ai21TaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAi21Request> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAi21Request::setupPutAi21RequestDeserializer);
    public static final Endpoint<PutAi21Request, PutAi21Response, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAi21Request, PutAi21Response>("es/inference.put_ai21", request -> "PUT", request -> {
        boolean _taskType = true;
        int _ai21InferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.ai21InferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _ai21InferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("ai21InferenceId", request.ai21InferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAi21Response._DESERIALIZER);

    private PutAi21Request(Builder builder) {
        this.ai21InferenceId = ApiTypeHelper.requireNonNull(builder.ai21InferenceId, this, "ai21InferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutAi21Request of(Function<Builder, ObjectBuilder<PutAi21Request>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String ai21InferenceId() {
        return this.ai21InferenceId;
    }

    public final Ai21ServiceType service() {
        return this.service;
    }

    public final Ai21ServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    public final Ai21TaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
    }

    protected static void setupPutAi21RequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::service, Ai21ServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, Ai21ServiceSettings._DESERIALIZER, "service_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAi21Request> {
        private String ai21InferenceId;
        private Ai21ServiceType service;
        private Ai21ServiceSettings serviceSettings;
        private Ai21TaskType taskType;
        @Nullable
        private Time timeout;

        public final Builder ai21InferenceId(String value) {
            this.ai21InferenceId = value;
            return this;
        }

        public final Builder service(Ai21ServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(Ai21ServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<Ai21ServiceSettings.Builder, ObjectBuilder<Ai21ServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new Ai21ServiceSettings.Builder()).build());
        }

        public final Builder taskType(Ai21TaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAi21Request build() {
            this._checkSingleUse();
            return new PutAi21Request(this);
        }
    }
}

