/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.JsonBuffer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.jackson.Jackson3JsonpGenerator;
import co.elastic.clients.json.jackson.Jackson3JsonpMapper;
import co.elastic.clients.json.jackson.Jackson3JsonpParser;
import co.elastic.clients.json.jackson.Jackson3Utils;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.util.TokenBuffer;

class Jackson3JsonBuffer
implements JsonBuffer,
JsonData {
    private final TokenBuffer buffer;
    private final Jackson3JsonpMapper mapper;

    Jackson3JsonBuffer(TokenBuffer buffer, Jackson3JsonpMapper mapper) {
        this.buffer = buffer;
        this.mapper = mapper;
    }

    @Override
    public JsonParser asParser() {
        return new Jackson3JsonpParser(this.buffer.asParser(), this.mapper);
    }

    @Override
    public JsonValue toJson() {
        try (JsonParser parser = this.asParser();){
            parser.next();
            JsonValue jsonValue = parser.getValue();
            return jsonValue;
        }
    }

    @Override
    public JsonValue toJson(JsonpMapper mapper) {
        return this.toJson();
    }

    @Override
    public <T> T to(Type type) {
        return this.to(type, (JsonpMapper)this.mapper);
    }

    @Override
    public <T> T to(Type type, JsonpMapper mapper) {
        try (JsonParser parser = this.asParser();){
            Object t = mapper.deserialize(parser, type);
            return t;
        }
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer) {
        return this.deserialize(deserializer, this.mapper);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer, JsonpMapper mapper) {
        try (JsonParser parser = this.asParser();){
            T t = deserializer.deserialize(parser, mapper);
            return t;
        }
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (generator instanceof Jackson3JsonpGenerator) {
            Jackson3JsonpGenerator jkGenerator = (Jackson3JsonpGenerator)generator;
            try {
                this.buffer.serialize(jkGenerator.jacksonGenerator());
            }
            catch (JacksonException e) {
                throw Jackson3Utils.convertException(e);
            }
        }
        try (JsonParser parser = this.asParser();){
            JsonpUtils.copy(parser, generator);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try (Jackson3JsonpGenerator generator = new Jackson3JsonpGenerator(this.mapper.objectMapper().createGenerator((Writer)writer));){
            this.serialize(generator, this.mapper);
            generator.close();
            String string = writer.toString();
            return string;
        }
    }
}

