/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SuggestContext
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final String path;
    private final String type;
    @Nullable
    private final String precision;
    public static final JsonpDeserializer<SuggestContext> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestContext::setupSuggestContextDeserializer);

    private SuggestContext(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.path = builder.path;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.precision = builder.precision;
    }

    public static SuggestContext of(Function<Builder, ObjectBuilder<SuggestContext>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final String precision() {
        return this.precision;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        generator.writeKey("type");
        generator.write(this.type);
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSuggestContextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::precision, JsonpDeserializer.stringDeserializer(), "precision");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SuggestContext> {
        private String name;
        @Nullable
        private String path;
        private String type;
        @Nullable
        private String precision;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder precision(@Nullable String value) {
            this.precision = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SuggestContext build() {
            this._checkSingleUse();
            return new SuggestContext(this);
        }
    }
}

