/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.UpdateErrorResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateErrorRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final String error;
    private final boolean isExpNullError;
    public static final JsonpDeserializer<UpdateErrorRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateErrorRequest::setupUpdateErrorRequestDeserializer);
    public static final Endpoint<UpdateErrorRequest, UpdateErrorResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateErrorRequest, UpdateErrorResponse>("es/connector.update_error", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_error");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateErrorResponse._DESERIALIZER);

    private UpdateErrorRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.error = builder.error;
        this.isExpNullError = builder.isExpNullError;
    }

    public static UpdateErrorRequest of(Function<Builder, ObjectBuilder<UpdateErrorRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (!this.isExpNullError) {
            generator.writeKey("error");
            generator.write(this.error);
        } else if (this.isExpNullError) {
            generator.writeKey("error");
            generator.writeNull();
        }
    }

    protected static void setupUpdateErrorRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateErrorRequest> {
        private String connectorId;
        private String error;
        private boolean isExpNullError;

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder error(String value) {
            this.error = value;
            this.isExpNullError = false;
            return this;
        }

        public final Builder errorWithNull() {
            this.isExpNullError = true;
            this.error = null;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateErrorRequest build() {
            this._checkSingleUse();
            return new UpdateErrorRequest(this);
        }
    }
}

