/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.CollectionCompat$JIteratorOps$;
import fs2.io.CollectionCompat$JSetOps$;
import fs2.io.CollectionCompat$SetOps$;
import fs2.io.Watcher;
import fs2.io.Watcher$;
import fs2.io.file.FileHandle;
import fs2.io.file.Files;
import fs2.io.file.Flags$;
import fs2.io.file.Path$;
import fs2.io.file.ReadCursor;
import fs2.io.file.WriteCursor;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;

public interface DeprecatedFilesApi<F> {
    public Async<F> F();

    public static Object copy$(DeprecatedFilesApi $this, Path source, Path target, Seq flags) {
        return $this.copy(source, target, (Seq<CopyOption>)flags);
    }

    default public F copy(Path source, Path target, Seq<CopyOption> flags) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.copy$$anonfun$1(source, target, flags));
    }

    public static Seq copy$default$3$(DeprecatedFilesApi $this) {
        return $this.copy$default$3();
    }

    default public Seq<CopyOption> copy$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Object createDirectory$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.createDirectory(path, flags);
    }

    default public F createDirectory(Path path, Seq<FileAttribute<?>> flags) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.createDirectory$$anonfun$1(path, flags));
    }

    public static Seq createDirectory$default$2$(DeprecatedFilesApi $this) {
        return $this.createDirectory$default$2();
    }

    default public Seq<FileAttribute<?>> createDirectory$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Object createDirectories$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.createDirectories(path, flags);
    }

    default public F createDirectories(Path path, Seq<FileAttribute<?>> flags) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.createDirectories$$anonfun$1(path, flags));
    }

    public static Seq createDirectories$default$2$(DeprecatedFilesApi $this) {
        return $this.createDirectories$default$2();
    }

    default public Seq<FileAttribute<?>> createDirectories$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Object delete$(DeprecatedFilesApi $this, Path path) {
        return $this.delete(path);
    }

    default public F delete(Path path) {
        return ((Files)this).delete(Path$.MODULE$.fromNioPath(path));
    }

    public static Object deleteIfExists$(DeprecatedFilesApi $this, Path path) {
        return $this.deleteIfExists(path);
    }

    default public F deleteIfExists(Path path) {
        return ((Files)this).deleteIfExists(Path$.MODULE$.fromNioPath(path));
    }

    public static Object deleteDirectoryRecursively$(DeprecatedFilesApi $this, Path path, scala.collection.immutable.Set options) {
        return $this.deleteDirectoryRecursively(path, (scala.collection.immutable.Set<FileVisitOption>)options);
    }

    default public F deleteDirectoryRecursively(Path path, scala.collection.immutable.Set<FileVisitOption> options) {
        return ((Files)this).deleteRecursively(Path$.MODULE$.fromNioPath(path), options.contains((Object)FileVisitOption.FOLLOW_LINKS));
    }

    public static scala.collection.immutable.Set deleteDirectoryRecursively$default$2$(DeprecatedFilesApi $this) {
        return $this.deleteDirectoryRecursively$default$2();
    }

    default public scala.collection.immutable.Set<FileVisitOption> deleteDirectoryRecursively$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public static Stream directoryStream$(DeprecatedFilesApi $this, Path path) {
        return $this.directoryStream(path);
    }

    default public Stream<F, Path> directoryStream(Path path) {
        return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.directoryStream$$anonfun$1(path)), (Function1 & Serializable)_$2 -> {
            java.lang.Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$2);
            return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
        });
    }

    public static Stream directoryStream$(DeprecatedFilesApi $this, Path path, Function1 filter) {
        return $this.directoryStream(path, (Function1<Path, Object>)filter);
    }

    default public Stream<F, Path> directoryStream(Path path, Function1<Path, Object> filter) {
        return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.directoryStream$$anonfun$3(path, filter)), (Function1 & Serializable)_$3 -> {
            java.lang.Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$3);
            return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
        });
    }

    public static Stream directoryStream$(DeprecatedFilesApi $this, Path path, String glob) {
        return $this.directoryStream(path, glob);
    }

    default public Stream<F, Path> directoryStream(Path path, String glob) {
        return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.directoryStream$$anonfun$5(path, glob)), (Function1 & Serializable)_$4 -> {
            java.lang.Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$4);
            return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
        });
    }

    public <C extends AutoCloseable> Stream<F, Path> _runJavaCollectionResource(F var1, Function1<C, Iterator<Path>> var2);

    public static Object exists$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.exists(path, (Seq<LinkOption>)flags);
    }

    default public F exists(Path path, Seq<LinkOption> flags) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.exists$$anonfun$1(path, flags));
    }

    public static Seq exists$default$2$(DeprecatedFilesApi $this) {
        return $this.exists$default$2();
    }

    default public Seq<LinkOption> exists$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Object isDirectory$(DeprecatedFilesApi $this, Path path, Seq linkOption) {
        return $this.isDirectory(path, (Seq<LinkOption>)linkOption);
    }

    default public F isDirectory(Path path, Seq<LinkOption> linkOption) {
        return (F)Sync$.MODULE$.apply(this.F()).delay(() -> DeprecatedFilesApi.isDirectory$$anonfun$1(path, linkOption));
    }

    public static Seq isDirectory$default$2$(DeprecatedFilesApi $this) {
        return $this.isDirectory$default$2();
    }

    default public Seq<LinkOption> isDirectory$default$2() {
        return package$.MODULE$.Nil();
    }

    public static Object isFile$(DeprecatedFilesApi $this, Path path, Seq linkOption) {
        return $this.isFile(path, (Seq<LinkOption>)linkOption);
    }

    default public F isFile(Path path, Seq<LinkOption> linkOption) {
        return (F)Sync$.MODULE$.apply(this.F()).delay(() -> DeprecatedFilesApi.isFile$$anonfun$1(path, linkOption));
    }

    public static Seq isFile$default$2$(DeprecatedFilesApi $this) {
        return $this.isFile$default$2();
    }

    default public Seq<LinkOption> isFile$default$2() {
        return package$.MODULE$.Nil();
    }

    public static Object move$(DeprecatedFilesApi $this, Path source, Path target, Seq flags) {
        return $this.move(source, target, (Seq<CopyOption>)flags);
    }

    default public F move(Path source, Path target, Seq<CopyOption> flags) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.move$$anonfun$1(source, target, flags));
    }

    public static Seq move$default$3$(DeprecatedFilesApi $this) {
        return $this.move$default$3();
    }

    default public Seq<CopyOption> move$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Resource open$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.open(path, (Seq<OpenOption>)flags);
    }

    default public Resource<F, FileHandle<F>> open(Path path, Seq<OpenOption> flags) {
        return ((Files)this).open(Path$.MODULE$.fromNioPath(path), Flags$.MODULE$.fromOpenOptions((Iterable)flags));
    }

    public static Object permissions$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.permissions(path, (Seq<LinkOption>)flags);
    }

    default public F permissions(Path path, Seq<LinkOption> flags) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.permissions$$anonfun$1(path, flags));
    }

    public static Seq permissions$default$2$(DeprecatedFilesApi $this) {
        return $this.permissions$default$2();
    }

    default public Seq<LinkOption> permissions$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Stream readAll$(DeprecatedFilesApi $this, Path path, int chunkSize) {
        return $this.readAll(path, chunkSize);
    }

    default public Stream<F, Object> readAll(Path path, int chunkSize) {
        return ((Files)this).readAll(Path$.MODULE$.fromNioPath(path), chunkSize, Flags$.MODULE$.Read());
    }

    public static Resource readCursor$(DeprecatedFilesApi $this, Path path) {
        return $this.readCursor(path);
    }

    default public Resource<F, ReadCursor<F>> readCursor(Path path) {
        return this.readCursor(path, (Seq<OpenOption>)package$.MODULE$.Nil());
    }

    public static Resource readCursor$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.readCursor(path, (Seq<OpenOption>)flags);
    }

    default public Resource<F, ReadCursor<F>> readCursor(Path path, Seq<OpenOption> flags) {
        StandardOpenOption standardOpenOption = StandardOpenOption.READ;
        return ((Files)this).readCursor(Path$.MODULE$.fromNioPath(path), Flags$.MODULE$.fromOpenOptions((Iterable)flags.$plus$colon((Object)standardOpenOption)));
    }

    public static Seq readCursor$default$2$(DeprecatedFilesApi $this) {
        return $this.readCursor$default$2();
    }

    default public Seq<OpenOption> readCursor$default$2() {
        return package$.MODULE$.Nil();
    }

    public static Stream readRange$(DeprecatedFilesApi $this, Path path, int chunkSize, long start, long end) {
        return $this.readRange(path, chunkSize, start, end);
    }

    default public Stream<F, Object> readRange(Path path, int chunkSize, long start, long end) {
        return ((Files)this).readRange(Path$.MODULE$.fromNioPath(path), chunkSize, start, end);
    }

    public static Object setPermissions$(DeprecatedFilesApi $this, Path path, scala.collection.immutable.Set permissions) {
        return $this.setPermissions(path, (scala.collection.immutable.Set<PosixFilePermission>)permissions);
    }

    default public F setPermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions) {
        return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.setPermissions$$anonfun$1(path, permissions));
    }

    public static Object size$(DeprecatedFilesApi $this, Path path) {
        return $this.size(path);
    }

    default public F size(Path path) {
        return ((Files)this).size(Path$.MODULE$.fromNioPath(path));
    }

    public static Stream tail$(DeprecatedFilesApi $this, Path path, int chunkSize, long offset, FiniteDuration pollDelay) {
        return $this.tail(path, chunkSize, offset, pollDelay);
    }

    default public Stream<F, Object> tail(Path path, int chunkSize, long offset, FiniteDuration pollDelay) {
        return ((Files)this).tail(Path$.MODULE$.fromNioPath(path), chunkSize, offset, pollDelay);
    }

    public static Resource tempFile$(DeprecatedFilesApi $this, Option dir, String prefix, String suffix, Seq attributes) {
        return $this.tempFile((Option<Path>)dir, prefix, suffix, attributes);
    }

    default public Resource<F, Path> tempFile(Option<Path> dir, String prefix, String suffix, Seq<FileAttribute<?>> attributes) {
        Object object;
        Option<Path> option = dir;
        if (option instanceof Some) {
            Path dir2 = (Path)((Some)option).value();
            object = Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.tempFile$$anonfun$1(prefix, suffix, attributes, dir2));
        } else if (None$.MODULE$.equals(option)) {
            object = Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.tempFile$$anonfun$2(prefix, suffix, attributes));
        } else {
            throw new MatchError(option);
        }
        return Resource$.MODULE$.make(object, (Function1 & Serializable)_$5 -> package.all$.MODULE$.toFunctorOps(this.deleteIfExists((Path)_$5), this.F()).void(), this.F());
    }

    public static Option tempFile$default$1$(DeprecatedFilesApi $this) {
        return $this.tempFile$default$1();
    }

    default public Option<Path> tempFile$default$1() {
        return None$.MODULE$;
    }

    public static String tempFile$default$2$(DeprecatedFilesApi $this) {
        return $this.tempFile$default$2();
    }

    default public String tempFile$default$2() {
        return "";
    }

    public static String tempFile$default$3$(DeprecatedFilesApi $this) {
        return $this.tempFile$default$3();
    }

    default public String tempFile$default$3() {
        return ".tmp";
    }

    public static Seq tempFile$default$4$(DeprecatedFilesApi $this) {
        return $this.tempFile$default$4();
    }

    default public Seq<FileAttribute<?>> tempFile$default$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Resource tempDirectory$(DeprecatedFilesApi $this, Option dir, String prefix, Seq attributes) {
        return $this.tempDirectory((Option<Path>)dir, prefix, attributes);
    }

    default public Resource<F, Path> tempDirectory(Option<Path> dir, String prefix, Seq<FileAttribute<?>> attributes) {
        Object object;
        Option<Path> option = dir;
        if (option instanceof Some) {
            Path dir2 = (Path)((Some)option).value();
            object = Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.tempDirectory$$anonfun$1(prefix, attributes, dir2));
        } else if (None$.MODULE$.equals(option)) {
            object = Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.tempDirectory$$anonfun$2(prefix, attributes));
        } else {
            throw new MatchError(option);
        }
        return Resource$.MODULE$.make(object, (Function1 & Serializable)p -> {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.deleteDirectoryRecursively((Path)p, (scala.collection.immutable.Set<FileVisitOption>)Predef$.MODULE$.Set().empty()), this.F());
            return ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return throwable instanceof NoSuchFileException;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof NoSuchFileException) {
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }
            }, this.F());
        }, this.F());
    }

    public static Option tempDirectory$default$1$(DeprecatedFilesApi $this) {
        return $this.tempDirectory$default$1();
    }

    default public Option<Path> tempDirectory$default$1() {
        return None$.MODULE$;
    }

    public static String tempDirectory$default$2$(DeprecatedFilesApi $this) {
        return $this.tempDirectory$default$2();
    }

    default public String tempDirectory$default$2() {
        return "";
    }

    public static Seq tempDirectory$default$3$(DeprecatedFilesApi $this) {
        return $this.tempDirectory$default$3();
    }

    default public Seq<FileAttribute<?>> tempDirectory$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Stream walk$(DeprecatedFilesApi $this, Path start) {
        return $this.walk(start);
    }

    default public Stream<F, Path> walk(Path start) {
        return this.walk(start, (Seq<FileVisitOption>)((Seq)package$.MODULE$.Seq().empty()));
    }

    public static Stream walk$(DeprecatedFilesApi $this, Path start, Seq options) {
        return $this.walk(start, (Seq<FileVisitOption>)options);
    }

    default public Stream<F, Path> walk(Path start, Seq<FileVisitOption> options) {
        return this.walk(start, Integer.MAX_VALUE, options);
    }

    public static Stream walk$(DeprecatedFilesApi $this, Path start, int maxDepth, Seq options) {
        return $this.walk(start, maxDepth, (Seq<FileVisitOption>)options);
    }

    default public Stream<F, Path> walk(Path start, int maxDepth, Seq<FileVisitOption> options) {
        return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.F()).blocking(() -> DeprecatedFilesApi.walk$$anonfun$1(start, maxDepth, options)), (Function1 & Serializable)_$6 -> {
            java.util.Iterator iterator = CollectionCompat$.MODULE$.JIteratorOps(_$6.iterator());
            return CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(iterator);
        });
    }

    public static Seq walk$default$3$(DeprecatedFilesApi $this) {
        return $this.walk$default$3();
    }

    default public Seq<FileVisitOption> walk$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static Resource watcher$(DeprecatedFilesApi $this) {
        return $this.watcher();
    }

    default public Resource<F, Watcher<F>> watcher() {
        return Watcher$.MODULE$.default(this.F());
    }

    public static Stream watch$(DeprecatedFilesApi $this, Path path, Seq types, Seq modifiers, FiniteDuration pollTimeout) {
        return $this.watch(path, (Seq<Watcher.EventType>)types, (Seq<WatchEvent.Modifier>)modifiers, pollTimeout);
    }

    default public Stream<F, Watcher.Event> watch(Path path, Seq<Watcher.EventType> types, Seq<WatchEvent.Modifier> modifiers, FiniteDuration pollTimeout) {
        return Stream$.MODULE$.resource(Watcher$.MODULE$.default(this.F()), this.F()).evalTap((Function1 & Serializable)_$7 -> _$7.watch(path, types, modifiers), this.F()).flatMap((Function1 & Serializable)_$8 -> _$8.events(pollTimeout), NotGiven$.MODULE$.value());
    }

    public static Seq watch$default$2$(DeprecatedFilesApi $this) {
        return $this.watch$default$2();
    }

    default public Seq<Watcher.EventType> watch$default$2() {
        return package$.MODULE$.Nil();
    }

    public static Seq watch$default$3$(DeprecatedFilesApi $this) {
        return $this.watch$default$3();
    }

    default public Seq<WatchEvent.Modifier> watch$default$3() {
        return package$.MODULE$.Nil();
    }

    public static FiniteDuration watch$default$4$(DeprecatedFilesApi $this) {
        return $this.watch$default$4();
    }

    default public FiniteDuration watch$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public static Function1 writeAll$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.writeAll(path, (Seq<StandardOpenOption>)flags);
    }

    default public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path path, Seq<StandardOpenOption> flags) {
        StandardOpenOption standardOpenOption = StandardOpenOption.WRITE;
        return ((Files)this).writeAll(Path$.MODULE$.fromNioPath(path), Flags$.MODULE$.fromOpenOptions((Iterable)flags.$plus$colon((Object)standardOpenOption)));
    }

    public static Seq writeAll$default$2$(DeprecatedFilesApi $this) {
        return $this.writeAll$default$2();
    }

    default public Seq<StandardOpenOption> writeAll$default$2() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public static Resource writeCursor$(DeprecatedFilesApi $this, Path path, Seq flags) {
        return $this.writeCursor(path, (Seq<OpenOption>)flags);
    }

    default public Resource<F, WriteCursor<F>> writeCursor(Path path, Seq<OpenOption> flags) {
        StandardOpenOption standardOpenOption = StandardOpenOption.WRITE;
        return ((Files)this).writeCursor(Path$.MODULE$.fromNioPath(path), Flags$.MODULE$.fromOpenOptions((Iterable)flags.$plus$colon((Object)standardOpenOption)));
    }

    public static Seq writeCursor$default$2$(DeprecatedFilesApi $this) {
        return $this.writeCursor$default$2();
    }

    default public Seq<OpenOption> writeCursor$default$2() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public static Function1 writeRotate$(DeprecatedFilesApi $this, Object computePath, long limit, Seq flags) {
        return $this.writeRotate(computePath, limit, (Seq<StandardOpenOption>)flags);
    }

    default public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeRotate(F computePath, long limit, Seq<StandardOpenOption> flags) {
        StandardOpenOption standardOpenOption = StandardOpenOption.WRITE;
        return ((Files)this).writeRotate(package.all$.MODULE$.toFunctorOps(computePath, this.F()).map((Function1 & Serializable)path -> Path$.MODULE$.fromNioPath((Path)path)), limit, Flags$.MODULE$.fromOpenOptions((Iterable)flags.$plus$colon((Object)standardOpenOption)));
    }

    public static Seq writeRotate$default$3$(DeprecatedFilesApi $this) {
        return $this.writeRotate$default$3();
    }

    default public Seq<StandardOpenOption> writeRotate$default$3() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    private static Path copy$$anonfun$1(Path source$1, Path target$1, Seq flags$1) {
        return java.nio.file.Files.copy(source$1, target$1, (CopyOption[])Arrays$.MODULE$.seqToArray(flags$1, CopyOption.class));
    }

    private static Path createDirectory$$anonfun$1(Path path$1, Seq flags$2) {
        return java.nio.file.Files.createDirectory(path$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(flags$2, FileAttribute.class));
    }

    private static Path createDirectories$$anonfun$1(Path path$2, Seq flags$3) {
        return java.nio.file.Files.createDirectories(path$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(flags$3, FileAttribute.class));
    }

    private static DirectoryStream directoryStream$$anonfun$1(Path path$3) {
        return java.nio.file.Files.newDirectoryStream(path$3);
    }

    private static DirectoryStream directoryStream$$anonfun$3(Path path$4, Function1 filter$1) {
        return java.nio.file.Files.newDirectoryStream(path$4, entry -> BoxesRunTime.unboxToBoolean((Object)filter$1.apply(entry)));
    }

    private static DirectoryStream directoryStream$$anonfun$5(Path path$5, String glob$1) {
        return java.nio.file.Files.newDirectoryStream(path$5, glob$1);
    }

    private static boolean exists$$anonfun$1(Path path$6, Seq flags$4) {
        return java.nio.file.Files.exists(path$6, (LinkOption[])Arrays$.MODULE$.seqToArray(flags$4, LinkOption.class));
    }

    private static boolean isDirectory$$anonfun$1(Path path$7, Seq linkOption$1) {
        return java.nio.file.Files.isDirectory(path$7, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOption$1, LinkOption.class));
    }

    private static boolean isFile$$anonfun$1(Path path$8, Seq linkOption$2) {
        return java.nio.file.Files.isRegularFile(path$8, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOption$2, LinkOption.class));
    }

    private static Path move$$anonfun$1(Path source$2, Path target$2, Seq flags$5) {
        return java.nio.file.Files.move(source$2, target$2, (CopyOption[])Arrays$.MODULE$.seqToArray(flags$5, CopyOption.class));
    }

    private static scala.collection.immutable.Set permissions$$anonfun$1(Path path$9, Seq flags$6) {
        Set set = CollectionCompat$.MODULE$.JSetOps(java.nio.file.Files.getPosixFilePermissions(path$9, (LinkOption[])Arrays$.MODULE$.seqToArray(flags$6, LinkOption.class)));
        return CollectionCompat$JSetOps$.MODULE$.asScala$extension(set);
    }

    private static Path setPermissions$$anonfun$1(Path path$10, scala.collection.immutable.Set permissions$1) {
        scala.collection.immutable.Set set = CollectionCompat$.MODULE$.SetOps(permissions$1);
        return java.nio.file.Files.setPosixFilePermissions(path$10, CollectionCompat$SetOps$.MODULE$.asJava$extension(set));
    }

    private static Path tempFile$$anonfun$1(String prefix$1, String suffix$1, Seq attributes$1, Path dir$1) {
        return java.nio.file.Files.createTempFile(dir$1, prefix$1, suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$1, FileAttribute.class));
    }

    private static Path tempFile$$anonfun$2(String prefix$2, String suffix$2, Seq attributes$2) {
        return java.nio.file.Files.createTempFile(prefix$2, suffix$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$2, FileAttribute.class));
    }

    private static Path tempDirectory$$anonfun$1(String prefix$3, Seq attributes$3, Path dir$2) {
        return java.nio.file.Files.createTempDirectory(dir$2, prefix$3, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$3, FileAttribute.class));
    }

    private static Path tempDirectory$$anonfun$2(String prefix$4, Seq attributes$4) {
        return java.nio.file.Files.createTempDirectory(prefix$4, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$4, FileAttribute.class));
    }

    private static java.util.stream.Stream walk$$anonfun$1(Path start$1, int maxDepth$1, Seq options$1) {
        return java.nio.file.Files.walk(start$1, maxDepth$1, (FileVisitOption[])Arrays$.MODULE$.seqToArray(options$1, FileVisitOption.class));
    }
}

