/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.file.FileHandle;
import fs2.io.file.Files$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.$less$colon$less$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

public interface FileHandleCompanionPlatform {
    public static Resource fromPath$(FileHandleCompanionPlatform $this, Path path, Seq flags, Async evidence$1) {
        return $this.fromPath(path, (Seq<OpenOption>)flags, evidence$1);
    }

    default public <F> Resource<F, FileHandle<F>> fromPath(Path path, Seq<OpenOption> flags, Async<F> evidence$1) {
        return Files$.MODULE$.apply(Files$.MODULE$.forAsync((Async)evidence$1)).open(path, flags);
    }

    public static Resource fromFileChannel$(FileHandleCompanionPlatform $this, Object channel, Async evidence$2) {
        return $this.fromFileChannel(channel, evidence$2);
    }

    default public <F> Resource<F, FileHandle<F>> fromFileChannel(Object channel, Async<F> evidence$2) {
        return Files$.MODULE$.apply(Files$.MODULE$.forAsync((Async)evidence$2)).openFileChannel(channel);
    }

    public static FileHandle make$(FileHandleCompanionPlatform $this, FileChannel chan, Sync F) {
        return $this.make(chan, F);
    }

    default public <F> FileHandle<F> make(FileChannel chan, Sync<F> F) {
        return new FileHandle<F>(chan, F){
            private final FileChannel chan$1;
            private final Sync F$1;
            {
                this.chan$1 = chan$2;
                this.F$1 = F$2;
            }

            public Object force(boolean metaData) {
                return this.F$1.blocking((Function0 & Serializable)() -> {
                    this.force$$anonfun$1(metaData);
                    return BoxedUnit.UNIT;
                });
            }

            public Object lock() {
                return this.F$1.blocking(this::lock$$anonfun$1);
            }

            public Object lock(long position, long size, boolean shared) {
                return this.F$1.blocking(() -> this.lock$$anonfun$2(position, size, shared));
            }

            public Object read(int numBytes, long offset) {
                return this.F$1.blocking(() -> this.read$$anonfun$1(numBytes, offset));
            }

            public Object size() {
                return this.F$1.blocking(this::size$$anonfun$1);
            }

            public Object truncate(long size) {
                return this.F$1.blocking((Function0 & Serializable)() -> {
                    this.truncate$$anonfun$1(size);
                    return BoxedUnit.UNIT;
                });
            }

            public Object tryLock() {
                return this.F$1.blocking(this::tryLock$$anonfun$1);
            }

            public Object tryLock(long position, long size, boolean shared) {
                return this.F$1.blocking(() -> this.tryLock$$anonfun$2(position, size, shared));
            }

            public Object unlock(FileLock f) {
                return this.F$1.blocking(() -> FileHandleCompanionPlatform.fs2$io$file$FileHandleCompanionPlatform$$anon$1$$_$unlock$$anonfun$adapted$1(f));
            }

            public Object write(Chunk bytes, long offset) {
                return this.F$1.blocking(() -> this.write$$anonfun$1(bytes, offset));
            }

            private final void force$$anonfun$1(boolean metaData$1) {
                this.chan$1.force(metaData$1);
            }

            private final FileLock lock$$anonfun$1() {
                return this.chan$1.lock();
            }

            private final FileLock lock$$anonfun$2(long position$1, long size$1, boolean shared$1) {
                return this.chan$1.lock(position$1, size$1, shared$1);
            }

            private final Option read$$anonfun$1(int numBytes$1, long offset$1) {
                ByteBuffer buf = ByteBuffer.allocate(numBytes$1);
                int len = this.chan$1.read(buf, offset$1);
                if (len < 0) {
                    return None$.MODULE$;
                }
                if (len == 0) {
                    return Some$.MODULE$.apply((Object)Chunk$.MODULE$.empty());
                }
                return Some$.MODULE$.apply((Object)Chunk$.MODULE$.array((Object)buf.array(), 0, len, ClassTag$.MODULE$.apply(Byte.TYPE)));
            }

            private final long size$$anonfun$1() {
                return this.chan$1.size();
            }

            private final void truncate$$anonfun$1(long size$2) {
                this.chan$1.truncate(size$2);
            }

            private final Option tryLock$$anonfun$1() {
                return Option$.MODULE$.apply((Object)this.chan$1.tryLock());
            }

            private final Option tryLock$$anonfun$2(long position$2, long size$3, boolean shared$2) {
                return Option$.MODULE$.apply((Object)this.chan$1.tryLock(position$2, size$3, shared$2));
            }

            private final int write$$anonfun$1(Chunk bytes$1, long offset$2) {
                return this.chan$1.write(bytes$1.toByteBuffer($less$colon$less$.MODULE$.refl()), offset$2);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{force$$anonfun$adapted$1(boolean ), lock$$anonfun$1(), lock$$anonfun$2(long long boolean ), read$$anonfun$1(int long ), size$$anonfun$1(), truncate$$anonfun$adapted$1(long ), tryLock$$anonfun$1(), tryLock$$anonfun$2(long long boolean ), fs2$io$file$FileHandleCompanionPlatform$$anon$1$$_$unlock$$anonfun$adapted$1(java.nio.channels.FileLock ), write$$anonfun$1(fs2.Chunk long )}, serializedLambda);
            }
        };
    }

    private static void unlock$$anonfun$1(FileLock f$1) {
        f$1.release();
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FileHandleCompanionPlatform$$anon$1$$_$unlock$$anonfun$adapted$1(FileLock f$2) {
        FileHandleCompanionPlatform.unlock$$anonfun$1(f$2);
        return BoxedUnit.UNIT;
    }
}

