/*
 * Decompiled with CFR 0.152.
 */
package fs2.io;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Show;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.package$;
import fs2.text$;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ClassTag;
import scala.runtime.Nothing$;
import scala.util.NotGiven$;

public interface iojvmnative {
    public static Function1 stdout$(iojvmnative $this, Sync evidence$1) {
        return $this.stdout(evidence$1);
    }

    default public <F> Function1<Stream<F, Object>, Stream<F, Nothing$>> stdout(Sync<F> evidence$1) {
        return package$.MODULE$.writeOutputStream(Sync$.MODULE$.apply(evidence$1).blocking(iojvmnative::stdout$$anonfun$1), false, evidence$1);
    }

    public static Function1 stderr$(iojvmnative $this, Sync evidence$2) {
        return $this.stderr(evidence$2);
    }

    default public <F> Function1<Stream<F, Object>, Stream<F, Nothing$>> stderr(Sync<F> evidence$2) {
        return package$.MODULE$.writeOutputStream(Sync$.MODULE$.apply(evidence$2).blocking(iojvmnative::stderr$$anonfun$1), false, evidence$2);
    }

    public static Function1 stdoutLines$(iojvmnative $this, Charset charset, Sync evidence$3, Show evidence$4) {
        return $this.stdoutLines(charset, evidence$3, evidence$4);
    }

    default public <F, O> Function1<Stream<F, O>, Stream<F, Nothing$>> stdoutLines(Charset charset, Sync<F> evidence$3, Show<O> evidence$4) {
        return (Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)_$5 -> package.all$.MODULE$.toShow(_$5, evidence$4).show()).through(text$.MODULE$.encode(charset)).through(this.stdout(evidence$3));
    }

    public static Charset stdoutLines$default$1$(iojvmnative $this) {
        return $this.stdoutLines$default$1();
    }

    default public <F, O> Charset stdoutLines$default$1() {
        return StandardCharsets.UTF_8;
    }

    public static Stream readClassResource$(iojvmnative $this, String name, int chunkSize, Sync F, ClassTag ct) {
        return $this.readClassResource(name, chunkSize, F, ct);
    }

    default public <F, C> Stream<F, Object> readClassResource(String name, int chunkSize, Sync<F> F, ClassTag<C> ct) {
        return Stream$.MODULE$.eval(F.blocking(() -> iojvmnative.readClassResource$$anonfun$1(name, ct))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                InputStream resource = (InputStream)((Some)option).value();
                InputStream inputStream = (InputStream)package.all$.MODULE$.catsSyntaxApplicativeId((Object)resource);
                return package$.MODULE$.readInputStream(ApplicativeIdOps$.MODULE$.pure$extension((Object)inputStream, (Applicative)F), chunkSize, package$.MODULE$.readInputStream$default$3(), F);
            }
            if (None$.MODULE$.equals(option)) {
                return Stream$.MODULE$.raiseError((Throwable)new IOException(new StringBuilder(19).append("Resource ").append(name).append(" not found").toString()), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F));
            }
            throw new MatchError((Object)option);
        }, NotGiven$.MODULE$.value());
    }

    public static int readClassResource$default$2$(iojvmnative $this) {
        return $this.readClassResource$default$2();
    }

    default public int readClassResource$default$2() {
        return 65536;
    }

    public static Stream readClassLoaderResource$(iojvmnative $this, String name, int chunkSize, ClassLoader classLoader, Sync F) {
        return $this.readClassLoaderResource(name, chunkSize, classLoader, F);
    }

    default public <F> Stream<F, Object> readClassLoaderResource(String name, int chunkSize, ClassLoader classLoader, Sync<F> F) {
        return Stream$.MODULE$.eval(F.blocking(() -> iojvmnative.readClassLoaderResource$$anonfun$1(name, classLoader))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                InputStream resource = (InputStream)((Some)option).value();
                InputStream inputStream = (InputStream)package.all$.MODULE$.catsSyntaxApplicativeId((Object)resource);
                return package$.MODULE$.readInputStream(ApplicativeIdOps$.MODULE$.pure$extension((Object)inputStream, (Applicative)F), chunkSize, package$.MODULE$.readInputStream$default$3(), F);
            }
            if (None$.MODULE$.equals(option)) {
                return Stream$.MODULE$.raiseError((Throwable)new IOException(new StringBuilder(19).append("Resource ").append(name).append(" not found").toString()), RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F));
            }
            throw new MatchError((Object)option);
        }, NotGiven$.MODULE$.value());
    }

    public static int readClassLoaderResource$default$2$(iojvmnative $this) {
        return $this.readClassLoaderResource$default$2();
    }

    default public int readClassLoaderResource$default$2() {
        return 65536;
    }

    public static ClassLoader readClassLoaderResource$default$3$(iojvmnative $this) {
        return $this.readClassLoaderResource$default$3();
    }

    default public <F> ClassLoader readClassLoaderResource$default$3() {
        return this.getClass().getClassLoader();
    }

    private static OutputStream stdout$$anonfun$1() {
        return System.out;
    }

    private static OutputStream stderr$$anonfun$1() {
        return System.err;
    }

    private static Option readClassResource$$anonfun$1(String name$1, ClassTag ct$1) {
        return Option$.MODULE$.apply((Object)ct$1.runtimeClass().getResourceAsStream(name$1));
    }

    private static Option readClassLoaderResource$$anonfun$1(String name$3, ClassLoader classLoader$1) {
        return Option$.MODULE$.apply((Object)classLoader$1.getResourceAsStream(name$3));
    }
}

