/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.std.Semaphore;
import cats.effect.std.Semaphore$;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.net.Socket;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;

public interface SocketCompanionPlatform {
    public static Resource forAsync$(SocketCompanionPlatform $this, AsynchronousSocketChannel ch, Async evidence$1) {
        return $this.forAsync(ch, evidence$1);
    }

    default public <F> Resource<F, Socket<F>> forAsync(AsynchronousSocketChannel ch, Async<F> evidence$1) {
        return cats.effect.package$.MODULE$.Resource().make(package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(Semaphore$.MODULE$.apply(1L, evidence$1), Semaphore$.MODULE$.apply(1L, evidence$1))).mapN((Function2 & Serializable)(readSemaphore, writeSemaphore) -> new AsyncSocket(this, ch, readSemaphore, writeSemaphore, evidence$1), evidence$1, evidence$1), (Function1 & Serializable)_$2 -> cats.effect.package$.MODULE$.Async().apply(evidence$1).delay((Function0 & Serializable)() -> {
            SocketCompanionPlatform.forAsync$$anonfun$2$$anonfun$1(ch);
            return BoxedUnit.UNIT;
        }), evidence$1);
    }

    private static void forAsync$$anonfun$2$$anonfun$1(AsynchronousSocketChannel ch$3) {
        if (ch$3.isOpen()) {
            ch$3.close();
            return;
        }
    }

    public static Chunk fs2$io$net$SocketCompanionPlatform$BufferedReads$$_$releaseBuffer$$anonfun$1(ByteBuffer buffer$1) {
        Chunk chunk;
        int read = buffer$1.position();
        if (read == 0) {
            chunk = Chunk$.MODULE$.empty();
        } else {
            byte[] dest = new byte[read];
            ((Buffer)buffer$1).flip();
            buffer$1.get(dest);
            chunk = Chunk$.MODULE$.array((Object)dest, ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        Chunk result = chunk;
        ((Buffer)buffer$1).clear();
        return result;
    }

    public static /* synthetic */ Option fs2$io$net$SocketCompanionPlatform$BufferedReads$$_$read$$anonfun$1$$anonfun$1$$anonfun$1(Chunk _$5) {
        return Some$.MODULE$.apply((Object)_$5);
    }

    public final class AsyncSocket<F>
    extends BufferedReads<F> {
        private final AsynchronousSocketChannel ch;
        private final Semaphore<F> writeSemaphore;
        private final Async<F> F;
        private final /* synthetic */ SocketCompanionPlatform $outer;

        public AsyncSocket(SocketCompanionPlatform $outer, AsynchronousSocketChannel ch, Semaphore<F> readSemaphore, Semaphore<F> writeSemaphore, Async<F> F) {
            this.ch = ch;
            this.writeSemaphore = writeSemaphore;
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, readSemaphore, F);
        }

        @Override
        public F readChunk(ByteBuffer buffer) {
            return (F)this.F.async((Function1 & Serializable)cb -> {
                this.ch.read(buffer, null, new IntCompletionHandler((Function1<Either<Throwable, Object>, BoxedUnit>)cb));
                return this.F.delay(this::readChunk$$anonfun$1$$anonfun$1);
            });
        }

        @Override
        public F write(Chunk<Object> bytes) {
            return (F)this.writeSemaphore.permit().use((Function1 & Serializable)_$8 -> this.go$2(bytes.toByteBuffer($less$colon$less$.MODULE$.refl())), this.F);
        }

        @Override
        public F localAddress() {
            return (F)this.F.delay(this::localAddress$$anonfun$1);
        }

        @Override
        public F remoteAddress() {
            return (F)this.F.delay(this::remoteAddress$$anonfun$1);
        }

        @Override
        public F isOpen() {
            return (F)this.F.delay(this::isOpen$$anonfun$1);
        }

        @Override
        public F endOfOutput() {
            return (F)this.F.delay((Function0 & Serializable)() -> {
                this.endOfOutput$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F endOfInput() {
            return (F)this.F.delay((Function0 & Serializable)() -> {
                this.endOfInput$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public final /* synthetic */ SocketCompanionPlatform fs2$io$net$SocketCompanionPlatform$AsyncSocket$$$outer() {
            return this.$outer;
        }

        private final void readChunk$$anonfun$1$$anonfun$1$$anonfun$1() {
            this.ch.shutdownInput();
        }

        private final Option readChunk$$anonfun$1$$anonfun$1() {
            return Some$.MODULE$.apply(this.F.delay((Function0 & Serializable)() -> {
                this.readChunk$$anonfun$1$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }));
        }

        private final void go$2$$anonfun$1$$anonfun$1$$anonfun$1() {
            this.ch.shutdownOutput();
        }

        private final Option go$2$$anonfun$1$$anonfun$1() {
            return Some$.MODULE$.apply(this.F.delay((Function0 & Serializable)() -> {
                this.go$2$$anonfun$1$$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            }));
        }

        private final /* synthetic */ Object go$2$$anonfun$2(ByteBuffer buff$2, int written) {
            if (written >= 0 && buff$2.remaining() > 0) {
                return this.go$2(buff$2);
            }
            return this.F.unit();
        }

        private final Object go$2(ByteBuffer buff) {
            return package.all$.MODULE$.toFlatMapOps(this.F.async((Function1 & Serializable)cb -> {
                this.ch.write(buff, null, new IntCompletionHandler((Function1<Either<Throwable, Object>, BoxedUnit>)cb));
                return this.F.delay(this::go$2$$anonfun$1$$anonfun$1);
            }), this.F).flatMap((Function1 & Serializable)written -> this.go$2$$anonfun$2(buff, BoxesRunTime.unboxToInt((Object)written)));
        }

        private final SocketAddress localAddress$$anonfun$1() {
            return SocketAddress$.MODULE$.fromInetSocketAddress((InetSocketAddress)this.ch.getLocalAddress());
        }

        private final SocketAddress remoteAddress$$anonfun$1() {
            return SocketAddress$.MODULE$.fromInetSocketAddress((InetSocketAddress)this.ch.getRemoteAddress());
        }

        private final boolean isOpen$$anonfun$1() {
            return this.ch.isOpen();
        }

        private final void endOfOutput$$anonfun$1() {
            this.ch.shutdownOutput();
        }

        private final void endOfInput$$anonfun$1() {
            this.ch.shutdownInput();
        }
    }

    public abstract class BufferedReads<F>
    implements Socket<F> {
        private final Semaphore<F> readSemaphore;
        private final Async<F> F;
        private ByteBuffer readBuffer;
        private final /* synthetic */ SocketCompanionPlatform $outer;

        public BufferedReads(SocketCompanionPlatform $outer, Semaphore<F> readSemaphore, Async<F> F) {
            this.readSemaphore = readSemaphore;
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            int defaultReadSize = 8192;
            this.readBuffer = ByteBuffer.allocateDirect(8192);
        }

        private <A> F withReadBuffer(int size, Function1<ByteBuffer, F> f) {
            return (F)this.readSemaphore.permit().use((Function1 & Serializable)_$4 -> {
                Object object = package.all$.MODULE$.catsSyntaxFlatten(this.F.delay(() -> this.withReadBuffer$$anonfun$1$$anonfun$1(size, f)), this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }, this.F);
        }

        public abstract F readChunk(ByteBuffer var1);

        private F releaseBuffer(ByteBuffer buffer) {
            return (F)this.F.delay(() -> SocketCompanionPlatform.fs2$io$net$SocketCompanionPlatform$BufferedReads$$_$releaseBuffer$$anonfun$1(buffer));
        }

        @Override
        public F read(int max) {
            return this.withReadBuffer(max, (Function1 & Serializable)buffer -> package.all$.MODULE$.toFlatMapOps(this.readChunk((ByteBuffer)buffer), this.F).flatMap((Function1 & Serializable)read -> this.read$$anonfun$1$$anonfun$1((ByteBuffer)buffer, BoxesRunTime.unboxToInt((Object)read))));
        }

        @Override
        public F readN(int max) {
            return this.withReadBuffer(max, (Function1 & Serializable)buffer -> this.go$1(max, (ByteBuffer)buffer));
        }

        @Override
        public Stream<F, Object> reads() {
            Stream stream = Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.repeatEval(this.read(8192)));
            return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writes() {
            return (Function1 & Serializable)_$6 -> _$6.chunks().foreach((Function1 & Serializable)bytes -> this.write((Chunk<Object>)bytes));
        }

        public final /* synthetic */ SocketCompanionPlatform fs2$io$net$SocketCompanionPlatform$BufferedReads$$$outer() {
            return this.$outer;
        }

        private final Object withReadBuffer$$anonfun$1$$anonfun$1(int size$2, Function1 f$2) {
            Buffer buffer;
            if (this.readBuffer.capacity() < size$2) {
                this.readBuffer = ByteBuffer.allocateDirect(size$2);
                buffer = BoxedUnit.UNIT;
            } else {
                buffer = ((Buffer)this.readBuffer).limit(size$2);
            }
            return f$2.apply((Object)this.readBuffer);
        }

        private final /* synthetic */ Object read$$anonfun$1$$anonfun$1(ByteBuffer buffer$2, int read) {
            if (read < 0) {
                return this.F.pure((Object)None$.MODULE$);
            }
            return package.all$.MODULE$.toFunctorOps(this.releaseBuffer(buffer$2), this.F).map(SocketCompanionPlatform::fs2$io$net$SocketCompanionPlatform$BufferedReads$$_$read$$anonfun$1$$anonfun$1$$anonfun$1);
        }

        private final /* synthetic */ Object go$1$$anonfun$1(int max$2, ByteBuffer buffer$4, int readBytes) {
            if (readBytes < 0 || buffer$4.position() >= max$2) {
                return this.releaseBuffer(buffer$4);
            }
            return this.go$1(max$2, buffer$4);
        }

        private final Object go$1(int max$1, ByteBuffer buffer$3) {
            return package.all$.MODULE$.toFlatMapOps(this.readChunk(buffer$3), this.F).flatMap((Function1 & Serializable)readBytes -> this.go$1$$anonfun$1(max$1, buffer$3, BoxesRunTime.unboxToInt((Object)readBytes)));
        }
    }

    public final class IntCompletionHandler
    implements CompletionHandler<Integer, Object> {
        private final Function1<Either<Throwable, Object>, BoxedUnit> cb;

        public IntCompletionHandler(Function1<Either<Throwable, Object>, BoxedUnit> cb) {
            this.cb = cb;
        }

        @Override
        public void completed(Integer i, Object attachment) {
            this.cb.apply((Object)package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(i))));
        }

        @Override
        public void failed(Throwable err, Object attachment) {
            this.cb.apply((Object)package$.MODULE$.Left().apply((Object)err));
        }
    }
}

