/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net.unixsocket;

import cats.effect.kernel.Async;
import cats.effect.kernel.Async$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.std.Semaphore;
import cats.effect.std.Semaphore$;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files$;
import fs2.io.file.Path$;
import fs2.io.net.Socket;
import fs2.io.net.Socket$;
import fs2.io.net.SocketCompanionPlatform;
import fs2.io.net.unixsocket.JdkUnixSockets$;
import fs2.io.net.unixsocket.JnrUnixSockets$;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;

public interface UnixSocketsCompanionPlatform {
    public static UnixSockets forAsync$(UnixSocketsCompanionPlatform $this, Async F) {
        return $this.forAsync(F);
    }

    default public <F> UnixSockets<F> forAsync(Async<F> F) {
        if (JdkUnixSockets$.MODULE$.supported()) {
            return JdkUnixSockets$.MODULE$.forAsync(F);
        }
        if (JnrUnixSockets$.MODULE$.supported()) {
            return JnrUnixSockets$.MODULE$.forAsync(F);
        }
        throw new UnsupportedOperationException("Must either run on JDK 16+ or have \"com.github.jnr\" % \"jnr-unixsocket\" % <version> on the classpath");
    }

    public static Resource fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket$(UnixSocketsCompanionPlatform $this, SocketChannel ch, Async evidence$1) {
        return $this.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket(ch, evidence$1);
    }

    default public <F> Resource<F, Socket<F>> fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket(SocketChannel ch, Async<F> evidence$1) {
        return Resource$.MODULE$.make(package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(Semaphore$.MODULE$.apply(1L, evidence$1), Semaphore$.MODULE$.apply(1L, evidence$1))).mapN((Function2 & Serializable)(readSemaphore, writeSemaphore) -> new AsyncSocket(this, ch, readSemaphore, writeSemaphore, evidence$1), evidence$1, evidence$1), (Function1 & Serializable)_$5 -> Async$.MODULE$.apply(evidence$1).delay((Function0 & Serializable)() -> {
            UnixSocketsCompanionPlatform.makeSocket$$anonfun$2$$anonfun$1(ch);
            return BoxedUnit.UNIT;
        }), evidence$1);
    }

    public static /* synthetic */ SocketChannel fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncUnixSockets$$_$acceptChannel$1$$anonfun$1(SocketChannel ch) {
        ch.configureBlocking(false);
        return ch;
    }

    private static void makeSocket$$anonfun$2$$anonfun$1(SocketChannel ch$3) {
        if (ch$3.isOpen()) {
            ch$3.close();
            return;
        }
    }

    public final class AsyncSocket<F>
    extends SocketCompanionPlatform.BufferedReads<F> {
        private final SocketChannel ch;
        private final Semaphore<F> writeSemaphore;
        private final Async<F> F;
        private final /* synthetic */ UnixSocketsCompanionPlatform $outer;

        public AsyncSocket(UnixSocketsCompanionPlatform $outer, SocketChannel ch, Semaphore<F> readSemaphore, Semaphore<F> writeSemaphore, Async<F> F) {
            this.ch = ch;
            this.writeSemaphore = writeSemaphore;
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(Socket$.MODULE$, readSemaphore, F);
        }

        @Override
        public F readChunk(ByteBuffer buff) {
            return (F)this.F.blocking(() -> this.readChunk$$anonfun$1(buff));
        }

        @Override
        public F write(Chunk<Object> bytes) {
            return (F)this.writeSemaphore.permit().use((Function1 & Serializable)_$7 -> this.go$2(bytes.toByteBuffer($less$colon$less$.MODULE$.refl())), this.F);
        }

        @Override
        public F localAddress() {
            return this.raiseIpAddressError();
        }

        @Override
        public F remoteAddress() {
            return this.raiseIpAddressError();
        }

        private <A> F raiseIpAddressError() {
            return (F)this.F.raiseError((Object)new UnsupportedOperationException("UnixSockets do not use IP addressing"));
        }

        @Override
        public F isOpen() {
            return (F)this.F.blocking(this::isOpen$$anonfun$1);
        }

        public F close() {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.close$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F endOfOutput() {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.endOfOutput$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F endOfInput() {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.endOfInput$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public final /* synthetic */ UnixSocketsCompanionPlatform fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncSocket$$$outer() {
            return this.$outer;
        }

        private final int readChunk$$anonfun$1(ByteBuffer buff$1) {
            return this.ch.read(buff$1);
        }

        private final int go$2$$anonfun$1(ByteBuffer buff$2) {
            return this.ch.write(buff$2);
        }

        private final Object go$2$$anonfun$2(ByteBuffer buff$3) {
            if (buff$3.remaining() <= 0) {
                return this.F.unit();
            }
            return this.go$2(buff$3);
        }

        private final Object go$2(ByteBuffer buff) {
            Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.F.blocking(() -> this.go$2$$anonfun$1(buff)), this.F);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.go$2$$anonfun$2(buff), this.F);
        }

        private final boolean isOpen$$anonfun$1() {
            return this.ch.isOpen();
        }

        private final void close$$anonfun$1() {
            this.ch.close();
        }

        private final void endOfOutput$$anonfun$1() {
            this.ch.shutdownOutput();
        }

        private final void endOfInput$$anonfun$1() {
            this.ch.shutdownInput();
        }
    }

    public abstract class AsyncUnixSockets<F>
    implements UnixSockets<F> {
        private final Async<F> F;
        private final /* synthetic */ UnixSocketsCompanionPlatform $outer;

        public AsyncUnixSockets(UnixSocketsCompanionPlatform $outer, Async<F> F) {
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public abstract F openChannel(UnixSocketAddress var1);

        public abstract F openServerChannel(UnixSocketAddress var1);

        @Override
        public Resource<F, Socket<F>> client(UnixSocketAddress address) {
            return Resource$.MODULE$.eval(this.openChannel(address)).flatMap((Function1 & Serializable)_$3 -> this.$outer.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket((SocketChannel)_$3, this.F));
        }

        @Override
        public Stream<F, Socket<F>> server(UnixSocketAddress address, boolean deleteIfExists, boolean deleteOnClose) {
            return Stream$.MODULE$.resource(Resource$.MODULE$.make(this.setup$1(address, deleteIfExists), (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object closeChannel = tuple2._2();
                    return this.cleanup$1(address, deleteOnClose, closeChannel);
                }
                throw new MatchError((Object)tuple2);
            }, this.F), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object accept = tuple2._1();
                    return this.acceptIncoming$1(accept);
                }
                throw new MatchError((Object)tuple2);
            }, NotGiven$.MODULE$.value());
        }

        public final /* synthetic */ UnixSocketsCompanionPlatform fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncUnixSockets$$$outer() {
            return this.$outer;
        }

        private final Object setup$1$$anonfun$1(UnixSocketAddress address$2) {
            return Files$.MODULE$.apply(Files$.MODULE$.forAsync((Async)this.F)).deleteIfExists(Path$.MODULE$.apply(address$2.path()));
        }

        private final Object setup$1(UnixSocketAddress address$1, boolean deleteIfExists$1) {
            Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.setup$1$$anonfun$1(address$1));
            return package.all$.MODULE$.catsSyntaxApply(ApplicativeByNameOps$.MODULE$.whenA$extension(function0, deleteIfExists$1, this.F), this.F).$times$greater(this.openServerChannel(address$1));
        }

        private final Object cleanup$1$$anonfun$1(UnixSocketAddress address$4) {
            return Files$.MODULE$.apply(Files$.MODULE$.forAsync((Async)this.F)).deleteIfExists(Path$.MODULE$.apply(address$4.path()));
        }

        private final Object cleanup$1(UnixSocketAddress address$3, boolean deleteOnClose$1, Object closeChannel) {
            Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.cleanup$1$$anonfun$1(address$3));
            return package.all$.MODULE$.catsSyntaxApply(closeChannel, this.F).$times$greater(ApplicativeByNameOps$.MODULE$.whenA$extension(function0, deleteOnClose$1, this.F));
        }

        private final Object acceptChannel$1(Object accept$2) {
            return package.all$.MODULE$.toFunctorOps(accept$2, this.F).map(UnixSocketsCompanionPlatform::fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncUnixSockets$$_$acceptChannel$1$$anonfun$1);
        }

        private final Stream go$1$$anonfun$2(Object accept$3) {
            return this.go$1(accept$3);
        }

        private final Stream go$1(Object accept$1) {
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.acceptChannel$1(accept$1), this.F);
            return Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F)).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.empty());
                    return Stream.PureOps$.MODULE$.apply$extension(stream);
                }
                if (either instanceof Right) {
                    SocketChannel accepted = (SocketChannel)((Right)either).value();
                    return Stream$.MODULE$.resource(this.$outer.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket(accepted, this.F), this.F);
                }
                throw new MatchError((Object)either);
            }, NotGiven$.MODULE$.value()).$plus$plus(() -> this.go$1$$anonfun$2(accept$1));
        }

        private final Stream acceptIncoming$1(Object accept) {
            return this.go$1(accept);
        }
    }
}

