/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CpuUsageGaugeSet
implements MetricSet {
    private static final ObjectName RUNTIME_MBEAN;
    private static final String UPTIME_ATTR = "Uptime";
    private static final ObjectName OS_MBEAN;
    private static final String AVAILABLE_PROCESSORS_ATTR = "AvailableProcessors";
    private static final String PROCESS_CPU_TIME_ATTR = "ProcessCpuTime";
    private static final String PROCESS_CPU_LOAD_ATTR = "ProcessCpuLoad";
    private static final String SYSTEM_CPU_LOAD_ATTR = "SystemCpuLoad";
    private static final String SYSTEM_LOAD_AVERAGE_ATTR = "SystemLoadAverage";
    private final MBeanServer mbeanServer;

    public CpuUsageGaugeSet() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public CpuUsageGaugeSet(MBeanServer beanServer) {
        this.mbeanServer = beanServer;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        if (this.hasAttribute(OS_MBEAN, PROCESS_CPU_TIME_ATTR) && this.hasAttribute(RUNTIME_MBEAN, UPTIME_ATTR)) {
            gauges.put("process.cpuUsage", (Metric)new Gauge<Double>(){
                private long prevUptime = -1L;
                private long prevProcessCpuTime = -1L;

                public Double getValue() {
                    long uptime = CpuUsageGaugeSet.this.getAttributeLong(RUNTIME_MBEAN, CpuUsageGaugeSet.UPTIME_ATTR) * 1000000L;
                    long processCpuTime = CpuUsageGaugeSet.this.getAttributeLong(OS_MBEAN, CpuUsageGaugeSet.PROCESS_CPU_TIME_ATTR);
                    double cpuUsage = 0.0;
                    if (this.prevUptime != -1L) {
                        long uptimeDiff = uptime - this.prevUptime;
                        long processTimeDiff = processCpuTime - this.prevProcessCpuTime;
                        cpuUsage = (uptimeDiff > 0L ? (double)processTimeDiff / (double)uptimeDiff : 0.0) * 100.0;
                    }
                    this.prevUptime = uptime;
                    this.prevProcessCpuTime = processCpuTime;
                    return cpuUsage;
                }
            });
        }
        if (this.hasAttribute(OS_MBEAN, PROCESS_CPU_LOAD_ATTR)) {
            gauges.put("process.cpuLoad", (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return CpuUsageGaugeSet.this.getAttributeDouble(OS_MBEAN, CpuUsageGaugeSet.PROCESS_CPU_LOAD_ATTR) * 100.0;
                }
            });
        }
        if (this.hasAttribute(OS_MBEAN, SYSTEM_LOAD_AVERAGE_ATTR)) {
            gauges.put("system.loadAverage", (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return CpuUsageGaugeSet.this.getAttributeDouble(OS_MBEAN, CpuUsageGaugeSet.SYSTEM_LOAD_AVERAGE_ATTR) * 100.0;
                }
            });
        }
        if (this.hasAttribute(OS_MBEAN, SYSTEM_CPU_LOAD_ATTR)) {
            gauges.put("system.cpuLoad", (Metric)new Gauge<Double>(){

                public Double getValue() {
                    return CpuUsageGaugeSet.this.getAttributeDouble(OS_MBEAN, CpuUsageGaugeSet.SYSTEM_CPU_LOAD_ATTR) * 100.0;
                }
            });
        }
        return gauges;
    }

    private boolean hasAttribute(ObjectName mbean, String attr) {
        try {
            MBeanInfo info = this.mbeanServer.getMBeanInfo(mbean);
            for (MBeanAttributeInfo ai : info.getAttributes()) {
                if (!attr.equals(ai.getName())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getAttributeInt(ObjectName mbean, String attr) {
        try {
            return (Integer)this.mbeanServer.getAttribute(mbean, attr);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get attribute " + attr + " from MBean " + mbean, e);
        }
    }

    private long getAttributeLong(ObjectName mbean, String attr) {
        try {
            return (Long)this.mbeanServer.getAttribute(mbean, attr);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get attribute " + attr + " from MBean " + mbean, e);
        }
    }

    private double getAttributeDouble(ObjectName mbean, String attr) {
        try {
            return (Double)this.mbeanServer.getAttribute(mbean, attr);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get attribute " + attr + " from MBean " + mbean, e);
        }
    }

    static {
        try {
            RUNTIME_MBEAN = new ObjectName("java.lang:type=Runtime");
            OS_MBEAN = new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }
}

