/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.RecordingDouble;
import co.paralleluniverse.common.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlightRecorderMessage {
    private final String clazz;
    private final String method;
    private final String format;
    private final Object[] args;
    private final StackTraceElement[] stackTrace;

    public FlightRecorderMessage(String clazz, String method, String format, Object[] args) {
        this.clazz = clazz;
        this.method = method;
        this.format = format;
        this.args = args;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.recordingDouble(args[i]);
            }
        }
        this.stackTrace = Debug.isRecordStackTraces() ? Thread.currentThread().getStackTrace() : null;
    }

    public String toString() {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i] == null || !this.args[i].getClass().isArray()) continue;
                Class<?> t = this.args[i].getClass().getComponentType();
                this.args[i] = t == Boolean.TYPE ? Arrays.toString((boolean[])this.args[i]) : (t == Byte.TYPE ? Arrays.toString((byte[])this.args[i]) : (t == Character.TYPE ? Arrays.toString((char[])this.args[i]) : (t == Short.TYPE ? Arrays.toString((short[])this.args[i]) : (t == Integer.TYPE ? Arrays.toString((int[])this.args[i]) : (t == Long.TYPE ? Arrays.toString((long[])this.args[i]) : (t == Float.TYPE ? Arrays.toString((float[])this.args[i]) : (t == Double.TYPE ? Arrays.toString((double[])this.args[i]) : Arrays.toString((Object[])this.args[i]))))))));
            }
        }
        Object[] ps = this.args != null ? new Object[this.args.length + 2] : new Object[2];
        ps[0] = this.clazz;
        ps[1] = this.method;
        if (this.args != null && this.args.length > 0) {
            System.arraycopy(this.args, 0, ps, 2, this.args.length);
        }
        try {
            Formatter formatter = new Formatter();
            formatter.format("%s.%s " + this.format, ps);
            String string = formatter.toString();
            if (this.stackTrace != null) {
                string = string + " at: " + Arrays.toString(this.stackTrace);
            }
            return string;
        }
        catch (Exception e) {
            return "ERROR in formatting this message: " + this.clazz + "." + this.method + " " + this.format;
        }
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getMethod() {
        return this.method;
    }

    public Object recordingDouble(Object obj) {
        try {
            if (obj instanceof RecordingDouble) {
                return ((RecordingDouble)obj).getRecordingDouble();
            }
            if (obj instanceof Map) {
                return new HashMap((Map)obj);
            }
            if (obj instanceof Set) {
                return new HashSet((Set)obj);
            }
            if (obj instanceof List) {
                return new ArrayList((List)obj);
            }
            return obj;
        }
        catch (Exception e) {
            return "<ERROR: " + e.getMessage() + '>';
        }
    }
}

