/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.ExecutorServiceLatencyProbe;
import co.paralleluniverse.common.monitoring.ForkJoinInfo;
import co.paralleluniverse.common.monitoring.ForkJoinPoolMXBean;
import co.paralleluniverse.common.monitoring.ForkJoinPoolMonitor;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import jsr166e.ForkJoinPool;

public class JMXForkJoinPoolMonitor
extends ForkJoinPoolMonitor
implements ForkJoinPoolMXBean {
    private final String mbeanName;
    private boolean registered;

    public JMXForkJoinPoolMonitor(String name, ForkJoinPool fjPool) {
        super(name, fjPool);
        this.mbeanName = "co.paralleluniverse:type=ForkJoinPool,name=" + name;
        this.registerMBean();
    }

    protected void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, mxbeanName);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public void unregister() {
        try {
            if (this.registered) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.mbeanName));
            }
            this.registered = false;
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    protected ForkJoinPool fjPool() {
        ForkJoinPool fjPool = super.fjPool();
        if (fjPool == null) {
            this.unregister();
            throw new RuntimeException("Pool collected");
        }
        return fjPool;
    }

    @Override
    public ForkJoinPoolMonitor.Status getStatus() {
        ForkJoinPool fjPool = this.fjPool();
        if (fjPool.isTerminated()) {
            return ForkJoinPoolMonitor.Status.TERMINATED;
        }
        if (fjPool.isTerminating()) {
            return ForkJoinPoolMonitor.Status.TERMINATING;
        }
        if (fjPool.isShutdown()) {
            return ForkJoinPoolMonitor.Status.SHUTDOWN;
        }
        if (fjPool.isQuiescent()) {
            return ForkJoinPoolMonitor.Status.QUIESCENT;
        }
        return ForkJoinPoolMonitor.Status.ACTIVE;
    }

    @Override
    public boolean getAsyncMode() {
        return this.fjPool().getAsyncMode();
    }

    @Override
    public int getParallelism() {
        return this.fjPool().getParallelism();
    }

    @Override
    public int getPoolSize() {
        return this.fjPool().getPoolSize();
    }

    @Override
    public int getActiveThreadCount() {
        return this.fjPool().getActiveThreadCount();
    }

    @Override
    public int getRunningThreadCount() {
        return this.fjPool().getRunningThreadCount();
    }

    @Override
    public int getQueuedSubmissionCount() {
        return this.fjPool().getQueuedSubmissionCount();
    }

    @Override
    public long getQueuedTaskCount() {
        return this.fjPool().getQueuedTaskCount();
    }

    @Override
    public long getStealCount() {
        return this.fjPool().getStealCount();
    }

    @Override
    public long[] getLatency() {
        return new ExecutorServiceLatencyProbe(this.fjPool(), 5).fire();
    }

    @Override
    public ForkJoinInfo getInfo() {
        ForkJoinPool fjPool = this.fjPool();
        int activeThreadCount = fjPool.getActiveThreadCount();
        int runningThreadCount = fjPool.getRunningThreadCount();
        int queuedSumbmissionCount = fjPool.getQueuedSubmissionCount();
        long queuedTaskCount = fjPool.getQueuedTaskCount();
        long stealCount = fjPool.getStealCount();
        return new ForkJoinInfo(activeThreadCount, runningThreadCount, queuedSumbmissionCount, queuedTaskCount, stealCount);
    }

    @Override
    public void shutdown() {
        this.fjPool().shutdown();
    }

    @Override
    public void shutdownNow() {
        this.fjPool().shutdownNow();
    }
}

