/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberInfo;
import java.util.Arrays;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;

class FibersDetailedMonitor {
    private final NonBlockingHashMapLong<Fiber> fibers = new NonBlockingHashMapLong();

    FibersDetailedMonitor() {
    }

    void fiberStarted(Fiber fiber) {
        this.fibers.put(fiber.getId(), fiber);
    }

    void fiberTerminated(Fiber fiber) {
        this.fibers.remove(fiber.getId());
    }

    public long[] getAllFiberIds() {
        int i;
        int size = this.fibers.size();
        NonBlockingHashMapLong.IteratorLong it = (NonBlockingHashMapLong.IteratorLong)this.fibers.keys();
        long[] ids = new long[size];
        for (i = 0; it.hasNext() && i < size; ++i) {
            ids[i] = it.nextLong();
        }
        if (i < size) {
            return Arrays.copyOf(ids, i);
        }
        return ids;
    }

    public FiberInfo getFiberInfo(long id, boolean stack) {
        Fiber f = this.fibers.get(id);
        if (f == null) {
            return null;
        }
        return f.getFiberInfo(stack);
    }

    public FiberInfo[] getFiberInfo(long[] ids, boolean stack) {
        FiberInfo[] fis = new FiberInfo[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            fis[i] = this.getFiberInfo(ids[i], stack);
        }
        return fis;
    }
}

