/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.SingleConsumerArrayQueue;

public class SingleConsumerArrayObjectQueue<E>
extends SingleConsumerArrayQueue<E> {
    private final Object[] array;
    private static final int base;
    private static final int shift;

    public SingleConsumerArrayObjectQueue(int size) {
        super(size);
        this.array = new Object[this.capacity];
    }

    @Override
    public E value(int index) {
        return (E)this.array[index];
    }

    @Override
    int arrayLength() {
        return this.array.length;
    }

    @Override
    public boolean enq(E item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        long i = this.preEnq();
        if (i < 0L) {
            return false;
        }
        this.volatileSet((int)i & this.mask, item);
        return true;
    }

    @Override
    boolean hasNext(long lind, int iind) {
        return this.get(iind) != null;
    }

    @Override
    void awaitValue(long i) {
        while (this.get((int)i & this.mask) == null) {
        }
    }

    @Override
    void clearValue(int index) {
        this.array[index] = null;
    }

    @Override
    void copyValue(int to, int from) {
        this.array[to] = this.array[from];
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    private void volatileSet(int i, Object value) {
        UNSAFE.putObjectVolatile(this.array, SingleConsumerArrayObjectQueue.byteOffset(i), value);
    }

    private void orderedSet(int i, Object value) {
        UNSAFE.putOrderedObject(this.array, SingleConsumerArrayObjectQueue.byteOffset(i), value);
    }

    private Object get(int i) {
        return UNSAFE.getObjectVolatile(this.array, SingleConsumerArrayObjectQueue.byteOffset(i));
    }

    static {
        try {
            base = UNSAFE.arrayBaseOffset(Object[].class);
            int scale = UNSAFE.arrayIndexScale(Object[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

