/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.BasicSingleConsumerDoubleQueue;
import co.paralleluniverse.strands.queues.DoubleQueueIterator;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedDWordQueue;
import co.paralleluniverse.strands.queues.SingleConsumerLinkedQueue;

public class SingleConsumerLinkedDoubleQueue
extends SingleConsumerLinkedDWordQueue<Double>
implements BasicSingleConsumerDoubleQueue {
    @Override
    public boolean enq(double item) {
        return this.enqRaw(Double.doubleToRawLongBits(item));
    }

    @Override
    public boolean enq(Double item) {
        if (item == null) {
            throw new IllegalArgumentException("null values not allowed");
        }
        return this.enq((double)item);
    }

    double doubleValue(SingleConsumerLinkedQueue.Node<Double> node) {
        return Double.longBitsToDouble(this.rawValue(node));
    }

    @Override
    Double value(SingleConsumerLinkedQueue.Node<Double> node) {
        return this.doubleValue(node);
    }

    @Override
    public double pollDouble() {
        SingleConsumerLinkedQueue.Node<Double> n = this.pk();
        double val = this.doubleValue(n);
        this.deq(n);
        return val;
    }

    @Override
    public DoubleQueueIterator iterator() {
        return new DoubleLinkedQueueIterator();
    }

    private class DoubleLinkedQueueIterator
    extends SingleConsumerLinkedQueue.LinkedQueueIterator
    implements DoubleQueueIterator {
        private DoubleLinkedQueueIterator() {
            super(SingleConsumerLinkedDoubleQueue.this);
        }

        @Override
        public double doubleValue() {
            return SingleConsumerLinkedDoubleQueue.this.doubleValue(this.n);
        }

        @Override
        public double doubleNext() {
            this.n = SingleConsumerLinkedDoubleQueue.this.succ(this.n);
            return this.doubleValue();
        }
    }
}

