/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.ConstraintAsset;
import com.adobe.aem.dermis.model.DataModel;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.IRule;
import com.adobe.aem.dermis.model.PropertyType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.models.annotations.Optional;

public class Property
extends ConstraintAsset
implements IProperty {
    private String parameterType;
    private Boolean required = false;
    private boolean nullable = true;
    @Inject
    @Optional
    @Named(value="fd:rules")
    private IRule rules;
    @Named(value="fdm:primaryKey")
    private Boolean isPrimaryKey = false;
    private transient IDataModel dataModel;
    private List<IProperty> properties;
    @Named(value="items")
    private IDataModel childDataModel;
    @Named(value="enum")
    private Object[] enumList;

    public Property() {
    }

    public Property(String name, String description, PropertyType type) {
        super(name, description, type);
    }

    public Property(String name, String description, PropertyType type, String typeRef) {
        super(name, description, type);
        this.setTypeRef(typeRef);
    }

    public Property(String name, PropertyType type, IDataModel dataModel) {
        super(name, null, type);
        this.dataModel = dataModel;
    }

    public Property(String name, PropertyType type, IDataModel dataModel, Boolean required) {
        this(name, type, dataModel);
        this.required = required;
    }

    public Property(String name, PropertyType type, IDataModel dataModel, Boolean isPrimaryKey, Boolean required) {
        this(name, type, dataModel);
        this.isPrimaryKey = isPrimaryKey;
        this.required = required;
    }

    public Property(String title, String name, String description, PropertyType type, String typeRef, PropertyType subType, String subTypeRef) {
        super(name, description, type);
        this.setTypeRef(typeRef);
        this.setSubType(subType);
        this.setSubTypeRef(subTypeRef);
        this.setTitle(title);
    }

    @Override
    public IDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public Boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public boolean isComputed() {
        return false;
    }

    @Override
    public IDataModel getChildDataModel() {
        return this.childDataModel;
    }

    @Override
    @JsonIgnore
    public IDataModel getAssociatedDataModel() {
        DataModel dataModel = null;
        if (this.properties != null) {
            dataModel = new DataModel();
            dataModel.setProperties(this.properties);
            dataModel.setName(this.getName());
            dataModel.setTitle(this.getTitle());
            dataModel.setDescription(this.getDescription());
        } else if (this.childDataModel != null && this.childDataModel.getProperties() != null) {
            dataModel = (DataModel)this.childDataModel;
        }
        return dataModel;
    }

    @Override
    public void setChildDataModel(IDataModel childDataModel) {
        this.childDataModel = childDataModel;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @JsonIgnore
    public Boolean getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setIsPrimaryKey(Boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public void setDataModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public String getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    @Override
    public List<? extends IProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<IProperty> properties) {
        this.properties = properties;
    }

    @Override
    public Object[] getEnumList() {
        return this.enumList;
    }

    public void setEnumList(Object[] enumList) {
        this.enumList = enumList;
    }

    public void addAssociation(PropertyType associationType, IDataModel dataModel) throws DermisException {
        if (associationType == PropertyType.ARRAY || associationType == PropertyType.OBJECT) {
            if (associationType == PropertyType.OBJECT) {
                this.setProperties(dataModel.getProperties());
                this.setChildDataModel(null);
            } else {
                this.setProperties(null);
                this.setSubType(PropertyType.OBJECT);
                this.setChildDataModel(dataModel);
            }
        } else {
            throw new DermisException("AEM-FDM-001-004");
        }
    }

    @Override
    public String getReferenceName() {
        String entityName = null;
        if (StringUtils.isNotBlank((String)this.getTypeRef())) {
            entityName = this.getTypeRef();
        } else if (StringUtils.isNotBlank((String)this.getSubTypeRef())) {
            entityName = this.getSubTypeRef();
        }
        return entityName;
    }

    @Override
    @JsonIgnore
    public String getIdentifier() {
        String identifier = StringUtils.isNotBlank((String)this.getId()) ? this.getId() : this.getName();
        return identifier;
    }

    @Override
    @JsonIgnore
    public boolean isComplexType() {
        boolean result = false;
        if (PropertyType.OBJECT == this.getSubType() || PropertyType.OBJECT == this.getType()) {
            result = true;
        } else if (StringUtils.isNotEmpty((String)this.getTypeRef()) || StringUtils.isNotEmpty((String)this.getSubTypeRef())) {
            result = true;
        }
        return result;
    }

    public boolean isArrayOfPrimitive() {
        boolean result = false;
        PropertyType subType = this.getSubType();
        result = PropertyType.ARRAY == this.getType() && subType != null && subType != PropertyType.OBJECT;
        return result;
    }

    @Override
    public IRule getRules() {
        return this.rules;
    }

    @Override
    @JsonIgnore
    public boolean isBelowCollection() {
        throw new UnsupportedOperationException("This property is not supported in property class");
    }

    @Override
    @JsonIgnore
    public boolean isPrimitiveType() {
        return !this.isComplexType() && !this.isArrayOfPrimitive();
    }
}

