/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.addon.dor;

import com.adobe.aemds.guide.addon.dor.DoRUtils;
import com.adobe.xfa.Element;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Subform;
import com.day.cq.i18n.I18n;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigPropertiesUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPropertiesUtils.class);

    private static String translate(String text, I18n i18n) {
        return i18n != null ? i18n.get(text) : text;
    }

    private static String translateVar(String text, I18n i18n) {
        return i18n != null ? i18n.getVar(text) : text;
    }

    public static JSONObject getConfigProperties(Subform rootSubform, I18n i18n) {
        if (rootSubform == null) {
            return null;
        }
        Element font = (Element)rootSubform.resolveNode("#font", true, false, true);
        Element color = (Element)rootSubform.resolveNode("#fill.#color", true, false, true);
        JSONObject items = new JSONObject();
        try {
            if (color != null) {
                String colorValue = color.getAttribute(XFA.VALUETAG).getAttrValue();
                JSONObject accentColor = new JSONObject();
                accentColor.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/colorfield");
                accentColor.put("showProperties", false);
                accentColor.put("fieldLabel", (Object)ConfigPropertiesUtils.translate("Accent Color", i18n));
                accentColor.put("fieldDescription", (Object)ConfigPropertiesUtils.translate("Specifies a color to emphasize a form object in Document of Record.", i18n));
                accentColor.put("name", (Object)"./accentColor");
                accentColor.put("showSwatches", true);
                accentColor.put("value", (Object)DoRUtils.convertColorToHEX(colorValue));
                items.put("accentColor", (Object)accentColor);
            }
            if (font != null) {
                String typeface = font.getAttribute(XFA.TYPEFACETAG).getAttrValue();
                JSONObject datasource = new JSONObject();
                datasource.put("sling:resourceType", (Object)"fd/af/dor/services/getFontList");
                JSONObject options = new JSONObject();
                options.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/autocomplete/list");
                JSONObject values = new JSONObject();
                values.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/autocomplete/tags");
                JSONObject fontFamily = new JSONObject();
                fontFamily.put("sling:resourceType", (Object)"granite/ui/components/coral/foundation/form/autocomplete");
                fontFamily.put("emptyText", (Object)ConfigPropertiesUtils.translate("Select", i18n));
                fontFamily.put("fieldLabel", (Object)ConfigPropertiesUtils.translate("Font Family", i18n));
                fontFamily.put("fieldDescription", (Object)ConfigPropertiesUtils.translate("Specifies a font for the form object. The specified font is used only in Document of Record.", i18n));
                fontFamily.put("name", (Object)"./fontFamily");
                fontFamily.put("variant", (Object)"quiet");
                fontFamily.put("value", (Object)typeface);
                fontFamily.put("datasource", (Object)datasource);
                fontFamily.put("options", (Object)options);
                fontFamily.put("values", (Object)values);
                items.put("fontFamily", (Object)fontFamily);
            }
        }
        catch (Exception e) {
            logger.error("Error while extracting configuration properties from template", (Throwable)e);
        }
        return items;
    }
}

