/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.adobe.aemds.guide.service.GuideException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideDatePicker
extends GuideField {
    protected Logger logger = LoggerFactory.getLogger(GuideDatePicker.class);

    @Override
    public String getGuideFieldType() {
        return "guideDatePicker";
    }

    public String getHtml5Type() {
        return (String)this.resourceProps.get("html5Type", (Object)"text");
    }

    public String getDateInputOptions() {
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter writer = new JSONWriter((Writer)jsonStringWriter);
        try {
            writer.object();
            writer.key("dateFormat").value(this.resourceProps.get("dateDisplayFormat", (Object)"date{M/D/YYYY}"));
            writer.key("placeholderMonth").value((Object)this.externalize((String)this.resourceProps.get("placeholderMonth", (Object)""), "placeholderMonth"));
            writer.key("placeholderDay").value((Object)this.externalize((String)this.resourceProps.get("placeholderDay", (Object)""), "placeholderDay"));
            writer.key("placeholderYear").value((Object)this.externalize((String)this.resourceProps.get("placeholderYear", (Object)""), "placeholderYear"));
            writer.key("labelMonth").value((Object)this.externalize((String)this.resourceProps.get("titleMonth", (Object)""), "titleMonth"));
            writer.key("labelDay").value((Object)this.externalize((String)this.resourceProps.get("titleDay", (Object)""), "titleDay"));
            writer.key("labelYear").value((Object)this.externalize((String)this.resourceProps.get("titleYear", (Object)""), "titleYear"));
            writer.key("hideLabels").value((Object)this.checkIfDateInputTitleHidden());
            writer.endObject();
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
        return jsonStringWriter.toString();
    }

    public Boolean checkIfDateInputTitleHidden() {
        return (Boolean)this.resourceProps.get("hideTitleDate", (Object)false);
    }

    public String getHeightOfDiv() {
        if (!this.checkIfDateInputTitleHidden().booleanValue()) {
            return "showDateInputLabels";
        }
        return "";
    }

    public Boolean isMaxDateExcluded() {
        return (Boolean)this.resourceProps.get("exclusiveMaximum", (Object)false);
    }

    public Boolean isMinDateExcluded() {
        return (Boolean)this.resourceProps.get("exclusiveMinimum", (Object)false);
    }

    public String getMaximumDate() {
        String maxDateInString = (String)this.resourceProps.get("maximum", (Object)"");
        if (!maxDateInString.isEmpty() && this.isMaxDateExcluded().booleanValue()) {
            Date maxDate = this.convertStringToDate(maxDateInString);
            maxDate = this.addDaysToDate(maxDate, -1);
            maxDateInString = this.convertDateToString(maxDate);
        }
        return maxDateInString;
    }

    public String getMinimumDate() {
        String minDateInString = (String)this.resourceProps.get("minimum", (Object)"");
        if (!minDateInString.isEmpty() && this.isMinDateExcluded().booleanValue()) {
            Date minDate = this.convertStringToDate(minDateInString);
            minDate = this.addDaysToDate(minDate, 1);
            minDateInString = this.convertDateToString(minDate);
        }
        return minDateInString;
    }

    private Date convertStringToDate(String dateInString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        try {
            date = formatter.parse(dateInString);
        }
        catch (ParseException e) {
            this.logger.error("Error in converting date picker string to date" + e.getMessage());
        }
        return date;
    }

    private String convertDateToString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateInString = formatter.format(date);
        return dateInString;
    }

    private Date addDaysToDate(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }
}

