/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.assembler.client;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMMsgSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ASMMsgSet.class);
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(ASMMsgSet.class.getName());
    public static final String PREFIX = "AEM-";
    public static final String ASM_N00_000_ASSEMBLER_VERSION = "AEM-ASM-N00-000";
    public static final String ASM_N00_001_NORMAL = "AEM-ASM-N00-001";
    public static final String ASM_S00_001_MISSING_DDX = "AEM-ASM-S00-001";
    public static final String ASM_S00_002_DDX_EXECUTION_ERROR = "AEM-ASM-S00-002";
    public static final String ASM_S00_003_LOG_PASSIVATION_FAILED = "AEM-ASM-S00-003";
    public static final String ASM_S00_004_FONT_MANAGER_ERROR = "AEM-ASM-S00-004";
    public static final String ASM_S00_005_NO_CONTENT = "AEM-ASM-S00-005";
    public static final String ASM_S00_006_PASSIVATE_FAILED = "AEM-ASM-S00-006";
    public static final String ASM_S00_007_UNKNOWN_OR_NO_RESULT = "AEM-ASM-S00-007";
    public static final String ASM_S00_008_INVALID_PDF_DOCUMENT = "AEM-ASM-S00-008";
    public static final String ASM_S00_009_INVALID_XDP_DOCUMENT = "AEM-ASM-S00-009";
    public static final String ASM_S00_010_DOCUMENT_FAILED_TO_OPEN = "AEM-ASM-S00-010";
    public static final String ASM_S00_011_CLONE_FAILED_FOR_DOM = "AEM-ASM-S00-011";
    public static final String ASM_S00_012_CLOSE_FAILED = "AEM-ASM-S00-012";
    public static final String ASM_S00_013_MISSING_SYSTEM_CONTEXT = "AEM-ASM-S00-013";
    public static final String ASM_S00_014_MISSING_PDF_INPUT_DOCUMENT = "AEM-ASM-S00-014";
    public static final String ASM_S00_015_TOO_MANY_OUPUT_DOCUMENTS = "AEM-ASM_S00_015";
    public static final String ASM_S00_016_FD_DOCUMENT_ERROR = "AEM-ASM_S00_016";
    public static final String ASM_S00_017_JPEG_DECODE_FAILURE = "AEM-ASM-S00-017";
    public static final String ASM_S01_004_CONTENT_CONVERSION_ERROR = "AEM-ASM-S01-004";
    public static final String ASM_W00_001_INVALID_LOG_LEVEL = "AEM-ASM-W00-001";
    public static final String ASM_W00_002_LOGGING_IMPACTS_PERFORMANCE = "AEM-ASM-W00-002";
    public static final String ASM_W00_003_OBSOLETE = "AEM-ASM-W00-003";
    public static final String ASM_W00_004_OBSOLETE = "AEM-ASM-W00-004";
    public static final String ASM_W00_005_BAD_INPUT_MAP_XREF = "AEM-ASM-W00-005";
    public static final String ASM_W00_006_BAD_INPUT_MAP_OBJECT = "AEM-ASM-W00-006";
    public static final String ASM_W00_007_DOCUMENT_FAILED_TO_CLOSE = "AEM-ASM-W00-007";
    public static final String ASM_W00_008_MULTIPLE_XPATHS_IN_PROCESS_URL = "AEM-ASM-W00-008";
    public static final String ASM_W00_009_INVALID_URL = "AEM-ASM-W00-009";
    public static final String ASM_W00_010_UNKNOWN_SIGNATURE_COMPATIBILITY = "AEM-ASM-W00-010";
    public static final String ASM_S01_001_SERVICE_FAILED = "AEM-ASM-S01-001";
    public static final String ASM_S01_002_SERVICE_STATUS = "AEM-ASM-S01-002";
    public static final String ASM_S01_003_SERVICE_NOT_INSTALLED = "AEM-ASM-S01-003";
    public static final String ASM_S01_005_HANDLE_CLEAN_UP_ERROR = "AEM-ASM-S01-005";
    public static final String ASM_W01_001_SIGNATURE_VERIFY_FAILED = "AEM-ASM-W01-001";
    public static final String ASM_N02_001_BOOTSTRAP = "AEM-ASM-N02-001";
    public static final String ASM_N02_002_PROCESSING_START = "AEM-ASM-N02-002";
    public static final String ASM_N02_003_VALIDATION_NOT_PDFA_COMPLIANT = "AEM-ASM-N02-003";
    public static final String ASM_N02_004_VALIDATION_PDFA_COMPLIANT = "AEM-ASM-N02-004";
    public static final String ASM_N02_005_PARTIAL_PDFA_CONVERSION = "AEM-ASM-N02-005";
    public static final String ASM_N02_006_FULL_PDFA_CONVERSION = "AEM-ASM-N02-006";
    public static final String ASM_S02_001_DOCUMENT_ERROR = "AEM-ASM-S02-001";
    public static final String ASM_S02_002_LOG_PASSIVATION_FAILED = "AEM-ASM-S02-002";
    public static final String ASM_S02_003_PDFA_VALIDATION_ERROR = "AEM-ASM-S02-003";
    public static final String ASM_S02_004_PDFA_CONVERSION_ERROR = "AEM-ASM-S02-004";
    public static final String ASM_S02_005_PDFA_TEMPORARY_OUTPUT_ERROR = "AEM-ASM-S02-005";
    public static final String ASM_W02_UNABLE_TOGET_CONTENT_TYPE = "AEM-ASM-W02-001";

    public static String getMessage(String code, Object[] args) {
        String message = null;
        try {
            if (code == null) {
                return null;
            }
            String messageString = RESOURCES.getString(code);
            message = args != null ? ASMMsgSet.fastFormat(messageString, args) : messageString;
        }
        catch (Exception e) {
            LOGGER.error("Exception caught in fetching error message ", (Throwable)e);
        }
        return code + ": " + message;
    }

    protected static String fastFormat(String msg, Object[] args) {
        try {
            if (args == null || args.length == 0) {
                return msg;
            }
            StringBuffer res = new StringBuffer();
            int pos = 0;
            int cursor = 0;
            int len = msg.length();
            while (cursor < len) {
                char c;
                if ((c = msg.charAt(cursor++)) == '{') {
                    String numStr;
                    int paramNum;
                    int loc = cursor;
                    while (cursor < len && msg.charAt(cursor) != '}') {
                        ++cursor;
                    }
                    if (cursor >= len) break;
                    if ((paramNum = Integer.parseInt(numStr = msg.substring(loc, cursor++))) >= args.length) continue;
                    res.append(msg.substring(pos, loc - 1));
                    if (args[paramNum] == null) {
                        res.append("null");
                    } else {
                        res.append(args[paramNum].toString());
                    }
                    pos = cursor;
                    continue;
                }
                if (c != '\'' || cursor >= len) continue;
                res.append(msg.substring(pos, cursor - 1));
                pos = cursor;
                c = msg.charAt(cursor++);
                if (c == '\'') {
                    res.append(c);
                } else {
                    while (cursor < len) {
                        if (msg.charAt(cursor++) != '\'') continue;
                        if (cursor >= len || msg.charAt(cursor) != '\'') break;
                        res.append(msg.substring(pos, cursor++));
                        pos = cursor;
                    }
                    int n = --cursor;
                    ++cursor;
                    res.append(msg.substring(pos, n));
                }
                pos = cursor;
            }
            if (pos < len) {
                res.append(msg.substring(pos, len));
            }
            return res.toString();
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Ignore exceptions", (Throwable)e);
            return MessageFormat.format(msg, args);
        }
    }
}

