/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures;

import com.adobe.fd.signatures.client.types.exceptions.CredentialNotFoundException;
import com.adobe.fd.signatures.client.types.exceptions.InvalidArgumentException;
import com.adobe.fd.signatures.hsm.HSMCredential;
import com.adobe.fd.signatures.hsm.api.HSMCredentialProviderImpl;
import com.adobe.fd.signatures.hsm.internal.transaction.util.TransactionUtil;
import com.adobe.fd.signatures.impl.ReferenceProvider;
import com.adobe.fd.signatures.pki.client.CertificateInfo;
import com.adobe.fd.signatures.pki.client.spi.PKICredential;
import com.adobe.fd.signatures.truststore.businessobject.HSMProfileBO;
import com.adobe.granite.keystore.KeyStoreService;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.net.ssl.X509KeyManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProviderService {
    private static CredentialProviderService credentialProvider = new CredentialProviderService();
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialProviderService.class);
    private HashMap<String, HSMProfileBO> hsmProfiles = new HashMap();

    private CredentialProviderService() {
    }

    public PKICredential getCredential(String alias, ResourceResolver resourceResolver) throws InvalidArgumentException, CredentialNotFoundException {
        if (alias == null || alias.equals("")) {
            LOGGER.debug("Alias is blank or null");
            throw new InvalidArgumentException("Alias can't be blank or null");
        }
        if (resourceResolver == null) {
            LOGGER.debug("ResourceResolver is null");
            throw new InvalidArgumentException("ResourceResolver can't be null");
        }
        KeyStoreService keyService = ReferenceProvider.getInstance().getKeyService();
        KeyStore keyStore = keyService.getKeyStore(resourceResolver);
        X509KeyManager keyManager = (X509KeyManager)keyService.getKeyManager(resourceResolver);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ResourceResolver.getUserID " + resourceResolver.getUserID());
            LOGGER.debug("Credential Alias " + alias);
        }
        try {
            if (keyStore.getCertificate(alias) != null) {
                return this.createCredential(alias, keyStore, keyManager);
            }
            LOGGER.debug("Alias " + alias + " not found in keystore");
            throw new CredentialNotFoundException("Alias " + alias + " not found in keystore");
        }
        catch (KeyStoreException e) {
            LOGGER.debug("error while fetching credentials from Keystore:->", (Throwable)e);
            throw new CredentialNotFoundException("error while fetching credentials from Keystore:->", e);
        }
    }

    private PKICredential createCredential(String alias, KeyStore keyStore, X509KeyManager keyManager) throws CredentialNotFoundException, KeyStoreException {
        return new KeystoreCredential(alias, keyStore, keyManager);
    }

    public static CredentialProviderService getInstance() {
        return credentialProvider;
    }

    public HSMProfileBO getHSMProfile(String alias) {
        return this.hsmProfiles.get(alias);
    }

    public void addHSMProfile(String alias, HSMProfileBO hsmProfileBO) {
        this.hsmProfiles.put(alias, hsmProfileBO);
    }

    public HSMProfileBO removeHSMProfile(String alias) {
        return this.hsmProfiles.remove(alias);
    }

    public HSMCredential getHSMCredential(String alias) throws Exception {
        HSMProfileBO hsmProfile = this.hsmProfiles.get(alias);
        return this.getHSMCredential(hsmProfile);
    }

    public HSMCredential getHSMCredential(final HSMProfileBO hsmProfile) throws Exception {
        try {
            HSMCredential hsmCred = (HSMCredential)TransactionUtil.execute((Callable)new Callable<HSMCredential>(){

                @Override
                public HSMCredential call() throws Exception {
                    HSMCredential hsmCred = null;
                    HSMCredentialProviderImpl hsmCredentialProvider = new HSMCredentialProviderImpl();
                    hsmCred = hsmCredentialProvider.getHSMCredential(hsmProfile);
                    return hsmCred;
                }
            });
            return hsmCred;
        }
        catch (Exception ex) {
            LOGGER.info("Exception in toPSWithSMT", (Throwable)ex);
            throw ex;
        }
    }

    private class KeystoreCredential
    extends PKICredential {
        KeystoreCredential(String alias, KeyStore keyStore, X509KeyManager keyManager) throws KeyStoreException, CredentialNotFoundException {
            if (keyStore.isKeyEntry(alias)) {
                PrivateKey pk = keyManager.getPrivateKey(alias);
                X509Certificate[] certchain = keyManager.getCertificateChain(alias);
                if (certchain != null && certchain.length != 0) {
                    LOGGER.debug("certificate chain for the alias " + alias);
                    CertificateInfo[] certInfoChain = new CertificateInfo[certchain.length];
                    for (int j = 0; j < certchain.length; ++j) {
                        certInfoChain[j] = new CertificateInfo(certchain[j]);
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("certificate " + j + 1 + certInfoChain[j].getAlias());
                    }
                    super.initialize(certInfoChain[0], certInfoChain, pk, keyStore.getProvider().getName());
                } else {
                    throw new CredentialNotFoundException("No CertificateChain is found for alias " + alias);
                }
            }
        }
    }
}

