/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures.pki.client.types.prefs;

import com.adobe.fd.signatures.pki.client.spi.PKICredential;
import com.adobe.fd.signatures.pki.client.types.common.HashAlgorithm;
import com.adobe.fd.signatures.pki.client.types.common.OCSPURLtoConsultOption;
import com.adobe.fd.signatures.pki.client.types.common.RevocationCheckStyle;
import com.adobe.fd.signatures.pki.client.types.prefs.CommonPreferencesImpl;
import com.adobe.fd.signatures.pki.client.types.prefs.OCSPPreferences;
import com.adobe.fd.signatures.pki.client.types.prefs.PreferencesMap;

public class OCSPPreferencesImpl
extends CommonPreferencesImpl
implements OCSPPreferences {
    private static final long serialVersionUID = -6848716568342505018L;
    private static final String ocspServerURLStr = "ocspServerURL";
    private static final String ocspDigestAlgo = "hashAlgo";
    private static final HashAlgorithm ocspDigestAlgo_Default = HashAlgorithm.SHA1;
    private static final String sendNonceStr = "sendNonce";
    private static final Boolean sendNonce_Default = new Boolean(true);
    private static final String maxClockSkewStr = "maxClockSkew";
    private static final Long maxClockSkew_Default = new Long(5L);
    private static final String responseFreshnessStr = "responseFreshness";
    private static final Long responseFreshness_Default = new Long(525600L);
    private static final String URLtoConsultStr = "URLtoConsult";
    private static final OCSPURLtoConsultOption URLtoConsult_Default = OCSPURLtoConsultOption.UseAIAIfPresentElseLocal;
    private static final String doSignRequestStr = "doSignRequest";
    private static final Boolean doSignRequest_Default = false;
    private static final String useCacheStr = "useCache";
    private static final Boolean useCache_Default = true;
    private static final String ignoreValidityDatesStr = "ignoreValidityDates";
    private static final Boolean ignoreValidityDates_Default = false;
    private static final String goOnlineStr = "goOnline";
    private static final Boolean goOnline_Default = true;
    private static final String allowOCSPNoCheckStr = "allowOCSPNoCheck";
    private static final Boolean allowOCSPNoCheck_Default = true;
    private static final String requireOCSPCertHashStr = "requireOCSPCertHash";
    private static final Boolean requireOCSPCertHash_Default = false;
    private static final String requestSignerCredentialAliasStr = "requestSignerCredentialAlias";

    @Override
    protected Object getPrefValueFromString(String prefName, String value) {
        if (prefName.equalsIgnoreCase(ocspServerURLStr)) {
            return value.trim().length() != 0 ? value.trim() : null;
        }
        if (prefName.equalsIgnoreCase(ocspDigestAlgo)) {
            return HashAlgorithm.getValueFromString(value.trim());
        }
        if (prefName.equalsIgnoreCase(sendNonceStr) || prefName.equalsIgnoreCase(doSignRequestStr) || prefName.equalsIgnoreCase(useCacheStr) || prefName.equalsIgnoreCase(ignoreValidityDatesStr) || prefName.equalsIgnoreCase(goOnlineStr) || prefName.equalsIgnoreCase(allowOCSPNoCheckStr) || prefName.equalsIgnoreCase(requireOCSPCertHashStr)) {
            return Boolean.valueOf(value);
        }
        if (prefName.equalsIgnoreCase(maxClockSkewStr) || prefName.equalsIgnoreCase(responseFreshnessStr)) {
            return Long.valueOf(value);
        }
        if (prefName.equalsIgnoreCase(URLtoConsultStr)) {
            return OCSPURLtoConsultOption.getValueFromString(value.trim());
        }
        return super.getPrefValueFromString(prefName, value);
    }

    public OCSPPreferencesImpl() {
        super(RevocationCheckStyle.CheckIfAvailable);
        this.put(sendNonceStr, (Object)sendNonce_Default);
        this.put(maxClockSkewStr, (Object)maxClockSkew_Default);
        this.put(responseFreshnessStr, (Object)responseFreshness_Default);
        this.put(doSignRequestStr, (Object)doSignRequest_Default);
        this.put(ocspDigestAlgo, (Object)ocspDigestAlgo_Default);
        this.put(URLtoConsultStr, (Object)URLtoConsult_Default);
        this.put(useCacheStr, (Object)useCache_Default);
        this.put(ignoreValidityDatesStr, (Object)ignoreValidityDates_Default);
        this.put(goOnlineStr, (Object)goOnline_Default);
        this.put(allowOCSPNoCheckStr, (Object)allowOCSPNoCheck_Default);
        this.put(requireOCSPCertHashStr, (Object)requireOCSPCertHash_Default);
    }

    @Override
    public boolean getDoSignRequest() {
        return (Boolean)this.get(doSignRequestStr);
    }

    public void setDoSignRequest(boolean doSignRequest) {
        this.put(doSignRequestStr, (Object)doSignRequest);
    }

    @Override
    public long getMaxClockSkew() {
        return (Long)this.get(maxClockSkewStr);
    }

    public void setMaxClockSkew(long maxClockSkew) {
        this.put(maxClockSkewStr, (Object)maxClockSkew);
    }

    @Override
    public String getOcspServerURL() {
        return (String)this.get(ocspServerURLStr);
    }

    public void setOcspServerURL(String ocspServerURL) {
        this.put(ocspServerURLStr, (Object)ocspServerURL);
    }

    @Override
    public PKICredential getRequestSignerCredential() {
        return (PKICredential)this.get(requestSignerCredentialAliasStr);
    }

    public void setRequestSignerCredential(PKICredential cred) {
        this.put(requestSignerCredentialAliasStr, (Object)cred);
    }

    @Override
    public long getResponseFreshness() {
        return (Long)this.get(responseFreshnessStr);
    }

    public void setResponseFreshness(long responseFreshness) {
        this.put(responseFreshnessStr, (Object)responseFreshness);
    }

    @Override
    public boolean getSendNonce() {
        return (Boolean)this.get(sendNonceStr);
    }

    public void setSendNonce(boolean sendNonce) {
        this.put(sendNonceStr, (Object)sendNonce);
    }

    @Override
    public OCSPURLtoConsultOption getURLtoConsult() {
        return (OCSPURLtoConsultOption)((Object)this.get(URLtoConsultStr));
    }

    public void setURLtoConsult(OCSPURLtoConsultOption urlToConsult) {
        this.put(URLtoConsultStr, (Object)urlToConsult);
    }

    public void setDigestAlgorithm(HashAlgorithm algo) {
        this.put(ocspDigestAlgo, (Object)algo);
    }

    @Override
    public HashAlgorithm getDigestAlgorithm() {
        return (HashAlgorithm)((Object)this.get(ocspDigestAlgo));
    }

    public void setUseCache(boolean value) {
        this.put(useCacheStr, (Object)value);
    }

    @Override
    public boolean getUseCache() {
        return (Boolean)this.get(useCacheStr);
    }

    public void setIgnoreValidityDates(boolean value) {
        this.put(ignoreValidityDatesStr, (Object)value);
    }

    @Override
    public boolean getIgnoreValidityDates() {
        return (Boolean)this.get(ignoreValidityDatesStr);
    }

    public void setGoOnline(boolean value) {
        this.put(goOnlineStr, (Object)value);
    }

    @Override
    public boolean getGoOnline() {
        return (Boolean)this.get(goOnlineStr);
    }

    public void setAllowOCSPNoCheck(boolean value) {
        this.put(allowOCSPNoCheckStr, (Object)value);
    }

    @Override
    public boolean getAllowOCSPNoCheck() {
        return (Boolean)this.get(allowOCSPNoCheckStr);
    }

    public void setRequireOCSPCertHash(boolean value) {
        this.put(requireOCSPCertHashStr, (Object)value);
    }

    @Override
    public boolean getRequireOCSPCertHash() {
        return (Boolean)this.get(requireOCSPCertHashStr);
    }

    @Override
    public PreferencesMap newInstance() {
        return new OCSPPreferencesImpl();
    }

    @Override
    protected PreferencesMap createChild(String myKey) {
        return null;
    }

    @Override
    protected String[] getNonCloneableKeys() {
        return new String[]{requestSignerCredentialAliasStr};
    }
}

