/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.render;

import com.adobe.icc.ddg.api.CoreService;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={RenderAuditForm.class})
public class RenderAuditForm {
    private static final Logger logger = LoggerFactory.getLogger(RenderAuditForm.class);
    @Reference
    private CoreService coreService;

    public byte[] render(String xciUri) throws ServletException, IOException {
        try {
            byte[] xmlBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/audit/auditData.xml"));
            byte[] xdpBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/audit/AuditRequestForm.xdp"));
            byte[] bytes = this.coreService.render(xciUri, xmlBytes, xdpBytes);
            return bytes;
        }
        catch (Exception e) {
            logger.error("There was a problem rendering the PDF. ", (Throwable)e);
            return null;
        }
    }

    protected static String getEncoding(byte[] data, String defaultEncoding) {
        String dataUtf8 = null;
        try {
            dataUtf8 = data != null ? new String(data, defaultEncoding) : new String(data, Charset.forName("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.debug(" Unsupported encoding, using default UTF-8", (Throwable)e);
            dataUtf8 = new String(data, Charset.forName("UTF-8"));
        }
        return RenderAuditForm.getEncoding(dataUtf8);
    }

    protected static String getEncoding(String sData) {
        String searchString = "<?xml version=\"1.0\" encoding=\"";
        int searchResult = sData.indexOf(searchString);
        int searchLength = searchString.length() + searchResult;
        if (searchResult > -1) {
            searchResult = sData.indexOf("\"", searchLength);
            String encoding = sData.substring(searchLength, searchResult);
            return encoding;
        }
        return null;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

