/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.AIRMigrationSigner;
import com.adobe.air.AIRPackager;
import com.adobe.air.CertificateCreationException;
import com.adobe.air.CertificateCreator;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.pki.TimestampException;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.UCF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;

public final class ADT
extends UCF {
    public static final String MIMETYPE_AIR = "application/vnd.adobe.air-application-installer-package+zip";
    public static final String MIMETYPE_AIRI = "application/vnd.adobe.air-application-intermediate-package+zip";
    public static final String PATH_DESCRIPTOR = "META-INF/AIR/application.xml";
    public static final String PATH_HASH = "META-INF/AIR/hash";
    public static final String PATH_DEBUG = "META-INF/AIR/debug";
    public static final String DEFAULT_TSA_URL = "https://timestamp.geotrust.com/tsa";
    private static final String ARG_PACKAGE = "-package";
    private static final String ARG_PREPARE = "-prepare";
    private static final String ARG_SIGN = "-sign";
    private static final String ARG_MIGRATE = "-migrate";
    private static final String ARG_CERT = "-certificate";
    private static final String ARG_CHECK_PASS = "-checkstore";
    private static final String ARG_VERSION = "-version";
    private static final String ARG_NO_VALIDATE = "-Xnovalidate";
    private static final String ARG_DEBUG = "-Xdebug";
    private int m_exitCode = 0;
    private static String Adobe_patent_P817 = "AdobePatentId=\"P817\"";
    private static String Adobe_patent_P851 = "AdobePatentId=\"P851\"";
    private static final String VERSION_STRING = "adt version \"{0}\"";
    private CertificateCreator creator;
    private File m_appXml;

    public static void main(String[] args) {
        ADT adt = new ADT(new AIRPackager());
        int result = adt.run(args);
        System.exit(result);
    }

    protected ADT(AIRPackager p2) {
        super(p2);
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  adt -checkstore SIGNING_OPTIONS");
        System.err.println("  adt -certificate -cn <name> ( -ou <org-unit> )? ( -o <org-name> )? ( -c <country> )? <key-type> <pfx-file> <password>");
        System.err.println("  adt -help");
        System.err.println("  adt -migrate SIGNING_OTIONS <air-file-in> <air-file-out>");
        System.err.println("  adt -package SIGNING_OPTIONS <air-file> <app-desc> FILE_ARGS");
        System.err.println("  adt -prepare <airi-file> <app-desc> FILE_ARGS");
        System.err.println("  adt -sign SIGNING_OPTIONS <airi-file> <air-file>");
        System.err.println("  adt -version");
        System.err.println();
        System.err.println("SIGNING_OPTIONS: -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -keypass <pass> )? ( -providerName <name> )? ( -tsa <url> )?");
        System.err.println("FILE_ARGS: <fileOrDir>* (( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ))*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] argv) {
        block22: {
            this.args = new Arguments(argv);
            ((AIRPackager)this.getPackager()).setListener(new Listener(){

                public void message(Message message) {
                    ADT.this.printMessage(message);
                    ADT.this.m_exitCode = 12;
                }

                public void progress(int soFar, int total) {
                }
            });
            try {
                if (!this.args.peek()) {
                    throw new UsageError("No arguments were found");
                }
                if (this.args.peek("-help")) {
                    this.parseUsage();
                    break block22;
                }
                if (this.args.peek(ARG_PACKAGE)) {
                    this.parsePackage();
                    ((AIRPackager)this.getPackager()).createAIR();
                    break block22;
                }
                if (this.args.peek(ARG_PREPARE)) {
                    this.parsePrepare();
                    ((AIRPackager)this.getPackager()).createIntermediate();
                    break block22;
                }
                if (this.args.peek(ARG_SIGN)) {
                    this.parseSign();
                    ((AIRPackager)this.getPackager()).createAIR();
                    break block22;
                }
                if (this.args.peek(ARG_MIGRATE)) {
                    this.parseMigrate();
                    break block22;
                }
                if (this.args.peek(ARG_CHECK_PASS)) {
                    this.parseCheckPass();
                    break block22;
                }
                if (this.args.peek(ARG_CERT)) {
                    this.creator = new CertificateCreator();
                    this.parseCertificate();
                    this.creator.create();
                    break block22;
                }
                if (this.args.peek(ARG_VERSION)) {
                    this.parseVersion();
                    break block22;
                }
                throw new UsageError("unexpected argument " + this.args.accept());
            }
            catch (UsageError e2) {
                System.err.println(e2.getMessage());
                this.printUsage();
                this.m_exitCode = e2.getExitCode();
            }
            catch (GeneralSecurityException e3) {
                System.err.println(e3.getMessage());
                this.m_exitCode = 9;
            }
            catch (TimestampException e4) {
                System.err.println(e4.getMessage());
                this.m_exitCode = 10;
            }
            catch (CertificateCreationException e5) {
                System.err.println(e5.getMessage());
                this.m_exitCode = 11;
            }
            catch (Exception e6) {
                System.err.println("unexpected failure: " + e6.getMessage());
                e6.printStackTrace();
                this.m_exitCode = 5;
            }
            finally {
                this.getPackager().close();
            }
        }
        return this.m_exitCode;
    }

    private void parsePackage() throws UsageError {
        this.args.accept(ARG_PACKAGE);
        this.parsePackageOrPrepare(".air", true);
    }

    private void parsePrepare() throws UsageError {
        this.args.accept(ARG_PREPARE);
        this.parsePackageOrPrepare(".airi", false);
    }

    private void parsePackageOrPrepare(String extension, boolean useSigningOptions) throws UsageError {
        boolean sawNoValidate = false;
        boolean sawDebug = false;
        while (true) {
            if (!sawNoValidate && this.args.peek(ARG_NO_VALIDATE)) {
                this.args.accept(ARG_NO_VALIDATE);
                ((AIRPackager)this.getPackager()).setValidate(false);
                sawNoValidate = true;
                continue;
            }
            if (sawDebug || !this.args.peek(ARG_DEBUG)) break;
            this.args.accept(ARG_DEBUG);
            ((AIRPackager)this.getPackager()).setDebug(true);
            sawDebug = true;
        }
        if (useSigningOptions) {
            this.parseSigningOptions(this.getPackager());
        }
        try {
            this.getPackager().setOutput(this.getFileWithExtension(this.args.accept(), extension));
        }
        catch (IOException ex) {
            throw new UsageError("unable to create temp file in output directory", 6);
        }
        this.m_appXml = new File(this.args.accept()).getAbsoluteFile();
        ((AIRPackager)this.getPackager()).setDescriptor(this.m_appXml);
        this.parseFileArguments();
    }

    private void parseSign() throws UsageError {
        this.args.accept(ARG_SIGN);
        this.parseSigningOptions(this.getPackager());
        File airiFile = new File(this.args.accept());
        if (!airiFile.exists()) {
            throw new UsageError("no such file " + airiFile.getPath());
        }
        ((AIRPackager)this.getPackager()).setIntermediate(airiFile);
        this.parseOutput(this.getPackager());
    }

    private void parseMigrate() throws UsageError {
        this.args.accept(ARG_MIGRATE);
        AIRMigrationSigner signer = new AIRMigrationSigner();
        this.parseSigningOptions(signer);
        File input = new File(this.args.accept());
        if (!input.exists()) {
            throw new UsageError("no such file " + input.getPath());
        }
        signer.setInput(input);
        this.parseOutput(signer);
        try {
            signer.sign();
        }
        catch (GeneralSecurityException ex) {
            throw new UsageError(ex.getMessage(), 9);
        }
        catch (InvalidInputException ex) {
            throw new UsageError(ex.getMessage(), 12);
        }
        catch (IOException ex) {
            throw new UsageError(ex.getMessage(), 6);
        }
    }

    private void parseOutput(ISigner p2) throws UsageError {
        try {
            p2.setOutput(this.getFileWithExtension(this.args.accept(), ".air"));
        }
        catch (FileNotFoundException ex) {
            throw new UsageError("output directory is not writable", 6);
        }
        catch (IOException ex) {
            throw new UsageError("output file is not writable", 6);
        }
    }

    private void parseCheckPass() throws UsageError {
        this.args.accept(ARG_CHECK_PASS);
        this.parseSigningOptions(null);
        System.err.println("valid password");
    }

    private void parseCertificate() throws UsageError {
        String cn = null;
        String ou = null;
        String o2 = null;
        String c2 = null;
        this.args.accept(ARG_CERT);
        while (true) {
            if (this.args.peek("-cn")) {
                if (cn != null) {
                    throw new UsageError("-cn already specified");
                }
                this.args.accept("-cn");
                cn = this.args.accept();
                continue;
            }
            if (this.args.peek("-ou")) {
                if (ou != null) {
                    throw new UsageError("-ou already specified");
                }
                this.args.accept("-ou");
                ou = this.args.accept();
                continue;
            }
            if (this.args.peek("-o")) {
                if (o2 != null) {
                    throw new UsageError("-o already specified");
                }
                this.args.accept("-o");
                o2 = this.args.accept();
                continue;
            }
            if (!this.args.peek("-c")) break;
            if (c2 != null) {
                throw new UsageError("-c already specified");
            }
            this.args.accept("-c");
            c2 = this.args.accept();
        }
        if (cn == null) {
            throw new UsageError("-cn is required");
        }
        String keyType = this.args.accept();
        try {
            this.creator.setKeyType(keyType);
        }
        catch (IllegalArgumentException e2) {
            throw new UsageError("key type not recognized: " + keyType + " -- valid types are 1024-RSA and 2048-RSA");
        }
        this.creator.setOutput(new File(this.args.accept()));
        this.creator.setPassword(this.args.accept());
        this.creator.setName(cn);
        if (ou != null) {
            this.creator.setOrganizationalUnit(ou);
        }
        if (o2 != null) {
            this.creator.setOrganizationName(o2);
        }
        try {
            if (c2 != null) {
                this.creator.setCountry(c2);
            }
        }
        catch (IllegalArgumentException e3) {
            throw new UsageError(e3.getMessage());
        }
    }

    protected void parseVersion() throws UsageError {
        this.args.accept(ARG_VERSION);
        MessageFormat mf = new MessageFormat(VERSION_STRING);
        String version = mf.format(new Object[]{"1.5.0.7220"});
        System.out.println(version);
    }

    private File getFileWithExtension(String outputFilename, String extension) {
        File outputFile = new File(outputFilename);
        String name = outputFile.getName();
        if (!name.matches(".+\\.[^\\.]+")) {
            name = name + extension;
        }
        return new File(outputFile.getParentFile(), name);
    }

    private void printMessage(Message message) {
        System.out.println(message.errorDescription);
    }
}

