/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.ucf.UCFOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.zip.ZipEntry;

public class AIROutputStream
extends UCFOutputStream {
    private UCFOutputStream.FileRecord hashFileRecord;
    private MessageDigest hashDigest;

    public AIROutputStream() {
        try {
            this.hashDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("SHA-256 digest algorithm not available");
        }
    }

    public void addDebugFile(String path, boolean addToSignature) throws IOException {
        boolean SIZE = false;
        byte[] data = new byte[]{};
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date());
        record.path = path;
        record.size = data.length;
        this.addFile(record, new ByteArrayInputStream(data), addToSignature, false);
    }

    public void addHashFile(String path) throws IOException {
        int size = this.hashDigest.getDigestLength();
        this.hashFileRecord = new UCFOutputStream.FileRecord(new Date());
        this.hashFileRecord.path = path;
        this.hashFileRecord.lfhOffset = this.raf.getFilePointer();
        this.hashFileRecord.size = size;
        this.hashFileRecord.compressedSize = size;
        byte[] lfh = this.getLocalFileHeader(this.hashFileRecord);
        this.raf.write(lfh);
        this.raf.write(new byte[size]);
        this.files.add(this.hashFileRecord);
    }

    public void addZipEntry(ZipEntry entry, InputStream data) throws IOException {
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date(entry.getTime()));
        record.path = entry.getName();
        record.size = entry.getSize();
        this.addFile(record, data, true, true);
    }

    protected void beforeClose() throws IOException {
        if (this.hashFileRecord != null) {
            byte[] digest = this.hashDigest.digest();
            this.crc.reset();
            this.crc.update(digest);
            this.hashFileRecord.crc32 = this.crc.getValue();
            this.raf.seek(this.hashFileRecord.lfhOffset);
            this.os.reset();
            this.os.writeLong(67324752L);
            this.writeCommonHeaderBlock(this.hashFileRecord);
            this.os.writeString(this.hashFileRecord.path);
            byte[] lfh = this.os.getBytes();
            this.raf.write(lfh);
            this.raf.write(digest);
        }
    }

    protected void processBytes(byte[] bytes, int numBytes) {
        this.hashDigest.update(bytes, 0, numBytes);
    }
}

