/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;

public final class OCSPRequestControl
implements Cloneable {
    private X509Certificate a = null;
    private String b = null;
    private String c = null;
    private X509Certificate[] d = null;
    private X509V3Extensions e = null;

    public OCSPRequestControl(X509Certificate x509Certificate, String string, String string2, X509Certificate[] x509CertificateArray, X509V3Extensions x509V3Extensions) throws InvalidParameterException {
        try {
            if (x509Certificate != null) {
                this.a = (X509Certificate)x509Certificate.clone();
            }
            if (string != null) {
                this.b = new String(string);
            }
            if (string2 != null) {
                this.c = new String(string2);
            }
            if (x509CertificateArray != null) {
                this.d = new X509Certificate[x509CertificateArray.length];
                for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                    this.d[i2] = (X509Certificate)x509CertificateArray[i2].clone();
                }
            }
            if (x509V3Extensions != null) {
                this.e = (X509V3Extensions)x509V3Extensions.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public OCSPRequestControl(X509Certificate x509Certificate) throws InvalidParameterException {
        try {
            if (x509Certificate != null) {
                this.a = (X509Certificate)x509Certificate.clone();
                this.b = "SHA1";
                this.c = "SHA1/RSA/PKCS1Block01Pad";
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OCSPRequestControl(this.a, this.b, this.c, this.d, this.e);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new CloneNotSupportedException(invalidParameterException.getMessage());
        }
    }

    public void setDigestAlgorithm(String string) throws InvalidParameterException {
        this.b = string == null ? null : new String(string);
    }

    public void setSignatureAlgorithm(String string) throws InvalidParameterException {
        this.c = string == null ? null : new String(string);
    }

    public void setExtraCerts(X509Certificate[] x509CertificateArray) throws InvalidParameterException {
        try {
            if (x509CertificateArray == null) {
                this.d = null;
            } else {
                this.d = new X509Certificate[x509CertificateArray.length];
                for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                    this.d[i2] = (X509Certificate)x509CertificateArray[i2].clone();
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public void setSignerCert(X509Certificate x509Certificate) throws InvalidParameterException {
        try {
            if (x509Certificate != null) {
                this.a = (X509Certificate)x509Certificate.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public void setRequestExtensions(X509V3Extensions x509V3Extensions) throws InvalidParameterException {
        try {
            this.e = x509V3Extensions == null ? null : (X509V3Extensions)x509V3Extensions.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public String getDigestAlgorithm() {
        return this.b;
    }

    public String getSignatureAlgorithm() {
        return this.c;
    }

    public X509Certificate getSignerCert() {
        return this.a;
    }

    public X509Certificate[] getExtraCerts() {
        return this.d;
    }

    public X509V3Extensions getRequestExtensions() {
        return this.e;
    }
}

