/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.version;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class Version {
    private Calendar buildDate;
    private String versionNum;
    private String version = null;
    private String productPkg = "";
    private boolean evalActive = false;
    public static final String buildDatePrefix = new String("      BUILT_ON: ");
    public static final String versionNumPrefix = new String("VERSION_NUMBER: ");
    public static final String versionPrefix = new String("       VERSION: ");
    public static final String evalPrefix = new String("          EVAL: ");
    public static final String warningPrefix = new String("       WARNING: ");

    protected void setBuildDate(Calendar calendar) {
        this.buildDate = calendar;
    }

    public void setBuildDate(String string, String string2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = Integer.parseInt(string.substring(0, 4));
        int n3 = Integer.parseInt(string.substring(4, 6));
        int n4 = Integer.parseInt(string.substring(6, 8));
        int n5 = Integer.parseInt(string2.substring(0, 2));
        int n6 = Integer.parseInt(string2.substring(2, 4));
        gregorianCalendar.set(n2, n3 - 1, n4, n5, n6, 0);
        this.buildDate = gregorianCalendar;
    }

    public void setVersionNum(String string) {
        this.versionNum = string;
    }

    public String getVersionNum() {
        return this.versionNum;
    }

    public void setVersion(String string, String string2, String string3) {
        this.version = string + " " + string2 + " " + this.convertToPrintStr(string3);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildDate() {
        return this.buildDate.getTime().toString();
    }

    public void printBuildDate(boolean bl2) {
        if (bl2) {
            System.out.print(buildDatePrefix);
        }
        System.out.println(this.buildDate.getTime());
    }

    public void printVersionNumber(boolean bl2) {
        if (bl2) {
            System.out.print(versionNumPrefix);
        }
        System.out.println(this.versionNum);
    }

    public void printVersion(boolean bl2) {
        if (bl2) {
            System.out.print(versionPrefix);
        }
        System.out.println(this.version);
    }

    public void printEvalActive(boolean bl2, boolean bl3) {
        if (bl2) {
            System.out.print(evalPrefix);
        }
        if (bl3) {
            System.out.println("Evaluation Build");
        } else {
            System.out.println();
        }
    }

    public void printLicenseInfo(boolean bl2) {
        this.printEvalActive(bl2, this.isEvalActive());
        if (this.isEvalActive()) {
            try {
                String string = this.getProductID();
                String string2 = this.getProductPkg();
            }
            catch (Exception exception) {
                if (bl2) {
                    this.printWarningPrefix();
                }
                System.out.println("License is invalid");
            }
        }
    }

    public void printWarningPrefix() {
        System.out.print(warningPrefix);
    }

    public String getProductID() {
        return this.version;
    }

    public String getProductPkg() {
        return this.productPkg;
    }

    private String convertToPrintStr(String string) {
        String string2 = string.substring(0, 4);
        int n2 = Integer.parseInt(string.substring(4, 6));
        String string3 = string.substring(6, 8);
        return string3 + "-" + this.monthToStr(n2) + "-" + string2;
    }

    private String monthToStr(int n2) {
        switch (n2) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "Invalid Month";
    }

    public boolean isEvalActive() {
        return this.evalActive;
    }

    public void evalBuild() {
        this.evalActive = true;
    }
}

