/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.ROS;

public final class CoolTypeScript {
    private final String name;
    public static final CoolTypeScript ROMAN = new CoolTypeScript("Roman");
    public static final CoolTypeScript JAPANESE = new CoolTypeScript("Japanese");
    public static final CoolTypeScript TRADITIONAL_CHINESE = new CoolTypeScript("TraditionalChinese");
    public static final CoolTypeScript KOREAN = new CoolTypeScript("Korean");
    public static final CoolTypeScript ARABIC = new CoolTypeScript("Arabic");
    public static final CoolTypeScript HEBREW = new CoolTypeScript("Hebrew");
    public static final CoolTypeScript GREEK = new CoolTypeScript("Greek");
    public static final CoolTypeScript CYRILLIC = new CoolTypeScript("Cyrillic");
    public static final CoolTypeScript RIGHTLEFT = new CoolTypeScript("RightLeft");
    public static final CoolTypeScript DEVANAGARI = new CoolTypeScript("Devanagari");
    public static final CoolTypeScript GURMUKHI = new CoolTypeScript("Gurmukhi");
    public static final CoolTypeScript GUJARATI = new CoolTypeScript("Gujarati");
    public static final CoolTypeScript ORIYA = new CoolTypeScript("Oriya");
    public static final CoolTypeScript BENGALI = new CoolTypeScript("Bengali");
    public static final CoolTypeScript TAMIL = new CoolTypeScript("Tamil");
    public static final CoolTypeScript TELUGU = new CoolTypeScript("Telugu");
    public static final CoolTypeScript KANNADA = new CoolTypeScript("Kannada");
    public static final CoolTypeScript MALAYALAM = new CoolTypeScript("Malayalam");
    public static final CoolTypeScript SINHALESE = new CoolTypeScript("Sinhalese");
    public static final CoolTypeScript BURMESE = new CoolTypeScript("Burmese");
    public static final CoolTypeScript KHMER = new CoolTypeScript("Khmer");
    public static final CoolTypeScript THAI = new CoolTypeScript("Thai");
    public static final CoolTypeScript LAOTIAN = new CoolTypeScript("Laotian");
    public static final CoolTypeScript GEORGIAN = new CoolTypeScript("Georgian");
    public static final CoolTypeScript ARMENIAN = new CoolTypeScript("Armenian");
    public static final CoolTypeScript SIMPLIFIED_CHINESE = new CoolTypeScript("SimplifiedChinese");
    public static final CoolTypeScript TIBETAN = new CoolTypeScript("Tibetan");
    public static final CoolTypeScript MONGOLIAN = new CoolTypeScript("Mongolian");
    public static final CoolTypeScript GEEZ = new CoolTypeScript("Geez");
    public static final CoolTypeScript EAST_EUROPEAN_ROMAN = new CoolTypeScript("EastEuropeanRoman");
    public static final CoolTypeScript VIETNAMESE = new CoolTypeScript("Vietnamese");
    public static final CoolTypeScript EXTENDED_ARABIC = new CoolTypeScript("ExtendedArabic");

    private CoolTypeScript(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public static CoolTypeScript fromWellKnownROS(ROS rOS) {
        if (rOS == null || !"Adobe".equals(rOS.registry)) {
            return null;
        }
        if ("Japan1".equals(rOS.ordering) || "Japan2".equals(rOS.ordering)) {
            return JAPANESE;
        }
        if ("GB1".equals(rOS.ordering)) {
            return SIMPLIFIED_CHINESE;
        }
        if ("Korea1".equals(rOS.ordering)) {
            return KOREAN;
        }
        if ("CNS1".equals(rOS.ordering)) {
            return TRADITIONAL_CHINESE;
        }
        return null;
    }

    public static CoolTypeScript fromAnyROS(ROS rOS) {
        if (rOS == null) {
            return null;
        }
        if (!"Adobe".equals(rOS.registry)) {
            return JAPANESE;
        }
        if (!"Identity".equals(rOS.ordering)) {
            return JAPANESE;
        }
        return null;
    }
}

