/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2ConsumerDefaultImpl;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.cff.Type2Parser;
import java.util.List;

final class CIDComponentFont {
    protected final Dict fontDict;
    protected final Dict privateDict;
    protected final CharStrings localSubrs;

    public CIDComponentFont(CFFByteArray cFFByteArray, int n, int n2, StringIndex stringIndex) throws InvalidFontException, UnsupportedFontException {
        this.fontDict = new Dict(cFFByteArray, n, n2, stringIndex);
        Dict.OffsetSizeValue offsetSizeValue = this.fontDict.get(Dict.Key.Private, false);
        if (offsetSizeValue == null) {
            throw new InvalidFontException("Missing privateDict in CID component font");
        }
        this.privateDict = new Dict(cFFByteArray, offsetSizeValue.offset, offsetSizeValue.size, stringIndex);
        Dict.OffsetValue offsetValue = this.privateDict.get(Dict.Key.Subrs, false);
        this.localSubrs = offsetValue != null ? new CharStrings(cFFByteArray, offsetSizeValue.offset + offsetValue.offset) : null;
    }

    public CIDComponentFont(Dict dict, Dict dict2, CharStrings charStrings) {
        this.fontDict = dict;
        this.privateDict = dict2;
        this.localSubrs = charStrings;
    }

    public void getOutline(CharStrings charStrings, int n, CharStrings charStrings2, Type2OutlineParser type2OutlineParser, OutlineConsumer outlineConsumer, Dict.NumbersValue numbersValue) throws InvalidFontException, UnsupportedFontException {
        type2OutlineParser.parse(charStrings, n, this.localSubrs, charStrings2, outlineConsumer, this.getOutlineMatrix(numbersValue), null);
    }

    public double getStemV() {
        Dict.NumbersValue numbersValue = this.privateDict.get(Dict.NumbersKey.StdVW, false);
        if (numbersValue != null) {
            return numbersValue.getFirstValueAsDouble();
        }
        numbersValue = this.privateDict.get(Dict.NumbersKey.StemSnapV, false);
        if (numbersValue != null) {
            return numbersValue.getFirstValueAsDouble();
        }
        return 0.0;
    }

    private Matrix getOutlineMatrix(Dict.NumbersValue numbersValue) {
        Dict.NumbersValue numbersValue2 = this.fontDict.get(Dict.Key.FontMatrix, false);
        if (numbersValue == null && numbersValue2 == null) {
            return new Matrix(this.fontDict.get(Dict.Key.FontMatrix, true).getValuesAsDouble());
        }
        if (numbersValue == null) {
            return new Matrix(numbersValue2.getValuesAsDouble());
        }
        if (numbersValue2 == null) {
            return new Matrix(numbersValue.getValuesAsDouble());
        }
        Matrix matrix = new Matrix(numbersValue2.getValuesAsDouble());
        return matrix.multiply(new Matrix(numbersValue.getValuesAsDouble()));
    }

    public double getHorizontalAdvance(CharStrings charStrings, int n, CharStrings charStrings2) throws InvalidFontException, UnsupportedFontException {
        Type2Parser type2Parser = new Type2Parser();
        WidthConsumer widthConsumer = new WidthConsumer();
        type2Parser.parse(charStrings, n, this.localSubrs, charStrings2, widthConsumer, null);
        if (widthConsumer.widthSeen) {
            Dict.NumbersValue numbersValue = this.privateDict.get(Dict.Key.nominalWidthX, true);
            return numbersValue.getFirstValueAsDouble() + widthConsumer.width;
        }
        Dict.NumbersValue numbersValue = this.privateDict.get(Dict.Key.defaultWidthX, true);
        return numbersValue.getFirstValueAsDouble();
    }

    public void collectStrings(List list) {
        this.fontDict.collectStrings(list);
        this.privateDict.collectStrings(list);
    }

    static class WidthConsumer
    extends Type2ConsumerDefaultImpl {
        public double width;
        public boolean widthSeen = false;

        WidthConsumer() {
        }

        public boolean width(double d) {
            this.widthSeen = true;
            this.width = d;
            return false;
        }
    }
}

