/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;

public final class Kern
extends Table {
    private static final int COVERAGE_HORIZONTAL = 1;
    private static final int COVERAGE_MINIMUM = 2;
    private static final int COVERAGE_OVERRIDES = 8;

    protected Kern(FontByteArray fontByteArray) throws IOException, InvalidFontException, UnsupportedFontException {
        super(fontByteArray);
        if (fontByteArray.getSize() < 4) {
            throw new InvalidFontException("'kern' table must be at least 4 bytes (actual = " + fontByteArray.getSize() + ")");
        }
        int n = this.getTableMajorVersion();
        int n2 = this.data.getuint16(2);
        if (n2 > 0) {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new UnsupportedFontException("'kern' table version 1.x not supported yet");
                }
                default: {
                    throw new UnsupportedFontException("'kern' table major version = " + n + " not supported");
                }
            }
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int[] getKernVector(int n, int n2) throws InvalidFontException, UnsupportedFontException {
        int[] nArray = new int[2];
        boolean bl = false;
        switch (this.getTableMajorVersion()) {
            case 0: {
                int n3 = this.data.getuint16(2);
                int n4 = 4;
                for (int i = 0; i < n3; ++i) {
                    bl = this.applyKernSubtable(nArray, n4, bl, n, n2);
                    n4 += this.data.getuint16(n4 + 2);
                }
                break;
            }
            case 1: {
                throw new UnsupportedFontException("kern table version 1.x not supported yet");
            }
        }
        return nArray;
    }

    private boolean applyKernSubtable(int[] nArray, int n, boolean bl, int n2, int n3) throws InvalidFontException, UnsupportedFontException {
        int n4 = this.data.getuint16(n + 4);
        int n5 = n4 >> 8;
        if ((n4 & 1) == 0) {
            return bl;
        }
        switch (n5) {
            case 0: {
                bl = this.applyKernSubtableFormat0(nArray, n, bl, n2, n3);
                break;
            }
            case 2: {
                throw new UnsupportedFontException("kern subtable format 2 not supported yet");
            }
            default: {
                throw new InvalidFontException("invalid kern subtable format (" + n5 + ")");
            }
        }
        return bl;
    }

    private boolean applyKernSubtableFormat0(int[] nArray, int n, boolean bl, int n2, int n3) throws InvalidFontException {
        int n4 = this.data.getuint16(n + 6);
        int n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            int n7 = (n5 + n6) / 2;
            int n8 = this.data.getuint16(n + 14 + 6 * n7);
            int n9 = this.data.getuint16(n + 14 + 6 * n7 + 2);
            if (n8 < n2 || n8 == n2 && n9 < n3) {
                n5 = n7 + 1;
                continue;
            }
            if (n2 < n8 || n2 == n8 && n3 < n9) {
                n6 = n7;
                continue;
            }
            int n10 = this.data.getint16(n + 14 + 6 * n7 + 4);
            if ((n10 & 0xFFFF) == 32768) {
                bl = false;
            } else {
                int n11;
                int n12 = this.data.getuint16(n + 4);
                int n13 = n11 = bl ? 1 : 0;
                if ((n12 & 2) != 0) {
                    nArray[n11] = Math.max(nArray[n11], n10);
                } else if ((n12 & 8) != 0) {
                    nArray[n11] = n10;
                } else {
                    int n14 = n11;
                    nArray[n14] = nArray[n14] + n10;
                }
            }
            return bl;
        }
        return bl;
    }
}

