/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.InterElementAttribute;
import com.adobe.fontengine.inlineformatting.LigatureLevel;

public final class OTSelectorAtLigatureLevel
extends OTSelector {
    private final LigatureLevel level;

    public OTSelectorAtLigatureLevel(LigatureLevel ligatureLevel) {
        this.level = ligatureLevel;
    }

    public boolean isApplied(AttributedRun attributedRun, int n) {
        LigatureLevel ligatureLevel = (LigatureLevel)attributedRun.getInterElementStyleBefore(n, InterElementAttribute.ligatureLevel);
        return LigatureLevel.lessThanOrEqual(this.level, ligatureLevel);
    }

    public boolean isApplied(AttributedRun attributedRun, int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            LigatureLevel ligatureLevel = (LigatureLevel)attributedRun.getInterElementStyleBefore(i, InterElementAttribute.ligatureLevel);
            if (LigatureLevel.lessThanOrEqual(this.level, ligatureLevel)) continue;
            return false;
        }
        return true;
    }

    public boolean isApplied(AttributedRun attributedRun, int[] nArray) {
        for (int i = nArray[0] + 1; i <= nArray[nArray.length - 1]; ++i) {
            LigatureLevel ligatureLevel = (LigatureLevel)attributedRun.getInterElementStyleBefore(i, InterElementAttribute.ligatureLevel);
            if (LigatureLevel.lessThanOrEqual(this.level, ligatureLevel)) continue;
            return false;
        }
        return true;
    }
}

