/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.ScalerDebugger;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.math.F16Dot16;
import com.adobe.fontengine.math.F16Dot16Vector;
import com.adobe.fontengine.math.F26Dot6;
import com.adobe.fontengine.math.F26Dot6Vector;
import com.adobe.fontengine.math.F2Dot14;
import com.adobe.fontengine.math.F2Dot14Vector;

public class TTInterpreter {
    private GraphicState gs;
    private GraphicParameters gp;
    private StorageArea storageArea;
    private Stack stack;
    private FunctionDefinitions functionDefs;
    private FunctionDefinitions instructionDefs = new FunctionDefinitions(256);
    private int unitsPerEm;
    private Matrix em2px;
    private TTPoint[] twilightZone;
    static Instr[] instructions = new Instr[]{new Instr(0, "SetVectorsToCoordAxis {x}", 0, 0), new Instr(1, "SetVectorsToCoordAxis {y}", 0, 0), new Instr(2, "SetPVToCoordAxis {x}", 0, 0), new Instr(3, "SetPVToCoordAxis {y}", 0, 0), new Instr(4, "SetFVToCoordAxis {x}", 0, 0), new Instr(5, "SetFVToCoordAxis {y}", 0, 0), new Instr(6, "SetPVToLine {para}", 2, 0), new Instr(7, "SetPVToLine {perp}", 2, 0), new Instr(8, "SetFVToLine {para}", 2, 0), new Instr(9, "SetFVToLine {para}", 2, 0), new Instr(10, "SetPVFromStack", 2, 0), new Instr(11, "SetFVFromStack", 2, 0), new Instr(12, "GetPV", 0, 2), new Instr(13, "GetFV", 0, 2), new Instr(14, "SetFVtoPV", 0, 0), new Instr(15, "movepointtoInterSECTion", 5, 0), new Instr(16, "SetRP0", 1, 0), new Instr(17, "SetRP1", 1, 0), new Instr(18, "SetRP2", 1, 0), new Instr(19, "SetZP0", 1, 0), new Instr(20, "SetZP1", 1, 0), new Instr(21, "SetZP2", 1, 0), new Instr(22, "SetZPS", 1, 0), new Instr(23, "SetLOOPvariable", 1, 0), new Instr(24, "RoundToGrid", 0, 0), new Instr(25, "RoundToHalfGrid", 0, 0), new Instr(26, "SetMinimumDistance", 1, 0), new Instr(27, "ELSE", 0, 0), new Instr(28, "JuMPRelative", 1, 0), new Instr(29, "SetCVTCutIn", 1, 0), new Instr(30, "SetSingleWidthCutIn", 1, 0), new Instr(31, "SetSingleWdith", 1, 0), new Instr(32, "DUP", 0, 1), new Instr(33, "POP", 0, 0), new Instr(34, "CLEAR", 0, 0), new Instr(35, "SWAP", 2, 2), new Instr(36, "DEPTH", 0, 1), new Instr(37, "CINDEX", 1, 1), new Instr(38, "MINDEX", 1, 1), new Instr(39, "ALIGNPoinTS", 2, 0), new Instr(40, "<idef>", 0, 0), new Instr(41, "UnTouchPoint", 1, 0), new Instr(42, "LOOPCALL", 2, 0), new Instr(43, "CALL", 1, 0), new Instr(44, "FDEF", 1, 0), new Instr(45, "ENDF", 0, 0), new Instr(46, "MoveDirectAbsolutePoint {noround}", 1, 0), new Instr(47, "MoveDirectAbsolutePoint {round}", 1, 0), new Instr(48, "InterpolateUntouchedPoints {y}", 0, 0), new Instr(49, "InterpolateUntouchedPoints {x}", 0, 0), new Instr(50, "ShiftPoint {zp1-rp2}", 0, 0), new Instr(51, "ShiftPoint {zp0-rp1}", 0, 0), new Instr(52, "SHiftContour {zp1-rp2}", 0, 0), new Instr(53, "SHiftContour {zp0-rp1}", 0, 0), new Instr(54, "SHiftZone {zp1-rp2}", 0, 0), new Instr(55, "SHiftZone {zp0-rp1}", 0, 0), new Instr(56, "SHiftpointbyPIXelamount", 0, 0), new Instr(57, "InterPolate", 0, 0), new Instr(58, "MoveStackIndirectRelativePoint", 2, 0), new Instr(59, "MoveStackIndirectRelativePoint {setRp0}", 2, 0), new Instr(60, "ALIGNRelativePoint", 0, 0), new Instr(61, "RoundToDoubleGrid", 0, 0), new Instr(62, "MoveIndirectAbsolutePoint {noround}", 2, 0), new Instr(63, "MoveIndirectAbsolutePoint {round}", 2, 0), new Instr(64, "NPUSHB", 0, 0), new Instr(65, "NPUSHW", 0, 0), new Instr(66, "WriteStore", 2, 0), new Instr(67, "ReadStore", 1, 1), new Instr(68, "WriteCVTPixel", 2, 0), new Instr(69, "ReadCVT", 1, 1), new Instr(70, "GetCoordinate (proj)", 1, 1), new Instr(71, "GetCoordinate (unhinted)", 1, 1), new Instr(72, "SetCoordinateFromStack", 2, 0), new Instr(73, "MeasureDistance (hinted)", 2, 1), new Instr(74, "MeasureDistance (original)", 2, 1), new Instr(75, "MeasurePPEM", 0, 1), new Instr(76, "MeasurePointSize", 0, 1), new Instr(77, "FLIPON", 0, 0), new Instr(78, "FLIPOFF", 0, 0), new Instr(79, "DEBUG", 1, 0), new Instr(80, "LessThan", 2, 1), new Instr(81, "LessThanEQ", 2, 1), new Instr(82, "GreaterThan", 2, 1), new Instr(83, "GreateThanEQ", 2, 1), new Instr(84, "EQual", 2, 1), new Instr(85, "NotEQual", 2, 1), new Instr(86, "ODD", 1, 1), new Instr(87, "EVEN", 1, 1), new Instr(88, "IF", 1, 0), new Instr(89, "EIF", 0, 0), new Instr(90, "AND", 2, 1), new Instr(91, "OR", 2, 1), new Instr(92, "NOT", 1, 1), new Instr(93, "DELTAP1", 1, 0), new Instr(94, "SetDeltaBase", 1, 0), new Instr(95, "SetDeltaShift", 1, 0), new Instr(96, "ADD", 2, 1), new Instr(97, "SUB", 2, 1), new Instr(98, "DIV", 2, 1), new Instr(99, "MUL", 2, 1), new Instr(100, "ABS", 1, 1), new Instr(101, "NEG", 1, 1), new Instr(102, "FLOOR", 1, 1), new Instr(103, "CEILING", 1, 1), new Instr(104, "ROUND {comp0}", 1, 1), new Instr(105, "ROUND {comp1}", 1, 1), new Instr(106, "ROUND {comp2}", 1, 1), new Instr(107, "ROUND {comp3}", 1, 1), new Instr(108, "NROUND {comp0}", 1, 1), new Instr(109, "NROUND {comp1}", 1, 1), new Instr(110, "NROUND {comp2}", 1, 1), new Instr(111, "NROUND {comp3}", 1, 1), new Instr(112, "WriteCVTFunits", 2, 0), new Instr(113, "DELTAP2", 1, 0), new Instr(114, "DELTAP3", 1, 0), new Instr(115, "DELTAC1", 1, 0), new Instr(116, "DELTAC2", 1, 0), new Instr(117, "DELTAC3", 1, 0), new Instr(118, "SuperROUND", 1, 0), new Instr(119, "S45ROUND", 1, 0), new Instr(120, "JumpRelativeOnTrue", 2, 0), new Instr(121, "JumpRelativeOnFalse", 2, 0), new Instr(122, "RoundOFF", 0, 0), new Instr(123, "<idef>", 0, 0), new Instr(124, "RoundUpToGrid", 0, 0), new Instr(125, "RoundDownToGrid", 0, 0), new Instr(126, "SetANGleWeight", 1, 0), new Instr(127, "AdjustAngle", 0, 0), new Instr(128, "FliPPoinT", 0, 0), new Instr(129, "FLIPRanGeON", 2, 0), new Instr(130, "FLIPRanGeOFF", 2, 0), new Instr(131, "<idef>", 0, 0), new Instr(132, "<idef>", 0, 0), new Instr(133, "SCANCTRL", 1, 0), new Instr(134, "SetDPVToLine {para}", 2, 0), new Instr(135, "SetDPVToLine {perp}", 2, 0), new Instr(136, "GETINFO", 1, 1), new Instr(137, "IDEF", 1, 0), new Instr(138, "ROLL", 3, 3), new Instr(139, "MAX", 2, 1), new Instr(140, "MIN", 2, 1), new Instr(141, "SCANTYPE", 1, 0), new Instr(142, "INSTCRL", 2, 0), new Instr(143, "<idef>", 0, 0), new Instr(144, "<idef>", 0, 0), new Instr(145, "<idef>", 0, 0), new Instr(146, "<idef>", 0, 0), new Instr(147, "<idef>", 0, 0), new Instr(148, "<idef>", 0, 0), new Instr(149, "<idef>", 0, 0), new Instr(150, "<idef>", 0, 0), new Instr(151, "<idef>", 0, 0), new Instr(152, "<idef>", 0, 0), new Instr(153, "<idef>", 0, 0), new Instr(154, "<idef>", 0, 0), new Instr(155, "<idef>", 0, 0), new Instr(156, "<idef>", 0, 0), new Instr(157, "<idef>", 0, 0), new Instr(158, "<idef>", 0, 0), new Instr(159, "<idef>", 0, 0), new Instr(160, "<idef>", 0, 0), new Instr(161, "<idef>", 0, 0), new Instr(162, "<idef>", 0, 0), new Instr(163, "<idef>", 0, 0), new Instr(164, "<idef>", 0, 0), new Instr(165, "<idef>", 0, 0), new Instr(166, "<idef>", 0, 0), new Instr(167, "<idef>", 0, 0), new Instr(168, "<idef>", 0, 0), new Instr(169, "<idef>", 0, 0), new Instr(170, "<idef>", 0, 0), new Instr(171, "<idef>", 0, 0), new Instr(172, "<idef>", 0, 0), new Instr(173, "<idef>", 0, 0), new Instr(174, "<idef>", 0, 0), new Instr(175, "<idef>", 0, 0), new Instr(176, "PUSHB1", 0, 1), new Instr(177, "PUSHB2", 0, 2), new Instr(178, "PUSHB3", 0, 3), new Instr(179, "PUSHB4", 0, 4), new Instr(180, "PUSHB5", 0, 5), new Instr(181, "PUSHB6", 0, 6), new Instr(182, "PUSHB7", 0, 7), new Instr(183, "PUSHB8", 0, 8), new Instr(184, "PUSHW1", 0, 1), new Instr(185, "PUSHW2", 0, 2), new Instr(186, "PUSHW3", 0, 3), new Instr(187, "PUSHW4", 0, 4), new Instr(188, "PUSHW5", 0, 5), new Instr(189, "PUSHW6", 0, 6), new Instr(190, "PUSHW7", 0, 7), new Instr(191, "PUSHW8", 0, 8), new Instr(192, "MoveDirectRelativePoint {comp0}", 1, 0), new Instr(193, "MoveDirectRelativePoint {comp1}", 1, 0), new Instr(194, "MoveDirectRelativePoint {comp2}", 1, 0), new Instr(195, "MoveDirectRelativePoint {comp3}", 1, 0), new Instr(196, "MoveDirectRelativePoint {round, comp0}", 1, 0), new Instr(197, "MoveDirectRelativePoint {round, comp1}", 1, 0), new Instr(198, "MoveDirectRelativePoint {round, comp2}", 1, 0), new Instr(199, "MoveDirectRelativePoint {round, comp3}", 1, 0), new Instr(200, "MoveDirectRelativePoint {keepMin, comp0}", 1, 0), new Instr(201, "MoveDirectRelativePoint {keepMin, comp1}", 1, 0), new Instr(202, "MoveDirectRelativePoint {keepMin, comp2}", 1, 0), new Instr(203, "MoveDirectRelativePoint {keepMin, comp3}", 1, 0), new Instr(204, "MoveDirectRelativePoint {keepMin, round, comp0}", 1, 0), new Instr(205, "MoveDirectRelativePoint {keepMin, round, comp1}", 1, 0), new Instr(206, "MoveDirectRelativePoint {keepMin, round, comp2}", 1, 0), new Instr(207, "MoveDirectRelativePoint {keepMin, round, comp3}", 1, 0), new Instr(208, "MoveDirectRelativePoint {setRp0, comp0}", 1, 0), new Instr(209, "MoveDirectRelativePoint {setRp0, comp1}", 1, 0), new Instr(210, "MoveDirectRelativePoint {setRp0, comp2}", 1, 0), new Instr(211, "MoveDirectRelativePoint {setRp0, comp3}", 1, 0), new Instr(212, "MoveDirectRelativePoint {setRp0, round, comp0}", 1, 0), new Instr(213, "MoveDirectRelativePoint {setRp0, round, comp1}", 1, 0), new Instr(214, "MoveDirectRelativePoint {setRp0, round, comp2}", 1, 0), new Instr(215, "MoveDirectRelativePoint {setRp0, round, comp3}", 1, 0), new Instr(216, "MoveDirectRelativePoint {setRp0, keepMin, comp0}", 1, 0), new Instr(217, "MoveDirectRelativePoint {setRp0, keepMin, comp1}", 1, 0), new Instr(218, "MoveDirectRelativePoint {setRp0, keepMin, comp2}", 1, 0), new Instr(219, "MoveDirectRelativePoint {setRp0, keepMin, comp3}", 1, 0), new Instr(220, "MoveDirectRelativePoint {setRp0, keepMin, round, comp0}", 1, 0), new Instr(221, "MoveDirectRelativePoint {setRp0, keepMin, round, comp1}", 1, 0), new Instr(222, "MoveDirectRelativePoint {setRp0, keepMin, round, comp2}", 1, 0), new Instr(223, "MoveDirectRelativePoint {setRp0, keepMin, round, comp3}", 1, 0), new Instr(224, "MoveIndirectRelativePoint {comp0}", 2, 0), new Instr(225, "MoveIndirectRelativePoint {comp1}", 2, 0), new Instr(226, "MoveIndirectRelativePoint {comp2}", 2, 0), new Instr(227, "MoveIndirectRelativePoint {comp3}", 2, 0), new Instr(228, "MoveIndirectRelativePoint {round, comp0}", 2, 0), new Instr(229, "MoveIndirectRelativePoint {round, comp1}", 2, 0), new Instr(230, "MoveIndirectRelativePoint {round, comp2}", 2, 0), new Instr(231, "MoveIndirectRelativePoint {round, comp3}", 2, 0), new Instr(232, "MoveIndirectRelativePoint {keepMin, comp0}", 2, 0), new Instr(233, "MoveIndirectRelativePoint {keepMin, comp1}", 2, 0), new Instr(234, "MoveIndirectRelativePoint {keepMin, comp2}", 2, 0), new Instr(235, "MoveIndirectRelativePoint {keepMin, comp3}", 2, 0), new Instr(236, "MoveIndirectRelativePoint {keepMin, round, comp0}", 2, 0), new Instr(237, "MoveIndirectRelativePoint {keepMin, round, comp1}", 2, 0), new Instr(238, "MoveIndirectRelativePoint {keepMin, round, comp2}", 2, 0), new Instr(239, "MoveIndirectRelativePoint {keepMin, round, comp3}", 2, 0), new Instr(240, "MoveIndirectRelativePoint {setRp0, comp0}", 2, 0), new Instr(241, "MoveIndirectRelativePoint {setRp0, comp1}", 2, 0), new Instr(242, "MoveIndirectRelativePoint {setRp0, comp2}", 2, 0), new Instr(243, "MoveIndirectRelativePoint {setRp0, comp3}", 2, 0), new Instr(244, "MoveIndirectRelativePoint {setRp0, round, comp0}", 2, 0), new Instr(245, "MoveIndirectRelativePoint {setRp0, round, comp1}", 2, 0), new Instr(246, "MoveIndirectRelativePoint {setRp0, round, comp2}", 2, 0), new Instr(247, "MoveIndirectRelativePoint {setRp0, round, comp3}", 2, 0), new Instr(248, "MoveIndirectRelativePoint {setRp0, keepMin, comp0}", 2, 0), new Instr(249, "MoveIndirectRelativePoint {setRp0, keepMin, comp1}", 2, 0), new Instr(250, "MoveIndirectRelativePoint {setRp0, keepMin, comp2}", 2, 0), new Instr(251, "MoveIndirectRelativePoint {setRp0, keepMin, comp3}", 2, 0), new Instr(252, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp0}", 2, 0), new Instr(253, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp1}", 2, 0), new Instr(254, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp2}", 2, 0), new Instr(255, "MoveIndirectRelativePoint {setRp0, keepMin, round, comp3}", 2, 0)};
    private ScalerDebugger debugger;
    private Instr currentInstr;
    private StringBuffer sb = new StringBuffer();
    private StringBuffer sbDetails = new StringBuffer();

    public TTInterpreter(int n, int n2, int n3, OTByteArray oTByteArray, int n4, int n5) throws InvalidFontException, UnsupportedFontException {
        this.gs = new GraphicState(n3, oTByteArray);
        this.gp = new GraphicParameters();
        this.storageArea = new StorageArea(n);
        this.stack = new Stack(n2);
        this.functionDefs = new FunctionDefinitions(n4);
        this.instructionDefs = new FunctionDefinitions(256);
        this.twilightZone = new TTPoint[n5];
        for (int i = 0; i < this.twilightZone.length; ++i) {
            this.twilightZone[i] = new TTPoint(0, 0, false);
        }
    }

    public void setUnitsPerEm(int n) {
        this.unitsPerEm = n;
    }

    public void setScaling(double d, double d2, double d3, double d4, double d5) throws InvalidFontException, UnsupportedFontException {
        int n;
        int n2;
        this.gs.setPointSize(d);
        boolean bl = false;
        boolean bl2 = false;
        this.em2px = new Matrix(d2, 0.0, 0.0, d3, d4, d5);
        if (bl) {
            n2 = F16Dot16.fromInt(this.unitsPerEm);
            n = F16Dot16.fromInt(this.unitsPerEm);
        } else {
            n2 = F16Dot16.fromDouble(Math.max(this.em2px.a, this.em2px.c));
            n = F16Dot16.fromDouble(Math.max(this.em2px.b, this.em2px.d));
            if (bl2) {
                n2 = F16Dot16.round(n2);
                n = F16Dot16.round(n);
            }
        }
        this.gs.cvtxN = n2;
        this.gs.cvtD = F16Dot16.fromInt(this.unitsPerEm);
        this.gs.cvtyN = n;
        if (n2 >= n) {
            ((GraphicState)this.gs).cvtStretch.x = 65536;
            ((GraphicState)this.gs).cvtStretch.y = F16Dot16.divide(n, n2);
            this.gs.setPixelsPerEm(d2);
        } else {
            ((GraphicState)this.gs).cvtStretch.x = F16Dot16.divide(n2, n);
            ((GraphicState)this.gs).cvtStretch.y = 65536;
            this.gs.setPixelsPerEm(d3);
        }
        this.gs.resetAndScaleCVT();
    }

    private TTPoint getPoint(TTOutline tTOutline, int n, int n2) throws InvalidGlyphException {
        if (n == 0) {
            return this.twilightZone[n2];
        }
        return tTOutline.getPoint(n2);
    }

    private int getNumOutlinePoints(TTOutline tTOutline, int n) throws InvalidGlyphException {
        if (n == 0) {
            return this.twilightZone.length;
        }
        return tTOutline.getNumOutlinePoints();
    }

    public int getScanType() {
        int n = this.gs.getScanControl();
        int n2 = n & 0xFF;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = (n & 0x100) != 0 && this.gs.getPixelsPerEm() <= n2 ? true : ((n & 0x100) != 0 && n2 == 255 ? true : ((n & 0x200) != 0 && bl ? true : ((n & 0x400) != 0 && bl2 ? true : ((n & 0x800) != 0 && this.gs.getPixelsPerEm() > n2 ? false : ((n & 0x1000) != 0 && !bl ? false : ((n & 0x2000) != 0 && !bl2 ? false : false))))));
        if (bl3) {
            return n >> 16;
        }
        return 2;
    }

    public void runFpgm(OTByteArray oTByteArray, int n, int n2) throws InvalidFontException, UnsupportedFontException {
        this.run(null, oTByteArray, n, n2);
    }

    public void runPrep(OTByteArray oTByteArray, int n, int n2) throws InvalidFontException, UnsupportedFontException {
        this.gs.setAutoFlip(true);
        this.gs.setDeltaBase(9);
        this.gs.setDeltaShift(3);
        this.gs.setRoundMode(this.gs.ROUND_TO_GRID);
        this.gs.setMinimumDistance(64);
        this.gs.setControlValueCutIn(F26Dot6.fromDouble(1.0625));
        this.gs.setSingleWidth(0);
        this.gs.setSingleWidthCutIn(0);
        this.gs.setAngleWeight(128);
        this.gs.setScanControl(0);
        this.gs.setInstrControl(0);
        try {
            this.gs.defaultGraphicState = (LocalGraphicState)this.gs.localGraphicState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("LocalGraphicState cannot be cloned!");
        }
        this.run(null, oTByteArray, n, n2);
        if ((this.gs.getInstrControl() & 2) == 0) {
            try {
                this.gs.defaultGraphicState = (LocalGraphicState)this.gs.localGraphicState.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("LocalGraphicState cannot be cloned!");
            }
        }
    }

    public void runGlyf(TTSimpleOutline tTSimpleOutline, OTByteArray oTByteArray, int n, int n2) throws InvalidGlyphException, UnsupportedFontException {
        if ((this.gs.getInstrControl() & 1) != 0) {
            return;
        }
        try {
            this.gs.localGraphicState = (LocalGraphicState)this.gs.defaultGraphicState.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("LocalGraphicState cannot be cloned!");
        }
        this.run(tTSimpleOutline, oTByteArray, n, n2);
    }

    private void run(TTSimpleOutline tTSimpleOutline, OTByteArray oTByteArray, int n, int n2) throws InvalidGlyphException, UnsupportedFontException {
        this.gs.setRp0(0);
        this.gs.setRp1(0);
        this.gs.setRp2(0);
        this.gs.setZp0(1);
        this.gs.setZp1(1);
        this.gs.setZp2(1);
        this.gs.setVector(this.gs.projectionVector, 16384, 0, false);
        this.gs.setVector(this.gs.freedomVector, 16384, 0, false);
        this.gs.setVector(this.gs.originalProjectionVector, 16384, 0, false);
        this.gs.setLoopVariable(1);
        this.runWithoutInit(tTSimpleOutline, oTByteArray, n, n2);
    }

    private int scaleAndRound(int n, int n2, int n3) {
        int n4 = n3 >> 1;
        n = n < 0 ? -(-n * n2 + n4) / n3 : (n * n2 + n4) / n3;
        return n;
    }

    private void runWithoutInit(TTSimpleOutline tTSimpleOutline, OTByteArray oTByteArray, int n, int n2) throws InvalidGlyphException, UnsupportedFontException {
        int n3 = n;
        try {
            block153: while (n < n2) {
                int n4 = oTByteArray.getuint8(n);
                ++n;
                switch (n4) {
                    case 64: {
                        int n5 = oTByteArray.getuint8(n);
                        ++n;
                        for (int i = 0; i < n5; ++i) {
                            this.stack.push(oTByteArray.getuint8(n));
                            ++n;
                        }
                        continue block153;
                    }
                    case 65: {
                        int n6 = oTByteArray.getuint8(n);
                        ++n;
                        for (int i = 0; i < n6; ++i) {
                            this.stack.push(oTByteArray.getint16(n));
                            n += 2;
                        }
                        continue block153;
                    }
                    case 176: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: {
                        int n7 = (n4 & 7) + 1;
                        for (int i = 0; i < n7; ++i) {
                            this.stack.push(oTByteArray.getuint8(n));
                            ++n;
                        }
                        continue block153;
                    }
                    case 184: 
                    case 185: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 191: {
                        int n8 = (n4 & 7) + 1;
                        for (int i = 0; i < n8; ++i) {
                            this.stack.push(oTByteArray.getint16(n));
                            n += 2;
                        }
                        continue block153;
                    }
                    case 67: {
                        this.stack.push(this.storageArea.getuint32(this.stack.pop()));
                        continue block153;
                    }
                    case 66: {
                        int n9 = this.stack.pop();
                        int n10 = this.stack.pop();
                        this.storageArea.setuint32(n10, n9);
                        continue block153;
                    }
                    case 68: {
                        int n11 = this.stack.pop();
                        int n12 = this.stack.pop();
                        this.gs.putCVT(n12, n11);
                        continue block153;
                    }
                    case 112: {
                        int n13 = this.stack.pop();
                        int n14 = this.stack.pop();
                        this.gs.putCVTPixels(n14, n13);
                        continue block153;
                    }
                    case 69: {
                        this.stack.push(this.gs.getCVT(this.stack.pop()));
                        continue block153;
                    }
                    case 0: 
                    case 1: {
                        boolean bl = (n4 & 1) == 0;
                        this.gs.setVector(this.gs.projectionVector, 16384, 0, bl);
                        this.gs.setVector(this.gs.originalProjectionVector, 16384, 0, bl);
                        this.gs.setVector(this.gs.freedomVector, 16384, 0, bl);
                        continue block153;
                    }
                    case 2: 
                    case 3: {
                        boolean bl = (n4 & 1) == 0;
                        this.gs.setVector(this.gs.projectionVector, 16384, 0, bl);
                        this.gs.setVector(this.gs.originalProjectionVector, 16384, 0, bl);
                        continue block153;
                    }
                    case 4: 
                    case 5: {
                        boolean bl = (n4 & 1) == 0;
                        this.gs.setVector(this.gs.freedomVector, 16384, 0, bl);
                        continue block153;
                    }
                    case 6: 
                    case 7: {
                        boolean bl = (n4 & 1) == 1;
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                        TTPoint tTPoint2 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        this.gs.setVector(this.gs.projectionVector, tTPoint.hinted, tTPoint2.hinted, bl);
                        continue block153;
                    }
                    case 8: 
                    case 9: {
                        boolean bl = (n4 & 1) == 1;
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                        TTPoint tTPoint3 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        this.gs.setVector(this.gs.freedomVector, tTPoint.hinted, tTPoint3.hinted, bl);
                        continue block153;
                    }
                    case 134: 
                    case 135: {
                        boolean bl = (n4 & 1) == 1;
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                        TTPoint tTPoint4 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        this.gs.setVector(this.gs.originalProjectionVector, tTPoint.unhinted, tTPoint4.unhinted, bl);
                        this.gs.setVector(this.gs.projectionVector, tTPoint.hinted, tTPoint4.hinted, bl);
                        continue block153;
                    }
                    case 14: {
                        this.gs.setVector(this.gs.freedomVector, ((GraphicState)this.gs).projectionVector.x, ((GraphicState)this.gs).projectionVector.y, false);
                        continue block153;
                    }
                    case 10: {
                        int n15 = this.stack.pop();
                        int n16 = this.stack.pop();
                        this.gs.setVector(this.gs.projectionVector, n16, n15, false);
                        this.gs.setVector(this.gs.originalProjectionVector, n16, n15, false);
                        continue block153;
                    }
                    case 11: {
                        int n17 = this.stack.pop();
                        int n18 = this.stack.pop();
                        this.gs.setVector(this.gs.freedomVector, n18, n17, false);
                        continue block153;
                    }
                    case 12: {
                        this.stack.push(((GraphicState)this.gs).projectionVector.x);
                        this.stack.push(((GraphicState)this.gs).projectionVector.y);
                        continue block153;
                    }
                    case 13: {
                        this.stack.push(((GraphicState)this.gs).freedomVector.x);
                        this.stack.push(((GraphicState)this.gs).freedomVector.y);
                        continue block153;
                    }
                    case 16: {
                        this.gs.setRp0(this.stack.pop());
                        continue block153;
                    }
                    case 17: {
                        this.gs.setRp1(this.stack.pop());
                        continue block153;
                    }
                    case 18: {
                        this.gs.setRp2(this.stack.pop());
                        continue block153;
                    }
                    case 19: {
                        this.gs.setZp0(this.stack.pop());
                        continue block153;
                    }
                    case 20: {
                        this.gs.setZp1(this.stack.pop());
                        continue block153;
                    }
                    case 21: {
                        this.gs.setZp2(this.stack.pop());
                        continue block153;
                    }
                    case 22: {
                        int n19 = this.stack.pop();
                        this.gs.setZp0(n19);
                        this.gs.setZp1(n19);
                        this.gs.setZp2(n19);
                        continue block153;
                    }
                    case 25: {
                        this.gs.setRoundMode(this.gs.ROUND_TO_HALF_GRID);
                        continue block153;
                    }
                    case 24: {
                        this.gs.setRoundMode(this.gs.ROUND_TO_GRID);
                        continue block153;
                    }
                    case 61: {
                        this.gs.setRoundMode(this.gs.ROUND_TO_DOUBLE_GRID);
                        continue block153;
                    }
                    case 125: {
                        this.gs.setRoundMode(this.gs.ROUND_DOWN_TO_GRID);
                        continue block153;
                    }
                    case 124: {
                        this.gs.setRoundMode(this.gs.ROUND_UP_TO_GRID);
                        continue block153;
                    }
                    case 122: {
                        this.gs.setRoundMode(this.gs.ROUND_OFF);
                        continue block153;
                    }
                    case 118: 
                    case 119: {
                        int n20;
                        int n21;
                        int n22 = this.stack.pop();
                        int n23 = 0;
                        if ((n4 & 1) == 0) {
                            switch (n22 & 0xC0) {
                                case 0: {
                                    n21 = 32;
                                    break;
                                }
                                case 64: {
                                    n21 = 64;
                                    break;
                                }
                                case 128: {
                                    n21 = 128;
                                    break;
                                }
                                default: {
                                    n21 = 999;
                                    break;
                                }
                            }
                        } else {
                            int n24 = 11591;
                            switch (n22 & 0xC0) {
                                case 0: {
                                    n24 >>= 1;
                                    break;
                                }
                                case 64: {
                                    break;
                                }
                                case 128: {
                                    n24 <<= 1;
                                    break;
                                }
                                default: {
                                    n24 = 999;
                                }
                            }
                            n20 = 8;
                            n21 = n24 + (1 << n20 - 1) >> n20;
                        }
                        switch (n22 & 0x30) {
                            case 0: {
                                n23 = 0;
                                break;
                            }
                            case 16: {
                                n23 = n21 + 2 >> 2;
                                break;
                            }
                            case 32: {
                                n23 = n21 + 1 >> 1;
                                break;
                            }
                            case 48: {
                                n23 = n21 + n21 + n21 + 2 >> 2;
                            }
                        }
                        int n25 = (n22 & 0xF) == 0 ? n21 - 1 : ((n22 & 0xF) - 4) * n21 + 4 >> 3;
                        this.gs.setRounding(n21, n23, n25, (n4 & 1) == 0 ? this.gs.SUPER_ROUND : this.gs.SUPER_45_ROUND);
                        continue block153;
                    }
                    case 23: {
                        this.gs.setLoopVariable(this.stack.pop());
                        continue block153;
                    }
                    case 26: {
                        this.gs.setMinimumDistance(this.stack.pop());
                        continue block153;
                    }
                    case 142: {
                        int n26 = this.stack.pop();
                        int n27 = this.stack.pop();
                        int n28 = this.gs.getInstrControl();
                        if (n26 == 1) {
                            n28 &= 0xFFFFFFFE;
                        } else if (n26 == 2) {
                            n28 &= 0xFFFFFFFD;
                        }
                        this.gs.setInstrControl(n28 |= n27);
                        continue block153;
                    }
                    case 133: {
                        this.gs.setScanControl(this.gs.getScanControl() & 0xFFFF0000 | this.stack.pop() & 0xFFFF);
                        continue block153;
                    }
                    case 141: {
                        this.gs.setScanControl(this.stack.pop() << 16 | this.gs.getScanControl() & 0xFFFF);
                        continue block153;
                    }
                    case 29: {
                        this.gs.setControlValueCutIn(this.stack.pop());
                        continue block153;
                    }
                    case 30: {
                        this.gs.setSingleWidthCutIn(this.stack.pop());
                        continue block153;
                    }
                    case 31: {
                        this.gs.setSingleWidth(this.stack.pop());
                        continue block153;
                    }
                    case 77: {
                        this.gs.setAutoFlip(true);
                        continue block153;
                    }
                    case 78: {
                        this.gs.setAutoFlip(false);
                        continue block153;
                    }
                    case 126: {
                        this.gs.setAngleWeight(this.stack.pop());
                        continue block153;
                    }
                    case 94: {
                        this.gs.setDeltaBase(this.stack.pop());
                        continue block153;
                    }
                    case 95: {
                        this.gs.setDeltaShift(this.stack.pop());
                        continue block153;
                    }
                    case 70: 
                    case 71: {
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                        if ((n4 & 1) == 0) {
                            this.stack.push(this.gs.project(this.gs.projectionVector, tTPoint.hinted));
                            continue block153;
                        }
                        this.stack.push(this.gs.project(this.gs.originalProjectionVector, tTPoint.unhinted));
                        continue block153;
                    }
                    case 72: {
                        int n29 = this.stack.pop();
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                        int n30 = this.gs.project(this.gs.projectionVector, tTPoint.hinted);
                        this.gs.move(tTPoint, n29 - n30);
                        if (this.gs.getZp2() != 0) continue block153;
                        tTPoint.unhinted.x = tTPoint.hinted.x;
                        tTPoint.unhinted.y = tTPoint.hinted.y;
                        continue block153;
                    }
                    case 73: 
                    case 74: {
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        TTPoint tTPoint5 = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.stack.pop());
                        int n31 = (n4 & 1) == 0 ? this.gs.project(this.gs.originalProjectionVector, tTPoint.unhinted, tTPoint5.unhinted) : this.gs.project(this.gs.projectionVector, tTPoint.hinted, tTPoint5.hinted);
                        this.stack.push(n31);
                        continue block153;
                    }
                    case 75: {
                        this.stack.push(this.gs.getPixelsPerEm());
                        continue block153;
                    }
                    case 76: {
                        this.stack.push(this.gs.getPointSize());
                        continue block153;
                    }
                    case 128: {
                        int n32 = this.gs.getZp0();
                        for (int i = this.gs.getAndResetLoopVariable(); i > 0; --i) {
                            TTPoint tTPoint = this.getPoint(tTSimpleOutline, n32, this.stack.pop());
                            tTPoint.onCurve = !tTPoint.onCurve;
                        }
                        continue block153;
                    }
                    case 129: 
                    case 130: {
                        int n33 = this.gs.getZp0();
                        int n34 = this.stack.pop();
                        int n35 = this.stack.pop();
                        boolean bl = (n4 & 1) == 1;
                        for (int i = n35; i <= n34; ++i) {
                            this.getPoint((TTOutline)tTSimpleOutline, (int)n33, (int)i).onCurve = bl;
                        }
                        continue block153;
                    }
                    case 50: 
                    case 51: {
                        TTPoint tTPoint = (n4 & 1) == 0 ? this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp1());
                        int n36 = this.gs.project(this.gs.projectionVector, tTPoint.unhinted, tTPoint.hinted);
                        int n37 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n36, ((GraphicState)this.gs).freedomVector.x, this.gs.fDotP);
                        int n38 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n36, ((GraphicState)this.gs).freedomVector.y, this.gs.fDotP);
                        for (int i = this.gs.getAndResetLoopVariable(); i > 0; --i) {
                            TTPoint tTPoint6 = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                            if (tTPoint6 == tTPoint) continue;
                            this.gs.move(tTPoint6, n37, n38);
                        }
                        continue block153;
                    }
                    case 52: 
                    case 53: {
                        int n39;
                        int n40 = this.stack.pop();
                        TTPoint tTPoint = (n4 & 1) == 0 ? this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp1());
                        int n41 = this.gs.project(this.gs.projectionVector, tTPoint.unhinted, tTPoint.hinted);
                        int n42 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n41, ((GraphicState)this.gs).freedomVector.x, this.gs.fDotP);
                        int n43 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n41, ((GraphicState)this.gs).freedomVector.y, this.gs.fDotP);
                        int n20 = tTSimpleOutline.getContourFirstPoint(n40);
                        int n44 = tTSimpleOutline.getContourLastPoint(n40);
                        for (n39 = n20; n39 <= n44; ++n39) {
                            TTPoint tTPoint7 = this.getPoint(tTSimpleOutline, this.gs.getZp2(), n39);
                            if (tTPoint7 == tTPoint) continue;
                            this.gs.move(tTPoint7, n42, n43);
                        }
                        continue block153;
                    }
                    case 54: 
                    case 55: {
                        int n39;
                        int n45 = this.stack.pop();
                        TTPoint tTPoint = (n4 & 1) == 0 ? this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.gs.getRp2()) : this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp1());
                        int n46 = this.gs.project(this.gs.projectionVector, tTPoint.unhinted, tTPoint.hinted);
                        int n47 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n46, ((GraphicState)this.gs).freedomVector.x, this.gs.fDotP);
                        int n48 = F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n46, ((GraphicState)this.gs).freedomVector.y, this.gs.fDotP);
                        int n20 = 0;
                        int n44 = this.getNumOutlinePoints(tTSimpleOutline, n45) - 1;
                        for (n39 = n20; n39 <= n44; ++n39) {
                            TTPoint tTPoint8 = this.getPoint(tTSimpleOutline, n45, n39);
                            if (tTPoint8 == tTPoint) continue;
                            this.gs.move(tTPoint8, n47, n48);
                        }
                        continue block153;
                    }
                    case 56: {
                        int n49 = this.stack.pop();
                        int n50 = F26Dot6.multiplyByF2Dot14(n49, ((GraphicState)this.gs).freedomVector.x);
                        int n51 = F26Dot6.multiplyByF2Dot14(n49, ((GraphicState)this.gs).freedomVector.y);
                        for (int i = this.gs.getAndResetLoopVariable(); i > 0; --i) {
                            TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                            this.gs.move(tTPoint, n50, n51);
                        }
                        continue block153;
                    }
                    case 58: 
                    case 59: {
                        int n52 = this.stack.pop();
                        int n53 = this.stack.pop();
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp1(), n53);
                        TTPoint tTPoint9 = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp0());
                        if (this.gs.getZp1() == 0) {
                            tTPoint.unhinted.x = F26Dot6.multiplyByF2Dot14(n52, ((GraphicState)this.gs).projectionVector.x);
                            tTPoint.unhinted.y = F26Dot6.multiplyByF2Dot14(n52, ((GraphicState)this.gs).projectionVector.y);
                            tTPoint.hinted.x = tTPoint.unhinted.x;
                            tTPoint.hinted.y = tTPoint.unhinted.y;
                        }
                        int n54 = this.gs.project(this.gs.projectionVector, tTPoint9.hinted, tTPoint.hinted);
                        this.gs.move(tTPoint, n52 - n54);
                        this.gs.setRp1(this.gs.getRp0());
                        this.gs.setRp2(n53);
                        if ((n4 & 1) == 0) continue block153;
                        this.gs.setRp0(n53);
                        continue block153;
                    }
                    case 46: 
                    case 47: {
                        int n55 = this.stack.pop();
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp0(), n55);
                        this.gs.setRp0(n55);
                        this.gs.setRp1(n55);
                        int n56 = 0;
                        if ((n4 & 1) != 0) {
                            int n57 = this.gs.project(this.gs.projectionVector, tTPoint.hinted);
                            n56 = this.gs.round(n57, this.gp.getEngineCompensation(0)) - n57;
                        }
                        this.gs.move(tTPoint, n56);
                        continue block153;
                    }
                    case 62: 
                    case 63: {
                        int n58 = this.gs.getCVT(this.stack.pop());
                        int n59 = this.stack.pop();
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp0(), n59);
                        this.gs.setRp0(n59);
                        this.gs.setRp1(n59);
                        if (this.gs.getZp0() == 0) {
                            tTPoint.unhinted.x = F26Dot6.multiplyByF2Dot14(n58, ((GraphicState)this.gs).projectionVector.x);
                            tTPoint.unhinted.y = F26Dot6.multiplyByF2Dot14(n58, ((GraphicState)this.gs).projectionVector.y);
                            tTPoint.hinted.x = tTPoint.unhinted.x;
                            tTPoint.hinted.y = tTPoint.unhinted.y;
                        }
                        int n60 = this.gs.project(this.gs.projectionVector, tTPoint.hinted);
                        if ((n4 & 1) != 0) {
                            if (Math.abs(n58 - n60) > this.gs.getControlValueCutIn()) {
                                n58 = n60;
                            }
                            n58 = this.gs.round(n58, this.gp.getEngineCompensation(0));
                        }
                        this.gs.move(tTPoint, n58 - n60);
                        continue block153;
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: 
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 216: 
                    case 217: 
                    case 218: 
                    case 219: 
                    case 220: 
                    case 221: 
                    case 222: 
                    case 223: {
                        int n61;
                        int n44;
                        int n20;
                        int n62 = this.stack.pop();
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp1(), n62);
                        TTPoint tTPoint10 = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp0());
                        if (this.gs.getZp0() == 0 || this.gs.getZp1() == 0 || tTSimpleOutline.unscaledCoordinatesAreInvalid) {
                            n61 = this.gs.project(this.gs.originalProjectionVector, tTPoint10.unhinted, tTPoint.unhinted);
                        } else {
                            int n63 = this.scaleAndRound(tTPoint.unscaled.x - tTPoint10.unscaled.x, this.gs.cvtxN >> 10, this.gs.cvtD >> 16);
                            n20 = this.scaleAndRound(tTPoint.unscaled.y - tTPoint10.unscaled.y, this.gs.cvtyN >> 10, this.gs.cvtD >> 16);
                            n61 = this.gs.project(this.gs.originalProjectionVector, n63, n20);
                        }
                        int n64 = n61 = this.gs.snapToSingleWidth(n61);
                        n20 = this.gp.getEngineCompensation(n4 & 3);
                        n61 = (n4 & 4) != 0 ? this.gs.round(n61, n20) : this.gs.roundOff(n61, n20);
                        if ((n4 & 8) != 0) {
                            n44 = this.gs.getMinimumDistance();
                            if (n64 >= 0) {
                                if (n61 < n44) {
                                    n61 = n44;
                                }
                            } else if (n61 > -n44) {
                                n61 = -n44;
                            }
                        }
                        n44 = this.gs.project(this.gs.projectionVector, tTPoint10.hinted, tTPoint.hinted);
                        this.gs.move(tTPoint, n61 - n44);
                        this.gs.setRp1(this.gs.getRp0());
                        this.gs.setRp2(n62);
                        if ((n4 & 0x10) == 0) continue block153;
                        this.gs.setRp0(n62);
                        continue block153;
                    }
                    case 224: 
                    case 225: 
                    case 226: 
                    case 227: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 237: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 253: 
                    case 254: 
                    case 255: {
                        int n39;
                        int n65 = this.gs.getCVT(this.stack.pop());
                        int n66 = this.stack.pop();
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp1(), n66);
                        TTPoint tTPoint11 = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp0());
                        n65 = this.gs.snapToSingleWidth(n65);
                        if (this.gs.getZp1() == 0) {
                            tTPoint.unhinted.x = tTPoint11.unhinted.x + F26Dot6.multiplyByF2Dot14(n65, ((GraphicState)this.gs).projectionVector.x);
                            tTPoint.unhinted.y = tTPoint11.unhinted.y + F26Dot6.multiplyByF2Dot14(n65, ((GraphicState)this.gs).projectionVector.y);
                            tTPoint.hinted.x = tTPoint.unhinted.x;
                            tTPoint.hinted.y = tTPoint.unhinted.y;
                        }
                        int n67 = this.gs.project(this.gs.originalProjectionVector, tTPoint11.unhinted, tTPoint.unhinted);
                        int n20 = this.gs.project(this.gs.projectionVector, tTPoint11.hinted, tTPoint.hinted);
                        if (this.gs.getAutoFlip() && !F26Dot6.sameSign(n67, n65)) {
                            n65 = -n65;
                        }
                        int n44 = this.gp.getEngineCompensation(n4 & 3);
                        if ((n4 & 4) != 0) {
                            if (Math.abs(n65 - n67) > this.gs.getControlValueCutIn()) {
                                n65 = n67;
                            }
                            n65 = this.gs.round(n65, n44);
                        } else {
                            n65 = this.gs.roundOff(n65, n44);
                        }
                        if ((n4 & 8) != 0) {
                            n39 = this.gs.getMinimumDistance();
                            if (n67 >= 0) {
                                if (n65 < n39) {
                                    n65 = n39;
                                }
                            } else if (n65 > -n39) {
                                n65 = -n39;
                            }
                        }
                        this.gs.move(tTPoint, n65 - n20);
                        this.gs.setRp1(this.gs.getRp0());
                        this.gs.setRp2(n66);
                        if ((n4 & 0x10) == 0) continue block153;
                        this.gs.setRp0(n66);
                        continue block153;
                    }
                    case 60: {
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp0());
                        for (int i = this.gs.getAndResetLoopVariable(); i > 0; --i) {
                            TTPoint tTPoint12 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                            this.gs.move(tTPoint12, -this.gs.project(this.gs.projectionVector, tTPoint.hinted, tTPoint12.hinted));
                        }
                        continue block153;
                    }
                    case 127: {
                        throw new InvalidGlyphException("TT instruction AA is no longer supported");
                    }
                    case 15: {
                        int n68;
                        int n69;
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.stack.pop());
                        TTPoint tTPoint13 = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.stack.pop());
                        TTPoint tTPoint14 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        TTPoint tTPoint15 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        TTPoint tTPoint16 = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                        int n20 = tTPoint.hinted.x - tTPoint13.hinted.x;
                        int n44 = tTPoint.hinted.y - tTPoint13.hinted.y;
                        int n39 = tTPoint14.hinted.x - tTPoint15.hinted.x;
                        int n70 = tTPoint14.hinted.y - tTPoint15.hinted.y;
                        if (n44 == 0) {
                            if (n39 == 0) {
                                this.gs.set(tTPoint16, tTPoint15.hinted.x, tTPoint13.hinted.y);
                                continue block153;
                            }
                            n69 = tTPoint15.hinted.y - tTPoint13.hinted.y;
                            n68 = -n70;
                        } else if (n20 == 0) {
                            if (n70 == 0) {
                                this.gs.set(tTPoint16, tTPoint13.hinted.x, tTPoint15.hinted.y);
                                continue block153;
                            }
                            n69 = tTPoint15.hinted.x - tTPoint13.hinted.x;
                            n68 = -n39;
                        } else if (F26Dot6.abs(n20) >= F26Dot6.abs(n44)) {
                            n69 = tTPoint15.hinted.y - tTPoint13.hinted.y - F26Dot6.multiplyDivide(tTPoint15.hinted.x - tTPoint13.hinted.x, n44, n20);
                            n68 = F26Dot6.multiplyDivide(n39, n44, n20) - n70;
                        } else {
                            n69 = F26Dot6.multiplyDivide(tTPoint15.hinted.y - tTPoint13.hinted.y, n20, n44) - (tTPoint15.hinted.x - tTPoint13.hinted.x);
                            n68 = n39 - F26Dot6.multiplyDivide(n70, n20, n44);
                        }
                        if (n68 != 0) {
                            this.gs.set(tTPoint16, tTPoint15.hinted.x + F26Dot6.multiplyDivide(n39, n69, n68), tTPoint15.hinted.y + F26Dot6.multiplyDivide(n70, n69, n68));
                            continue block153;
                        }
                        this.gs.set(tTPoint16, tTPoint15.hinted.x + (n39 >> 1) + tTPoint13.hinted.x + (n20 >> 1) >> 1, tTPoint15.hinted.y + (n70 >> 1) + tTPoint13.hinted.y + (n44 >> 1) >> 1);
                        continue block153;
                    }
                    case 39: {
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.stack.pop());
                        TTPoint tTPoint17 = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.stack.pop());
                        int n71 = this.gs.project(this.gs.projectionVector, tTPoint.hinted, tTPoint17.hinted);
                        this.gs.move(tTPoint, n71 / 2);
                        this.gs.move(tTPoint17, n71 - n71 / 2);
                        continue block153;
                    }
                    case 57: {
                        int n69;
                        int n70;
                        int n39;
                        int n20;
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.gs.getRp1());
                        TTPoint tTPoint18 = this.getPoint(tTSimpleOutline, this.gs.getZp1(), this.gs.getRp2());
                        boolean bl = this.gs.getZp0() == 0 || this.gs.getZp1() == 0 || this.gs.getZp2() == 0 || tTSimpleOutline.unscaledCoordinatesAreInvalid;
                        int n72 = bl ? this.gs.project(this.gs.originalProjectionVector, tTPoint.unhinted, tTPoint18.unhinted) : this.gs.project(this.gs.originalProjectionVector, tTPoint18.unscaled.x - tTPoint.unscaled.x, tTPoint18.unscaled.y - tTPoint.unscaled.y);
                        int n73 = this.gs.project(this.gs.projectionVector, tTPoint.hinted, tTPoint18.hinted);
                        for (n20 = this.gs.getAndResetLoopVariable(); n20 > 0; --n20) {
                            TTPoint tTPoint19 = this.getPoint(tTSimpleOutline, this.gs.getZp2(), this.stack.pop());
                            n39 = bl ? this.gs.project(this.gs.projectionVector, tTPoint.unhinted, tTPoint19.unhinted) : this.gs.project(this.gs.projectionVector, tTPoint19.unscaled.x - tTPoint.unscaled.x, tTPoint19.unscaled.y - tTPoint.unscaled.y);
                            n70 = this.gs.project(this.gs.projectionVector, tTPoint.hinted, tTPoint19.hinted);
                            n69 = n72 == 0 ? n39 : F26Dot6.multiplyDivide(n73, n39, n72);
                            this.gs.move(tTPoint19, n69 - n70);
                        }
                        continue block153;
                    }
                    case 41: {
                        TTPoint tTPoint = this.getPoint(tTSimpleOutline, this.gs.getZp0(), this.stack.pop());
                        this.gs.untouch(tTPoint);
                        continue block153;
                    }
                    case 48: 
                    case 49: {
                        boolean bl;
                        int n68;
                        int n39;
                        int n44;
                        int n20;
                        boolean bl2 = bl = (n4 & 1) == 1;
                        if (this.gs.getZp2() != 1) {
                            throw new InvalidGlyphException("ZP2 should be 1 instead of " + this.gs.getZp2() + " in an IUP instruction");
                        }
                        for (int i = 0; i < tTSimpleOutline.getNumContours(); ++i) {
                            int n74;
                            int n75 = tTSimpleOutline.getContourFirstPoint(i);
                            int n76 = tTSimpleOutline.getContourLastPoint(i);
                            for (n74 = n75; n74 <= n76 && !this.getPoint(tTSimpleOutline, 1, n74).touched(bl); ++n74) {
                            }
                            if (n74 > n76) continue;
                            n20 = n74;
                            n44 = tTSimpleOutline.getContourNextPoint(i, n74);
                            while (n44 != n74) {
                                int n77;
                                if (this.getPoint(tTSimpleOutline, 1, n44).touched(bl)) {
                                    n20 = n44;
                                    n44 = tTSimpleOutline.getContourNextPoint(i, n44);
                                    continue;
                                }
                                n39 = tTSimpleOutline.getContourNextPoint(i, n44);
                                while (!this.getPoint(tTSimpleOutline, 1, n39).touched(bl)) {
                                    n39 = tTSimpleOutline.getContourNextPoint(i, n39);
                                }
                                TTPoint tTPoint = this.getPoint(tTSimpleOutline, 1, n20);
                                TTPoint tTPoint20 = this.getPoint(tTSimpleOutline, 1, n39);
                                int n78 = bl ? (tTSimpleOutline.unscaledCoordinatesAreInvalid ? tTPoint.unhinted.x : tTPoint.unscaled.x) : (n68 = tTSimpleOutline.unscaledCoordinatesAreInvalid ? tTPoint.unhinted.y : tTPoint.unscaled.y);
                                int n79 = bl ? (tTSimpleOutline.unscaledCoordinatesAreInvalid ? tTPoint20.unhinted.x : tTPoint20.unscaled.x) : (n77 = tTSimpleOutline.unscaledCoordinatesAreInvalid ? tTPoint20.unhinted.y : tTPoint20.unscaled.y);
                                if (n68 > n77) {
                                    TTPoint tTPoint21 = tTPoint;
                                    tTPoint = tTPoint20;
                                    tTPoint20 = tTPoint21;
                                    int n80 = n68;
                                    n68 = n77;
                                    n77 = n80;
                                }
                                while (n44 != n39) {
                                    TTPoint tTPoint22 = this.getPoint(tTSimpleOutline, 1, n44);
                                    int n81 = bl ? (tTSimpleOutline.unscaledCoordinatesAreInvalid ? tTPoint22.unhinted.x : tTPoint22.unscaled.x) : (tTSimpleOutline.unscaledCoordinatesAreInvalid ? tTPoint22.unhinted.y : tTPoint22.unscaled.y);
                                    int n82 = tTPoint22.hinted.x;
                                    int n83 = tTPoint22.hinted.y;
                                    if (n68 == n77) {
                                        if (bl) {
                                            tTPoint22.hinted.x += tTPoint20.hinted.x - tTPoint20.unhinted.x;
                                        } else {
                                            tTPoint22.hinted.y += tTPoint20.hinted.y - tTPoint20.unhinted.y;
                                        }
                                    } else if (n68 < n81 && n81 < n77) {
                                        if (bl) {
                                            tTPoint22.hinted.x = tTPoint.hinted.x + F26Dot6.multiplyDivide(n81 - n68, tTPoint20.hinted.x - tTPoint.hinted.x, n77 - n68);
                                        } else {
                                            tTPoint22.hinted.y = tTPoint.hinted.y + F26Dot6.multiplyDivide(n81 - n68, tTPoint20.hinted.y - tTPoint.hinted.y, n77 - n68);
                                        }
                                    } else if (n81 <= n68) {
                                        if (bl) {
                                            tTPoint22.hinted.x += tTPoint.hinted.x - tTPoint.unhinted.x;
                                        } else {
                                            tTPoint22.hinted.y += tTPoint.hinted.y - tTPoint.unhinted.y;
                                        }
                                    } else if (bl) {
                                        tTPoint22.hinted.x += tTPoint20.hinted.x - tTPoint20.unhinted.x;
                                    } else {
                                        tTPoint22.hinted.y += tTPoint20.hinted.y - tTPoint20.unhinted.y;
                                    }
                                    n44 = tTSimpleOutline.getContourNextPoint(i, n44);
                                }
                            }
                        }
                        continue block153;
                    }
                    case 93: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: {
                        int n69;
                        int n39;
                        int n44;
                        int n20;
                        int n84 = n4 == 114 || n4 == 117 ? this.gs.getDeltaBase() + 32 : (n4 == 113 || n4 == 116 ? this.gs.getDeltaBase() + 16 : this.gs.getDeltaBase());
                        int n85 = this.gs.getPixelsPerEm();
                        int n86 = this.stack.pop();
                        for (int i = 0; i < n86; ++i) {
                            int n87 = this.stack.pop();
                            n20 = this.stack.pop();
                            n44 = n84 + (n20 >> 4 & 0xF);
                            if (n44 != n85) continue;
                            int n88 = n39 - ((n39 = n20 & 0xF) < 8 ? 8 : 7);
                            n69 = n88 << 6 - this.gs.getDeltaShift();
                            if (n4 < 115) {
                                this.gs.move(this.getPoint(tTSimpleOutline, this.gs.getZp0(), n87), n69);
                                continue;
                            }
                            this.gs.incrementCVT(n87, n69);
                        }
                        continue block153;
                    }
                    case 32: {
                        this.stack.copy(1);
                        continue block153;
                    }
                    case 33: {
                        this.stack.pop();
                        continue block153;
                    }
                    case 34: {
                        this.stack.clear();
                        continue block153;
                    }
                    case 35: {
                        int n89 = this.stack.pop();
                        int n90 = this.stack.pop();
                        this.stack.push(n89);
                        this.stack.push(n90);
                        continue block153;
                    }
                    case 36: {
                        this.stack.pushDepth();
                        continue block153;
                    }
                    case 37: {
                        this.stack.copy(this.stack.pop());
                        continue block153;
                    }
                    case 38: {
                        this.stack.bubbleUp(this.stack.pop());
                        continue block153;
                    }
                    case 138: {
                        int n91 = this.stack.pop();
                        int n92 = this.stack.pop();
                        int n93 = this.stack.pop();
                        this.stack.push(n92);
                        this.stack.push(n91);
                        this.stack.push(n93);
                        continue block153;
                    }
                    case 88: {
                        int n94 = this.stack.pop();
                        if (n94 != 0) continue block153;
                        int n95 = 0;
                        int n96 = n;
                        boolean bl = false;
                        while (n96 < n2 && !bl) {
                            switch (oTByteArray.getuint8(n96)) {
                                case 88: {
                                    ++n95;
                                    break;
                                }
                                case 27: {
                                    if (n95 != 0) break;
                                    bl = true;
                                    break;
                                }
                                case 89: {
                                    if (n95 == 0) {
                                        bl = true;
                                        break;
                                    }
                                    --n95;
                                }
                            }
                            n96 = this.skipInstruction(oTByteArray, n96);
                        }
                        if (bl) {
                            n = n96;
                            continue block153;
                        }
                        throw new InvalidFontException("incorrect IF - no ELSE or EIF in TT outline");
                    }
                    case 27: {
                        int n97 = 0;
                        int n98 = n;
                        boolean bl = false;
                        while (n98 < n2 && !bl) {
                            switch (oTByteArray.getuint8(n98)) {
                                case 88: {
                                    ++n97;
                                    break;
                                }
                                case 89: {
                                    if (n97 == 0) {
                                        bl = true;
                                        break;
                                    }
                                    --n97;
                                }
                            }
                            n98 = this.skipInstruction(oTByteArray, n98);
                        }
                        if (bl) {
                            n = n98;
                            continue block153;
                        }
                        throw new InvalidGlyphException("incorrect IF - ELSE - no EIF in TT outline");
                    }
                    case 89: {
                        continue block153;
                    }
                    case 120: {
                        int n99 = this.stack.pop();
                        int n100 = this.stack.pop();
                        if (n99 == 0 || (n += n100 - 1) >= n3 && n2 >= n) continue block153;
                        throw new InvalidGlyphException("JROF outside of hinted instruction block");
                    }
                    case 28: {
                        int n101 = this.stack.pop();
                        if ((n += n101 - 1) >= n3 && n2 >= n) continue block153;
                        throw new InvalidGlyphException("JROF outside of hinted instruction block");
                    }
                    case 121: {
                        int n102 = this.stack.pop();
                        int n103 = this.stack.pop();
                        if (n102 != 0 || (n += n103 - 1) >= n3 && n2 >= n) continue block153;
                        throw new InvalidGlyphException("JROF outside of hinted instruction block");
                    }
                    case 80: {
                        int n104 = this.stack.pop();
                        int n105 = this.stack.pop();
                        this.stack.push(n105 < n104 ? 1 : 0);
                        continue block153;
                    }
                    case 81: {
                        int n106 = this.stack.pop();
                        int n107 = this.stack.pop();
                        this.stack.push(n107 <= n106 ? 1 : 0);
                        continue block153;
                    }
                    case 82: {
                        int n108 = this.stack.pop();
                        int n109 = this.stack.pop();
                        this.stack.push(n109 > n108 ? 1 : 0);
                        continue block153;
                    }
                    case 83: {
                        int n110 = this.stack.pop();
                        int n111 = this.stack.pop();
                        this.stack.push(n111 >= n110 ? 1 : 0);
                        continue block153;
                    }
                    case 84: {
                        int n112 = this.stack.pop();
                        int n113 = this.stack.pop();
                        this.stack.push(n113 == n112 ? 1 : 0);
                        continue block153;
                    }
                    case 85: {
                        int n114 = this.stack.pop();
                        int n115 = this.stack.pop();
                        this.stack.push(n115 != n114 ? 1 : 0);
                        continue block153;
                    }
                    case 86: {
                        int n116 = this.stack.pop();
                        this.stack.push(F26Dot6.isEven(this.gs.roundToGrid(n116, 0)) ? 0 : 1);
                        continue block153;
                    }
                    case 87: {
                        int n117 = this.stack.pop();
                        this.stack.push(F26Dot6.isEven(this.gs.roundToGrid(n117, 0)) ? 1 : 0);
                        continue block153;
                    }
                    case 90: {
                        int n118 = this.stack.pop();
                        int n119 = this.stack.pop();
                        this.stack.push(n119 != 0 && n118 != 0 ? 1 : 0);
                        continue block153;
                    }
                    case 91: {
                        int n120 = this.stack.pop();
                        int n121 = this.stack.pop();
                        this.stack.push(n121 != 0 || n120 != 0 ? 1 : 0);
                        continue block153;
                    }
                    case 92: {
                        int n122 = this.stack.pop();
                        this.stack.push(n122 == 0 ? 1 : 0);
                        continue block153;
                    }
                    case 96: {
                        this.stack.push(F26Dot6.add(this.stack.pop(), this.stack.pop()));
                        continue block153;
                    }
                    case 97: {
                        int n123 = this.stack.pop();
                        int n124 = this.stack.pop();
                        this.stack.push(F26Dot6.subtract(n124, n123));
                        continue block153;
                    }
                    case 98: {
                        int n125 = this.stack.pop();
                        int n126 = this.stack.pop();
                        this.stack.push(F26Dot6.divide(n126, n125));
                        continue block153;
                    }
                    case 99: {
                        this.stack.push(F26Dot6.multiply(this.stack.pop(), this.stack.pop()));
                        continue block153;
                    }
                    case 100: {
                        this.stack.push(F26Dot6.abs(this.stack.pop()));
                        continue block153;
                    }
                    case 101: {
                        this.stack.push(F26Dot6.negate(this.stack.pop()));
                        continue block153;
                    }
                    case 102: {
                        this.stack.push(F26Dot6.floor(this.stack.pop()));
                        continue block153;
                    }
                    case 103: {
                        this.stack.push(F26Dot6.ceiling(this.stack.pop()));
                        continue block153;
                    }
                    case 139: {
                        this.stack.push(Math.max(this.stack.pop(), this.stack.pop()));
                        continue block153;
                    }
                    case 140: {
                        this.stack.push(Math.min(this.stack.pop(), this.stack.pop()));
                        continue block153;
                    }
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        int n127 = this.stack.pop();
                        this.stack.push(this.gs.round(n127, this.gp.getEngineCompensation(n4 & 3)));
                        continue block153;
                    }
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: {
                        int n128 = this.stack.pop();
                        this.stack.push(this.gs.roundOff(n128, this.gp.getEngineCompensation(n4 & 3)));
                        continue block153;
                    }
                    case 44: {
                        int n129 = this.stack.pop();
                        if (n129 < 0 || n129 > this.functionDefs.instructionStreams.length) {
                            throw new InvalidGlyphException("Invalid function identifier in FDEF (" + n129 + ")");
                        }
                        if (this.functionDefs.instructionStreams[n129] != null) {
                            throw new InvalidGlyphException("Redefined function identifier in FDEF (" + n129 + ")");
                        }
                        int n130 = n;
                        boolean bl = false;
                        while (n130 < n2 && !bl) {
                            switch (oTByteArray.getuint8(n130)) {
                                case 44: 
                                case 137: {
                                    throw new InvalidGlyphException("Nested FDEF/IDEF definitions");
                                }
                                case 45: {
                                    bl = true;
                                }
                            }
                            n130 = this.skipInstruction(oTByteArray, n130);
                        }
                        if (!bl) {
                            throw new InvalidGlyphException("FDEF without IDEF in TT outline");
                        }
                        this.functionDefs.setFunction(n129, oTByteArray, n, n130 - 1);
                        n = n130;
                        continue block153;
                    }
                    case 45: {
                        throw new InvalidGlyphException("dangling ENDF");
                    }
                    case 43: {
                        int n131 = this.stack.pop();
                        if (n131 < 0 || n131 > this.functionDefs.instructionStreams.length) {
                            throw new InvalidGlyphException("Invalid function identifier in CALL (" + n131 + ")");
                        }
                        if (this.functionDefs.limit[n131] == -1) {
                            throw new InvalidGlyphException("Undefined function identifier in CALL (" + n131 + ")");
                        }
                        this.runWithoutInit(tTSimpleOutline, this.functionDefs.instructionStreams[n131], this.functionDefs.start[n131], this.functionDefs.limit[n131]);
                        continue block153;
                    }
                    case 42: {
                        int n132 = this.stack.pop();
                        int n133 = this.stack.pop();
                        if (n132 < 0 || n132 > this.functionDefs.instructionStreams.length) {
                            throw new InvalidGlyphException("Invalid function identifier in LOOPCALL (" + n132 + ")");
                        }
                        if (this.functionDefs.limit[n132] == -1) {
                            throw new InvalidGlyphException("Undefined function identifier in LOOPCALL (" + n132 + ")");
                        }
                        for (int i = 0; i < n133; ++i) {
                            this.runWithoutInit(tTSimpleOutline, this.functionDefs.instructionStreams[n132], this.functionDefs.start[n132], this.functionDefs.limit[n132]);
                        }
                        continue block153;
                    }
                    case 137: {
                        int n134 = this.stack.pop();
                        if (n134 < 0 || n134 > 255) {
                            throw new InvalidGlyphException("Illegal IDEF opcode (" + n134 + ")");
                        }
                        int n135 = n;
                        boolean bl = false;
                        while (n135 < n2 && !bl) {
                            switch (oTByteArray.getuint8(n135)) {
                                case 44: 
                                case 137: {
                                    throw new InvalidGlyphException("Nested FDEF/IDEF definitions");
                                }
                                case 45: {
                                    bl = true;
                                }
                            }
                            n135 = this.skipInstruction(oTByteArray, n135);
                        }
                        if (!bl) {
                            throw new InvalidGlyphException("IDEF without ENDF TT outline");
                        }
                        n = n135;
                        this.instructionDefs.setFunction(n134, oTByteArray, n, n135 - 1);
                        n = n135;
                        continue block153;
                    }
                    case 79: {
                        this.stack.pop();
                        continue block153;
                    }
                    case 136: {
                        int n136 = this.stack.pop();
                        int n137 = 0;
                        boolean bl = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if ((n136 & 1) != 0) {
                            n137 |= 0x25;
                        }
                        if ((n136 & 2) != 0) {
                            n137 |= bl ? 256 : 0;
                        }
                        if ((n136 & 4) != 0) {
                            n137 |= bl3 ? 512 : 0;
                        }
                        if ((n136 & 0x10) != 0) {
                            n137 |= bl4 ? 4096 : 0;
                        }
                        this.stack.push(n137);
                        continue block153;
                    }
                }
                if (this.instructionDefs.instructionStreams[n4] == null) continue;
                this.runWithoutInit(tTSimpleOutline, this.instructionDefs.instructionStreams[n4], this.instructionDefs.start[n4], this.instructionDefs.limit[n4]);
            }
        }
        catch (InvalidGlyphException invalidGlyphException) {
            throw invalidGlyphException;
        }
        catch (InvalidFontException invalidFontException) {
            throw new InvalidGlyphException(invalidFontException);
        }
    }

    private int skipInstruction(OTByteArray oTByteArray, int n) throws InvalidFontException {
        int n2 = oTByteArray.getuint8(n);
        ++n;
        switch (n2) {
            case 64: {
                int n3 = oTByteArray.getuint8(n);
                ++n;
                n += n3;
                break;
            }
            case 65: {
                int n4 = oTByteArray.getuint8(n);
                ++n;
                n += 2 * n4;
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: {
                n += (n2 & 7) + 1;
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                n += 2 * ((n2 & 7) + 1);
            }
        }
        return n;
    }

    public void setDebugger(ScalerDebugger scalerDebugger) {
        this.debugger = scalerDebugger;
    }

    private void logInstruction(int n, int n2) {
        this.sb.setLength(0);
        this.sbDetails.setLength(0);
        this.currentInstr = instructions[n2];
        this.sb.append(n);
        this.sb.append(" ");
        this.sb.append(this.currentInstr.name);
        this.sb.append(" (");
        this.logStack(this.sb, this.currentInstr.stackPop);
        this.sb.append(")");
    }

    private void logResult() {
        if (this.currentInstr.stackPush != 0) {
            this.sb.append(" -> ");
            this.logStack(this.sb, this.currentInstr.stackPush);
        }
        this.sb.append("\n");
        this.sb.append(this.sbDetails);
        this.debugger.ttInterpLog(this.sb.toString());
    }

    private void logDetail(String string) {
        this.sbDetails.append("  ");
        this.sbDetails.append(string);
        this.sbDetails.append("\n");
    }

    private void logDetailNoLn(String string) {
        this.sbDetails.append(string);
    }

    private void logStack(StringBuffer stringBuffer, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string + Integer.toHexString(this.stack.peek(i)));
            string = ", ";
        }
    }

    static class Instr {
        int opcode;
        String name;
        int stackPop;
        int stackPush;

        public Instr(int n, String string, int n2, int n3) {
            this.opcode = n;
            this.name = string;
            this.stackPop = n2;
            this.stackPush = n3;
        }
    }

    private final class FunctionDefinitions {
        private OTByteArray[] instructionStreams;
        private int[] start;
        private int[] limit;

        public FunctionDefinitions(int n) {
            this.instructionStreams = new OTByteArray[n];
            this.start = new int[n];
            this.limit = new int[n];
        }

        public void setFunction(int n, OTByteArray oTByteArray, int n2, int n3) {
            this.instructionStreams[n] = oTByteArray;
            this.start[n] = n2;
            this.limit[n] = n3;
        }
    }

    private final class ControlValueTable {
        private int[] originalData;
        private int[] data;

        ControlValueTable(int n, OTByteArray oTByteArray) throws InvalidFontException {
            if (n < 0 || 200000 <= n) {
                throw new InvalidFontException("attempt to CVT table with " + n + " entries");
            }
            this.originalData = new int[n];
            for (int i = 0; i < n; ++i) {
                this.originalData[i] = oTByteArray.getint16(2 * i);
            }
            this.data = new int[n];
        }

        void resetAndScale(int n, int n2) {
            for (int i = 0; i < this.originalData.length; ++i) {
                this.data[i] = this.scale(this.originalData[i], n, n2);
            }
        }

        int countLowZeros(int n) {
            for (int i = 0; i < 32; ++i) {
                if ((n & 1) != 0) {
                    return i;
                }
                n >>= 1;
            }
            return 32;
        }

        int getShift(int n) {
            if ((n & n - 1) != 0 || n == 0) {
                return -1;
            }
            return this.countLowZeros(n);
        }

        int scale(int n, int n2, int n3) {
            int n4 = this.countLowZeros(n2 | n3) - 1;
            if (n4 > 0) {
                n2 >>= n4;
                n3 >>= n4;
            }
            if (n2 < 0x2000000) {
                n2 <<= 6;
            } else {
                n3 >>= 6;
            }
            if (n2 <= Short.MAX_VALUE) {
                n4 = this.getShift(n3);
                if (n4 >= 0) {
                    return n * n2 + (n3 >> 1) >> n4;
                }
                if (n < 0) {
                    return -(-n * n2 + (n3 >> 1)) / n3;
                }
                return (n * n2 + (n3 >> 1)) / n3;
            }
            return F16Dot16.multiply(n, F16Dot16.divide(n2, n3));
        }

        void put(int n, int n2) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                throw new InvalidGlyphException("attempt to write CVT entry " + n + " (" + this.data.length + " actual entries)");
            }
            this.data[n] = n2;
        }

        int get(int n) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                return 0;
            }
            return this.data[n];
        }
    }

    private final class Stack {
        private final int[] data;
        private int currentDepth;

        public Stack(int n) {
            this.data = new int[n];
            this.currentDepth = 0;
        }

        public int pop() throws InvalidGlyphException {
            if (this.currentDepth == 0) {
                throw new InvalidGlyphException("pop on empty TT stack");
            }
            --this.currentDepth;
            return this.data[this.currentDepth];
        }

        public void push(int n) throws InvalidGlyphException {
            if (this.currentDepth > this.data.length) {
                throw new InvalidGlyphException("push on full TT stack");
            }
            this.data[this.currentDepth] = n;
            ++this.currentDepth;
        }

        public int peek(int n) {
            if (this.currentDepth - n < 0) {
                System.err.println("*** peek below stack bottom");
            }
            return this.data[this.currentDepth - n - 1];
        }

        public void clear() {
            this.currentDepth = 0;
        }

        public void copy(int n) throws InvalidGlyphException {
            if (n > this.currentDepth) {
                throw new InvalidGlyphException("index of non-existing TT stack element (" + n + ", currentDepth=" + this.currentDepth + ")");
            }
            this.push(this.data[this.currentDepth - n]);
        }

        public void pushDepth() throws InvalidGlyphException {
            this.push(this.currentDepth);
        }

        public void bubbleUp(int n) throws InvalidGlyphException {
            if (n > this.currentDepth) {
                throw new InvalidGlyphException("index of non-existing TT stack element (" + n + ", currentDepth=" + this.currentDepth + ")");
            }
            int n2 = this.data[this.currentDepth - n];
            for (int i = this.currentDepth - n; i < this.currentDepth - 1; ++i) {
                this.data[i] = this.data[i + 1];
            }
            this.data[this.currentDepth - 1] = n2;
        }
    }

    private final class StorageArea {
        private final int[] data;

        public StorageArea(int n) {
            this.data = new int[n];
        }

        public int getuint32(int n) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                throw new InvalidGlyphException("attempting to access TT storage area location " + n + " (must be in [" + 0 + ", " + this.data.length + "[)");
            }
            return this.data[n];
        }

        public void setuint32(int n, int n2) throws InvalidGlyphException {
            if (n < 0 || this.data.length <= n) {
                throw new InvalidGlyphException("attempting to access TT storage area location " + n + " (must be in [" + 0 + ", " + this.data.length + "[)");
            }
            this.data[n] = n2;
        }
    }

    private final class GraphicParameters {
        private GraphicParameters() {
        }

        int getEngineCompensation(int n) {
            return 0;
        }
    }

    private final class GraphicState {
        LocalGraphicState defaultGraphicState;
        LocalGraphicState localGraphicState;
        final int ROUND_TO_DOUBLE_GRID = 0;
        final int ROUND_TO_GRID = 1;
        final int ROUND_TO_HALF_GRID = 2;
        final int ROUND_OFF = 3;
        final int ROUND_DOWN_TO_GRID = 4;
        final int ROUND_UP_TO_GRID = 5;
        final int SUPER_ROUND = 6;
        final int SUPER_45_ROUND = 7;
        private F2Dot14Vector projectionVector = new F2Dot14Vector(0, 0);
        private F2Dot14Vector freedomVector = new F2Dot14Vector(0, 0);
        private F2Dot14Vector originalProjectionVector = new F2Dot14Vector(0, 0);
        private int fDotP;
        private F16Dot16Vector cvtStretch = new F16Dot16Vector();
        private ControlValueTable controlValueTable;
        private int cvtxN;
        private int cvtyN;
        private int cvtD;
        private double pixelsPerEm;
        private double pointSize;
        private int rp0;
        private int rp1;
        private int rp2;
        private int zp0;
        private int zp1;
        private int zp2;
        private int loopVariable;

        public GraphicState(int n, OTByteArray oTByteArray) throws InvalidFontException {
            this.cvtStretch.x = 65536;
            this.cvtStretch.y = 65536;
            this.controlValueTable = new ControlValueTable(n, oTByteArray);
            this.localGraphicState = new LocalGraphicState();
        }

        boolean getAutoFlip() {
            return this.localGraphicState.autoFlip;
        }

        void setAutoFlip(boolean bl) {
            this.localGraphicState.autoFlip = bl;
        }

        int getAngleWeight() {
            return this.localGraphicState.angleWeight;
        }

        void setAngleWeight(int n) {
            this.localGraphicState.angleWeight = n;
        }

        int getMinimumDistance() {
            return this.localGraphicState.minimumDistance;
        }

        void setMinimumDistance(int n) {
            this.localGraphicState.minimumDistance = n;
        }

        int getControlValueCutIn() {
            return this.localGraphicState.controlValueCutIn;
        }

        void setControlValueCutIn(int n) {
            this.localGraphicState.controlValueCutIn = n;
        }

        int snapToSingleWidth(int n) {
            if (this.localGraphicState.singleWidth - this.localGraphicState.singleWidthCutIn < n && n < this.localGraphicState.singleWidth + this.localGraphicState.singleWidthCutIn) {
                return this.localGraphicState.singleWidth;
            }
            if (-(this.localGraphicState.singleWidth + this.localGraphicState.singleWidthCutIn) < n && n < -(this.localGraphicState.singleWidth - this.localGraphicState.singleWidthCutIn)) {
                return -this.localGraphicState.singleWidth;
            }
            return n;
        }

        void setSingleWidthCutIn(int n) {
            this.localGraphicState.singleWidthCutIn = n;
        }

        void setSingleWidth(int n) {
            this.localGraphicState.singleWidth = n;
        }

        int getDeltaBase() {
            return this.localGraphicState.deltaBase;
        }

        void setDeltaBase(int n) {
            this.localGraphicState.deltaBase = n;
        }

        int getDeltaShift() {
            return this.localGraphicState.deltaShift;
        }

        void setDeltaShift(int n) {
            this.localGraphicState.deltaShift = n;
        }

        void setScanControl(int n) {
            this.localGraphicState.scanControl = n;
        }

        int getScanControl() {
            return this.localGraphicState.scanControl;
        }

        void setInstrControl(int n) {
            this.localGraphicState.instrControl = n;
        }

        int getInstrControl() {
            return this.localGraphicState.instrControl;
        }

        void setRoundMode(int n) {
            this.localGraphicState.roundMode = n;
        }

        void setRounding(int n, int n2, int n3, int n4) {
            this.localGraphicState.roundPeriod = n;
            this.localGraphicState.roundPhase = n2;
            this.localGraphicState.roundThreshold = n3;
            this.localGraphicState.roundMode = n4;
        }

        int round(int n, int n2) {
            return this.round(n, n2, this.localGraphicState.roundMode);
        }

        int roundOff(int n, int n2) {
            return this.round(n, n2, 3);
        }

        int roundToGrid(int n, int n2) {
            return this.round(n, n2, 1);
        }

        int round(int n, int n2, int n3) {
            boolean bl;
            int n4;
            if (n < 0) {
                n4 = -n;
                bl = true;
            } else {
                n4 = n;
                bl = false;
            }
            n4 += n2;
            switch (n3) {
                case 0: {
                    n4 += 16;
                    n4 &= 0xFFFFFFE0;
                    break;
                }
                case 1: {
                    n4 += 32;
                    n4 &= 0xFFFFFFC0;
                    break;
                }
                case 2: {
                    n4 &= 0xFFFFFFC0;
                    n4 += 32;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    n4 &= 0xFFFFFFC0;
                    break;
                }
                case 5: {
                    n4 += 63;
                    n4 &= 0xFFFFFFC0;
                    break;
                }
                case 6: {
                    n4 += this.localGraphicState.roundThreshold - this.localGraphicState.roundPhase;
                    n4 &= ~(this.localGraphicState.roundPeriod - 1);
                    n4 += this.localGraphicState.roundPhase;
                    break;
                }
                case 7: {
                    n4 = F26Dot6.divideByF2Dot14(n4, this.localGraphicState.roundPeriod);
                    n4 = F26Dot6.truncate(n4);
                    n4 = F26Dot6.multiplyByF2Dot14(n4, this.localGraphicState.roundPeriod);
                    n4 += this.localGraphicState.roundPhase;
                }
            }
            if (bl) {
                n4 = -n4;
            }
            if (!F26Dot6.sameSign(n4, n) && n != 0) {
                n4 = 0;
            }
            return n4;
        }

        void setVector(F2Dot14Vector f2Dot14Vector, F26Dot6Vector f26Dot6Vector, F26Dot6Vector f26Dot6Vector2, boolean bl) {
            int n = f26Dot6Vector2.x - f26Dot6Vector.x;
            int n2 = f26Dot6Vector2.y - f26Dot6Vector.y;
            if (n == 0 && n2 == 0) {
                this.setVector(f2Dot14Vector, 16384, 0, bl);
            } else {
                double d = F26Dot6.toDouble(n);
                double d2 = F26Dot6.toDouble(n2);
                double d3 = Math.sqrt(d * d + d2 * d2);
                this.setVector(f2Dot14Vector, F2Dot14.fromDouble(d / d3), F2Dot14.fromDouble(d2 / d3), bl);
            }
        }

        void setVector(F2Dot14Vector f2Dot14Vector, int n, int n2, boolean bl) {
            if (bl) {
                f2Dot14Vector.x = -n2;
                f2Dot14Vector.y = n;
            } else {
                f2Dot14Vector.x = n;
                f2Dot14Vector.y = n2;
            }
            if (f2Dot14Vector == this.projectionVector || f2Dot14Vector == this.freedomVector) {
                this.fDotP = F2Dot14.multiply(this.projectionVector.x, this.freedomVector.x) + F2Dot14.multiply(this.projectionVector.y, this.freedomVector.y);
                if (-1024 < this.fDotP && this.fDotP < 1024) {
                    this.fDotP = this.fDotP < 0 ? -16384 : 16384;
                }
            }
        }

        int project(F2Dot14Vector f2Dot14Vector, int n, int n2) {
            return F26Dot6.multiplyByF2Dot14(n, f2Dot14Vector.x) + F26Dot6.multiplyByF2Dot14(n2, f2Dot14Vector.y);
        }

        int project(F2Dot14Vector f2Dot14Vector, F26Dot6Vector f26Dot6Vector) {
            return this.project(f2Dot14Vector, f26Dot6Vector.x, f26Dot6Vector.y);
        }

        int project(F2Dot14Vector f2Dot14Vector, F26Dot6Vector f26Dot6Vector, F26Dot6Vector f26Dot6Vector2) {
            return this.project(f2Dot14Vector, f26Dot6Vector2.x - f26Dot6Vector.x, f26Dot6Vector2.y - f26Dot6Vector.y);
        }

        void resetAndScaleCVT() {
            this.controlValueTable.resetAndScale(this.cvtxN, this.cvtD);
        }

        int getCVTscale() {
            int n = F16Dot16.multiplyByF2Dot14(F16Dot16.square(this.cvtStretch.x), F2Dot14.square(this.projectionVector.x)) + F16Dot16.multiplyByF2Dot14(F16Dot16.square(this.cvtStretch.y), F2Dot14.square(this.projectionVector.y));
            if (n >= 65536) {
                return 65536;
            }
            return F16Dot16.fromDouble(Math.sqrt(F16Dot16.toDouble(n)));
        }

        int getCVT(int n) throws InvalidGlyphException {
            return F26Dot6.multiplyByF16Dot16(this.controlValueTable.get(n), this.getCVTscale());
        }

        void putCVT(int n, int n2) throws InvalidGlyphException {
            this.controlValueTable.put(n, F26Dot6.divideByF16Dot16(n2, this.getCVTscale()));
        }

        void putCVTPixels(int n, int n2) throws InvalidGlyphException {
            this.controlValueTable.put(n, F16Dot16.multiplyDivide(F26Dot6.fromDouble(n2), this.cvtxN, this.cvtD));
        }

        void incrementCVT(int n, int n2) throws InvalidGlyphException {
            this.controlValueTable.put(n, this.controlValueTable.get(n) + F26Dot6.divideByF16Dot16(n2, this.getCVTscale()));
        }

        int getPixelsPerEm() {
            return F26Dot6.toInt(F26Dot6.multiplyByF16Dot16(F26Dot6.fromDouble(this.pixelsPerEm), this.getCVTscale()));
        }

        void setPixelsPerEm(double d) {
            this.pixelsPerEm = d;
        }

        int getPointSize() {
            return F26Dot6.fromDouble(this.pointSize);
        }

        void setPointSize(double d) {
            this.pointSize = d;
        }

        void move(TTPoint tTPoint, int n) {
            if (this.fDotP != 16384) {
                if (this.freedomVector.x != 0) {
                    tTPoint.hinted.x = this.fDotP == this.freedomVector.x ? (tTPoint.hinted.x += n) : (tTPoint.hinted.x += F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n, this.freedomVector.x, this.fDotP));
                    tTPoint.touchedX = true;
                }
                if (this.freedomVector.y != 0) {
                    tTPoint.hinted.y = this.fDotP == this.freedomVector.y ? (tTPoint.hinted.y += n) : (tTPoint.hinted.y += F26Dot6.multiplyByF2Dot14DivideByF2Dot14(n, this.freedomVector.y, this.fDotP));
                    tTPoint.touchedY = true;
                }
            } else if (this.freedomVector.x == 16384) {
                tTPoint.hinted.x += n;
                tTPoint.touchedX = true;
            } else if (this.freedomVector.y == 16384) {
                tTPoint.hinted.y += n;
                tTPoint.touchedY = true;
            } else {
                if (this.freedomVector.x != 0) {
                    tTPoint.hinted.x += F26Dot6.multiplyByF2Dot14(n, this.freedomVector.x);
                    tTPoint.touchedX = true;
                }
                if (this.freedomVector.y != 0) {
                    tTPoint.hinted.y += F26Dot6.multiplyByF2Dot14(n, this.freedomVector.y);
                    tTPoint.touchedY = true;
                }
            }
        }

        void move(TTPoint tTPoint, int n, int n2) {
            if (this.freedomVector.x != 0) {
                tTPoint.hinted.x += n;
                tTPoint.touchedX = true;
            }
            if (this.freedomVector.y != 0) {
                tTPoint.hinted.y += n2;
                tTPoint.touchedY = true;
            }
        }

        void set(TTPoint tTPoint, int n, int n2) {
            tTPoint.hinted.x = n;
            tTPoint.touchedX = true;
            tTPoint.hinted.y = n2;
            tTPoint.touchedY = true;
        }

        void untouch(TTPoint tTPoint) {
            if (this.freedomVector.x != 0) {
                tTPoint.touchedX = false;
            }
            if (this.freedomVector.x != 0) {
                tTPoint.touchedY = false;
            }
        }

        void setRp0(int n) {
            this.rp0 = n;
        }

        int getRp0() {
            return this.rp0;
        }

        void setRp1(int n) {
            this.rp1 = n;
        }

        int getRp1() {
            return this.rp1;
        }

        void setRp2(int n) {
            this.rp2 = n;
        }

        int getRp2() {
            return this.rp2;
        }

        void setZp0(int n) {
            this.zp0 = n;
        }

        int getZp0() {
            return this.zp0;
        }

        void setZp1(int n) {
            this.zp1 = n;
        }

        int getZp1() {
            return this.zp1;
        }

        void setZp2(int n) {
            this.zp2 = n;
        }

        int getZp2() {
            return this.zp2;
        }

        void setLoopVariable(int n) {
            this.loopVariable = n;
        }

        int getAndResetLoopVariable() {
            int n = this.loopVariable;
            this.loopVariable = 1;
            return n;
        }
    }

    private final class LocalGraphicState
    implements Cloneable {
        private boolean autoFlip;
        private int angleWeight;
        private int minimumDistance;
        private int controlValueCutIn;
        private int singleWidthCutIn;
        private int singleWidth;
        private int deltaBase;
        private int deltaShift;
        private int scanControl;
        private int instrControl;
        private int roundMode;
        private int roundPeriod;
        private int roundPhase;
        private int roundThreshold;

        private LocalGraphicState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

