/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGRectElementBridge
extends SVGShapeElementBridge {
    public String getLocalName() {
        return "rect";
    }

    public Bridge getInstance() {
        return new SVGRectElementBridge();
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        String s = e.getAttributeNS(null, "x");
        float x = 0.0f;
        if (s.length() != 0) {
            x = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x", uctx);
        }
        s = e.getAttributeNS(null, "y");
        float y = 0.0f;
        if (s.length() != 0) {
            y = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y", uctx);
        }
        if ((s = e.getAttributeNS(null, "width")).length() == 0) {
            throw new BridgeException(e, "attribute.missing", new Object[]{"width", s});
        }
        float w = UnitProcessor.svgHorizontalLengthToUserSpace(s, "width", uctx);
        s = e.getAttributeNS(null, "height");
        if (s.length() == 0) {
            throw new BridgeException(e, "attribute.missing", new Object[]{"height", s});
        }
        float h = UnitProcessor.svgVerticalLengthToUserSpace(s, "height", uctx);
        s = e.getAttributeNS(null, "rx");
        boolean rxs = s.length() != 0;
        float rx = 0.0f;
        if (rxs) {
            rx = UnitProcessor.svgHorizontalLengthToUserSpace(s, "rx", uctx);
        }
        rx = rx > w / 2.0f ? w / 2.0f : rx;
        s = e.getAttributeNS(null, "ry");
        boolean rys = s.length() != 0;
        float ry = 0.0f;
        if (rys) {
            ry = UnitProcessor.svgVerticalLengthToUserSpace(s, "ry", uctx);
        }
        ry = ry > h / 2.0f ? h / 2.0f : ry;
        RectangularShape shape = null;
        shape = rxs && rys ? (rx == 0.0f || ry == 0.0f ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, rx * 2.0f, ry * 2.0f)) : (rxs ? (rx == 0.0f ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, rx * 2.0f, rx * 2.0f)) : (rys ? (ry == 0.0f ? new Rectangle2D.Float(x, y, w, h) : new RoundRectangle2D.Float(x, y, w, h, ry * 2.0f, ry * 2.0f)) : new Rectangle2D.Float(x, y, w, h)));
        shapeNode.setShape(shape);
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x") || attrName.equals("y") || attrName.equals("width") || attrName.equals("height") || attrName.equals("rx") || attrName.equals("ry")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }

    protected ShapePainter createShapePainter(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        Shape shape = shapeNode.getShape();
        Rectangle2D r2d = shape.getBounds2D();
        if (r2d.getWidth() == 0.0 || r2d.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(ctx, e, shapeNode);
    }
}

