/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.events;

import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.EventListenerList;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.HashTable;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;

public class EventSupport {
    protected HashTable capturingListeners;
    protected HashTable bubblingListeners;

    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        HashTable listeners;
        if (useCapture) {
            if (this.capturingListeners == null) {
                this.capturingListeners = new HashTable();
            }
            listeners = this.capturingListeners;
        } else {
            if (this.bubblingListeners == null) {
                this.bubblingListeners = new HashTable();
            }
            listeners = this.bubblingListeners;
        }
        EventListenerList list = (EventListenerList)listeners.get(type);
        if (list == null) {
            list = new EventListenerList();
            listeners.put(type, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        HashTable listeners = useCapture ? this.capturingListeners : this.bubblingListeners;
        if (listeners == null) {
            return;
        }
        EventListenerList list = (EventListenerList)listeners.get(type);
        if (list != null) {
            list.remove(listener);
            if (list.size() == 0) {
                listeners.remove(type);
            }
        }
    }

    public static boolean dispatchEvent(NodeEventTarget target, Event e) throws EventException {
        NodeEventTarget node;
        int i;
        AbstractEvent evt = (AbstractEvent)e;
        if (evt == null) {
            return false;
        }
        String type = evt.getType();
        if (type == null) {
            throw EventSupport.createUnspecifiedEventTypeErr("Event type can't be null");
        }
        evt.setTarget(target);
        evt.stopPropagation(false);
        evt.preventDefault(false);
        NodeEventTarget[] ancestors = EventSupport.getAncestors(target);
        evt.setEventPhase((short)1);
        for (i = 0; i < ancestors.length && !evt.getStopPropagation(); ++i) {
            node = ancestors[i];
            evt.setCurrentTarget(node);
            EventSupport.fireEventListeners(node, evt, true);
        }
        if (!evt.getStopPropagation()) {
            evt.setEventPhase((short)2);
            evt.setCurrentTarget(target);
            EventSupport.fireEventListeners(target, evt, false);
        }
        if (evt.getBubbles()) {
            evt.setEventPhase((short)3);
            for (i = ancestors.length - 1; i >= 0 && !evt.getStopPropagation(); --i) {
                node = ancestors[i];
                evt.setCurrentTarget(node);
                EventSupport.fireEventListeners(node, evt, false);
            }
        }
        return !evt.getPreventDefault();
    }

    private static void fireEventListeners(NodeEventTarget node, Event evt, boolean useCapture) {
        String type = evt.getType();
        EventSupport support = node.getEventSupport();
        if (support == null) {
            return;
        }
        EventListenerList list = support.getEventListeners(type, useCapture);
        if (list == null) {
            return;
        }
        EventListener[] listeners = list.getEventListeners();
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].handleEvent(evt);
                continue;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }

    private static NodeEventTarget[] getAncestors(NodeEventTarget node) {
        node = node.getParentNodeEventTarget();
        int nancestors = 0;
        NodeEventTarget n = node;
        while (n != null) {
            n = n.getParentNodeEventTarget();
            ++nancestors;
        }
        NodeEventTarget[] ancestors = new NodeEventTarget[nancestors];
        int i = nancestors - 1;
        while (i >= 0) {
            ancestors[i] = node;
            --i;
            node = node.getParentNodeEventTarget();
        }
        return ancestors;
    }

    public EventListenerList getEventListeners(String type, boolean useCapture) {
        HashTable listeners;
        HashTable hashTable = listeners = useCapture ? this.capturingListeners : this.bubblingListeners;
        if (listeners == null) {
            return null;
        }
        return (EventListenerList)listeners.get(type);
    }

    private static EventException createEventException(short code, String s) {
        return new EventException(code, s);
    }

    private static EventException createUnspecifiedEventTypeErr(String s) {
        return EventSupport.createEventException((short)0, s);
    }
}

