/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.LicenseException;
import flex2.compiler.PreLink;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.ConfigurationException;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Component;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcDirectoryArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.SwcMovie;
import flex2.compiler.swc.SwcWriteOnlyArchive;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import flex2.tools.API;
import flex2.tools.CompcPreLink;
import flex2.tools.Compiler;
import flex2.tools.ToolsConfiguration;
import flex2.tools.oem.Application;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.Logger;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.LibraryData;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.asc.util.ContextStatics;

public class Library
implements Builder {
    private Set sources = new TreeSet(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            VirtualFile f0 = (VirtualFile)arg0;
            VirtualFile f1 = (VirtualFile)arg1;
            return f0.getName().compareTo(f1.getName());
        }
    });
    private Set classes = new TreeSet();
    private Set namespaces = new TreeSet();
    private Set resourceBundles = new TreeSet();
    private Map files = new TreeMap();
    private Map stylesheets = new TreeMap();
    private OEMConfiguration configuration = null;
    private Logger logger = null;
    private File output = null;
    private File directory = null;
    private MimeMappings mimeMappings = new MimeMappings();
    private ProgressMeter meter = null;
    protected PathResolver resolver = null;
    private CompilerControl cc = new CompilerControl();
    LibraryData data = null;
    private String cacheName = null;
    private String configurationReport = null;
    private List messages = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addComponent(String includeClass) {
        this.classes.add(includeClass);
    }

    public void addComponent(File includeSource) {
        this.sources.add(new LocalFile(includeSource));
    }

    public void addComponent(VirtualLocalFile includeSource) {
        this.sources.add(includeSource);
    }

    public void addComponent(URI includeNamespace) {
        this.namespaces.add(includeNamespace);
    }

    public void removeComponent(String includeClass) {
        this.classes.remove(includeClass);
    }

    public void removeComponent(File includeSource) {
        this.sources.remove(new LocalFile(includeSource));
    }

    public void removeComponent(VirtualLocalFile includeSource) {
        this.sources.remove(includeSource);
    }

    public void removeComponent(URI includeNamespace) {
        this.namespaces.remove(includeNamespace);
    }

    public void removeAllComponents() {
        this.sources.clear();
        this.classes.clear();
        this.namespaces.clear();
    }

    public void addResourceBundle(String resourceBundle) {
        this.resourceBundles.add(resourceBundle);
    }

    public void removeResourceBundle(String resourceBundle) {
        this.resourceBundles.remove(resourceBundle);
    }

    public void removeAllResourceBundles() {
        this.resourceBundles.clear();
    }

    public void addArchiveFile(String name, File file) {
        this.files.put(name, new LocalFile(file));
    }

    public void addArchiveFile(String name, VirtualLocalFile file) {
        this.files.put(name, file);
    }

    public void removeArchiveFile(String name) {
        this.files.remove(name);
    }

    public void removeAllArchiveFiles() {
        this.files.clear();
    }

    public void addStyleSheet(String name, File file) {
        this.stylesheets.put(name, new LocalFile(file));
    }

    public void addStyleSheet(String name, VirtualLocalFile file) {
        this.stylesheets.put(name, file);
    }

    public void removeStyleSheet(String name) {
        this.stylesheets.remove(name);
    }

    public void removeAllStyleSheets() {
        this.stylesheets.clear();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = (OEMConfiguration)configuration;
    }

    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getLibraryConfiguration(this.constructCommandLine(null), false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getOutput() {
        return this.output;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long build(boolean incremental) throws IOException {
        if (this.output != null || this.directory != null) {
            Exception ex22;
            long l;
            OutputStream out;
            ByteArrayOutputStream tempOut;
            block21: {
                InputStream tempIn = null;
                tempOut = null;
                out = null;
                long size = 0L;
                try {
                    int result = this.compile(incremental);
                    if (result == 0 || result == Integer.MAX_VALUE || result == 1) {
                        if (this.output != null) {
                            tempOut = new ByteArrayOutputStream();
                        }
                        size = this.link(tempOut);
                        if (this.output != null) {
                            tempOut.flush();
                            if (size > 0L) {
                                tempIn = new ByteArrayInputStream(tempOut.toByteArray());
                                out = new BufferedOutputStream(new FileOutputStream(this.output));
                                FileUtil.streamOutput((InputStream)tempIn, (OutputStream)out);
                            }
                        }
                    }
                    l = size;
                    Object var11_8 = null;
                    if (tempIn == null) break block21;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var11_9 = null;
                    if (tempIn != null) {
                        try {
                            tempIn.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    if (tempOut != null) {
                        try {
                            tempOut.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    tempIn.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            if (tempOut != null) {
                try {
                    tempOut.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
            }
            return l;
        }
        return 0L;
    }

    public long build(OutputStream out, boolean incremental) throws IOException {
        int result = this.compile(incremental);
        if (result == 1 || result == Integer.MAX_VALUE) {
            return this.link(out);
        }
        if (result == 0) {
            return this.link(out);
        }
        return 0L;
    }

    private int recompile(boolean fullRecompile) {
        VirtualFile[] includeLibs;
        OEMConfiguration c = this.configuration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getLibraryConfiguration(this.constructCommandLine(this.configuration), this.configuration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
        if (c == null) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.configuration != null && this.configuration.keepConfigurationReport()) {
            this.configurationReport = OEMUtil.formatConfigurationBuffer(c.cfgbuf);
        }
        if (this.configuration != null) {
            this.configuration.cfgbuf = c.cfgbuf;
        }
        this.cc.run();
        OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
        VirtualFile[] virtualFileArray = includeLibs = c.configuration == null ? null : c.configuration.getCompilerConfiguration().getIncludeLibraries();
        if (this.sources.size() == 0 && this.classes.size() == 0 && this.namespaces.size() == 0 && this.resourceBundles.size() == 0 && this.files.size() == 0 && this.stylesheets.size() == 0 && (includeLibs == null || includeLibs.length == 0)) {
            ThreadLocalToolkit.log((ILocalizableMessage)new ConfigurationException.NoSwcInputs(null, null, -1));
            this.clean(false, false, false);
            return -1;
        }
        Map licenseMap = OEMUtil.getLicenseMap(c.configuration);
        this.data = new LibraryData();
        this.data.configuration = c.configuration;
        this.data.cacheName = this.cacheName;
        flex2.compiler.API.setupHeadless((flex2.compiler.common.Configuration)c.configuration);
        NameMappings mappings = flex2.compiler.API.getNameMappings((flex2.compiler.common.Configuration)c.configuration);
        NameMappings copy = mappings.copy();
        CompilerConfiguration compilerConfig = c.configuration.getCompilerConfiguration();
        compilerConfig.setMetadataExport(true);
        if (this.output != null || this.directory != null) {
            OEMUtil.setGeneratedDirectory(compilerConfig, this.output != null ? this.output : this.directory);
        }
        Transcoder[] transcoders = API.getTranscoders((flex2.compiler.common.Configuration)c.configuration);
        flex2.compiler.Compiler[] compilers = API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
        this.data.fileSet = this.processSources();
        if (this.data.fileSet == null) {
            this.clean(true, false, false);
            return -1;
        }
        this.data.fileSet.addAll(this.processStylesheets());
        if (!this.setupSourceContainers((flex2.compiler.common.Configuration)c.configuration, this.data.fileSet)) {
            this.clean(true, false, false);
            return -1;
        }
        this.data.swcCache = new SwcCache();
        CompilerSwcContext swcContext = new CompilerSwcContext(true, true, compilerConfig.getCompatibilityVersionString());
        try {
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false);
            return -1;
        }
        this.data.includes = new HashSet(swcContext.getIncludes());
        this.data.excludes = new HashSet(swcContext.getExterns());
        c.configuration.addExterns((Collection)swcContext.getExterns());
        c.configuration.addIncludes((Collection)swcContext.getIncludes());
        this.data.swcArchiveFiles = new HashMap(swcContext.getIncludeFiles());
        this.data.cmdChecksum = c.cfgbuf.checksum_ts();
        this.data.linkChecksum = c.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        int[] checksums = new int[]{0, this.data.cmdChecksum, this.data.linkChecksum, this.data.swcChecksum};
        if (!fullRecompile) {
            if (!this.loadCompilationUnits(c.configuration, this.data.fileSet, swcContext, checksums)) {
                this.clean(true, false, false);
                return -1;
            }
            this.data.checksum = checksums[0];
            if (this.data.units != null && this.data.units.size() > 0 && OEMUtil.isRecompilationNeeded(this.data, swcContext, c) && !this.setupSourceContainers((flex2.compiler.common.Configuration)c.configuration, this.data.fileSet)) {
                this.clean(true, false, false);
                return -1;
            }
        }
        int count = flex2.compiler.API.validateCompilationUnits((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceBundlePath)this.data.bundlePath, (ResourceContainer)this.data.resources, (CompilerSwcContext)swcContext, null, (boolean)false, (flex2.compiler.common.Configuration)c.configuration);
        SymbolTable symbolTable = SymbolTable.newSymbolTable((flex2.compiler.common.Configuration)c.configuration);
        this.data.perCompileData = symbolTable.perCompileData;
        TreeMap classes = new TreeMap();
        this.data.nsComponents = this.processInputs(swcContext, copy, classes);
        if (this.data.nsComponents == null) {
            this.clean(true, false, false);
            return -1;
        }
        this.data.sources = new ArrayList();
        this.data.units = this.compile(compilers, swcContext, symbolTable, licenseMap, classes, this.data.sources, c);
        this.data.checksum = OEMUtil.calculateChecksum(this.data, swcContext, c);
        boolean forcedToStop = flex2.compiler.API.forcedToStop();
        if (this.data.units == null || forcedToStop) {
            this.clean(true, false, false);
            return -1;
        }
        this.clean(false, false, false);
        return 1;
    }

    public void stop() {
        this.cc.stop();
    }

    public void clean() {
        this.clean(true, true, true, true, true);
    }

    public void load(InputStream in) throws IOException {
        this.cacheName = OEMUtil.load(in, this.cacheName);
        this.clean(true, false, false);
    }

    public long save(OutputStream out) throws IOException {
        return OEMUtil.save(out, this.cacheName, this.data);
    }

    public Report getReport() {
        OEMUtil.setupLocalizationManager();
        return new OEMReport(this.data == null ? null : this.data.sources, this.data == null ? null : this.data.movie, this.data == null ? null : this.data.configuration, this.configurationReport, this.messages);
    }

    private String[] constructCommandLine(OEMConfiguration c) {
        return c != null ? c.getCompilerOptions() : new String[]{};
    }

    private Set processInputs(CompilerSwcContext swcContext, NameMappings mappings, Map classes) {
        try {
            Set nsComponents = this.processNamespaces(mappings, classes);
            if (nsComponents == null) {
                return null;
            }
            if (!this.processClasses(classes)) {
                return null;
            }
            return nsComponents;
        }
        catch (SwcException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private boolean processClasses(Map classes) {
        try {
            flex2.compiler.swc.API.setupClasses(new ArrayList(this.classes), (SourcePath)this.data.sourcePath, (Map)classes);
            return true;
        }
        catch (CompilerException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
            return false;
        }
    }

    private Set processNamespaces(NameMappings mappings, Map classes) {
        TreeSet nsComponents;
        block3: {
            nsComponents = null;
            try {
                List list = flex2.compiler.swc.API.setupNamespaceComponents((List)this.toStrings(this.namespaces), (NameMappings)mappings, (SourcePath)this.data.sourcePath, (Map)classes);
                nsComponents = new TreeSet(new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        Component c0 = (Component)arg0;
                        Component c1 = (Component)arg1;
                        return c0.getClassName().compareTo(c1.getClassName());
                    }
                });
                nsComponents.addAll(list);
            }
            catch (ConfigurationException ex) {
                Compiler.processConfigurationException((ConfigurationException)ex, (String)"oem");
            }
            catch (CompilerException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block3;
                throw new AssertionError();
            }
        }
        return nsComponents;
    }

    private List toStrings(Set set) {
        ArrayList<String> a = new ArrayList<String>(set.size());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            URI uri = (URI)i.next();
            a.add(uri.toString());
        }
        return a;
    }

    private boolean setupSourceContainers(flex2.compiler.common.Configuration configuration, Set fileSet) {
        boolean result;
        block6: {
            CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
            VirtualFile[] asClasspath = compilerConfig.getSourcePath();
            result = false;
            try {
                this.data.sourcePath = new SourcePath(API.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
                this.data.sourcePath.addPathElements(asClasspath);
                List[] array = flex2.compiler.API.getVirtualFileList((Set)fileSet, (List)this.data.sourcePath.getPaths());
                this.data.fileSpec = new FileSpec(array[0], API.getFileSpecMimeTypes(), false);
                this.data.sourceList = new SourceList(array[1], asClasspath, null, API.getSourceListMimeTypes(), false);
                this.data.resources = new ResourceContainer();
                this.data.bundlePath = new ResourceBundlePath(compilerConfig, null);
                if (this.data.sources != null) {
                    this.data.sources.clear();
                }
                if (this.data.units != null) {
                    this.data.units.clear();
                }
                if (this.data.swcDefSignatureChecksums != null) {
                    this.data.swcDefSignatureChecksums.clear();
                }
                if (this.data.swcFileChecksums != null) {
                    this.data.swcFileChecksums.clear();
                }
                result = true;
            }
            catch (CompilerException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block6;
                throw new AssertionError();
            }
        }
        return result;
    }

    private Set processSources() {
        TreeSet fileSet;
        block2: {
            fileSet = null;
            try {
                List fileList = flex2.compiler.API.getVirtualFileList(new ArrayList(this.sources), new HashSet<String>(Arrays.asList(API.getSourcePathMimeTypes())));
                fileSet = new TreeSet(new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        VirtualFile f0 = (VirtualFile)arg0;
                        VirtualFile f1 = (VirtualFile)arg1;
                        return f0.getName().compareTo(f1.getName());
                    }
                });
                fileSet.addAll(fileList);
            }
            catch (ConfigurationException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block2;
                throw new AssertionError();
            }
        }
        return fileSet;
    }

    private Set processStylesheets() {
        TreeSet fileSet;
        block2: {
            fileSet = null;
            try {
                List fileList = flex2.compiler.API.getVirtualFileList(new ArrayList(this.stylesheets.values()), new HashSet<String>(Arrays.asList("text/css")));
                fileSet = new TreeSet(new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        VirtualFile f0 = (VirtualFile)arg0;
                        VirtualFile f1 = (VirtualFile)arg1;
                        return f0.getName().compareTo(f1.getName());
                    }
                });
                fileSet.addAll(fileList);
            }
            catch (ConfigurationException ex) {
                if ($assertionsDisabled || ThreadLocalToolkit.errorCount() > 0) break block2;
                throw new AssertionError();
            }
        }
        return fileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadCompilationUnits(ToolsConfiguration configuration, Set fileSet, CompilerSwcContext swcContext, int[] checksums) {
        if (this.data.cacheName == null) {
            return true;
        }
        RandomAccessFile cacheFile = null;
        cacheFile = new RandomAccessFile(this.data.cacheName, "r");
        this.data.sources = new ArrayList();
        this.data.units = new ArrayList();
        this.data.swcDefSignatureChecksums = new HashMap();
        this.data.swcFileChecksums = new HashMap();
        flex2.compiler.API.loadCompilationUnits((flex2.compiler.common.Configuration)configuration, (FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, this.data.sources, this.data.units, (int[])checksums, this.data.swcDefSignatureChecksums, this.data.swcFileChecksums, (RandomAccessFile)cacheFile, (String)this.data.cacheName);
        Object var9_6 = null;
        if (cacheFile == null) return true;
        try {
            cacheFile.close();
            return true;
        }
        catch (IOException ex2) {}
        return true;
        {
            catch (FileNotFoundException ex) {
                ThreadLocalToolkit.logInfo((String)ex.getMessage());
                boolean bl = true;
                Object var9_7 = null;
                if (cacheFile == null) return bl;
                try {
                    cacheFile.close();
                    return bl;
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException ex) {
                block14: {
                    boolean bl;
                    try {
                        ThreadLocalToolkit.logInfo((String)ex.getMessage());
                        if (this.setupSourceContainers((flex2.compiler.common.Configuration)configuration, fileSet)) break block14;
                        bl = false;
                        Object var9_8 = null;
                        if (cacheFile == null) return bl;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (cacheFile == null) throw throwable;
                        try {
                            cacheFile.close();
                            throw throwable;
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        cacheFile.close();
                        return bl;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return bl;
                }
                Object var9_9 = null;
                if (cacheFile == null) return true;
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
        }
    }

    protected int compile(boolean incremental) {
        VirtualFile[] includeLibs;
        this.messages.clear();
        if (this.data == null || !incremental) {
            return this.recompile(false);
        }
        OEMConfiguration c = this.configuration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getLibraryConfiguration(this.constructCommandLine(this.configuration), this.configuration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
        if (c == null) {
            this.clean(false, false, false);
            return -1;
        }
        if (this.configuration != null && this.configuration.keepConfigurationReport()) {
            this.configurationReport = OEMUtil.formatConfigurationBuffer(c.cfgbuf);
        }
        if (this.configuration != null) {
            this.configuration.cfgbuf = c.cfgbuf;
        }
        this.cc.run();
        OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
        VirtualFile[] virtualFileArray = includeLibs = c.configuration == null ? null : c.configuration.getCompilerConfiguration().getIncludeLibraries();
        if (this.sources.size() == 0 && this.classes.size() == 0 && this.namespaces.size() == 0 && this.resourceBundles.size() == 0 && this.files.size() == 0 && this.stylesheets.size() == 0 && (includeLibs == null || includeLibs.length == 0)) {
            ThreadLocalToolkit.log((ILocalizableMessage)new ConfigurationException.NoSwcInputs(null, null, -1));
            this.clean(false, false, false);
            return -1;
        }
        Map licenseMap = OEMUtil.getLicenseMap(c.configuration);
        flex2.compiler.API.setupHeadless((flex2.compiler.common.Configuration)c.configuration);
        NameMappings mappings = flex2.compiler.API.getNameMappings((flex2.compiler.common.Configuration)c.configuration);
        NameMappings copy = mappings.copy();
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        CompilerConfiguration compilerConfig = c.configuration.getCompilerConfiguration();
        compilerConfig.setMetadataExport(true);
        if (this.output != null || this.directory != null) {
            OEMUtil.setGeneratedDirectory(compilerConfig, this.output != null ? this.output : this.directory);
        }
        Transcoder[] transcoders = API.getTranscoders((flex2.compiler.common.Configuration)c.configuration);
        flex2.compiler.Compiler[] compilers = API.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
        CompilerSwcContext swcContext = new CompilerSwcContext(false, true, compilerConfig.getCompatibilityVersionString());
        try {
            swcContext.load(compilerConfig.getLibraryPath(), compilerConfig.getExternalLibraryPath(), null, compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false);
            return -1;
        }
        this.data.includes = new HashSet(swcContext.getIncludes());
        this.data.excludes = new HashSet(swcContext.getExterns());
        c.configuration.addExterns((Collection)swcContext.getExterns());
        c.configuration.addIncludes((Collection)swcContext.getIncludes());
        this.data.swcArchiveFiles = new HashMap(swcContext.getIncludeFiles());
        int count = flex2.compiler.API.validateCompilationUnits((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceBundlePath)this.data.bundlePath, (ResourceContainer)this.data.resources, (CompilerSwcContext)swcContext, (ContextStatics)this.data.perCompileData, (boolean)false, (flex2.compiler.common.Configuration)c.configuration);
        if (OEMUtil.isRecompilationNeeded(this.data, swcContext, c)) {
            this.clean(true, false, false);
            return this.recompile(true);
        }
        Set fileSet = null;
        fileSet = this.processSources();
        if (fileSet == null) {
            this.clean(false, false, false);
            return -1;
        }
        fileSet.addAll(this.processStylesheets());
        boolean isFileSpecDifferent = this.isDifferent(this.data.fileSet, fileSet);
        if (isFileSpecDifferent) {
            this.clean(true, false, false);
            return this.recompile(true);
        }
        TreeMap classes = new TreeMap();
        Set nsComponents = null;
        nsComponents = this.processInputs(swcContext, copy, classes);
        if (nsComponents == null) {
            this.clean(false, false, false);
            return -1;
        }
        boolean isDifferent = this.isDifferent(this.data.classes, classes.keySet());
        if (count > 0 || isDifferent || this.isResourceBundleListDifferent() || this.data.swcChecksum != swcContext.checksum()) {
            SymbolTable symbolTable = new SymbolTable(this.data.perCompileData);
            this.data.configuration = c.configuration;
            this.data.nsComponents = nsComponents;
            this.data.classes = classes.keySet();
            this.data.fileSet = fileSet;
            this.data.linkChecksum = c.cfgbuf.link_checksum_ts();
            this.data.swcChecksum = swcContext.checksum();
            this.data.sources = new ArrayList();
            this.data.units = this.compile(compilers, swcContext, symbolTable, licenseMap, classes, this.data.sources, c);
            boolean forcedToStop = flex2.compiler.API.forcedToStop();
            if (this.data.units == null || forcedToStop) {
                this.clean(true, false, false);
                return -1;
            }
            this.clean(false, false, false);
            return 1;
        }
        int retVal = 0;
        if (this.data != null) {
            flex2.compiler.API.displayWarnings((List)this.data.units);
            if (this.data.linkChecksum != c.cfgbuf.link_checksum_ts()) {
                retVal = Integer.MAX_VALUE;
            }
        } else {
            retVal = Integer.MAX_VALUE;
        }
        this.data.linkChecksum = c.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        if (flex2.compiler.API.forcedToStop()) {
            retVal = -1;
        }
        if (retVal == Integer.MAX_VALUE) {
            this.clean(false, false, false, false, false);
        } else {
            this.clean(false, false, false);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List compile(flex2.compiler.Compiler[] compilers, CompilerSwcContext swcContext, SymbolTable symbolTable, Map licenseMap, Map classes, List sources, OEMConfiguration oemConfig) {
        List units = null;
        HashMap rbFiles = new HashMap();
        try {
            try {
                units = flex2.compiler.API.compile((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, classes.values(), (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (flex2.compiler.common.Configuration)this.data.configuration, (flex2.compiler.Compiler[])compilers, (PreLink)new CompcPreLink(rbFiles, new ArrayList(this.resourceBundles)), (Map)licenseMap, (List)sources);
            }
            catch (LicenseException ex) {
                ThreadLocalToolkit.logError((String)ex.getMessage());
                Object var12_11 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                this.data.classes = classes.keySet();
                this.data.rbFiles = rbFiles;
                Map m = this.data.configuration.getCSSArchiveFiles();
                if (m != null) {
                    this.data.cssArchiveFiles = new HashMap(m);
                }
                if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                    this.data.l10nArchiveFiles = new HashMap(m);
                }
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                return units;
            }
            catch (CompilerException ex) {
                if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                    throw new AssertionError();
                }
                Object var12_12 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                this.data.classes = classes.keySet();
                this.data.rbFiles = rbFiles;
                Map m = this.data.configuration.getCSSArchiveFiles();
                if (m != null) {
                    this.data.cssArchiveFiles = new HashMap(m);
                }
                if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                    this.data.l10nArchiveFiles = new HashMap(m);
                }
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                return units;
            }
            catch (SwcException ex) {
                if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                    throw new AssertionError();
                }
                Object var12_13 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                this.data.classes = classes.keySet();
                this.data.rbFiles = rbFiles;
                Map m = this.data.configuration.getCSSArchiveFiles();
                if (m != null) {
                    this.data.cssArchiveFiles = new HashMap(m);
                }
                if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                    this.data.l10nArchiveFiles = new HashMap(m);
                }
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                return units;
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            this.data.classes = classes.keySet();
            this.data.rbFiles = rbFiles;
            Map m = this.data.configuration.getCSSArchiveFiles();
            if (m != null) {
                this.data.cssArchiveFiles = new HashMap(m);
            }
            if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
                this.data.l10nArchiveFiles = new HashMap(m);
            }
            OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
            OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
            throw throwable;
        }
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        this.data.classes = classes.keySet();
        this.data.rbFiles = rbFiles;
        Map m = this.data.configuration.getCSSArchiveFiles();
        if (m != null) {
            this.data.cssArchiveFiles = new HashMap(m);
        }
        if ((m = this.data.configuration.getL10NArchiveFiles()) != null) {
            this.data.l10nArchiveFiles = new HashMap(m);
        }
        OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
        OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long link(OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null) {
            return 0L;
        }
        boolean hasChanged = this.configuration == null ? false : this.configuration.hasChanged();
        OEMConfiguration c = null;
        flex2.compiler.common.Configuration config = null;
        if (hasChanged) {
            c = OEMUtil.getLinkerConfiguration(this.configuration.getLinkerOptions(), this.configuration.keepLinkReport(), OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.resolver, this.data.configuration, this.configuration.newLinkerOptionsAfterCompile, this.data.includes, this.data.excludes);
            if (c == null) {
                this.clean(false, false, false, false, false);
                return 0L;
            }
            config = c.configuration;
        } else {
            config = this.data.configuration;
        }
        try {
            OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
            SimpleMovie temp = this.data.movie;
            this.data.movie = flex2.compiler.swc.API.link((flex2.linker.Configuration)config, (List)this.data.units);
            SwcDirectoryArchive archive = null;
            TreeMap archiveFiles = new TreeMap();
            if (this.data.swcArchiveFiles != null) {
                archiveFiles.putAll(this.data.swcArchiveFiles);
            }
            if (this.data.cssArchiveFiles != null) {
                archiveFiles.putAll(this.data.cssArchiveFiles);
            }
            if (this.data.l10nArchiveFiles != null) {
                archiveFiles.putAll(this.data.l10nArchiveFiles);
            }
            archiveFiles.putAll(this.files);
            if (this.directory != null) {
                archive = new SwcDirectoryArchive(FileUtil.getCanonicalPath((File)this.directory));
                flex2.compiler.swc.API.exportSwc((SwcArchive)archive, archiveFiles, (Map)this.stylesheets, (flex2.linker.Configuration)config, (SwcMovie)((SwcMovie)this.data.movie), new ArrayList(this.data.nsComponents), (SwcCache)this.data.swcCache, (Map)this.data.rbFiles);
            }
            long size = 0L;
            if (out != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                archive = new SwcWriteOnlyArchive("oem", (OutputStream)baos);
                flex2.compiler.swc.API.exportSwc((SwcArchive)archive, archiveFiles, (Map)this.stylesheets, (flex2.linker.Configuration)config, (SwcMovie)((SwcMovie)this.data.movie), new ArrayList(this.data.nsComponents), (SwcCache)this.data.swcCache, (Map)this.data.rbFiles);
                ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
                FileUtil.streamOutput((InputStream)in, (OutputStream)out);
                size = baos.size();
            }
            if (hasChanged && temp != null) {
                this.data.movie = temp;
            }
            long l = size;
            return l;
        }
        catch (LinkerException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
            long l = 0L;
            return l;
        }
        catch (SwcException ex) {
            if (!$assertionsDisabled && ThreadLocalToolkit.errorCount() <= 0) {
                throw new AssertionError();
            }
            long l = 0L;
            return l;
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            ThreadLocalToolkit.logError((String)ex.getMessage());
            long l = 0L;
            return l;
        }
        finally {
            this.clean(false, false, false, true, false);
        }
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput) {
        this.clean(cleanData, cleanCache, cleanOutput, true, false);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages) {
        OEMUtil.clean();
        if (this.configuration != null && cleanConfig) {
            this.configuration.reset();
        }
        if (cleanData) {
            this.data = null;
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile((String)this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    private boolean isDifferent(Collection s1, Collection s2) {
        Iterator i = s2.iterator();
        while (i.hasNext()) {
            if (s1.contains(i.next())) continue;
            return true;
        }
        return s1.size() > s2.size();
    }

    private boolean isResourceBundleListDifferent() {
        int size1 = this.data == null || this.data.rbFiles == null ? 0 : this.data.rbFiles.size();
        int size2 = this.resourceBundles == null ? 0 : this.resourceBundles.size();
        return size1 != size2;
    }

    static {
        $assertionsDisabled = !Library.class.desiredAssertionStatus();
        Class clazz = Application.class;
    }
}

