/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem;

import flash.fonts.FontManager;
import flash.swf.Movie;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.FileSpec;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.ResourceContainer;
import flex2.compiler.Source;
import flex2.compiler.SourceList;
import flex2.compiler.SourcePath;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.extensions.ExtensionManager;
import flex2.compiler.extensions.IApplicationExtension;
import flex2.compiler.i18n.I18nUtils;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.Benchmark;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.PerformanceData;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.linker.ConsoleApplication;
import flex2.linker.FlexMovie;
import flex2.linker.LinkerAPI;
import flex2.linker.LinkerConfiguration;
import flex2.linker.LinkerException;
import flex2.linker.SimpleMovie;
import flex2.tools.Mxmlc;
import flex2.tools.PostLink;
import flex2.tools.PreLink;
import flex2.tools.ToolsConfiguration;
import flex2.tools.WebTierAPI;
import flex2.tools.oem.ApplicationCache;
import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.LibraryCache;
import flex2.tools.oem.Logger;
import flex2.tools.oem.Message;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.Report;
import flex2.tools.oem.VirtualLocalFile;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import flex2.tools.oem.internal.ApplicationData;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMReport;
import flex2.tools.oem.internal.OEMUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ContextStatics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
implements Builder {
    private List<VirtualFile> files;
    private OEMConfiguration oemConfiguration;
    private Logger logger;
    private File output;
    private MimeMappings mimeMappings;
    private ProgressMeter meter;
    protected PathResolver resolver;
    private CompilerControl cc;
    private boolean isGeneratedTargetFile;
    private ApplicationCache applicationCache;
    private LibraryCache libraryCache;
    private ApplicationData data;
    private String cacheName;
    private String configurationReport;
    private List<Message> messages;
    private HashMap<String, PerformanceData[]> compilerBenchmarks;
    private Benchmark benchmark;

    public Application(File file) throws FileNotFoundException {
        this(file, null);
    }

    public Application(File file, LibraryCache libraryCache) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(FileUtil.getCanonicalPath((File)file));
        }
        this.init(new VirtualFile[]{new LocalFile(FileUtil.getCanonicalFile((File)file))});
        this.libraryCache = libraryCache;
    }

    public Application(VirtualLocalFile file) {
        this.init(new VirtualFile[]{file});
    }

    public Application(VirtualLocalFile[] files) {
        this.init(files);
    }

    public Application() {
        this.init(new VirtualFile[0]);
    }

    private void init(VirtualFile[] files) {
        this.files = new ArrayList<VirtualFile>(files.length);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            this.files.add(files[i]);
        }
        this.oemConfiguration = null;
        this.logger = null;
        this.output = null;
        this.mimeMappings = new MimeMappings();
        this.meter = null;
        this.resolver = null;
        this.cc = new CompilerControl();
        this.isGeneratedTargetFile = false;
        this.data = null;
        this.cacheName = null;
        this.configurationReport = null;
        this.messages = new ArrayList<Message>();
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.oemConfiguration = (OEMConfiguration)configuration;
    }

    @Override
    public Configuration getDefaultConfiguration() {
        return this.getDefaultConfiguration(false);
    }

    private Configuration getDefaultConfiguration(boolean processDefaults) {
        return OEMUtil.getApplicationConfiguration(this.constructCommandLine(null), false, false, OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings, processDefaults);
    }

    @Override
    public Map<String, PerformanceData[]> getCompilerBenchmarks() {
        return this.compilerBenchmarks;
    }

    @Override
    public Benchmark getBenchmark() {
        return this.benchmark;
    }

    @Override
    public Configuration getConfiguration() {
        return this.oemConfiguration;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @Override
    public File getOutput() {
        return this.output;
    }

    @Override
    public void setSupportedFileExtensions(String mimeType, String[] extensions) {
        this.mimeMappings.set(mimeType, extensions);
    }

    @Override
    public void setProgressMeter(ProgressMeter meter) {
        this.meter = meter;
    }

    @Override
    public void setPathResolver(PathResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long build(boolean incremental) throws IOException {
        if (this.output != null) {
            Exception ex222222;
            long l;
            OutputStream out;
            ByteArrayOutputStream tempOut;
            InputStream tempIn;
            block29: {
                tempIn = null;
                tempOut = null;
                out = null;
                long size = 0L;
                int result = this.compile(incremental);
                if (result == 0 || result == Integer.MAX_VALUE || result == 1) {
                    tempOut = new ByteArrayOutputStream();
                    size = result == 1 || result == Integer.MAX_VALUE ? this.link(tempOut) : this.encode(tempOut);
                    tempOut.flush();
                    if (size > 0L) {
                        tempIn = new ByteArrayInputStream(tempOut.toByteArray());
                        out = new BufferedOutputStream(new FileOutputStream(this.output));
                        FileUtil.streamOutput((InputStream)tempIn, (OutputStream)out);
                    }
                }
                l = size;
                Object var11_10 = null;
                if (tempIn == null) break block29;
                try {
                    tempIn.close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (tempOut != null) {
                try {
                    tempOut.close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                this.benchmark.stopTime("postcompile", false);
            }
            this.runExtensions();
            this.clean(false, false, false, true, false, true);
            return l;
            catch (Throwable t) {
                Exception ex222222;
                long l2;
                block32: {
                    try {
                        ThreadLocalToolkit.logError((String)t.getLocalizedMessage());
                        l2 = 0L;
                        Object var11_11 = null;
                        if (tempIn == null) break block32;
                    }
                    catch (Throwable throwable) {
                        Exception ex222222;
                        Object var11_12 = null;
                        if (tempIn != null) {
                            try {
                                tempIn.close();
                            }
                            catch (Exception ex222222) {
                                // empty catch block
                            }
                        }
                        if (tempOut != null) {
                            try {
                                tempOut.close();
                            }
                            catch (Exception ex222222) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception ex222222) {
                                // empty catch block
                            }
                        }
                        if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                            this.benchmark.stopTime("postcompile", false);
                        }
                        this.runExtensions();
                        this.clean(false, false, false, true, false, true);
                        throw throwable;
                    }
                    try {
                        tempIn.close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (tempOut != null) {
                    try {
                        tempOut.close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                    this.benchmark.stopTime("postcompile", false);
                }
                this.runExtensions();
                this.clean(false, false, false, true, false, true);
                return l2;
            }
        }
        return 0L;
    }

    private void runExtensions() {
        if (this.oemConfiguration != null) {
            Set extensions = ExtensionManager.getApplicationExtensions(this.oemConfiguration.getExtensions());
            for (IApplicationExtension extension : extensions) {
                if (ThreadLocalToolkit.errorCount() != 0) continue;
                extension.run((Configuration)this.oemConfiguration.clone());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long build(OutputStream out, boolean incremental) throws IOException {
        block9: {
            int result;
            block8: {
                long l;
                try {
                    result = this.compile(incremental);
                    if (result != 1 && result != Integer.MAX_VALUE) break block8;
                    this.runExtensions();
                    l = this.link(out);
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                        this.benchmark.stopTime("postcompile", false);
                    }
                    this.clean(false, false, false, true, false, true);
                    throw throwable;
                }
                if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                    this.benchmark.stopTime("postcompile", false);
                }
                this.clean(false, false, false, true, false, true);
                return l;
            }
            if (result != 0) break block9;
            this.runExtensions();
            long l = this.encode(out);
            Object var7_8 = null;
            if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
                this.benchmark.stopTime("postcompile", false);
            }
            this.clean(false, false, false, true, false, true);
            return l;
        }
        long l = 0L;
        Object var7_9 = null;
        if (this.benchmark != null && this.benchmark.hasStarted("postcompile")) {
            this.benchmark.stopTime("postcompile", false);
        }
        this.clean(false, false, false, true, false, true);
        return l;
    }

    @Override
    public void stop() {
        this.cc.stop();
    }

    @Override
    public void clean() {
        this.clean(true, true, true, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(InputStream in) throws IOException {
        try {
            this.cacheName = OEMUtil.load(in, this.cacheName);
            Object var3_2 = null;
            this.clean(true, false, false, true, false, true);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clean(true, false, false, true, false, true);
            throw throwable;
        }
    }

    @Override
    public long save(OutputStream out) throws IOException {
        return OEMUtil.save(out, this.cacheName, this.data);
    }

    @Override
    public Report getReport() {
        OEMUtil.setupLocalizationManager();
        return new OEMReport(this.data == null ? null : this.data.sources, this.data == null ? null : this.data.movie, this.data == null ? null : this.data.configuration, this.data == null ? null : this.data.sourceList, this.configurationReport, this.messages);
    }

    private void setupFontManager(OEMConfiguration localOEMConfiguration) {
        if (localOEMConfiguration != null && this.data != null) {
            FontsConfiguration fontsConfiguration = localOEMConfiguration.configuration.getCompilerConfiguration().getFontsConfiguration();
            fontsConfiguration.setTopLevelManager(this.data.fontManager);
        }
    }

    private boolean setupSourceContainers(OEMConfiguration localOEMConfiguration) {
        ToolsConfiguration configuration = localOEMConfiguration.configuration;
        CompilerConfiguration compilerConfig = configuration.getCompilerConfiguration();
        VirtualFile[] asClasspath = compilerConfig.getSourcePath();
        boolean result = false;
        try {
            if (this.files.size() == 0) {
                ApplicationCompilerConfiguration acc = (ApplicationCompilerConfiguration)localOEMConfiguration.configuration;
                this.files.add(CompilerAPI.getVirtualFile((String)acc.getTargetFile(), (boolean)true));
                this.isGeneratedTargetFile = true;
            } else if (this.isGeneratedTargetFile) {
                I18nUtils.regenerateResourceModule((ApplicationCompilerConfiguration)((ApplicationCompilerConfiguration)localOEMConfiguration.configuration));
            }
            VirtualFile targetFile = this.files.get(this.files.size() - 1);
            WebTierAPI.checkSupportedTargetMimeType((VirtualFile)targetFile);
            this.data.fileSpec = new FileSpec(Collections.emptyList(), WebTierAPI.getFileSpecMimeTypes());
            this.data.sourceList = new SourceList(this.files, asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes());
            this.data.sourcePath = new SourcePath(asClasspath, targetFile, WebTierAPI.getSourcePathMimeTypes(), compilerConfig.allowSourcePathOverlap());
            this.data.resources = new ResourceContainer();
            if (this.applicationCache != null) {
                if (this.applicationCache.isConsistent((flex2.compiler.common.Configuration)localOEMConfiguration.configuration)) {
                    this.data.resources.setApplicationCache(this.applicationCache);
                    this.data.sourceList.applyApplicationCache(this.applicationCache);
                    this.data.sourcePath.setApplicationCache(this.applicationCache);
                } else {
                    this.applicationCache.clear();
                }
            }
            this.data.bundlePath = new ResourceBundlePath(compilerConfig, targetFile);
            if (this.data.sources != null) {
                this.data.sources.clear();
            }
            if (this.data.units != null) {
                this.data.units.clear();
            }
            if (this.data.swcDefSignatureChecksums != null) {
                this.data.swcDefSignatureChecksums.clear();
            }
            if (this.data.swcFileChecksums != null) {
                this.data.swcFileChecksums.clear();
            }
            result = true;
        }
        catch (CompilerException ex) {
            assert (ThreadLocalToolkit.errorCount() > 0);
        }
        catch (ConfigurationException e) {
            ThreadLocalToolkit.logInfo((String)e.getMessage());
        }
        return result;
    }

    private boolean loadCachedSources(Map<String, Source> sources) {
        boolean relink = false;
        for (Map.Entry<String, Source> entry : sources.entrySet()) {
            String className = entry.getKey();
            Source source = entry.getValue();
            Source cachedSource = this.applicationCache.getSource(className);
            if (cachedSource == null || cachedSource.isUpdated()) continue;
            CompilationUnit compilationUnit = source.getCompilationUnit();
            VirtualFile pathRoot = source.getPathRoot();
            CompilationUnit cachedCompilationUnit = cachedSource.getCompilationUnit();
            VirtualFile cachedSourcePathRoot = cachedSource.getPathRoot();
            if ((pathRoot != null || cachedSourcePathRoot != null) && (pathRoot == null || !pathRoot.equals(cachedSource.getPathRoot())) || compilationUnit == null || compilationUnit.hasTypeInfo || cachedCompilationUnit == null || !cachedCompilationUnit.hasTypeInfo) continue;
            Source.copyCompilationUnit((CompilationUnit)cachedCompilationUnit, (CompilationUnit)compilationUnit, (boolean)true);
            source.setFileTime(cachedSource.getFileTime());
            source.reused();
            relink = true;
        }
        return relink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadCompilationUnits(OEMConfiguration localOEMConfiguration, CompilerSwcContext swcContext, int[] checksums) {
        ToolsConfiguration configuration = localOEMConfiguration.configuration;
        if (this.data.cacheName == null) {
            return true;
        }
        RandomAccessFile cacheFile = null;
        cacheFile = new RandomAccessFile(this.data.cacheName, "r");
        this.data.sources = new ArrayList<Source>();
        this.data.units = new ArrayList<CompilationUnit>();
        this.data.swcDefSignatureChecksums = new HashMap<QName, Long>();
        this.data.swcFileChecksums = new HashMap<String, Long>();
        CompilerAPI.loadCompilationUnits((flex2.compiler.common.Configuration)configuration, (FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, this.data.sources, this.data.units, (int[])checksums, this.data.swcDefSignatureChecksums, this.data.swcFileChecksums, (RandomAccessFile)cacheFile, (String)this.data.cacheName, (FontManager)this.data.fontManager);
        Object var9_6 = null;
        if (cacheFile == null) return true;
        try {
            cacheFile.close();
            return true;
        }
        catch (IOException ex2) {}
        return true;
        {
            catch (FileNotFoundException ex) {
                ThreadLocalToolkit.logInfo((String)ex.getMessage());
                Object var9_7 = null;
                if (cacheFile == null) return true;
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
            catch (IOException ex) {
                ThreadLocalToolkit.logInfo((String)ex.getMessage());
                if (!this.setupSourceContainers(localOEMConfiguration)) {
                    boolean bl = false;
                    Object var9_8 = null;
                    if (cacheFile == null) return bl;
                    try {
                        cacheFile.close();
                        return bl;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return bl;
                }
                try {
                    Object var9_9 = null;
                    if (cacheFile == null) return true;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (cacheFile == null) throw throwable;
                    try {
                        cacheFile.close();
                        throw throwable;
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    cacheFile.close();
                    return true;
                }
                catch (IOException ex2) {}
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compile(boolean incremental) {
        boolean relink;
        CompilerSwcContext swcContext;
        OEMConfiguration tempOEMConfiguration;
        block34: {
            SubCompiler[] compilers;
            NameMappings mappings;
            Map licenseMap;
            block33: {
                block32: {
                    String compilationType;
                    block31: {
                        int n;
                        try {
                            this.messages.clear();
                            tempOEMConfiguration = this.oemConfiguration == null ? (OEMConfiguration)this.getDefaultConfiguration(true) : OEMUtil.getApplicationConfiguration(this.constructCommandLine(this.oemConfiguration), this.oemConfiguration.keepLinkReport(), this.oemConfiguration.keepSizeReport(), OEMUtil.getLogger(this.logger, this.messages), this.resolver, this.mimeMappings);
                            if (tempOEMConfiguration != null) break block31;
                            this.clean(false, false, false, true, false, false);
                            n = -1;
                            Object var15_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var15_11 = null;
                            OEMUtil.clean();
                            throw throwable;
                        }
                        OEMUtil.clean();
                        return n;
                    }
                    if (this.oemConfiguration != null && this.oemConfiguration.keepConfigurationReport()) {
                        this.configurationReport = OEMUtil.formatConfigurationBuffer(tempOEMConfiguration.cfgbuf);
                    }
                    this.setupFontManager(tempOEMConfiguration);
                    if (this.oemConfiguration != null) {
                        this.oemConfiguration.cfgbuf = tempOEMConfiguration.cfgbuf;
                    }
                    if (tempOEMConfiguration.configuration.benchmark()) {
                        this.benchmark = CompilerAPI.runBenchmark();
                        this.benchmark.setTimeFilter(tempOEMConfiguration.configuration.getBenchmarkTimeFilter());
                        this.benchmark.startTime("precompile");
                    } else {
                        CompilerAPI.disableBenchmark();
                    }
                    this.cc.run();
                    OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
                    licenseMap = OEMUtil.getLicenseMap(tempOEMConfiguration.configuration);
                    if (this.data != null && incremental) break block32;
                    String string = compilationType = this.cacheName != null ? "inactive" : "full";
                    if (this.benchmark != null) {
                        this.benchmark.benchmark2("Starting " + compilationType + " compile for " + this.getOutput(), true);
                    }
                    int returnValue = this.recompile(false, licenseMap, tempOEMConfiguration);
                    if (this.benchmark != null) {
                        this.benchmark.benchmark2("Ending " + compilationType + " compile for " + this.getOutput(), true);
                    }
                    this.clean(returnValue == -1, false, false, true, false, false);
                    int n = returnValue;
                    Object var15_6 = null;
                    OEMUtil.clean();
                    return n;
                }
                CompilerAPI.setupHeadless((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
                CompilerConfiguration compilerConfig = tempOEMConfiguration.configuration.getCompilerConfiguration();
                mappings = CompilerAPI.getNameMappings((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
                Transcoder[] transcoders = WebTierAPI.getTranscoders((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
                compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
                swcContext = new CompilerSwcContext(true);
                try {
                    swcContext.load(compilerConfig.getLibraryPath(), flex2.compiler.common.Configuration.getAllExcludedLibraries((CompilerConfiguration)compilerConfig, (flex2.compiler.common.Configuration)tempOEMConfiguration.configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), this.data.swcCache);
                }
                catch (SwcException ex) {
                    this.clean(false, false, false, true, false, false);
                    int n = -1;
                    Object var15_7 = null;
                    OEMUtil.clean();
                    return n;
                }
                if (this.libraryCache != null) {
                    this.libraryCache.setSwcCache(this.data.swcCache);
                }
                this.data.includes = new HashSet<String>(swcContext.getIncludes());
                this.data.excludes = new HashSet<String>(swcContext.getExterns());
                tempOEMConfiguration.configuration.addExterns((Collection)swcContext.getExterns());
                tempOEMConfiguration.configuration.addIncludes((Collection)swcContext.getIncludes());
                tempOEMConfiguration.configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
                if (!OEMUtil.isRecompilationNeeded(this.data, swcContext, tempOEMConfiguration)) break block33;
                this.data.resources = new ResourceContainer();
                if (this.benchmark != null) {
                    this.benchmark.benchmark2("Starting full compile for " + this.getOutput(), true);
                }
                this.clean(true, false, false, true, false, false);
                int returnValue = this.recompile(true, licenseMap, tempOEMConfiguration);
                if (this.benchmark != null) {
                    this.benchmark.benchmark2("Ending full compile for " + this.getOutput(), true);
                }
                this.clean(returnValue == -1, false, false, true, false, false);
                int n = returnValue;
                Object var15_8 = null;
                OEMUtil.clean();
                return n;
            }
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Starting active compile for " + this.getOutput(), true);
            }
            relink = false;
            if (this.applicationCache != null) {
                ContextStatics contextStatics;
                this.data.perCompileData = contextStatics = this.applicationCache.getContextStatics();
                if (this.applicationCache.isConsistent((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration)) {
                    relink = this.loadCachedSources(this.data.resources.sources()) || this.loadCachedSources(this.data.sourceList.sources()) || this.loadCachedSources(this.data.sourcePath.sources());
                } else {
                    this.applicationCache.clear();
                }
            }
            this.data.perCompileData.userDefined.clear();
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            int count = CompilerAPI.validateCompilationUnits((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceBundlePath)this.data.bundlePath, (ResourceContainer)this.data.resources, (CompilerSwcContext)swcContext, (ContextStatics)this.data.perCompileData, (flex2.compiler.common.Configuration)tempOEMConfiguration.configuration);
            if (count <= 0 && this.data.swcChecksum == swcContext.checksum()) break block34;
            this.data.configuration = tempOEMConfiguration.configuration;
            this.data.linkChecksum = tempOEMConfiguration.cfgbuf.link_checksum_ts();
            this.data.swcChecksum = swcContext.checksum();
            SymbolTable symbolTable = new SymbolTable((flex2.compiler.common.Configuration)tempOEMConfiguration.configuration, this.data.perCompileData);
            this.data.sources = new ArrayList<Source>();
            this.data.units = this.compile(compilers, swcContext, symbolTable, mappings, licenseMap, this.data.sources);
            boolean forcedToStop = CompilerAPI.forcedToStop();
            if (this.data.units == null || forcedToStop) {
                this.data.sources = null;
            }
            if (this.benchmark != null) {
                this.benchmark.benchmark2("Ending active compile for " + this.getOutput(), true);
            }
            this.clean(false, false, false, true, false, false);
            int n = this.data.units != null && !forcedToStop ? 1 : -1;
            Object var15_9 = null;
            OEMUtil.clean();
            return n;
        }
        if (this.benchmark != null) {
            this.benchmark.stopTime("precompile", false);
            this.benchmark.startTime("postcompile");
        }
        int retVal = 0;
        if (this.data != null) {
            CompilerAPI.displayWarnings(this.data.units);
            if (this.data.linkChecksum != tempOEMConfiguration.cfgbuf.link_checksum_ts() || relink) {
                retVal = Integer.MAX_VALUE;
            }
        } else {
            retVal = Integer.MAX_VALUE;
        }
        this.data.linkChecksum = tempOEMConfiguration.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        if (this.benchmark != null) {
            this.benchmark.benchmark2("Ending active compile for " + this.getOutput(), true);
        }
        if (CompilerAPI.forcedToStop()) {
            retVal = -1;
        }
        if (retVal != Integer.MAX_VALUE) {
            this.clean(false, false, false, true, false, false);
        }
        int n = retVal;
        Object var15_10 = null;
        OEMUtil.clean();
        return n;
    }

    private int recompile(boolean fullRecompile, Map licenseMap, OEMConfiguration localOEMConfiguration) {
        SymbolTable symbolTable;
        ContextStatics contextStatics;
        this.data = new ApplicationData();
        this.data.configuration = localOEMConfiguration.configuration;
        this.data.cacheName = this.cacheName;
        CompilerAPI.setupHeadless((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        CompilerConfiguration compilerConfig = localOEMConfiguration.configuration.getCompilerConfiguration();
        NameMappings mappings = CompilerAPI.getNameMappings((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        this.data.fontManager = compilerConfig.getFontsConfiguration().getTopLevelManager();
        if (this.output != null) {
            OEMUtil.setGeneratedDirectory(compilerConfig, this.output);
        }
        Transcoder[] transcoders = WebTierAPI.getTranscoders((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        SubCompiler[] compilers = WebTierAPI.getCompilers((CompilerConfiguration)compilerConfig, (NameMappings)mappings, (Transcoder[])transcoders);
        if (!this.setupSourceContainers(localOEMConfiguration)) {
            this.clean(true, false, false, true, false, false);
            return -1;
        }
        if (this.libraryCache != null && (contextStatics = this.libraryCache.getContextStatics()) != null) {
            contextStatics.userDefined.clear();
            this.data.swcCache = this.libraryCache.getSwcCache();
            this.data.perCompileData = contextStatics;
        }
        if (this.data.swcCache == null) {
            this.data.swcCache = new SwcCache();
        }
        CompilerSwcContext swcContext = new CompilerSwcContext(true);
        try {
            swcContext.load(compilerConfig.getLibraryPath(), flex2.compiler.common.Configuration.getAllExcludedLibraries((CompilerConfiguration)compilerConfig, (flex2.compiler.common.Configuration)localOEMConfiguration.configuration), compilerConfig.getThemeFiles(), compilerConfig.getIncludeLibraries(), mappings, I18nUtils.getTranslationFormat((CompilerConfiguration)compilerConfig), this.data.swcCache);
        }
        catch (SwcException ex) {
            this.clean(false, false, false, true, false, false);
            return -1;
        }
        if (this.libraryCache != null) {
            this.libraryCache.setSwcCache(this.data.swcCache);
        }
        this.data.includes = new HashSet<String>(swcContext.getIncludes());
        this.data.excludes = new HashSet<String>(swcContext.getExterns());
        localOEMConfiguration.configuration.addExterns((Collection)swcContext.getExterns());
        localOEMConfiguration.configuration.addIncludes((Collection)swcContext.getIncludes());
        localOEMConfiguration.configuration.getCompilerConfiguration().addThemeCssFiles(swcContext.getThemeStyleSheets());
        this.data.cmdChecksum = localOEMConfiguration.cfgbuf.checksum_ts();
        this.data.linkChecksum = localOEMConfiguration.cfgbuf.link_checksum_ts();
        this.data.swcChecksum = swcContext.checksum();
        int[] checksums = new int[]{0, this.data.cmdChecksum, this.data.linkChecksum, this.data.swcChecksum};
        boolean relink = false;
        if (!fullRecompile) {
            ContextStatics contextStatics2;
            if (!this.loadCompilationUnits(localOEMConfiguration, swcContext, checksums)) {
                this.clean(true, false, false, true, false, false);
                return -1;
            }
            this.data.checksum = checksums[0];
            if (this.data.units != null && this.data.units.size() > 0 && OEMUtil.isRecompilationNeeded(this.data, swcContext, localOEMConfiguration) && !this.setupSourceContainers(localOEMConfiguration)) {
                this.clean(true, false, false, true, false, false);
                return -1;
            }
            if (this.applicationCache != null && (contextStatics2 = this.applicationCache.getContextStatics()) != null) {
                contextStatics2.userDefined.clear();
                this.data.perCompileData = contextStatics2;
                if (this.applicationCache.isConsistent((flex2.compiler.common.Configuration)localOEMConfiguration.configuration)) {
                    relink = this.loadCachedSources(this.data.resources.sources()) || this.loadCachedSources(this.data.sourceList.sources()) || this.loadCachedSources(this.data.sourcePath.sources());
                } else {
                    this.applicationCache.clear();
                }
            }
        }
        int count = CompilerAPI.validateCompilationUnits((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, (SourcePath)this.data.sourcePath, (ResourceBundlePath)this.data.bundlePath, (ResourceContainer)this.data.resources, (CompilerSwcContext)swcContext, (ContextStatics)this.data.perCompileData, (flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
        if (this.data.perCompileData != null) {
            symbolTable = new SymbolTable((flex2.compiler.common.Configuration)localOEMConfiguration.configuration, this.data.perCompileData);
        } else {
            symbolTable = new SymbolTable((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
            this.data.perCompileData = symbolTable.perCompileData;
        }
        if (this.applicationCache != null) {
            this.applicationCache.setConfiguration((flex2.compiler.common.Configuration)localOEMConfiguration.configuration);
            this.applicationCache.setContextStatics(this.data.perCompileData);
        }
        if (this.libraryCache != null) {
            this.libraryCache.setContextStatics(this.data.perCompileData);
        }
        this.data.sources = new ArrayList<Source>();
        this.data.units = this.compile(compilers, swcContext, symbolTable, mappings, licenseMap, this.data.sources);
        this.data.checksum = OEMUtil.calculateChecksum(this.data, swcContext, localOEMConfiguration);
        int result = 1;
        if (this.data.units == null || CompilerAPI.forcedToStop()) {
            result = -1;
        } else if (count == 0 && relink) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CompilationUnit> compile(SubCompiler[] compilers, CompilerSwcContext swcContext, SymbolTable symbolTable, NameMappings nameMappings, Map licenseMap, List<Source> sources) {
        List units = null;
        try {
            try {
                if (this.benchmark != null) {
                    for (int i = 0; i < compilers.length; ++i) {
                        compilers[i].initBenchmarks();
                    }
                }
                ApplicationCompilerConfiguration config = (ApplicationCompilerConfiguration)this.data.configuration;
                VirtualFile projector = config.getProjector();
                if (this.benchmark != null) {
                    this.benchmark.stopTime("precompile", false);
                }
                units = projector != null && projector.getName().endsWith("avmplus.exe") ? CompilerAPI.compile((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, null, (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)nameMappings, (flex2.compiler.common.Configuration)this.data.configuration, (SubCompiler[])compilers, null, (Map)licenseMap, sources) : CompilerAPI.compile((FileSpec)this.data.fileSpec, (SourceList)this.data.sourceList, null, (SourcePath)this.data.sourcePath, (ResourceContainer)this.data.resources, (ResourceBundlePath)this.data.bundlePath, (CompilerSwcContext)swcContext, (SymbolTable)symbolTable, (NameMappings)nameMappings, (flex2.compiler.common.Configuration)this.data.configuration, (SubCompiler[])compilers, (flex2.compiler.PreLink)new PreLink(), (Map)licenseMap, sources);
                if (this.applicationCache != null) {
                    this.data.resources.refresh();
                    this.applicationCache.addSources(this.data.resources.sources());
                    this.applicationCache.addSources(this.data.sourceList.sources());
                    this.applicationCache.addSources(this.data.sourcePath.sources());
                }
                if (this.benchmark != null) {
                    this.benchmark.startTime("postcompile");
                }
                if (this.benchmark != null && ThreadLocalToolkit.getLogger() != null) {
                    if (this.compilerBenchmarks == null) {
                        this.compilerBenchmarks = new HashMap();
                    }
                    this.compilerBenchmarks.clear();
                    flex2.compiler.Logger logger = ThreadLocalToolkit.getLogger();
                    for (int i = 0; i < compilers.length; ++i) {
                        String compilerName;
                        SubCompiler compiler = compilers[i];
                        PerformanceData[] times = compiler.getBenchmarks();
                        if (times != null) {
                            compiler.logBenchmarks(logger);
                            compilerName = compiler.getName();
                            assert (!this.compilerBenchmarks.containsKey(compilerName));
                            this.compilerBenchmarks.put(compilerName, times);
                        }
                        if ((times = compiler.getEmbeddedBenchmarks()) == null) continue;
                        compiler.logBenchmarks(logger);
                        compilerName = compiler.getName();
                        compilerName = compilerName + "_emb";
                        assert (!this.compilerBenchmarks.containsKey(compilerName));
                        this.compilerBenchmarks.put(compilerName, times);
                    }
                }
                Object var16_17 = null;
            }
            catch (CompilerException ex) {
                assert (ThreadLocalToolkit.errorCount() > 0);
                Object var16_18 = null;
                this.data.sourcePath.clearCache();
                this.data.bundlePath.clearCache();
                this.data.resources.refresh();
                OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
                OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
                swcContext.close();
                return units;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.data.sourcePath.clearCache();
            this.data.bundlePath.clearCache();
            this.data.resources.refresh();
            OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
            OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
            swcContext.close();
            throw throwable;
        }
        this.data.sourcePath.clearCache();
        this.data.bundlePath.clearCache();
        this.data.resources.refresh();
        OEMUtil.saveSwcFileChecksums(swcContext, this.data, this.data.configuration);
        OEMUtil.saveSignatureChecksums(units, this.data, this.data.configuration);
        swcContext.close();
        return units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long link(OutputStream out) throws IOException {
        if (this.data == null) return 0L;
        if (this.data.units == null) {
            return 0L;
        }
        boolean hasChanged = this.oemConfiguration == null ? false : this.oemConfiguration.hasChanged();
        flex2.compiler.common.Configuration config = null;
        if (hasChanged) {
            OEMConfiguration tempOEMConfiguration = OEMUtil.getLinkerConfiguration(this.oemConfiguration.getLinkerOptions(), this.oemConfiguration.keepLinkReport(), this.oemConfiguration.keepSizeReport(), OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.resolver, this.data.configuration, this.oemConfiguration.newLinkerOptionsAfterCompile, this.data.includes, this.data.excludes);
            if (tempOEMConfiguration == null) {
                this.clean(false, false, false, false, false, true);
                return 0L;
            }
            config = tempOEMConfiguration.configuration;
        } else {
            config = this.data.configuration;
        }
        long size = 0L;
        try {
            block14: {
                try {
                    OEMUtil.init(OEMUtil.getLogger(this.logger, this.messages), this.mimeMappings, this.meter, this.resolver, this.cc);
                    ApplicationCompilerConfiguration appConfig = (ApplicationCompilerConfiguration)this.data.configuration;
                    VirtualFile projector = appConfig.getProjector();
                    PostLink postLink = null;
                    if (config.optimize() && !config.debug()) {
                        postLink = new PostLink((LinkerConfiguration)config);
                    }
                    if (projector != null && projector.getName().endsWith("avmplus.exe")) {
                        ConsoleApplication temp = this.data.app;
                        this.data.app = LinkerAPI.linkConsole(this.data.units, (flex2.linker.PostLink)postLink, (flex2.compiler.common.Configuration)config);
                        size = this.encodeConsoleProjector(projector, out);
                        if (hasChanged && temp != null) {
                            this.data.app = temp;
                        }
                        break block14;
                    }
                    SimpleMovie temp = this.data.movie;
                    this.data.movie = (FlexMovie)LinkerAPI.link(this.data.units, (flex2.linker.PostLink)postLink, (flex2.compiler.common.Configuration)config);
                    long l = size = projector == null ? this.encode(out) : this.encodeProjector(projector, out);
                    if (!hasChanged || temp == null) break block14;
                    this.data.movie = temp;
                }
                catch (LinkerException ex) {
                    assert (ThreadLocalToolkit.errorCount() > 0);
                    Object var11_14 = null;
                    OEMUtil.clean();
                    return size;
                }
                catch (Throwable t) {
                    if (Trace.error) {
                        t.printStackTrace();
                    }
                    ThreadLocalToolkit.logError((String)t.getLocalizedMessage());
                    Object var11_15 = null;
                    OEMUtil.clean();
                    return size;
                }
            }
            Object var11_13 = null;
            OEMUtil.clean();
            return size;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            OEMUtil.clean();
            throw throwable;
        }
    }

    private long encode(OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.movie == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompilerAPI.encode((flex2.compiler.common.Configuration)this.data.configuration, (Movie)this.data.movie, (OutputStream)baos);
        long size = baos.size();
        baos.writeTo(out);
        out.flush();
        return size;
    }

    private long encodeProjector(VirtualFile projector, OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.movie == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompilerAPI.encode((flex2.compiler.common.Configuration)this.data.configuration, (Movie)this.data.movie, (OutputStream)baos);
        return Mxmlc.createProjector((flex2.compiler.common.Configuration)this.data.configuration, (VirtualFile)projector, (ByteArrayOutputStream)baos, (OutputStream)out);
    }

    private long encodeConsoleProjector(VirtualFile projector, OutputStream out) throws IOException {
        if (this.data == null || this.data.units == null || this.data.app == null) {
            return 0L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CompilerAPI.encode((ConsoleApplication)this.data.app, (OutputStream)baos);
        return Mxmlc.createProjector((flex2.compiler.common.Configuration)this.data.configuration, (VirtualFile)projector, (ByteArrayOutputStream)baos, (OutputStream)out);
    }

    private void clean(boolean cleanData, boolean cleanCache, boolean cleanOutput, boolean cleanConfig, boolean cleanMessages, boolean cleanThreadLocals) {
        if (cleanThreadLocals) {
            OEMUtil.clean();
        }
        if (this.oemConfiguration != null && cleanConfig) {
            this.oemConfiguration.reset();
        }
        if (cleanData) {
            this.data = null;
            this.configurationReport = null;
        }
        if (cleanCache && this.cacheName != null) {
            File dead = FileUtil.openFile((String)this.cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            this.cacheName = null;
        }
        if (cleanOutput && this.output != null && this.output.exists()) {
            this.output.delete();
        }
        if (cleanMessages) {
            this.messages.clear();
        }
    }

    private String[] constructCommandLine(OEMConfiguration localOEMConfiguration) {
        String[] options = localOEMConfiguration != null ? localOEMConfiguration.getCompilerOptions() : new String[]{};
        String[] args = new String[options.length + this.files.size() + 1];
        System.arraycopy(options, 0, args, 0, options.length);
        args[options.length] = "--file-specs";
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            args[options.length + 1 + i] = this.files.get(i).getName();
        }
        return args;
    }

    public ApplicationCache getApplicationCache() {
        return this.applicationCache;
    }

    @Override
    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }

    public LibraryCache getSwcCache() {
        return this.libraryCache;
    }

    @Override
    public void setSwcCache(LibraryCache libraryCache) {
        this.libraryCache = libraryCache;
    }

    static {
        int len;
        File[] list = null;
        try {
            File tempDir = File.createTempFile("Flex2_", "").getParentFile();
            list = tempDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith("Flex2_");
                }
            });
        }
        catch (Throwable e) {
            // empty catch block
        }
        int n = len = list == null ? 0 : list.length;
        for (int i = 0; i < len; ++i) {
            try {
                list[i].delete();
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        URL url = Application.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File f = new File(new URI(url.toExternalForm()));
            if (f.getAbsolutePath().endsWith("flex-compiler-oem.jar")) {
                String applicationHome = f.getParentFile().getParent();
                System.setProperty("application.home", applicationHome);
            }
        }
        catch (URISyntaxException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

