/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.genext;

import flash.swf.tools.as3.EvaluatorAdapter;
import flash.util.FileUtils;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.Compiler;
import flex2.compiler.as3.binding.ClassInfo;
import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.as3.genext.GenerativeClassInfo;
import flex2.compiler.as3.genext.PositionResetEvaluator;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.util.ObjectList;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public abstract class GenerativeSecondPassEvaluator
extends EvaluatorAdapter {
    protected final CompilationUnit unit;
    protected final String generatedOutputDirectory;
    protected final Map classMap;
    protected final Set evaluatedClasses;
    protected final TypeAnalyzer typeAnalyzer;
    protected final MetaDataEvaluator metaDataEvaluator;

    public GenerativeSecondPassEvaluator(CompilationUnit unit, Map classMap, TypeAnalyzer typeAnalyzer, String generatedOutputDirectory) {
        this.unit = unit;
        this.classMap = classMap;
        this.typeAnalyzer = typeAnalyzer;
        this.generatedOutputDirectory = generatedOutputDirectory;
        this.evaluatedClasses = new HashSet();
        this.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
        this.metaDataEvaluator = new MetaDataEvaluator();
    }

    protected boolean checkForExistingMethods(macromedia.asc.util.Context context, ClassDefinitionNode node, ClassInfo classInfo, InterfaceInfo interfaceInfo) {
        boolean result = false;
        List functionNames = interfaceInfo.getFunctionNames();
        if (functionNames != null) {
            Iterator iterator = functionNames.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                String functionName = qName.getLocalPart();
                if (functionName.equals("$construct") || !classInfo.definesFunction(functionName, true)) continue;
                context.localizedError2(node.pos(), (Object)new ExistingMethodError(interfaceInfo.getInterfaceName(), node.name.name, functionName));
                result = true;
            }
        }
        return result;
    }

    protected void registerRenamedAccessor(GenerativeClassInfo.AccessorInfo info) {
        HashMap<String, String> renamedVariableMap = (HashMap<String, String>)this.unit.getContext().getAttribute("RenamedVariableMap");
        if (renamedVariableMap == null) {
            renamedVariableMap = new HashMap<String, String>();
            this.unit.getContext().setAttribute("RenamedVariableMap", renamedVariableMap);
        }
        renamedVariableMap.put(info.getBackingPropertyName(), info.getPropertyName());
    }

    protected static void hideVariable(VariableDefinitionNode variableDefinition, GenerativeClassInfo.AccessorInfo info) {
        VariableBindingNode variableBindingNode = NodeMagic.getVariableBinding(variableDefinition);
        NodeMagic.setVariableBindingName(variableBindingNode, info.getBackingPropertyName());
        GenerativeSecondPassEvaluator.makeAttrListPrivate((DefinitionNode)variableDefinition);
    }

    protected static void hideFunction(FunctionDefinitionNode functionDefinition, GenerativeClassInfo.AccessorInfo info) {
        NodeMagic.prefixFunctionName(functionDefinition, info.getBackingPrefix());
        GenerativeSecondPassEvaluator.makeAttrListPrivate((DefinitionNode)functionDefinition);
    }

    protected static boolean isIdentifier(IdentifierNode identifier, String attribute) {
        boolean result = false;
        if (identifier != null) {
            result = identifier.name.equals(attribute);
        }
        return result;
    }

    private static void makeAttrListPrivate(DefinitionNode def) {
        if (def.attrs != null) {
            Iterator iterator = def.attrs.items.iterator();
            while (iterator.hasNext()) {
                Object node = iterator.next();
                IdentifierNode identifier = null;
                if (node instanceof MemberExpressionNode) {
                    identifier = NodeMagic.getIdentifier((MemberExpressionNode)node);
                    if (GenerativeSecondPassEvaluator.isIdentifier(identifier, "override")) {
                        iterator.remove();
                        continue;
                    }
                    GenerativeSecondPassEvaluator.ensureNonPublic(identifier);
                    continue;
                }
                if (!(node instanceof ListNode)) continue;
                ListNode list = (ListNode)node;
                Iterator listIterator = list.items.iterator();
                while (listIterator.hasNext()) {
                    Object listNode = listIterator.next();
                    if (!(listNode instanceof MemberExpressionNode)) continue;
                    identifier = NodeMagic.getIdentifier((MemberExpressionNode)listNode);
                    if (GenerativeSecondPassEvaluator.isIdentifier(identifier, "override")) {
                        iterator.remove();
                        continue;
                    }
                    GenerativeSecondPassEvaluator.ensureNonPublic(identifier);
                }
            }
        }
    }

    protected static void ensureNonPublic(IdentifierNode identifier) {
        if (GenerativeSecondPassEvaluator.isIdentifier(identifier, "public")) {
            identifier.name = "private";
        }
    }

    protected abstract String getTemplateName();

    protected abstract String getTemplatePath();

    protected abstract Map getTemplateVars();

    protected abstract String getGeneratedSuffix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected ProgramNode generateSupportCode(macromedia.asc.util.Context context, String className) {
        block21: {
            programNode = null;
            templateName = this.getTemplateName();
            templateVars = this.getTemplateVars();
            suffix = this.getGeneratedSuffix();
            template = null;
            try {
                template = VelocityManager.getTemplate(this.getTemplatePath() + templateName + ".vm");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (template != null) {
                try {
                    block20: {
                        stringWriter = new StringWriter();
                        velocityContext = new VelocityContext();
                        iter = templateVars.entrySet().iterator();
                        while (iter.hasNext()) {
                            entry = iter.next();
                            velocityContext.put((String)entry.getKey(), entry.getValue());
                        }
                        template.merge((Context)velocityContext, (Writer)stringWriter);
                        sourceName = this.unit.getSource().getName();
                        prefix = sourceName.substring(0, sourceName.lastIndexOf(File.separatorChar) + 1);
                        generatedName = prefix + className + suffix;
                        if (this.generatedOutputDirectory != null) {
                            generatedName = FileUtils.addPathComponents((String)this.generatedOutputDirectory, (String)("_" + className + suffix), (char)File.separatorChar);
                        }
                        if (this.generatedOutputDirectory != null) {
                            fileWriter = null;
                            try {
                                fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(generatedName), "UTF-8"));
                                fileWriter.write(stringWriter.toString());
                                fileWriter.flush();
                                var16_16 = null;
                                ** if (fileWriter == null) goto lbl-1000
                            }
                            catch (Throwable var15_23) {
                                var16_18 = null;
                                if (fileWriter != null) {
                                    try {
                                        fileWriter.close();
                                    }
                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                                throw var15_23;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    fileWriter.close();
                                }
                                catch (IOException ex) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block20;
                                catch (IOException ioException) {
                                    ioException.printStackTrace();
                                    var16_17 = null;
                                    if (fileWriter != null) {
                                        try {
                                            fileWriter.close();
                                        }
                                        catch (IOException ex) {}
                                    }
                                }
                            }
                        }
                    }
                    context = new macromedia.asc.util.Context(context.statics);
                    context.setPath("");
                    context.setScriptName(generatedName);
                    context.setHandler((CompilerHandler)new Compiler.CompilerHandler());
                    context.statics.handler = context.getHandler();
                    parser = new Parser(context, stringWriter.toString(), generatedName);
                    programNode = parser.parseProgram();
                }
                catch (Exception e) {
                    ThreadLocalToolkit.log(new TemplateRunException(templateName, className, e.getLocalizedMessage()));
                    if (Trace.error) {
                        e.printStackTrace();
                    }
                    break block21;
                }
            }
            ThreadLocalToolkit.log(new TemplateLoadError(templateName));
        }
        return programNode;
    }

    protected void modifySyntaxTree(macromedia.asc.util.Context context, ClassDefinitionNode classDef, GenerativeClassInfo classInfo) {
        ProgramNode genProgramNode = this.generateSupportCode(context, classDef.name.name);
        if (genProgramNode.statements.items != null) {
            this.applyGeneratedSupportCode(context, classDef, classInfo, genProgramNode);
        }
    }

    private void applyGeneratedSupportCode(macromedia.asc.util.Context context, ClassDefinitionNode classDef, GenerativeClassInfo classInfo, ProgramNode genProgramNode) {
        Iterator genIter = genProgramNode.statements.items.iterator();
        while (genIter.hasNext()) {
            Object genItem = genIter.next();
            if (!(genItem instanceof ClassDefinitionNode)) continue;
            ClassDefinitionNode genClassDef = (ClassDefinitionNode)genItem;
            if (genClassDef.statements == null) continue;
            Iterator genClassStmtIter = genClassDef.statements.items.iterator();
            while (genClassStmtIter.hasNext()) {
                Node genClassStmt = (Node)genClassStmtIter.next();
                if (genClassStmt instanceof MetaDataNode) {
                    this.prepMetaDataNode(context, (MetaDataNode)genClassStmt);
                } else if (genClassStmt instanceof FunctionDefinitionNode) {
                    this.prepFunctionDefinitionNode(context, classDef, classInfo, (FunctionDefinitionNode)genClassStmt);
                } else if (genClassStmt instanceof VariableDefinitionNode) {
                    VariableDefinitionNode variableDefinition = (VariableDefinitionNode)genClassStmt;
                    this.prepVariableDefinitionNode(classDef, variableDefinition);
                    this.resetPositions(context, (Node)variableDefinition, -1);
                }
                this.addGeneratedMember(classDef, genClassStmt);
            }
            this.applyGeneratedInterfaces(classInfo, classDef, genClassDef);
        }
    }

    private void addGeneratedMember(ClassDefinitionNode classDef, Node genClassStmt) {
        if (!(genClassStmt instanceof NamespaceDefinitionNode)) {
            classDef.statements.items.add((Object)genClassStmt);
        }
    }

    private void prepMetaDataNode(macromedia.asc.util.Context context, MetaDataNode metaData) {
        metaData.evaluate(context, (Evaluator)this.metaDataEvaluator);
        this.unit.metadata.add(metaData);
    }

    private void prepFunctionDefinitionNode(macromedia.asc.util.Context context, ClassDefinitionNode classDef, GenerativeClassInfo classInfo, FunctionDefinitionNode genFuncDef) {
        String functionName = NodeMagic.getFunctionName(genFuncDef);
        genFuncDef.cx = classDef.cx;
        genFuncDef.fexpr.cx = classDef.cx;
        genFuncDef.pkgdef = classDef.pkgdef;
        genFuncDef.skipNode(true);
        if (functionName != null && classInfo.getAccessors() != null) {
            GenerativeClassInfo.AccessorInfo accessorInfo = classInfo.getAccessor(functionName);
            if (accessorInfo != null) {
                if (accessorInfo instanceof GenerativeClassInfo.VariableInfo) {
                    GenerativeClassInfo.VariableInfo variableInfo = (GenerativeClassInfo.VariableInfo)accessorInfo;
                    this.resetPositions(context, (Node)genFuncDef, variableInfo.getPosition());
                    if (NodeMagic.functionIsGetter(genFuncDef)) {
                        this.patchMetaData((DefinitionNode)genFuncDef, variableInfo.getMetaData());
                    }
                } else if (accessorInfo instanceof GenerativeClassInfo.GetterSetterInfo) {
                    GenerativeClassInfo.GetterSetterInfo getterSetterInfo = (GenerativeClassInfo.GetterSetterInfo)accessorInfo;
                    if (NodeMagic.functionIsGetter(genFuncDef)) {
                        this.resetPositions(context, (Node)genFuncDef, getterSetterInfo.getGetterPosition());
                        this.patchMetaData((DefinitionNode)genFuncDef, getterSetterInfo.getGetterMetaData());
                    } else if (NodeMagic.functionIsSetter(genFuncDef)) {
                        this.resetPositions(context, (Node)genFuncDef, getterSetterInfo.getSetterPosition());
                        this.patchMetaData((DefinitionNode)genFuncDef, getterSetterInfo.getSetterMetaData());
                    }
                }
                classInfo.removeOriginalMetaData(accessorInfo.getDefinitionNode());
            } else {
                this.resetPositions(context, (Node)genFuncDef, -1);
            }
        }
    }

    private void patchMetaData(DefinitionNode def, List metadata) {
        Iterator it = metadata.iterator();
        while (it.hasNext()) {
            MetaDataNode md = (MetaDataNode)it.next();
            if (md.id != null && md.id.equals("Bindable") && (md.values == null || md.values.length == 0)) continue;
            def.addMetaDataNode((Node)md);
        }
    }

    private void resetPositions(macromedia.asc.util.Context context, Node node, int position) {
        PositionResetEvaluator positionResetEvaluator = new PositionResetEvaluator(position);
        node.evaluate(context, (Evaluator)positionResetEvaluator);
    }

    private void prepVariableDefinitionNode(ClassDefinitionNode classDef, VariableDefinitionNode variableDefinition) {
        variableDefinition.cx = classDef.cx;
        variableDefinition.pkgdef = classDef.pkgdef;
        variableDefinition.skipNode(true);
    }

    private void applyGeneratedInterfaces(GenerativeClassInfo classInfo, ClassDefinitionNode origClassDef, ClassDefinitionNode genClassDef) {
        if (classInfo.needsAdditionalInterfaces()) {
            if (origClassDef.interfaces == null) {
                origClassDef.interfaces = genClassDef.interfaces;
            } else if (genClassDef.interfaces != null) {
                ObjectList interfaces = genClassDef.interfaces.items;
                for (int i = 0; i < interfaces.size(); ++i) {
                    origClassDef.interfaces.items.add(genClassDef.interfaces.items.get(i));
                }
            }
        }
    }

    protected void postProcessClassInfo(macromedia.asc.util.Context context, GenerativeClassInfo classInfo) {
        if (classInfo.getAccessors() != null) {
            Iterator iter = classInfo.getAccessors().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                GenerativeClassInfo.AccessorInfo info = (GenerativeClassInfo.AccessorInfo)entry.getValue();
                if (!info.getIsFunction()) continue;
                String propName = info.getPropertyName();
                ClassInfo reflectionInfo = classInfo.getClassInfo();
                if (!reflectionInfo.definesGetter(propName, true)) {
                    if (info.getIsExplicit()) {
                        context.localizedWarning2(((GenerativeClassInfo.GetterSetterInfo)info).getSetterPosition(), (Object)new BindableOnWriteOnlySetter());
                    }
                    iter.remove();
                    continue;
                }
                if (reflectionInfo.definesSetter(propName, true)) continue;
                if (info.getIsExplicit()) {
                    context.localizedWarning2(((GenerativeClassInfo.GetterSetterInfo)info).getGetterPosition(), (Object)new BindableOnReadOnlyGetter());
                }
                iter.remove();
            }
        }
    }

    public static class TemplateRunException
    extends CompilerMessage.CompilerError {
        public String templateName;
        public String className;
        public String exceptionText;

        public TemplateRunException(String templateName, String className, String exceptionText) {
            this.templateName = templateName;
            this.className = className;
            this.exceptionText = exceptionText;
            this.noPath();
        }
    }

    public static class TemplateLoadError
    extends CompilerMessage.CompilerError {
        public String templateName;

        public TemplateLoadError(String templateName) {
            this.templateName = templateName;
        }
    }

    public static class ExistingMethodError
    extends CompilerMessage.CompilerError {
        public String interfaceName;
        public String className;
        public String methodName;

        public ExistingMethodError(String interfaceName, String className, String methodName) {
            this.interfaceName = interfaceName;
            this.className = className;
            this.methodName = methodName;
        }
    }

    public static class BindableOnWriteOnlySetter
    extends CompilerMessage.CompilerWarning {
    }

    public static class BindableOnReadOnlyGetter
    extends CompilerMessage.CompilerWarning {
    }
}

