/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.mxml.dom.ApplicationNode;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.Script;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DocumentInfo {
    public static final String OUTER_DOCUMENT_PROP = "outerDocument";
    private ApplicationNode rootNode;
    private final String path;
    private String className;
    private String packageName;
    private QName qname;
    private String qualifiedSuperClassName;
    private Set interfaceNames;
    private Set importNames;
    private Map varDecls;
    private List scripts;
    private List metadata;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DocumentInfo(String path) {
        this.path = path;
    }

    public void setRootNode(ApplicationNode rootNode, int line) {
        if (!$assertionsDisabled && this.rootNode != null) {
            throw new AssertionError();
        }
        this.rootNode = rootNode;
        String outerDocumentClassName = rootNode.getOuterDocumentClassName();
        if (outerDocumentClassName != null) {
            this.addVarDecl(OUTER_DOCUMENT_PROP, outerDocumentClassName, line);
        }
    }

    public ApplicationNode getRootNode() {
        if (!$assertionsDisabled && this.rootNode == null) {
            throw new AssertionError();
        }
        return this.rootNode;
    }

    public void setClassName(String className) {
        if (!$assertionsDisabled && this.className != null) {
            throw new AssertionError();
        }
        this.className = className;
    }

    public String getClassName() {
        if (!$assertionsDisabled && this.className == null) {
            throw new AssertionError();
        }
        return this.className;
    }

    public void setPackageName(String packageName) {
        if (!$assertionsDisabled && this.packageName != null) {
            throw new AssertionError();
        }
        this.packageName = packageName;
    }

    public String getPackageName() {
        if (!$assertionsDisabled && this.packageName == null) {
            throw new AssertionError();
        }
        return this.packageName;
    }

    public QName getQName() {
        return this.qname != null ? this.qname : (this.qname = new QName(this.packageName, this.className));
    }

    public void setQualifiedSuperClassName(String qualifiedSuperClassName, int line) {
        if (!$assertionsDisabled && this.qualifiedSuperClassName != null) {
            throw new AssertionError();
        }
        this.qualifiedSuperClassName = qualifiedSuperClassName;
        this.addImportName(qualifiedSuperClassName, line);
    }

    public String getQualifiedSuperClassName() {
        if (!$assertionsDisabled && this.qualifiedSuperClassName == null) {
            throw new AssertionError();
        }
        return this.qualifiedSuperClassName;
    }

    public void addInterfaceName(String interfaceName, int line) {
        (this.interfaceNames != null ? this.interfaceNames : (this.interfaceNames = new TreeSet<NameInfo>())).add(new NameInfo(interfaceName, line));
        this.addImportName(interfaceName, line);
    }

    public Set getInterfaceNames() {
        return this.interfaceNames != null ? this.interfaceNames : Collections.EMPTY_SET;
    }

    public void addImportName(String importName, int line) {
        if (!importName.equals("*") && !StandardDefs.isBuiltInTypeName(importName)) {
            (this.importNames != null ? this.importNames : (this.importNames = new TreeSet<NameInfo>())).add(new NameInfo(importName, line));
        }
    }

    public void addImportNames(Collection names, int line) {
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            this.addImportName((String)iter.next(), line);
        }
    }

    public Collection getImportNames() {
        return this.importNames != null ? this.importNames : Collections.EMPTY_SET;
    }

    public void addVarDecl(String name, String className, int line) {
        VarDecl ref = new VarDecl(name, className, line);
        (this.varDecls != null ? this.varDecls : (this.varDecls = new LinkedHashMap<String, VarDecl>())).put(name, ref);
        this.addImportName(className, line);
    }

    public Map getVarDecls() {
        return this.varDecls != null ? this.varDecls : Collections.EMPTY_MAP;
    }

    public boolean containsVarDecl(String id) {
        return this.getVarDecls().containsKey(id);
    }

    public void addScript(Script script) {
        (this.scripts != null ? this.scripts : (this.scripts = new ArrayList<Script>())).add(script);
    }

    public List getScripts() {
        return this.scripts != null ? this.scripts : Collections.EMPTY_LIST;
    }

    public void addMetadata(Script metadatum) {
        (this.metadata != null ? this.metadata : (this.metadata = new ArrayList<Script>())).add(metadatum);
    }

    public List getMetadata() {
        return this.metadata != null ? this.metadata : Collections.EMPTY_LIST;
    }

    static {
        $assertionsDisabled = !DocumentInfo.class.desiredAssertionStatus();
    }

    public static class NameInfo
    implements Comparable {
        private final String name;
        private final int line;

        NameInfo(String name, int line) {
            this.name = name;
            this.line = line;
        }

        public int compareTo(Object o) {
            return o instanceof NameInfo ? this.name.compareTo(((NameInfo)o).name) : 0;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int getLine() {
            return this.line;
        }
    }

    public static class VarDecl {
        public final String name;
        public final String className;
        public final int line;

        VarDecl(String name, String className, int line) {
            this.name = name;
            this.className = className;
            this.line = line;
        }
    }
}

