/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.AbstractSubCompiler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Logger;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.mxml.MxmlLogAdapter;
import flex2.compiler.util.DualModeLineNumberMap;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.ThreadLocalToolkit;

public abstract class AbstractDelegatingSubCompiler
extends AbstractSubCompiler {
    protected static final String DELEGATE_UNIT = "DelegateUnit";
    protected static final String LINE_NUMBER_MAP = "LineNumberMap";
    protected AbstractSubCompiler delegateSubCompiler;

    public Source preprocess(Source source) {
        return source;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Source.transferInheritance(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.delegateSubCompiler.parse2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferAssets(ascUnit, unit);
        Source.transferGeneratedSources(ascUnit, unit);
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.delegateSubCompiler.analyze1(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferTypeInfo(ascUnit, unit);
        Source.transferNamespaces(ascUnit, unit);
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Source.transferDependencies(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.delegateSubCompiler.analyze2(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
        Source.transferDependencies(ascUnit, unit);
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Source.transferDependencies(unit, ascUnit);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.delegateSubCompiler.analyze3(ascUnit, symbolTable);
        ThreadLocalToolkit.setLogger(original);
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Logger original = ThreadLocalToolkit.getLogger();
        LineNumberMap map = (LineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.delegateSubCompiler.analyze4(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        ThreadLocalToolkit.setLogger(original);
        Source.transferExpressions(ascUnit, unit);
        Source.transferMetaData(ascUnit, unit);
        Source.transferLoaderClassBase(ascUnit, unit);
        Source.transferClassTable(ascUnit, unit);
        Source.transferStyles(ascUnit, unit);
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        CompilationUnit ascUnit = (CompilationUnit)unit.getContext().getAttribute(DELEGATE_UNIT);
        Logger original = ThreadLocalToolkit.getLogger();
        DualModeLineNumberMap map = (DualModeLineNumberMap)unit.getContext().getAttribute(LINE_NUMBER_MAP);
        if (map != null) {
            map.flushTemp();
        }
        MxmlLogAdapter adapter = new MxmlLogAdapter(original, map);
        ThreadLocalToolkit.setLogger(adapter);
        this.delegateSubCompiler.generate(ascUnit, symbolTable);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        Source.transferGeneratedSources(ascUnit, unit);
        Source.transferBytecodes(ascUnit, unit);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }
}

