/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.as3.AbstractSyntaxTreeUtil;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.binding.ArrayElementWatcher;
import flex2.compiler.as3.binding.ChangeEvent;
import flex2.compiler.as3.binding.DataBindingFirstPassEvaluator;
import flex2.compiler.as3.binding.DataBindingInfo;
import flex2.compiler.as3.binding.EvaluationWatcher;
import flex2.compiler.as3.binding.FunctionReturnWatcher;
import flex2.compiler.as3.binding.PropertyWatcher;
import flex2.compiler.as3.binding.RepeaterComponentWatcher;
import flex2.compiler.as3.binding.RepeaterItemWatcher;
import flex2.compiler.as3.binding.Watcher;
import flex2.compiler.as3.binding.XMLWatcher;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.TextFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.mxml.SourceCodeBuffer;
import flex2.compiler.mxml.gen.VelocityUtil;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.compiler.util.VelocityException;
import flex2.compiler.util.VelocityManager;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SelectorNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.util.ObjectList;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataBindingExtension
implements Extension {
    private static final String TEMPLATE_PATH = "flex2/compiler/as3/binding/";
    private static final String DATA_BINDING_INFO_KEY = "dataBindingInfo";
    private static final String DOT = ".";
    private static final String DOT_AS = ".as";
    private static final String EMPTY_STRING = "";
    private static final String ADD_CHILD = "addChild".intern();
    private static final String APPLY = "apply".intern();
    private static final String ARRAY = "Array".intern();
    private static final String ARRAY_ELEMENT_WATCHER = "ArrayElementWatcher".intern();
    private static final String ARRAY_WATCHER = "arrayWatcher".intern();
    private static final String BINDINGS = "bindings".intern();
    private static final String EXCLUDE_CLASS = "ExcludeClass".intern();
    private static final String FBS = "fbs".intern();
    private static final String FUNCTION = "Function".intern();
    private static final String FUNCTION_RETURN_WATCHER = "FunctionReturnWatcher".intern();
    private static final String IFLEX_MODULE_FACTORY = "IFlexModuleFactory".intern();
    private static final String INIT = "init".intern();
    private static final String IWATCHER_SETUP_UTIL2 = "IWatcherSetupUtil2".intern();
    private static final String OBJECT = "Object".intern();
    private static final String PARENT_WATCHER = "parentWatcher".intern();
    private static final String PROPERTY_GETTER = "propertyGetter".intern();
    private static final String PROPERTY_WATCHER = "PropertyWatcher".intern();
    private static final String REPEATER_COMPONENT_WATCHER = "RepeaterComponentWatcher".intern();
    private static final String REPEATER_ITEM_WATCHER = "RepeaterItemWatcher".intern();
    private static final String SETUP = "setup".intern();
    private static final String STATIC_PROPERTY_GETTER = "staticPropertyGetter".intern();
    private static final String STATIC_PROPERTY_WATCHER = "StaticPropertyWatcher".intern();
    private static final String TARGET = "target".intern();
    private static final String UPDATE_PARENT = "updateParent".intern();
    private static final String WATCHERS = "watchers".intern();
    private static final String WATCHER_SETUP_UTIL = "watcherSetupUtil".intern();
    private static final String XML_WATCHER = "XMLWatcher".intern();
    private String generatedOutputDirectory;
    private boolean showBindingWarnings;
    private boolean generateAbstractSyntaxTree;
    private ObjectList<ConfigVar> defines;

    public DataBindingExtension(String generatedOutputDirectory, boolean showBindingWarnings, boolean generateAbstractSyntaxTree, ObjectList<ConfigVar> defines) {
        this.generatedOutputDirectory = generatedOutputDirectory;
        this.showBindingWarnings = showBindingWarnings;
        this.generateAbstractSyntaxTree = generateAbstractSyntaxTree;
        this.defines = defines;
    }

    @Override
    public void parse1(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    @Override
    public void parse2(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    @Override
    public void analyze1(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    @Override
    public void analyze2(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    @Override
    public void analyze3(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    @Override
    public void analyze4(CompilationUnit compilationUnit, TypeTable typeTable) {
    }

    @Override
    public void generate(CompilationUnit compilationUnit, TypeTable typeTable) {
        CompilerContext context = compilationUnit.getContext();
        macromedia.asc.util.Context cx = context.getAscContext();
        Node node = (Node)compilationUnit.getSyntaxTree();
        DataBindingFirstPassEvaluator dataBindingFirstPassEvaluator = new DataBindingFirstPassEvaluator(compilationUnit, typeTable, this.showBindingWarnings);
        node.evaluate(cx, (Evaluator)dataBindingFirstPassEvaluator);
        List<DataBindingInfo> dataBindingInfoList = dataBindingFirstPassEvaluator.getDataBindingInfoList();
        if (dataBindingInfoList.size() > 1) assert (false) : compilationUnit.getSource().getName();
        if (dataBindingInfoList.size() > 0) {
            Map<QName, Source> generatedSources = this.generateWatcherSetupUtilClasses(compilationUnit, typeTable.getSymbolTable(), dataBindingInfoList);
            compilationUnit.addGeneratedSources(generatedSources);
        }
    }

    private Source createSource(String fileName, String shortName, long lastModified, PathResolver resolver, SourceCodeBuffer sourceCodeBuffer) {
        Source result = null;
        if (sourceCodeBuffer.getBuffer() != null) {
            String sourceCode = sourceCodeBuffer.toString();
            if (this.generatedOutputDirectory != null) {
                try {
                    FileUtil.writeFile(this.generatedOutputDirectory + File.separatorChar + fileName, sourceCode);
                }
                catch (IOException e) {
                    ThreadLocalToolkit.log(new VelocityException.UnableToWriteGeneratedFile(fileName, e.getMessage()));
                }
            }
            TextFile generatedFile = new TextFile(sourceCode, fileName, null, "text/as", lastModified);
            result = new Source((VirtualFile)generatedFile, EMPTY_STRING, shortName, null, false, false, false);
            result.setPathResolver(resolver);
        }
        return result;
    }

    private FunctionCommonNode generateAccessorFunction(NodeFactory nodeFactory, macromedia.asc.util.Context cx, HashSet<String> configNamespaces, ArrayElementWatcher arrayElementWatcher) {
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, null);
        List<Node> nodeList = AbstractSyntaxTreeUtil.parse(cx, configNamespaces, arrayElementWatcher.getEvaluationPart());
        ListNode list = null;
        assert (nodeList.size() == 0 || nodeList.size() == 1) : nodeList.size();
        if (!nodeList.isEmpty()) {
            ExpressionStatementNode expressionStatement = (ExpressionStatementNode)nodeList.get(0);
            list = (ListNode)expressionStatement.expr;
        }
        ReturnStatementNode returnStatement = nodeFactory.returnStatement(list);
        StatementListNode statementList = nodeFactory.statementList(null, (Node)returnStatement);
        return nodeFactory.functionCommon(cx, null, functionSignature, statementList);
    }

    private FunctionCommonNode generateAccessorFunction(NodeFactory nodeFactory, macromedia.asc.util.Context cx, HashSet<String> configNamespaces, FunctionReturnWatcher functionReturnWatcher) {
        MemberExpressionNode memberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, ARRAY, false);
        TypeExpressionNode returnType = nodeFactory.typeExpression((Node)memberExpression, true, false, -1);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(null, (Node)returnType);
        List<Node> nodeList = AbstractSyntaxTreeUtil.parse(cx, configNamespaces, functionReturnWatcher.getEvaluationPart());
        ArgumentListNode argumentList = null;
        assert (nodeList.size() == 0 || nodeList.size() == 1) : nodeList.size();
        if (!nodeList.isEmpty()) {
            ExpressionStatementNode expressionStatement = (ExpressionStatementNode)nodeList.get(0);
            ListNode list = (ListNode)expressionStatement.expr;
            Iterator iterator = list.items.iterator();
            while (iterator.hasNext()) {
                argumentList = nodeFactory.argumentList(argumentList, (Node)iterator.next());
            }
        }
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        ListNode outerList = nodeFactory.list(null, (Node)literalArray);
        ReturnStatementNode returnStatement = nodeFactory.returnStatement((Node)outerList);
        StatementListNode statementList = nodeFactory.statementList(null, (Node)returnStatement);
        return nodeFactory.functionCommon(cx, null, functionSignature, statementList);
    }

    private ExpressionStatementNode generateAddChild(NodeFactory nodeFactory, Watcher watcher) {
        MemberExpressionNode watchersMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode getExpression = this.generateArrayIndex(nodeFactory, watcher.getParent().getId());
        getExpression.setMode(-29);
        MemberExpressionNode base = nodeFactory.memberExpression((Node)watchersMemberExpression, (SelectorNode)getExpression);
        IdentifierNode identifier = nodeFactory.identifier(ADD_CHILD, false);
        MemberExpressionNode childBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode childSelector = this.generateArrayIndex(nodeFactory, watcher.getId());
        childSelector.setMode(-29);
        MemberExpressionNode childMemberExpression = nodeFactory.memberExpression((Node)childBase, (SelectorNode)childSelector);
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)childMemberExpression);
        CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, args);
        selector.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    private GetExpressionNode generateArrayIndex(NodeFactory nodeFactory, int index) {
        LiteralNumberNode literalNumber = nodeFactory.literalNumber(index);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalNumber);
        return nodeFactory.getExpression((Node)argumentList);
    }

    private Node generateChangeEvents(NodeFactory nodeFactory, Watcher watcher) {
        LiteralNullNode result;
        Iterator<ChangeEvent> iterator = watcher.getChangeEvents().iterator();
        if (iterator.hasNext()) {
            ArgumentListNode argumentList = null;
            while (iterator.hasNext()) {
                ChangeEvent changeEvent = iterator.next();
                IdentifierNode identifierNode = nodeFactory.identifier(changeEvent.getName());
                LiteralBooleanNode literalBoolean = nodeFactory.literalBoolean(changeEvent.getCommitting());
                LiteralFieldNode literalField = nodeFactory.literalField((Node)identifierNode, (Node)literalBoolean);
                argumentList = nodeFactory.argumentList(argumentList, (Node)literalField);
            }
            result = nodeFactory.literalObject(argumentList);
        } else {
            result = nodeFactory.literalNull();
        }
        return result;
    }

    private ClassDefinitionNode generateClassDefinition(macromedia.asc.util.Context cx, HashSet<String> configNamespaces, String name, DataBindingInfo dataBindingInfo, StandardDefs standardDefs) {
        NodeFactory nodeFactory = cx.getNodeFactory();
        nodeFactory.StartClassDefs();
        MemberExpressionNode iWatcherSetupUtilMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, standardDefs.getBindingPackage(), IWATCHER_SETUP_UTIL2, false);
        ListNode interfaces = nodeFactory.list(null, (Node)iWatcherSetupUtilMemberExpression);
        InheritanceNode inheritance = nodeFactory.inheritance(null, interfaces);
        FunctionDefinitionNode constructorFunctionDefinition = AbstractSyntaxTreeUtil.generateConstructor(cx, name, null, true, null, -1);
        StatementListNode statementList = nodeFactory.statementList(null, (Node)constructorFunctionDefinition);
        FunctionCommonNode initFunctionCommon = this.generateInitFunctionCommon(nodeFactory, cx, dataBindingInfo);
        initFunctionCommon.setUserDefinedBody(true);
        FunctionDefinitionNode initFunctionDefinition = this.generateInitFunctionDefinition(nodeFactory, cx, initFunctionCommon);
        statementList = nodeFactory.statementList(statementList, (Node)initFunctionDefinition);
        FunctionCommonNode setupFunctionCommon = this.generateSetupFunctionCommon(nodeFactory, cx, configNamespaces, dataBindingInfo, standardDefs);
        setupFunctionCommon.setUserDefinedBody(true);
        FunctionDefinitionNode setupFunctionDefinition = this.generateSetupFunctionDefinition(nodeFactory, cx, setupFunctionCommon);
        statementList = nodeFactory.statementList(statementList, (Node)setupFunctionDefinition);
        ClassDefinitionNode classDefinition = nodeFactory.classDefinition(cx, AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory), (IdentifierNode)AbstractSyntaxTreeUtil.generatePublicQualifiedIdentifier(nodeFactory, name), inheritance, statementList);
        return classDefinition;
    }

    private ExpressionStatementNode generateEvaluationWatcherPart(NodeFactory nodeFactory, EvaluationWatcher evaluationWatcher) {
        MemberExpressionNode watchersBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode watchersSelector = this.generateArrayIndex(nodeFactory, evaluationWatcher.getId());
        MemberExpressionNode watcherBase = nodeFactory.memberExpression((Node)watchersBase, (SelectorNode)watchersSelector);
        watchersSelector.setMode(-29);
        IdentifierNode parentVariableIdentifier = null;
        if (evaluationWatcher instanceof ArrayElementWatcher) {
            parentVariableIdentifier = nodeFactory.identifier(ARRAY_WATCHER, false);
        } else if (evaluationWatcher instanceof FunctionReturnWatcher) {
            parentVariableIdentifier = nodeFactory.identifier(PARENT_WATCHER, false);
        } else assert (false) : "Unhandled EvaluationWatcher type: " + evaluationWatcher.getClass().getName();
        MemberExpressionNode parentWatchersBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode parentWatchersSelector = this.generateArrayIndex(nodeFactory, evaluationWatcher.getParent().getId());
        parentWatchersSelector.setMode(-29);
        MemberExpressionNode parentWatcherBase = nodeFactory.memberExpression((Node)parentWatchersBase, (SelectorNode)parentWatchersSelector);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)parentWatcherBase);
        SetExpressionNode setExpression = nodeFactory.setExpression((Node)parentVariableIdentifier, argumentList, false);
        setExpression.setMode(-18);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)watcherBase, (SelectorNode)setExpression);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    private FunctionCommonNode generateInitFunctionCommon(NodeFactory nodeFactory, macromedia.asc.util.Context cx, DataBindingInfo dataBindingInfo) {
        ParameterNode parameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, FBS, IFLEX_MODULE_FACTORY, false);
        ParameterListNode parameterList = nodeFactory.parameterList(null, parameter);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.void_anno = true;
        String className = dataBindingInfo.getClassName();
        ImportDirectiveNode importDirective = AbstractSyntaxTreeUtil.generateImport(cx, className);
        StatementListNode statementList = nodeFactory.statementList(null, (Node)importDirective);
        int index = className.lastIndexOf(DOT);
        ListNode base = index > 0 ? nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className.substring(0, index), className.substring(index + 1), true)) : nodeFactory.list(null, (Node)AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, true));
        IdentifierNode watcherSetupUtilIdentifier = nodeFactory.identifier(WATCHER_SETUP_UTIL, false);
        IdentifierNode watcherSetupUtilClassIdentifier = nodeFactory.identifier(dataBindingInfo.getWatcherSetupUtilClassName());
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)watcherSetupUtilClassIdentifier, null);
        callExpression.setRValue(false);
        callExpression.is_new = true;
        MemberExpressionNode newMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)newMemberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)watcherSetupUtilIdentifier, argumentList, false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        statementList = nodeFactory.statementList(statementList, (Node)expressionStatement);
        return nodeFactory.functionCommon(cx, null, functionSignature, statementList);
    }

    private FunctionDefinitionNode generateInitFunctionDefinition(NodeFactory nodeFactory, macromedia.asc.util.Context cx, FunctionCommonNode functionCommon) {
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicStaticAttribute(nodeFactory);
        IdentifierNode identifier = nodeFactory.identifier(INIT, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, identifier);
        return nodeFactory.functionDefinition(cx, attributeList, functionName, functionCommon);
    }

    private LiteralArrayNode generateListener(NodeFactory nodeFactory, int id) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, BINDINGS, false);
        GetExpressionNode selector = this.generateArrayIndex(nodeFactory, id);
        selector.setMode(-29);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)memberExpression);
        return nodeFactory.literalArray(argumentList);
    }

    private LiteralArrayNode generateListeners(NodeFactory nodeFactory, PropertyWatcher propertyWatcher) {
        ArgumentListNode argumentList = null;
        for (BindingExpression bindingExpression : propertyWatcher.getBindingExpressions()) {
            MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, BINDINGS, false);
            GetExpressionNode selector = this.generateArrayIndex(nodeFactory, bindingExpression.getId());
            selector.setMode(-29);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
            argumentList = nodeFactory.argumentList(argumentList, (Node)memberExpression);
        }
        return nodeFactory.literalArray(argumentList);
    }

    private MemberExpressionNode generatePath(NodeFactory nodeFactory, String path) {
        MemberExpressionNode base;
        String string;
        int index = path.lastIndexOf(DOT);
        if (index > 0) {
            string = path.substring(index + 1);
            base = this.generatePath(nodeFactory, path.substring(0, index));
        } else {
            string = path;
            base = null;
        }
        IdentifierNode identifier = nodeFactory.identifier(string);
        GetExpressionNode getExpression = nodeFactory.getExpression(identifier);
        getExpression.setMode(-18);
        return nodeFactory.memberExpression((Node)base, (SelectorNode)getExpression);
    }

    private StatementListNode generateRootWatcherBottom(NodeFactory nodeFactory, macromedia.asc.util.Context cx, StatementListNode statementList, Watcher watcher) {
        MemberExpressionNode parentMemberExpression;
        StatementListNode result = statementList;
        MemberExpressionNode watchersMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode getExpression = this.generateArrayIndex(nodeFactory, watcher.getId());
        getExpression.setMode(-29);
        MemberExpressionNode base = nodeFactory.memberExpression((Node)watchersMemberExpression, (SelectorNode)getExpression);
        IdentifierNode identifier = nodeFactory.identifier(UPDATE_PARENT, false);
        String className = watcher.getClassName();
        if (className != null) {
            result = nodeFactory.statementList(result, (Node)AbstractSyntaxTreeUtil.generateImport(cx, className));
            int index = className.lastIndexOf(DOT);
            parentMemberExpression = index > 0 ? AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className.substring(0, index), className.substring(index + 1), true) : AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, className, true);
        } else {
            parentMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TARGET, false);
        }
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)parentMemberExpression);
        CallExpressionNode selector = (CallExpressionNode)nodeFactory.callExpression((Node)identifier, args);
        selector.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        result = nodeFactory.statementList(result, (Node)expressionStatement);
        return result;
    }

    private FunctionCommonNode generateSetupFunctionCommon(NodeFactory nodeFactory, macromedia.asc.util.Context cx, HashSet<String> configNamespaces, DataBindingInfo dataBindingInfo, StandardDefs standardDefs) {
        ParameterListNode parameterList = null;
        ParameterNode targetParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, TARGET, OBJECT, false);
        parameterList = nodeFactory.parameterList(parameterList, targetParameter);
        ParameterNode propertyGetterParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, PROPERTY_GETTER, FUNCTION, false);
        parameterList = nodeFactory.parameterList(parameterList, propertyGetterParameter);
        ParameterNode staticPropertyGetterParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, STATIC_PROPERTY_GETTER, FUNCTION, false);
        parameterList = nodeFactory.parameterList(parameterList, staticPropertyGetterParameter);
        ParameterNode bindingsParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, BINDINGS, ARRAY, false);
        parameterList = nodeFactory.parameterList(parameterList, bindingsParameter);
        ParameterNode watchersParameter = AbstractSyntaxTreeUtil.generateParameter(nodeFactory, WATCHERS, ARRAY, false);
        parameterList = nodeFactory.parameterList(parameterList, watchersParameter);
        FunctionSignatureNode functionSignature = nodeFactory.functionSignature(parameterList, null);
        functionSignature.void_anno = true;
        StatementListNode statementList = null;
        Iterator<String> importIterator = dataBindingInfo.getImports().iterator();
        while (importIterator.hasNext()) {
            ImportDirectiveNode importDirective = AbstractSyntaxTreeUtil.generateImport(cx, importIterator.next());
            statementList = nodeFactory.statementList(statementList, (Node)importDirective);
        }
        for (Watcher watcher : dataBindingInfo.getRootWatchers().values()) {
            if (watcher.shouldWriteSelf()) {
                if (watcher instanceof ArrayElementWatcher) {
                    ArrayElementWatcher arrayElementWatcher = (ArrayElementWatcher)watcher;
                    statementList = this.generateWatcher(nodeFactory, cx, configNamespaces, statementList, arrayElementWatcher, standardDefs);
                } else if (watcher instanceof FunctionReturnWatcher) {
                    FunctionReturnWatcher functionReturnWatcher = (FunctionReturnWatcher)watcher;
                    statementList = this.generateWatcher(nodeFactory, cx, configNamespaces, statementList, functionReturnWatcher, standardDefs);
                } else if (watcher instanceof RepeaterComponentWatcher) {
                    RepeaterComponentWatcher repeaterComponentWatcher = (RepeaterComponentWatcher)watcher;
                    statementList = this.generateWatcher(nodeFactory, statementList, repeaterComponentWatcher, standardDefs);
                } else if (watcher instanceof RepeaterItemWatcher) {
                    RepeaterItemWatcher repeaterItemWatcher = (RepeaterItemWatcher)watcher;
                    statementList = this.generateWatcher(nodeFactory, cx, statementList, repeaterItemWatcher, standardDefs);
                } else if (watcher instanceof XMLWatcher) {
                    XMLWatcher xmlWatcher = (XMLWatcher)watcher;
                    statementList = this.generateWatcher(nodeFactory, statementList, xmlWatcher, standardDefs);
                } else if (watcher instanceof PropertyWatcher) {
                    PropertyWatcher propertyWatcher = (PropertyWatcher)watcher;
                    statementList = this.generateWatcher(nodeFactory, cx, statementList, propertyWatcher, standardDefs, dataBindingInfo.getClassName());
                } else assert (false) : "Unhandled Watcher type: " + watcher.getClass().getName();
            }
            if (!watcher.shouldWriteChildren()) continue;
            statementList = this.generateWatcherChildren(nodeFactory, cx, configNamespaces, statementList, watcher, standardDefs, dataBindingInfo.getClassName());
        }
        for (Watcher watcher : dataBindingInfo.getRootWatchers().values()) {
            statementList = this.generateWatcherBottom(nodeFactory, cx, statementList, watcher);
        }
        return nodeFactory.functionCommon(cx, null, functionSignature, statementList);
    }

    private FunctionDefinitionNode generateSetupFunctionDefinition(NodeFactory nodeFactory, macromedia.asc.util.Context cx, FunctionCommonNode functionCommon) {
        AttributeListNode attributeList = AbstractSyntaxTreeUtil.generatePublicAttribute(nodeFactory);
        IdentifierNode identifier = nodeFactory.identifier(SETUP, false);
        FunctionNameNode functionName = nodeFactory.functionName(-133, identifier);
        return nodeFactory.functionDefinition(cx, attributeList, functionName, functionCommon);
    }

    private ExpressionStatementNode generateUpdateParentProperty(NodeFactory nodeFactory, int watcherId, PropertyWatcher parent) {
        MemberExpressionNode watchersBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode idSelector = this.generateArrayIndex(nodeFactory, watcherId);
        idSelector.setMode(-29);
        MemberExpressionNode watcherBase = nodeFactory.memberExpression((Node)watchersBase, (SelectorNode)idSelector);
        IdentifierNode updateParentIdentifier = nodeFactory.identifier(UPDATE_PARENT, false);
        MemberExpressionNode parentMemberExpression = this.generatePath(nodeFactory, TARGET + DOT + parent.getPathToProperty());
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)parentMemberExpression);
        CallExpressionNode updateParentSelector = (CallExpressionNode)nodeFactory.callExpression((Node)updateParentIdentifier, args);
        updateParentSelector.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)watcherBase, (SelectorNode)updateParentSelector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    private ExpressionStatementNode generateUpdateParentPrivateProperty(NodeFactory nodeFactory, int watcherId, PropertyWatcher parent) {
        MemberExpressionNode watchersBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode idSelector = this.generateArrayIndex(nodeFactory, watcherId);
        idSelector.setMode(-29);
        MemberExpressionNode watcherBase = nodeFactory.memberExpression((Node)watchersBase, (SelectorNode)idSelector);
        IdentifierNode updateParentIdentifier = nodeFactory.identifier(UPDATE_PARENT, false);
        MemberExpressionNode propertyGetterBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PROPERTY_GETTER, false);
        IdentifierNode applyIdentifier = nodeFactory.identifier(APPLY, false);
        IdentifierNode targetIdentifier = nodeFactory.identifier(TARGET, false);
        ArgumentListNode applyArgs = nodeFactory.argumentList(null, (Node)targetIdentifier);
        LiteralStringNode literalString = nodeFactory.literalString(parent.getProperty());
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        LiteralArrayNode literalArray = nodeFactory.literalArray(argumentList);
        applyArgs = nodeFactory.argumentList(applyArgs, (Node)literalArray);
        CallExpressionNode propertyGetterSelector = (CallExpressionNode)nodeFactory.callExpression((Node)applyIdentifier, applyArgs);
        propertyGetterSelector.setRValue(false);
        MemberExpressionNode propertyGetterMemberExpression = nodeFactory.memberExpression((Node)propertyGetterBase, (SelectorNode)propertyGetterSelector);
        ArgumentListNode updateParentArgs = nodeFactory.argumentList(null, (Node)propertyGetterMemberExpression);
        CallExpressionNode updateParentSelector = (CallExpressionNode)nodeFactory.callExpression((Node)updateParentIdentifier, updateParentArgs);
        updateParentSelector.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)watcherBase, (SelectorNode)updateParentSelector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    private ExpressionStatementNode generateUpdateParentStaticProperty(NodeFactory nodeFactory, int watcherId, PropertyWatcher parent) {
        MemberExpressionNode watchersBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        GetExpressionNode idSelector = this.generateArrayIndex(nodeFactory, watcherId);
        idSelector.setMode(-29);
        MemberExpressionNode watcherBase = nodeFactory.memberExpression((Node)watchersBase, (SelectorNode)idSelector);
        IdentifierNode updateParentIdentifier = nodeFactory.identifier(UPDATE_PARENT, false);
        MemberExpressionNode parentMemberExpression = this.generatePath(nodeFactory, parent.getClassName() + DOT + parent.getPathToProperty());
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)parentMemberExpression);
        CallExpressionNode updateParentSelector = (CallExpressionNode)nodeFactory.callExpression((Node)updateParentIdentifier, args);
        updateParentSelector.setRValue(false);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)watcherBase, (SelectorNode)updateParentSelector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        return nodeFactory.expressionStatement((Node)list);
    }

    private StatementListNode generateWatcher(NodeFactory nodeFactory, macromedia.asc.util.Context cx, HashSet<String> configNamespaces, StatementListNode statementList, ArrayElementWatcher arrayElementWatcher, StandardDefs standardDefs) {
        StatementListNode result = statementList;
        if (arrayElementWatcher.shouldWriteChildren()) {
            MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
            QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, standardDefs.getBindingPackage(), ARRAY_ELEMENT_WATCHER, false);
            LiteralNumberNode literalNumber = nodeFactory.literalNumber(arrayElementWatcher.getId());
            ArgumentListNode expression = nodeFactory.argumentList(null, (Node)literalNumber);
            MemberExpressionNode targetMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TARGET, false);
            ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)targetMemberExpression);
            argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateAccessorFunction(nodeFactory, cx, configNamespaces, arrayElementWatcher));
            int listenerId = arrayElementWatcher.getBindingExpression().getId();
            argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateListener(nodeFactory, listenerId));
            CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, argumentList);
            callExpression.setRValue(false);
            callExpression.is_new = true;
            MemberExpressionNode callMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
            ArgumentListNode args = nodeFactory.argumentList(null, (Node)callMemberExpression);
            SetExpressionNode selector = nodeFactory.setExpression((Node)expression, args, false);
            selector.setMode(-29);
            MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
            ListNode list = nodeFactory.list(null, (Node)memberExpression);
            ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
            result = nodeFactory.statementList(result, (Node)expressionStatement);
        }
        return result;
    }

    private StatementListNode generateWatcher(NodeFactory nodeFactory, macromedia.asc.util.Context cx, HashSet<String> configNamespaces, StatementListNode statementList, FunctionReturnWatcher functionReturnWatcher, StandardDefs standardDefs) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, standardDefs.getBindingPackage(), FUNCTION_RETURN_WATCHER, false);
        LiteralNumberNode literalNumber = nodeFactory.literalNumber(functionReturnWatcher.getId());
        ArgumentListNode expression = nodeFactory.argumentList(null, (Node)literalNumber);
        LiteralStringNode literalString = nodeFactory.literalString(functionReturnWatcher.getFunctionName());
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        MemberExpressionNode targetMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, TARGET, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)targetMemberExpression);
        argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateAccessorFunction(nodeFactory, cx, configNamespaces, functionReturnWatcher));
        argumentList = nodeFactory.argumentList(argumentList, this.generateChangeEvents(nodeFactory, functionReturnWatcher));
        int listenerId = functionReturnWatcher.getBindingExpression().getId();
        argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateListener(nodeFactory, listenerId));
        if (functionReturnWatcher.getParent() != null || functionReturnWatcher.getClassName() != null) {
            argumentList = nodeFactory.argumentList(argumentList, (Node)nodeFactory.literalNull());
        } else {
            MemberExpressionNode propertyGetterMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PROPERTY_GETTER, false);
            argumentList = nodeFactory.argumentList(argumentList, (Node)propertyGetterMemberExpression);
        }
        if (functionReturnWatcher.isStyleWatcher()) {
            argumentList = nodeFactory.argumentList(argumentList, (Node)nodeFactory.literalBoolean(true));
        }
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, argumentList);
        callExpression.setRValue(false);
        callExpression.is_new = true;
        MemberExpressionNode callMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)callMemberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)expression, args, false);
        selector.setMode(-29);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode result = nodeFactory.statementList(statementList, (Node)expressionStatement);
        return result;
    }

    private StatementListNode generateWatcher(NodeFactory nodeFactory, macromedia.asc.util.Context cx, StatementListNode statementList, PropertyWatcher propertyWatcher, StandardDefs standardDefs, String documentClassName) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        String type = propertyWatcher.getStaticProperty() ? STATIC_PROPERTY_WATCHER : PROPERTY_WATCHER;
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, standardDefs.getBindingPackage(), type, false);
        LiteralNumberNode literalNumber = nodeFactory.literalNumber(propertyWatcher.getId());
        ArgumentListNode expression = nodeFactory.argumentList(null, (Node)literalNumber);
        LiteralStringNode literalString = nodeFactory.literalString(propertyWatcher.getProperty());
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        argumentList = nodeFactory.argumentList(argumentList, this.generateChangeEvents(nodeFactory, propertyWatcher));
        argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateListeners(nodeFactory, propertyWatcher));
        if (propertyWatcher.getParent() != null || propertyWatcher.getClassName() != null && !propertyWatcher.getClassName().equals(documentClassName)) {
            argumentList = nodeFactory.argumentList(argumentList, (Node)nodeFactory.literalNull());
        } else if (propertyWatcher.getStaticProperty()) {
            MemberExpressionNode staticPropertyGetterMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, STATIC_PROPERTY_GETTER, false);
            argumentList = nodeFactory.argumentList(argumentList, (Node)staticPropertyGetterMemberExpression);
        } else {
            MemberExpressionNode propertyGetterMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PROPERTY_GETTER, false);
            argumentList = nodeFactory.argumentList(argumentList, (Node)propertyGetterMemberExpression);
        }
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, argumentList);
        callExpression.setRValue(false);
        callExpression.is_new = true;
        MemberExpressionNode callMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)callMemberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)expression, args, false);
        selector.setMode(-29);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode result = nodeFactory.statementList(statementList, (Node)expressionStatement);
        return result;
    }

    private StatementListNode generateWatcherChildren(NodeFactory nodeFactory, macromedia.asc.util.Context cx, HashSet<String> configNamespaces, StatementListNode statementList, Watcher watcher, StandardDefs standardDefs, String documentClassName) {
        StatementListNode result = statementList;
        for (Watcher childWatcher : watcher.getChildren()) {
            if (childWatcher.shouldWriteSelf()) {
                if (childWatcher instanceof ArrayElementWatcher) {
                    ArrayElementWatcher childArrayElementWatcher = (ArrayElementWatcher)childWatcher;
                    result = this.generateWatcher(nodeFactory, cx, configNamespaces, result, childArrayElementWatcher, standardDefs);
                } else if (childWatcher instanceof FunctionReturnWatcher) {
                    FunctionReturnWatcher childFunctionReturnWatcher = (FunctionReturnWatcher)childWatcher;
                    result = this.generateWatcher(nodeFactory, cx, configNamespaces, result, childFunctionReturnWatcher, standardDefs);
                } else if (childWatcher instanceof RepeaterComponentWatcher) {
                    RepeaterComponentWatcher childRepeaterComponentWatcher = (RepeaterComponentWatcher)childWatcher;
                    result = this.generateWatcher(nodeFactory, result, childRepeaterComponentWatcher, standardDefs);
                } else if (childWatcher instanceof RepeaterItemWatcher) {
                    RepeaterItemWatcher childRepeaterItemWatcher = (RepeaterItemWatcher)childWatcher;
                    result = this.generateWatcher(nodeFactory, cx, result, childRepeaterItemWatcher, standardDefs);
                } else if (childWatcher instanceof XMLWatcher) {
                    XMLWatcher childXMLWatcher = (XMLWatcher)childWatcher;
                    result = this.generateWatcher(nodeFactory, result, childXMLWatcher, standardDefs);
                } else if (childWatcher instanceof PropertyWatcher) {
                    PropertyWatcher childPropertyWatcher = (PropertyWatcher)childWatcher;
                    result = this.generateWatcher(nodeFactory, cx, result, childPropertyWatcher, standardDefs, documentClassName);
                } else assert (false) : "Unhandled Watcher type: " + childWatcher.getClass().getName();
            }
            if (!childWatcher.shouldWriteChildren()) continue;
            result = this.generateWatcherChildren(nodeFactory, cx, configNamespaces, result, childWatcher, standardDefs, documentClassName);
        }
        return result;
    }

    private Map<QName, Source> generateWatcherSetupUtilClasses(CompilationUnit compilationUnit, SymbolTable symbolTable, List dataBindingInfoList) {
        HashMap<QName, Source> extraSources = new HashMap<QName, Source>();
        for (DataBindingInfo dataBindingInfo : dataBindingInfoList) {
            QName classQName = new QName(dataBindingInfo.getWatcherSetupUtilClassName());
            if (this.generateAbstractSyntaxTree) {
                extraSources.put(classQName, this.generateWatcherSetupUtilAST(compilationUnit, symbolTable, dataBindingInfo));
                continue;
            }
            extraSources.put(classQName, this.generateWatcherSetupUtil(compilationUnit, dataBindingInfo));
        }
        return extraSources;
    }

    private StatementListNode generateWatcher(NodeFactory nodeFactory, StatementListNode statementList, RepeaterComponentWatcher repeaterComponentWatcher, StandardDefs standardDefs) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, standardDefs.getBindingPackage(), REPEATER_COMPONENT_WATCHER, false);
        LiteralNumberNode literalNumber = nodeFactory.literalNumber(repeaterComponentWatcher.getId());
        ArgumentListNode expression = nodeFactory.argumentList(null, (Node)literalNumber);
        LiteralStringNode literalString = nodeFactory.literalString(repeaterComponentWatcher.getProperty());
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        argumentList = nodeFactory.argumentList(argumentList, this.generateChangeEvents(nodeFactory, repeaterComponentWatcher));
        argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateListeners(nodeFactory, repeaterComponentWatcher));
        MemberExpressionNode propertyGetterMemberExpression = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, PROPERTY_GETTER, false);
        argumentList = nodeFactory.argumentList(argumentList, (Node)propertyGetterMemberExpression);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, argumentList);
        callExpression.setRValue(false);
        callExpression.is_new = true;
        MemberExpressionNode callMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)callMemberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)expression, args, false);
        selector.setMode(-29);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode result = nodeFactory.statementList(statementList, (Node)expressionStatement);
        return result;
    }

    private StatementListNode generateWatcher(NodeFactory nodeFactory, macromedia.asc.util.Context cx, StatementListNode statementList, RepeaterItemWatcher repeaterItemWatcher, StandardDefs standardDefs) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, standardDefs.getBindingPackage(), REPEATER_ITEM_WATCHER, false);
        LiteralNumberNode id = nodeFactory.literalNumber(repeaterItemWatcher.getId());
        ArgumentListNode expression = nodeFactory.argumentList(null, (Node)id);
        MemberExpressionNode parentWatchersBase = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        LiteralNumberNode parentId = nodeFactory.literalNumber(repeaterItemWatcher.getParent().getId());
        ArgumentListNode parentExpression = nodeFactory.argumentList(null, (Node)parentId);
        GetExpressionNode parentSelector = nodeFactory.getExpression((Node)parentExpression);
        parentSelector.setMode(-29);
        MemberExpressionNode parentMemberExpression = nodeFactory.memberExpression((Node)parentWatchersBase, (SelectorNode)parentSelector);
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)parentMemberExpression);
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, argumentList);
        callExpression.setRValue(false);
        callExpression.is_new = true;
        MemberExpressionNode callMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)callMemberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)expression, args, false);
        selector.setMode(-29);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode result = nodeFactory.statementList(statementList, (Node)expressionStatement);
        return result;
    }

    private StatementListNode generateWatcher(NodeFactory nodeFactory, StatementListNode statementList, XMLWatcher xmlWatcher, StandardDefs standardDefs) {
        MemberExpressionNode base = AbstractSyntaxTreeUtil.generateGetterSelector(nodeFactory, WATCHERS, false);
        QualifiedIdentifierNode qualifiedIdentifier = AbstractSyntaxTreeUtil.generateQualifiedIdentifier(nodeFactory, standardDefs.getBindingPackage(), XML_WATCHER, false);
        LiteralNumberNode literalNumber = nodeFactory.literalNumber(xmlWatcher.getId());
        ArgumentListNode expression = nodeFactory.argumentList(null, (Node)literalNumber);
        LiteralStringNode literalString = nodeFactory.literalString(xmlWatcher.getProperty());
        ArgumentListNode argumentList = nodeFactory.argumentList(null, (Node)literalString);
        argumentList = nodeFactory.argumentList(argumentList, (Node)this.generateListeners(nodeFactory, xmlWatcher));
        CallExpressionNode callExpression = (CallExpressionNode)nodeFactory.callExpression((Node)qualifiedIdentifier, argumentList);
        callExpression.setRValue(false);
        callExpression.is_new = true;
        MemberExpressionNode callMemberExpression = nodeFactory.memberExpression(null, (SelectorNode)callExpression);
        ArgumentListNode args = nodeFactory.argumentList(null, (Node)callMemberExpression);
        SetExpressionNode selector = nodeFactory.setExpression((Node)expression, args, false);
        selector.setMode(-29);
        MemberExpressionNode memberExpression = nodeFactory.memberExpression((Node)base, (SelectorNode)selector);
        ListNode list = nodeFactory.list(null, (Node)memberExpression);
        ExpressionStatementNode expressionStatement = nodeFactory.expressionStatement((Node)list);
        StatementListNode result = nodeFactory.statementList(statementList, (Node)expressionStatement);
        return result;
    }

    private StatementListNode generateWatcherBottom(NodeFactory nodeFactory, macromedia.asc.util.Context cx, StatementListNode statementList, Watcher watcher) {
        StatementListNode result = statementList;
        if (watcher.shouldWriteSelf()) {
            if (watcher instanceof ArrayElementWatcher && watcher.shouldWriteSelf() && watcher.shouldWriteChildren() || watcher instanceof FunctionReturnWatcher) {
                EvaluationWatcher evaluationWatcher = (EvaluationWatcher)watcher;
                if (watcher.getParent() != null && watcher.getParent().shouldWriteSelf()) {
                    result = nodeFactory.statementList(result, (Node)this.generateEvaluationWatcherPart(nodeFactory, evaluationWatcher));
                }
                Iterator<Watcher> iterator = evaluationWatcher.getTriggeringWatchers().iterator();
                while (iterator.hasNext()) {
                    result = nodeFactory.statementList(result, (Node)this.generateAddChild(nodeFactory, iterator.next()));
                }
            }
            if (watcher.getParent() != null) {
                if (watcher.getParent().shouldWriteSelf()) {
                    result = nodeFactory.statementList(result, (Node)this.generateAddChild(nodeFactory, watcher));
                } else {
                    Watcher parent = watcher.getParent();
                    if (parent instanceof PropertyWatcher) {
                        PropertyWatcher propertyWatcher = (PropertyWatcher)parent;
                        result = propertyWatcher.getStaticProperty() ? nodeFactory.statementList(result, (Node)this.generateUpdateParentStaticProperty(nodeFactory, watcher.getId(), propertyWatcher)) : (parent.getParent() != null ? nodeFactory.statementList(result, (Node)this.generateUpdateParentProperty(nodeFactory, watcher.getId(), propertyWatcher)) : nodeFactory.statementList(result, (Node)this.generateUpdateParentPrivateProperty(nodeFactory, watcher.getId(), propertyWatcher)));
                    }
                }
            } else {
                result = this.generateRootWatcherBottom(nodeFactory, cx, result, watcher);
            }
        }
        if (watcher.shouldWriteChildren()) {
            for (Watcher childWatcher : watcher.getChildren()) {
                result = this.generateWatcherBottom(nodeFactory, cx, result, childWatcher);
            }
        }
        return result;
    }

    private Source generateWatcherSetupUtil(CompilationUnit compilationUnit, DataBindingInfo dataBindingInfo) {
        Template template;
        StandardDefs standardDefs = compilationUnit.getStandardDefs();
        String templatePath = TEMPLATE_PATH + standardDefs.getWatcherSetupUtilTemplate();
        try {
            template = VelocityManager.getTemplate(templatePath);
        }
        catch (Exception exception) {
            ThreadLocalToolkit.log(new VelocityException.TemplateNotFound(templatePath));
            return null;
        }
        String className = dataBindingInfo.getWatcherSetupUtilClassName();
        String shortName = className.substring(className.lastIndexOf(DOT) + 1);
        String generatedName = className.replace('.', File.separatorChar) + DOT_AS;
        SourceCodeBuffer out = new SourceCodeBuffer();
        try {
            VelocityUtil util = new VelocityUtil(TEMPLATE_PATH, false, out, null);
            VelocityContext velocityContext = VelocityManager.getCodeGenContext(util);
            velocityContext.put(DATA_BINDING_INFO_KEY, (Object)dataBindingInfo);
            template.merge((Context)velocityContext, (Writer)out);
        }
        catch (Exception e) {
            ThreadLocalToolkit.log(new VelocityException.GenerateException(compilationUnit.getSource().getRelativePath(), e.getLocalizedMessage()));
            return null;
        }
        return this.createSource(generatedName, shortName, compilationUnit.getSource().getLastModified(), compilationUnit.getSource().getPathResolver(), out);
    }

    private Source generateWatcherSetupUtilAST(CompilationUnit compilationUnit, SymbolTable symbolTable, DataBindingInfo dataBindingInfo) {
        String className = dataBindingInfo.getWatcherSetupUtilClassName();
        String shortName = className.substring(className.lastIndexOf(DOT) + 1);
        String fileName = className.replace('.', File.separatorChar) + DOT_AS;
        TextFile emptyFile = new TextFile(EMPTY_STRING, fileName, null, "text/as", compilationUnit.getSource().getLastModified());
        Source result = new Source((VirtualFile)emptyFile, EMPTY_STRING, shortName, null, false, false, false);
        macromedia.asc.util.Context cx = AbstractSyntaxTreeUtil.generateContext(symbolTable.perCompileData, result, symbolTable.emitter, this.defines);
        NodeFactory nodeFactory = cx.getNodeFactory();
        HashSet<String> configNamespaces = new HashSet<String>();
        StatementListNode configVars = AbstractSyntaxTreeUtil.parseConfigVars(cx, configNamespaces);
        ProgramNode program = AbstractSyntaxTreeUtil.generateProgram(cx, configVars, EMPTY_STRING);
        StatementListNode programStatementList = program.statements;
        String[] watcherImports = compilationUnit.getStandardDefs().getImports();
        for (int i = 0; i < watcherImports.length; ++i) {
            ImportDirectiveNode importDirective = AbstractSyntaxTreeUtil.generateImport(cx, watcherImports[i]);
            programStatementList = nodeFactory.statementList(programStatementList, (Node)importDirective);
        }
        MetaDataNode metaDataNode = AbstractSyntaxTreeUtil.generateMetaData(nodeFactory, EXCLUDE_CLASS);
        programStatementList = nodeFactory.statementList(programStatementList, (Node)metaDataNode);
        ClassDefinitionNode classDefinition = this.generateClassDefinition(cx, configNamespaces, shortName, dataBindingInfo, compilationUnit.getStandardDefs());
        program.statements = programStatementList = nodeFactory.statementList(programStatementList, (Node)classDefinition);
        PackageDefinitionNode packageDefinition = nodeFactory.finishPackage(cx, null);
        nodeFactory.statementList(programStatementList, (Node)packageDefinition);
        CompilerContext context = new CompilerContext();
        context.setAscContext(cx);
        result.newCompilationUnit(program, context).setSyntaxTree(program);
        As3Compiler.cleanNodeFactory(nodeFactory);
        return result;
    }
}

