/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.InterfaceInfo;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Info {
    private Set<String> imports;
    private Map<String, String> qualifiedImports;
    private List<String> interfaceNames;
    private List<MultiName> interfaceMultiNames;
    private List<InterfaceInfo> interfaceInfoList;
    private List<QName> functions;
    private List<QName> getters;
    private List<QName> setters;

    public void addFunction(QName functionName) {
        assert (functionName != null);
        if (this.functions == null) {
            this.functions = new ArrayList<QName>();
        }
        this.functions.add(functionName);
    }

    public void addGetter(QName getterName) {
        assert (getterName != null);
        if (this.getters == null) {
            this.getters = new ArrayList<QName>();
        }
        this.getters.add(getterName);
    }

    void addImport(String importName) {
        assert (importName != null);
        if (this.imports == null) {
            this.imports = new TreeSet<String>();
        }
        this.imports.add(importName);
    }

    public void addInterfaceMultiName(String[] namespaces, String interfaceName) {
        assert (namespaces != null && interfaceName != null);
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList<MultiName>();
        }
        this.interfaceMultiNames.add(new MultiName(namespaces, interfaceName));
    }

    public void addInterfaceMultiName(String namespace, String interfaceName) {
        assert (namespace != null && interfaceName != null);
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList<MultiName>();
        }
        this.interfaceMultiNames.add(new MultiName(namespace, interfaceName));
    }

    void addInterfaceName(String interfaceName) {
        assert (interfaceName != null);
        if (this.interfaceNames == null) {
            this.interfaceNames = new ArrayList<String>();
        }
        this.interfaceNames.add(interfaceName);
    }

    public void addInterfaceInfo(InterfaceInfo interfaceInfo) {
        assert (interfaceInfo != null);
        if (this.interfaceInfoList == null) {
            this.interfaceInfoList = new ArrayList<InterfaceInfo>();
        }
        this.interfaceInfoList.add(interfaceInfo);
    }

    void addQualifiedImport(String localPart, String namespace) {
        assert (localPart != null && localPart.length() > 0 && namespace != null);
        if (this.qualifiedImports == null) {
            this.qualifiedImports = new TreeMap<String, String>();
        }
        this.qualifiedImports.put(localPart, namespace);
    }

    public void addSetter(QName setterName) {
        if (this.setters == null) {
            this.setters = new ArrayList<QName>();
        }
        this.setters.add(setterName);
    }

    boolean definesFunction(String functionName) {
        boolean result = false;
        if (this.functions != null) {
            for (QName qName : this.functions) {
                if (!functionName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        return result;
    }

    boolean definesGetter(String getterName) {
        boolean result = false;
        if (this.getters != null) {
            for (QName qName : this.getters) {
                if (!getterName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        return result;
    }

    boolean definesSetter(String setterName) {
        boolean result = false;
        if (this.setters != null) {
            for (QName qName : this.setters) {
                if (!setterName.equals(qName.getLocalPart())) continue;
                result = true;
            }
        }
        return result;
    }

    public List<QName> getFunctionNames() {
        return this.functions;
    }

    public Set<String> getImports() {
        return this.imports;
    }

    List<MultiName> getInterfaceMultiNames() {
        if (this.interfaceMultiNames == null) {
            this.interfaceMultiNames = new ArrayList<MultiName>();
            if (this.interfaceNames != null) {
                for (String interfaceName : this.interfaceNames) {
                    MultiName interfaceMultiName = this.getMultiName(interfaceName);
                    this.interfaceMultiNames.add(interfaceMultiName);
                }
            }
        }
        return this.interfaceMultiNames;
    }

    public MultiName getMultiName(String name) {
        MultiName result;
        assert (name != null) : "Info.getMultiName called on null";
        int lastIndex = name.lastIndexOf(":");
        if (lastIndex < 0) {
            lastIndex = name.lastIndexOf(".");
        }
        if (lastIndex > 0) {
            result = new MultiName(new String[]{name.substring(0, lastIndex)}, name.substring(lastIndex + 1));
        } else if (this.qualifiedImports != null && this.qualifiedImports.containsKey(name)) {
            result = new MultiName(new String[]{this.qualifiedImports.get(name)}, name);
        } else if (this.imports != null) {
            String[] namespaces = new String[this.imports.size() + 1];
            this.imports.toArray(namespaces);
            namespaces[this.imports.size()] = "";
            result = new MultiName(namespaces, name);
        } else {
            result = new MultiName(name);
        }
        return result;
    }

    boolean implementsInterface(String namespace, String interfaceName) {
        boolean result = false;
        assert (this.interfaceMultiNames == null && this.interfaceInfoList == null || this.interfaceMultiNames != null && this.interfaceInfoList != null && this.interfaceInfoList.size() == this.interfaceMultiNames.size()) : "Info.implementsInterface: interfaceInfoList = " + this.interfaceInfoList + ", interfaceMultiNames = " + this.interfaceMultiNames;
        if (this.interfaceInfoList != null) {
            for (InterfaceInfo interfaceInfo : this.interfaceInfoList) {
                if (interfaceInfo.getInterfaceName().equals(namespace + ":" + interfaceName)) {
                    result = true;
                    continue;
                }
                if (interfaceInfo.extendsInterface(namespace, interfaceName)) {
                    result = true;
                    continue;
                }
                if (!interfaceInfo.implementsInterface(namespace, interfaceName)) continue;
                result = true;
            }
        }
        return result;
    }
}

