/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.CompilationUnit;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.LineNumberMap;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.NodeFactory;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;
import macromedia.asc.util.Multinames;
import macromedia.asc.util.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMagic {
    public static final String CONST = "const";
    public static final String DYNAMIC = "dynamic";
    public static final String FINAL = "final";
    public static final String INTERNAL = "internal";
    public static final String INTRINSIC = "intrinsic";
    public static final String NATIVE = "native";
    public static final String OVERRIDE = "override";
    public static final String PRIVATE = "private";
    public static final String PROTECTED = "protected";
    public static final String PROTOTYPE = "prototype";
    public static final String PUBLIC = "public";
    public static final String STATIC = "static";
    public static final String VIRTUAL = "virtual";
    private static MetaDataValueComparator metaDataValueComparator = new MetaDataValueComparator();

    public static String getVariableName(VariableDefinitionNode node) {
        return NodeMagic.getVariableBinding((VariableDefinitionNode)node).variable.identifier.name;
    }

    public static VariableBindingNode getVariableBinding(VariableDefinitionNode node) {
        return (VariableBindingNode)node.list.items.get(0);
    }

    public static void setVariableBindingName(VariableBindingNode node, String name) {
        node.variable.identifier.name = name.intern();
    }

    public static String getVariableTypeName(VariableDefinitionNode node) {
        return NodeMagic.getVariableTypeName(NodeMagic.getVariableBinding(node));
    }

    public static String getVariableTypeName(VariableBindingNode node) {
        MemberExpressionNode memberExpression;
        if (node.variable.type instanceof TypeExpressionNode) {
            TypeExpressionNode typeExpression = (TypeExpressionNode)node.variable.type;
            memberExpression = (MemberExpressionNode)typeExpression.expr;
        } else {
            memberExpression = (MemberExpressionNode)node.variable.type;
        }
        return NodeMagic.getTypeName(memberExpression);
    }

    private static String typeNameFromSelector(GetExpressionNode getExpression) {
        return NodeMagic.typeNameFromIdentifier((IdentifierNode)getExpression.expr);
    }

    private static String typeNameFromIdentifier(IdentifierNode identifier) {
        String result = identifier.name;
        if (identifier instanceof QualifiedIdentifierNode) {
            QualifiedIdentifierNode qualifiedIdentifier = (QualifiedIdentifierNode)identifier;
            if (qualifiedIdentifier.qualifier != null && qualifiedIdentifier.qualifier instanceof LiteralStringNode) {
                LiteralStringNode literalString = (LiteralStringNode)qualifiedIdentifier.qualifier;
                if (literalString.value != null && literalString.value.length() > 0) {
                    result = literalString.value + "." + qualifiedIdentifier.name;
                } else assert (false) : "Empty LiteralStringNode";
            } else assert (false) : "Empty QualifiedIdentifierNode";
        }
        return result;
    }

    private static void addIdentifier(List<String> list, IdentifierNode identifier) {
        if (identifier.name.equals(OVERRIDE)) {
            list.add(0, OVERRIDE);
        } else {
            list.add(identifier.name);
        }
    }

    public static void addImport(Context context, ClassDefinitionNode node, String packageName) {
        NodeFactory nodeFactory = new NodeFactory(context);
        PackageIdentifiersNode packageIdentifiers = null;
        StringTokenizer stringTokenizer = new StringTokenizer(packageName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            IdentifierNode identifier = nodeFactory.identifier(token);
            packageIdentifiers = nodeFactory.packageIdentifiers(packageIdentifiers, identifier, true);
        }
        PackageNameNode packageNameNode = nodeFactory.packageName(packageIdentifiers);
        ImportDirectiveNode importDirective = nodeFactory.importDirective(null, packageNameNode, null, context);
        importDirective.pkgdef = node.pkgdef;
        if (node.statements == null) {
            node.statements = new StatementListNode(null);
        }
        node.statements.items.add(0, (Object)importDirective);
    }

    private static void checkForIdentifier(List<String> list, Object attrsNode) {
        if (attrsNode instanceof MemberExpressionNode) {
            MemberExpressionNode memberExpression = (MemberExpressionNode)attrsNode;
            if (memberExpression.selector instanceof GetExpressionNode) {
                GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                if (getExpression.expr instanceof IdentifierNode) {
                    NodeMagic.addIdentifier(list, (IdentifierNode)getExpression.expr);
                }
            }
        } else if (attrsNode instanceof LiteralStringNode) {
            LiteralStringNode literalString = (LiteralStringNode)attrsNode;
            list.add(literalString.value);
        } else if (attrsNode instanceof IdentifierNode) {
            NodeMagic.addIdentifier(list, (IdentifierNode)attrsNode);
        } else assert (false) : "Unexpected attribute node: " + attrsNode.getClass().getName();
    }

    public static List<Node> getMetaData(DefinitionNode definition) {
        LinkedList<Node> list = new LinkedList<Node>();
        if (definition.metaData != null && definition.metaData.items != null) {
            list.addAll((Collection<Node>)definition.metaData.items);
        }
        return list;
    }

    public static String getSortedMetaDataParamString(MetaDataNode node) {
        TreeSet<Value> params = new TreeSet<Value>(metaDataValueComparator);
        StringBuilder parameters = new StringBuilder(32);
        if (node.values != null) {
            int length = node.values.length;
            for (int i = 0; i < length; ++i) {
                params.add(node.values[i]);
            }
            Iterator iter = params.iterator();
            parameters.append('(');
            while (iter.hasNext()) {
                Object v = iter.next();
                if (v instanceof MetaDataEvaluator.KeyValuePair) {
                    MetaDataEvaluator.KeyValuePair pair = (MetaDataEvaluator.KeyValuePair)v;
                    parameters.append(pair.key).append("=\"").append(pair.obj).append('\"');
                } else {
                    assert (v instanceof MetaDataEvaluator.KeylessValue);
                    parameters.append('\"').append(((MetaDataEvaluator.KeylessValue)v).obj).append('\"');
                }
                if (!iter.hasNext()) continue;
                parameters.append(",");
            }
            parameters.append(')');
        }
        return parameters.toString();
    }

    public static List<String> getAttributes(DefinitionNode definition) {
        return NodeMagic.getAttributes(definition.attrs);
    }

    public static List<String> getAttributes(AttributeListNode node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node != null) {
            for (Object attrsNode : node.items) {
                if (attrsNode instanceof ListNode) {
                    for (Object listNode : ((ListNode)attrsNode).items) {
                        NodeMagic.checkForIdentifier(result, listNode);
                    }
                    continue;
                }
                NodeMagic.checkForIdentifier(result, attrsNode);
            }
        }
        return result;
    }

    public static String getSortedAttributeString(AttributeListNode node, String delimiter) {
        return NodeMagic.setToString(NodeMagic.getSortedAttributes(node), delimiter);
    }

    public static TreeSet<String> getSortedAttributes(AttributeListNode node) {
        TreeSet<String> attrs = new TreeSet<String>();
        Iterator<String> iter = NodeMagic.getAttributes(node).iterator();
        while (iter.hasNext()) {
            attrs.add(iter.next().toString());
        }
        return attrs;
    }

    public static String setToString(Set<String> set, String delimiter) {
        StringBuilder attributes = new StringBuilder(32);
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            attributes.append(iter.next());
            if (!iter.hasNext()) continue;
            attributes.append(delimiter);
        }
        return attributes.toString();
    }

    public static Set<String> getImports(Multinames multiNames) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : multiNames.entrySet()) {
            String className = (String)entry.getKey();
            Namespaces namespaces = (Namespaces)entry.getValue();
            if (namespaces.isEmpty()) {
                result.add(className);
                continue;
            }
            for (ObjectValue objectValue : namespaces) {
                String packageName = objectValue.toString();
                if (packageName.length() > 0) {
                    result.add(packageName + "." + className);
                    continue;
                }
                result.add(className);
            }
        }
        return result;
    }

    public static String getDottedImportName(ImportDirectiveNode node) {
        StringBuilder buf = new StringBuilder();
        if (node.name != null && node.name.id.list != null) {
            Iterator iter = node.name.id.list.iterator();
            while (iter.hasNext()) {
                buf.append(((IdentifierNode)iter.next()).toIdentifierString());
                if (!iter.hasNext()) continue;
                buf.append('.');
            }
        }
        return buf.toString();
    }

    public static QName getQName(QualifiedIdentifierNode qualifiedIdentifier) {
        String namespaceURI = null;
        if (qualifiedIdentifier.qualifier instanceof MemberExpressionNode) {
            MemberExpressionNode memberExpression = (MemberExpressionNode)qualifiedIdentifier.qualifier;
            if (memberExpression.selector instanceof GetExpressionNode) {
                GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
                if (getExpression.expr instanceof IdentifierNode) {
                    namespaceURI = ((IdentifierNode)getExpression.expr).name;
                }
            }
        }
        return new QName(namespaceURI, qualifiedIdentifier.name);
    }

    public static String getUserNamespace(DefinitionNode definition) {
        String result = "";
        for (String attribute : NodeMagic.getAttributes(definition.attrs)) {
            if (attribute.equals(CONST) || attribute.equals(DYNAMIC) || attribute.equals(FINAL) || attribute.equals(INTERNAL) || attribute.equals(INTRINSIC) || attribute.equals(NATIVE) || attribute.equals(OVERRIDE) || attribute.equals(PRIVATE) || attribute.equals(PROTECTED) || attribute.equals(PROTOTYPE) || attribute.equals(PUBLIC) || attribute.equals(STATIC) || attribute.equals(VIRTUAL)) continue;
            result = attribute;
            break;
        }
        return result;
    }

    public static boolean functionIsGetter(FunctionDefinitionNode node) {
        return node.name.kind == -79;
    }

    public static boolean functionIsSetter(FunctionDefinitionNode node) {
        return node.name.kind == -99;
    }

    public static String getFunctionTypeName(FunctionDefinitionNode node) {
        MemberExpressionNode memberExpr = node.fexpr.signature.result instanceof TypeExpressionNode ? (MemberExpressionNode)((TypeExpressionNode)node.fexpr.signature.result).expr : (MemberExpressionNode)node.fexpr.signature.result;
        return NodeMagic.getTypeName(memberExpr);
    }

    public static int getFunctionParamCount(FunctionDefinitionNode function) {
        ParameterListNode params = function.fexpr.signature.parameter;
        return params != null ? params.items.size() : 0;
    }

    public static String getFunctionParamTypeName(FunctionDefinitionNode function, int pnum) {
        ParameterListNode params = function.fexpr.signature.parameter;
        if (params == null || pnum >= params.size()) {
            return "*";
        }
        ParameterNode param = (ParameterNode)params.items.get(pnum);
        assert (param != null) : "functionDefinitionNode.params contains null entry at " + pnum;
        MemberExpressionNode memberExpr = param.type instanceof TypeExpressionNode ? (MemberExpressionNode)((TypeExpressionNode)param.type).expr : (MemberExpressionNode)param.type;
        return NodeMagic.getTypeName(memberExpr);
    }

    public static String getFunctionName(FunctionDefinitionNode functionDefinition) {
        String result = null;
        if (functionDefinition.name != null && functionDefinition.name.identifier != null && functionDefinition.name.identifier.name != null) {
            result = functionDefinition.name.identifier.name;
        }
        return result;
    }

    public static void prefixFunctionName(FunctionDefinitionNode node, String prefix) {
        if (node.name != null && node.name.identifier != null && node.name.identifier.name != null) {
            node.name.identifier.name = (prefix + node.name.identifier.name).intern();
        }
        if (node.fexpr != null && node.fexpr.internal_name != null) {
            node.fexpr.internal_name = prefix + node.fexpr.internal_name;
        }
    }

    public static String getPackageName(ClassDefinitionNode node) {
        return NodeMagic.getPackageName(node.pkgdef);
    }

    public static String getPackageName(PackageDefinitionNode node) {
        if (node != null && node.name != null && node.name.id != null) {
            return node.name.id.toIdentifierString();
        }
        return "";
    }

    public static String getUnqualifiedFunctionName(FunctionDefinitionNode functionDefinitionNode) {
        if (functionDefinitionNode.name != null) {
            assert (functionDefinitionNode.name.identifier != null);
            return functionDefinitionNode.name.identifier.name;
        }
        return null;
    }

    public static String getUnqualifiedClassName(ClassDefinitionNode classDefinitionNode) {
        return classDefinitionNode.name.name;
    }

    public static String getClassName(ClassDefinitionNode classDefinition) {
        if (classDefinition.cframe != null) {
            return classDefinition.cframe.name.toString();
        }
        StringBuilder stringBuffer = new StringBuilder(NodeMagic.getPackageName(classDefinition));
        if (stringBuffer.length() > 0) {
            stringBuffer.append(":");
        }
        stringBuffer.append(NodeMagic.getUnqualifiedClassName(classDefinition));
        return stringBuffer.toString();
    }

    public static boolean isClassDefinition(MetaDataNode n) {
        return n.def instanceof ClassDefinitionNode;
    }

    public static String retrieveClassName(MetaDataNode n) {
        String className = null;
        if (NodeMagic.isClassDefinition(n)) {
            ClassDefinitionNode node = (ClassDefinitionNode)n.def;
            if (node.cframe != null) {
                className = node.cframe.name.toString().replace(':', '.');
            } else {
                StringBuilder fullyQualifiedClassName = new StringBuilder();
                fullyQualifiedClassName.append(NodeMagic.getPackageName(node));
                if (fullyQualifiedClassName.length() > 0) {
                    fullyQualifiedClassName.append('.');
                }
                fullyQualifiedClassName.append(node.name.name);
                className = fullyQualifiedClassName.toString();
            }
        }
        return className;
    }

    public static String normalizeClassName(String className) {
        int dot;
        if (className == null) {
            return null;
        }
        if (className.indexOf(58) == -1 && (dot = className.lastIndexOf(46)) != -1) {
            className = className.substring(0, dot) + ':' + className.substring(dot + 1);
        }
        return className;
    }

    public static void metaDataOnly(CompilationUnit unit, LineNumberMap map, int[] beginLines, int[] endLines) {
        int length;
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        Context cx = node.cx;
        StatementListNode stmts = node.statements;
        int n = length = stmts.items == null ? 0 : stmts.items.size();
        block0: for (int i = 0; i < length; ++i) {
            int count;
            Node n2 = (Node)stmts.items.get(i);
            if (!(n2 instanceof DocCommentNode) && n2 instanceof MetaDataNode) continue;
            int line = map.get(cx.input.getLnNum(n2.pos()));
            int n3 = count = line == 0 ? 0 : beginLines.length;
            for (int j = 0; j < count; ++j) {
                if (line < beginLines[j] || line > endLines[j]) continue;
                OnlyMetadataIsAllowed m = new OnlyMetadataIsAllowed();
                m.setPath(cx.input.origin);
                m.setLine(cx.input.getLnNum(n2.pos()));
                ThreadLocalToolkit.log(m);
                continue block0;
            }
        }
    }

    public static IdentifierNode getIdentifier(MemberExpressionNode memberExpression) {
        IdentifierNode result = null;
        if (memberExpression.selector instanceof GetExpressionNode) {
            GetExpressionNode getExpression = (GetExpressionNode)memberExpression.selector;
            if (getExpression.expr instanceof IdentifierNode) {
                result = (IdentifierNode)getExpression.expr;
            }
        }
        return result;
    }

    private static String getTypeName(MemberExpressionNode memberExpression) {
        String result = "*";
        if (memberExpression != null) {
            if (memberExpression.selector instanceof GetExpressionNode) {
                result = NodeMagic.typeNameFromSelector((GetExpressionNode)memberExpression.selector);
            } else if (memberExpression.selector instanceof ApplyTypeExprNode) {
                ApplyTypeExprNode applyType = (ApplyTypeExprNode)memberExpression.selector;
                if (applyType.expr instanceof IdentifierNode) {
                    result = NodeMagic.typeNameFromIdentifier((IdentifierNode)applyType.expr);
                    if (applyType.typeArgs != null) {
                        result = result + ".<";
                        Iterator iterator = applyType.typeArgs.items.iterator();
                        while (iterator.hasNext()) {
                            Node node = (Node)iterator.next();
                            if (node instanceof TypeExpressionNode) {
                                TypeExpressionNode typeExpression = (TypeExpressionNode)node;
                                result = result + NodeMagic.getTypeName((MemberExpressionNode)typeExpression.expr);
                            }
                            if (!iterator.hasNext()) continue;
                            result = result + ", ";
                        }
                        result = result + ">";
                    }
                } else assert (false) : "Unexpedted ApplyTypeExprNode expr type: " + applyType.expr.getClass().getName();
            } else assert (false) : "Unexpedted MemberExpressionNode selector type: " + memberExpression.selector.getClass().getName();
        }
        return result;
    }

    public static String lookupType(VariableBindingNode variableBinding) {
        GetExpressionNode getExpression;
        MemberExpressionNode memberExpression = null;
        if (variableBinding.variable != null && variableBinding.variable.type != null) {
            if (variableBinding.variable.type instanceof TypeExpressionNode) {
                memberExpression = (MemberExpressionNode)((TypeExpressionNode)variableBinding.variable.type).expr;
            } else if (variableBinding.variable.type instanceof MemberExpressionNode) {
                memberExpression = (MemberExpressionNode)variableBinding.variable.type;
            }
        }
        String result = null;
        if (memberExpression != null && memberExpression.selector != null && memberExpression.selector instanceof GetExpressionNode && (getExpression = (GetExpressionNode)memberExpression.selector).getIdentifier() != null) {
            result = getExpression.getIdentifier().name;
        }
        return result;
    }

    public static void removeMetaData(DefinitionNode definitionNode, String id) {
        StatementListNode metaData = definitionNode.metaData;
        if (metaData != null && metaData.items != null) {
            Iterator iterator = metaData.items.iterator();
            while (iterator.hasNext()) {
                MetaDataNode metaDataNode = (MetaDataNode)iterator.next();
                if (metaDataNode.id == null || !metaDataNode.id.equals(id)) continue;
                iterator.remove();
            }
        }
    }

    public static class OnlyMetadataIsAllowed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 6872237372429205625L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataValueComparator
    implements Comparator<Value> {
        private MetaDataValueComparator() {
        }

        private static String getKey(Value v) {
            return v instanceof MetaDataEvaluator.KeyValuePair ? ((MetaDataEvaluator.KeyValuePair)v).key : ((MetaDataEvaluator.KeylessValue)v).obj;
        }

        @Override
        public int compare(Value o1, Value o2) {
            return MetaDataValueComparator.getKey(o1).compareTo(MetaDataValueComparator.getKey(o2));
        }
    }
}

