/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.svg.SpriteTranscoder;
import flash.swf.tags.DefineSprite;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import flex2.compiler.media.MovieTranscoder;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.batik.transcoder.TranscoderInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGTranscoder
extends AbstractTranscoder {
    private boolean deprecationIssued = false;
    private boolean showDeprecationWarnings;

    public SVGTranscoder(boolean showDeprecationWarnings) {
        super(new String[]{"image/svg", "image/svg-xml"}, DefineSprite.class, true);
        this.showDeprecationWarnings = showDeprecationWarnings;
    }

    @Override
    public Transcoder.TranscodingResults doTranscode(PathResolver context, SymbolTable symbolTable, Map<String, Object> args, String className, boolean generateSource) throws TranscoderException {
        if (!this.deprecationIssued && this.showDeprecationWarnings) {
            ThreadLocalToolkit.log(new Deprecated());
            this.deprecationIssued = true;
        }
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults(this.resolveSource(context, args));
        String newName = (String)args.get("exportSymbol");
        results.defineTag = this.svg(results.assetSource, newName, args);
        if (generateSource) {
            this.generateSource(results, className, args);
        }
        return results;
    }

    @Override
    public boolean isSupportedAttribute(String attr) {
        return "scaleGridTop".equals(attr) || "scaleGridLeft".equals(attr) || "scaleGridBottom".equals(attr) || "scaleGridRight".equals(attr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DefineSprite svg(VirtualFile source, String newName, Map<String, Object> args) throws TranscoderException {
        DefineSprite defineSprite;
        FilterInputStream is = null;
        try {
            try {
                String docURI = source.getURL();
                is = new BufferedInputStream(source.getInputStream());
                if (SVGTranscoder.isGZIPCompressed((BufferedInputStream)is)) {
                    is = new GZIPInputStream(is);
                }
                TranscoderInput ti = new TranscoderInput((InputStream)is);
                ti.setURI(docURI);
                DefineSprite sprite = this.transcodeSVG(ti, source, newName);
                if (args.containsKey("scaleGridLeft") || args.containsKey("scaleGridRight") || args.containsKey("scaleGridTop") || args.containsKey("scaleGridBottom")) {
                    MovieTranscoder.defineScalingGrid(sprite, args);
                }
                defineSprite = sprite;
                Object var10_10 = null;
                if (is == null) return defineSprite;
            }
            catch (IOException ex) {
                throw new AbstractTranscoder.ExceptionWhileTranscoding(ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return defineSprite;
        }
        ((InputStream)is).close();
        return defineSprite;
    }

    private DefineSprite transcodeSVG(TranscoderInput ti, VirtualFile source, String symbolName) throws TranscoderException {
        try {
            SpriteTranscoder transcoder = new SpriteTranscoder();
            transcoder.transcode(ti, null);
            DefineSprite defineSprite = new DefineSprite(symbolName);
            defineSprite.tagList = transcoder.getTags();
            defineSprite.framecount = 1;
            return defineSprite;
        }
        catch (Exception ex) {
            throw new AbstractTranscoder.ExceptionWhileTranscoding(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private static boolean isGZIPCompressed(BufferedInputStream in) {
        block10: {
            block9: {
                in.mark(4);
                if (SVGTranscoder.readUShort(in) != 35615 || SVGTranscoder.readUByte(in) != 8) break block9;
                boolean bl = true;
                Object var3_3 = null;
                try {
                    in.reset();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return bl;
            }
            Object var3_4 = null;
            try {
                in.reset();
            }
            catch (IOException ex) {}
            break block10;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    Object var3_5 = null;
                    try {
                        in.reset();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                try {
                    in.reset();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    private static int readUShort(InputStream in) throws IOException {
        int b = SVGTranscoder.readUByte(in);
        return SVGTranscoder.readUByte(in) << 8 | b;
    }

    private static int readUByte(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    public static class Deprecated
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 274970449301472265L;
    }
}

